/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.importacao.carneleao;

import br.gov.serpro.updater.DialogoOcupado;
import java.awt.Component;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import serpro.ppgd.app.acoes.ImportarCarneLeaoAction;
import serpro.ppgd.app.acoes.LoginGovAction;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.rendpf.PainelAbaEscrituracaoDependente;
import serpro.ppgd.irpf.gui.rendpf.PainelAbaRendPFDependentesDetalhe;
import serpro.ppgd.irpf.gui.rendpf.PainelAbaRendPFTitular;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracao;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoDependente;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracaoTitular;
import serpro.ppgd.irpf.gui.rendpf.nuvem.CodigoAcessoModel;
import serpro.ppgd.irpf.gui.rendpf.nuvem.ImportacaoModel;
import serpro.ppgd.irpf.gui.rendpf.nuvem.PainelImportacaoCarneLeao;
import serpro.ppgd.irpf.gui.rendpf.nuvem.PainelLoginGovBrOuCodigoAcesso;
import serpro.ppgd.irpf.gui.rendpf.nuvem.PainelSolicitarCodigoAcesso;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.nuvem.carneleao.CarneLeao;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.txt.importacao.carneleao.RepositorioTxtDadosCarneLeaoWeb;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;

public class ProcessoImportacaoCarneLeaoWeb {
    private boolean titular;
    private ItemRendPFDependente dependente;
    private static SwingWorker<Boolean, Void> workerImportacao = null;
    boolean importacaoOK = false;
    boolean cancelar = false;
    boolean criouDependente = false;
    ImportarCarneLeaoAction action;
    private boolean exibirContabilizarSucessosErros;

    public ProcessoImportacaoCarneLeaoWeb(ImportarCarneLeaoAction action) {
        this.titular = true;
        this.action = action;
    }

    public ProcessoImportacaoCarneLeaoWeb(ItemRendPFDependente aDependente, ImportarCarneLeaoAction action) {
        this.titular = aDependente == null;
        this.dependente = aDependente;
        this.action = action;
        this.setExibirContabilizarSucessosErros(false);
    }

    public void setExibirContabilizarSucessosErros(boolean exibir) {
        this.exibirContabilizarSucessosErros = exibir;
    }

    public boolean isExibirContabilizarSucessosErros() {
        return this.exibirContabilizarSucessosErros;
    }

    public void importar(ImportacaoModel importacaoModel) {
        String senhaAcesso;
        RendPF rendPF;
        this.titular = importacaoModel.getTipo().naoFormatado().equals("T");
        if (!this.titular) {
            this.dependente = IRPFFacade.getInstancia().getDeclaracao().getRendPFDependente().obterItemRendPFDependentePorCPF(importacaoModel.getCpfDependente().naoFormatado());
            if (this.dependente == null) {
                this.dependente = new ItemRendPFDependente();
                this.dependente.getCpf().setConteudo(importacaoModel.getCpfDependente().naoFormatado());
                IRPFFacade.getInstancia().getDeclaracao().getRendPFDependente().add((ObjetoNegocio)this.dependente);
                this.criouDependente = true;
            }
        } else {
            this.criouDependente = false;
        }
        RendPF rendPF2 = rendPF = this.titular ? IRPFFacade.getInstancia().getRendPFTitular() : this.dependente.getRendimentos();
        if (!rendPF.isVazio() && !GuiUtil.mostrarConfirma((String)"confirmacao_importacao_cl", (int)140)) {
            return;
        }
        final String cpfContribuinte = this.titular ? IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado() : this.dependente.getCpf().naoFormatado();
        final String cpfSolicitante = importacaoModel.getCpfSolicitante().naoFormatado();
        final String codigoAcesso = importacaoModel.getCodigoAcesso().naoFormatado();
        String string = senhaAcesso = importacaoModel.getSenha() != null ? String.valueOf(importacaoModel.getSenha()) : "";
        if (workerImportacao == null || SwingWorker.StateValue.DONE.equals((Object)workerImportacao.getState())) {
            workerImportacao = new SwingWorker<Boolean, Void>(){
                private DialogoOcupado dlg = null;

                @Override
                protected Boolean doInBackground() throws Exception {
                    this.dlg = DialogoOcupado.exibeDialogo((String)"Importando Carn\u00ea-Le\u00e3o...");
                    if (cpfContribuinte != null) {
                        CarneLeao carneLeao = null;
                        carneLeao = BarramentoIRPFService.getUsuarioLogado() != null ? BarramentoIRPFService.importarCarneLeaoComLoginGovBr((String)cpfContribuinte) : BarramentoIRPFService.importarCarneLeaoComCodigoAcesso((String)cpfContribuinte, (String)cpfSolicitante, (String)codigoAcesso, (String)senhaAcesso);
                        if (carneLeao != null && "IN0028".equals(carneLeao.getCodigo())) {
                            ProcessoImportacaoCarneLeaoWeb.this.voltarParaAbaListagemRendimentosPF();
                            String nit = rendPF.getNITPISPASEP().naoFormatado();
                            rendPF.limpar();
                            rendPF.getNITPISPASEP().setConteudo(nit);
                            RepositorioTxtDadosCarneLeaoWeb repositorioTxtDadosCarneLeao = new RepositorioTxtDadosCarneLeaoWeb(carneLeao);
                            if (ProcessoImportacaoCarneLeaoWeb.this.titular) {
                                repositorioTxtDadosCarneLeao.importaIdentificacao(ControladorGui.getDemonstrativoAberto());
                                repositorioTxtDadosCarneLeao.importaDados(rendPF, IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf(), ProcessoImportacaoCarneLeaoWeb.this.titular);
                            } else {
                                repositorioTxtDadosCarneLeao.importaDados(rendPF, ProcessoImportacaoCarneLeaoWeb.this.dependente.getCpf(), ProcessoImportacaoCarneLeaoWeb.this.titular);
                            }
                            return true;
                        }
                    }
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void done() {
                    block12: {
                        Boolean retorno = null;
                        try {
                            retorno = workerImportacao.get();
                            if (retorno.booleanValue()) {
                                if (ProcessoImportacaoCarneLeaoWeb.this.titular) {
                                    IRPFFacade.getInstancia().getDeclaracao().getRendPFTitular().getUsouImportacaoCarneLeaoWeb().setConteudo(Logico.SIM);
                                } else {
                                    IRPFFacade.getInstancia().getDeclaracao().getRendPFDependente().getUsouImportacaoCarneLeaoWeb().setConteudo(Logico.SIM);
                                }
                                GuiUtil.mostrarInfo((String)"importacao_carneleao_sucesso");
                                try {
                                    ProcessoImportacaoCarneLeaoWeb.this.action.finalizou();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ProcessoImportacaoCarneLeaoWeb.this.importacaoOK = true;
                                break block12;
                            }
                            if (ProcessoImportacaoCarneLeaoWeb.this.criouDependente) {
                                IRPFFacade.getInstancia().getDeclaracao().getRendPFDependente().remove((ObjetoNegocio)ProcessoImportacaoCarneLeaoWeb.this.dependente);
                            }
                        }
                        catch (InterruptedException | ExecutionException e) {
                            LogPPGD.erro((String)e.getMessage());
                            String[] erros = e.getCause().getMessage().split(" - ");
                            String msg = erros.length > 1 ? erros[1] : erros[0];
                            GuiUtil.mostrarErro((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)msg);
                            if (ProcessoImportacaoCarneLeaoWeb.this.criouDependente) {
                                IRPFFacade.getInstancia().getDeclaracao().getRendPFDependente().remove((ObjetoNegocio)ProcessoImportacaoCarneLeaoWeb.this.dependente);
                            }
                        }
                        finally {
                            this.dlg.finaliza();
                        }
                    }
                }
            };
        }
        if (SwingWorker.StateValue.PENDING.equals((Object)workerImportacao.getState())) {
            workerImportacao.execute();
        }
        if (this.importacaoOK) {
            PainelAbaEscrituracaoDependente painelAbaDependente;
            PainelDadosEscrituracaoDependente painelDependente;
            if (ControladorGui.getPainelAtualmenteExibido() instanceof PainelDadosEscrituracao) {
                PainelDadosEscrituracaoTitular painelTitular;
                PainelDadosEscrituracao painel = (PainelDadosEscrituracao)ControladorGui.getPainelAtualmenteExibido();
                if (painel.getTabbedPane().getSelectedIndex() == 0 && (painelTitular = (PainelDadosEscrituracaoTitular)painel.getAbas()[0]).getTabbedPane().getSelectedIndex() == 1) {
                    painelTitular.getTabbedPane().setSelectedIndex(0);
                    painelTitular.getTabbedPane().setSelectedIndex(1);
                }
            } else if (ControladorGui.getPainelAtualmenteExibido() instanceof PainelAbaEscrituracaoDependente && (painelDependente = (painelAbaDependente = (PainelAbaEscrituracaoDependente)ControladorGui.getPainelAtualmenteExibido()).getPainelDadosEscrituracaoDependente()).getTabbedPane().getSelectedIndex() == 1) {
                painelDependente.getTabbedPane().setSelectedIndex(0);
                painelDependente.getTabbedPane().setSelectedIndex(1);
            }
        }
    }

    public void validarUsuarioLogado() {
        if (BarramentoIRPFService.getUsuarioLogado() == null) {
            PainelLoginGovBrOuCodigoAcesso painelLoginGovBrOuCodigoAcesso = new PainelLoginGovBrOuCodigoAcesso();
            GuiUtil.exibeDialog((JComponent)painelLoginGovBrOuCodigoAcesso, (boolean)true, (String)("Importar Carn\u00ea-Le\u00e3o " + ConstantesGlobais.EXERCICIO_ANTERIOR), (boolean)false);
            if (painelLoginGovBrOuCodigoAcesso.getOpcaoSelecionada() == 1) {
                try {
                    new LoginGovAction().iniciarLogon(usuarioGov -> this.verificaSeloLoginGovBr(usuarioGov));
                }
                catch (AplicacaoException aplicacaoException) {}
            } else if (painelLoginGovBrOuCodigoAcesso.getOpcaoSelecionada() == 2) {
                PainelSolicitarCodigoAcesso painelSolicitarCodigoAcesso = new PainelSolicitarCodigoAcesso();
                GuiUtil.exibeDialog((JComponent)painelSolicitarCodigoAcesso, (boolean)true, (String)"Acesso com c\u00f3digo de acesso", (boolean)false);
                if (painelSolicitarCodigoAcesso.getOpcaoSelecionada() == 0) {
                    this.exibePainelImportacao(painelSolicitarCodigoAcesso.getCodigoAcessoModel());
                }
            }
        } else {
            this.verificaSeloLoginGovBr(BarramentoIRPFService.getUsuarioLogado());
        }
    }

    private void verificaSeloLoginGovBr(UsuarioLogado usuarioGov) {
        if (!"ouro".equals(usuarioGov.getNivelAcessoGov()) && !"prata".equals(usuarioGov.getNivelAcessoGov())) {
            String msg = CadastroTabelasIRPF.recuperarMensagemHTML((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00505);
            GuiUtil.mostrarErroHTML((String)msg);
        } else {
            this.exibePainelImportacao(null);
        }
    }

    private void exibePainelImportacao(CodigoAcessoModel codigoAcessoModel) {
        PainelImportacaoCarneLeao painelImportacaoCarneLeao = codigoAcessoModel == null ? new PainelImportacaoCarneLeao() : new PainelImportacaoCarneLeao(codigoAcessoModel.getCpfSolicitante().naoFormatado(), codigoAcessoModel.getCodigoAcesso().naoFormatado(), codigoAcessoModel.getSenha());
        GuiUtil.exibeDialog((JComponent)painelImportacaoCarneLeao, (boolean)true, (String)("Importar Carn\u00ea-Le\u00e3o " + ConstantesGlobais.EXERCICIO_ANTERIOR), (boolean)false);
        if (painelImportacaoCarneLeao.getOpcaoSelecionada() == 0) {
            this.interromperEdicaoDemonstrativoPF();
            this.importar(painelImportacaoCarneLeao.getImportacaoModel());
        }
    }

    private void interromperEdicaoDemonstrativoPF() {
        try {
            PainelAbaEscrituracaoDependente painel;
            PainelDadosEscrituracaoDependente painelDependente;
            if (ControladorGui.getPainelAtualmenteExibido() instanceof PainelDadosEscrituracao) {
                PainelDadosEscrituracaoTitular painelTitular;
                PainelDadosEscrituracao painel2 = (PainelDadosEscrituracao)ControladorGui.getPainelAtualmenteExibido();
                if (painel2.getTabbedPane().getSelectedComponent() instanceof PainelDadosEscrituracaoTitular && (painelTitular = (PainelDadosEscrituracaoTitular)painel2.getTabbedPane().getSelectedComponent()).getTabbedPane().getSelectedComponent() instanceof PainelAbaRendPFTitular) {
                    PainelAbaRendPFTitular painelTabelao = (PainelAbaRendPFTitular)painelTitular.getTabbedPane().getSelectedComponent();
                    painelTabelao.pararEdicao();
                }
            } else if (ControladorGui.getPainelAtualmenteExibido() instanceof PainelAbaEscrituracaoDependente && (painelDependente = (painel = (PainelAbaEscrituracaoDependente)ControladorGui.getPainelAtualmenteExibido()).getPainelDadosEscrituracaoDependente()).getTabbedPane().getSelectedComponent() instanceof PainelAbaRendPFDependentesDetalhe) {
                PainelAbaRendPFDependentesDetalhe painelTabelao = (PainelAbaRendPFDependentesDetalhe)painelDependente.getTabbedPane().getSelectedComponent();
                painelTabelao.pararEdicao();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void voltarParaAbaListagemRendimentosPF() {
        try {
            PainelAbaEscrituracaoDependente painelAbaDependente;
            PainelDadosEscrituracaoDependente painelDependente;
            if (ControladorGui.getPainelAtualmenteExibido() instanceof PainelDadosEscrituracao) {
                PainelDadosEscrituracaoTitular painelTitular;
                PainelDadosEscrituracao painel = (PainelDadosEscrituracao)ControladorGui.getPainelAtualmenteExibido();
                if (painel.getTabbedPane().getSelectedIndex() == 0 && (painelTitular = (PainelDadosEscrituracaoTitular)painel.getAbas()[0]).getTabbedPane().getSelectedIndex() == 1) {
                    painelTitular.getTabbedPane().setSelectedIndex(0);
                }
            } else if (ControladorGui.getPainelAtualmenteExibido() instanceof PainelAbaEscrituracaoDependente && (painelDependente = (painelAbaDependente = (PainelAbaEscrituracaoDependente)ControladorGui.getPainelAtualmenteExibido()).getPainelDadosEscrituracaoDependente()).getTabbedPane().getSelectedIndex() == 1) {
                painelDependente.getTabbedPane().setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

