/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.importacao.atividaderural;

import java.awt.Component;
import javax.swing.JOptionPane;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileFilter;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.PainelCacher;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.atividaderural.AtividadeRural;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.atividaderural.PainelAbaReceitasDespesasBrasil;
import serpro.ppgd.irpf.gui.atividaderural.PainelAbaReceitasDespesasExteriorLista;
import serpro.ppgd.irpf.gui.atividaderural.PainelReceitasDespesas;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.ProcessoSwing;
import serpro.ppgd.irpf.gui.util.Tarefa;
import serpro.ppgd.irpf.txt.importacao.atividaderural.FiltroDemonstrativoAtividadeRural;
import serpro.ppgd.irpf.txt.importacao.atividaderural.RepositorioTxtDadosAtividadeRural;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.util.LogPPGD;

public class ProcessoImportacaoAtividadeRural {
    private String arquivoImportacao = null;
    private int quantidadeSucessos;
    private int quantidadeErros;
    private boolean exibirContabilizarSucessosErros;
    private String erro = null;

    public ProcessoImportacaoAtividadeRural() {
        this.setExibirContabilizarSucessosErros(false);
    }

    public void importar() {
        if (this.arquivoImportacao == null) {
            AtividadeRural ativRural = IRPFFacade.getInstancia().getAtividadeRural();
            if (!(ativRural.getBrasil().getReceitasDespesas().getTotalReceita().isVazio() && ativRural.getBrasil().getReceitasDespesas().getTotalDespesas().isVazio() && ativRural.getExterior().getReceitasDespesas().isVazio() || GuiUtil.mostrarConfirma((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)MensagemUtil.getMensagem((String)"confirmacao_importacao_ar")))) {
                return;
            }
            FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
            fc.setDialogTitle("Importa\u00e7\u00e3o de dados do Livro Caixa de Atividade Rural");
            fc.setApproveButtonText("OK");
            fc.setApproveButtonToolTipText("Importa\u00e7\u00e3o de dados do Livro Caixa de Atividade Rural");
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter((FileFilter)new FiltroDemonstrativoAtividadeRural());
            fc.setMultiSelectionEnabled(true);
            FileChooserResponse retorno = fc.showOpenDialog((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal());
            if (retorno == FileChooserResponse.APPROVE_OPTION) {
                this.arquivoImportacao = fc.getSelectedFile().getPath();
            }
        }
        if (this.arquivoImportacao != null) {
            final RepositorioTxtDadosAtividadeRural repositorioTxtDadosAtividadeRural = new RepositorioTxtDadosAtividadeRural(this.arquivoImportacao);
            Object retornoImport = ProcessoSwing.executarTarefa((Tarefa)new Tarefa(){

                public Object definirTarefa() {
                    try {
                        repositorioTxtDadosAtividadeRural.setContabilizarSucessosErros(ProcessoImportacaoAtividadeRural.this.isExibirContabilizarSucessosErros());
                        ProcessoImportacaoAtividadeRural.this.erro = repositorioTxtDadosAtividadeRural.importaDados();
                    }
                    catch (GeracaoTxtException e) {
                        LogPPGD.erro((String)e.getMessage());
                        ProcessoImportacaoAtividadeRural.this.arquivoImportacao = null;
                        String string = ProcessoImportacaoAtividadeRural.this.erro = "Arquivo corrompido.";
                        return string;
                    }
                    catch (Exception e) {
                        LogPPGD.erro((String)e.getMessage());
                        ProcessoImportacaoAtividadeRural.this.arquivoImportacao = null;
                        String string = ProcessoImportacaoAtividadeRural.this.erro = e.getMessage();
                        return string;
                    }
                    finally {
                        ProcessoImportacaoAtividadeRural.this.setQuantidadeSucessos(repositorioTxtDadosAtividadeRural.getQuantidadeSucessos());
                        ProcessoImportacaoAtividadeRural.this.setQuantidadeErros(repositorioTxtDadosAtividadeRural.getQuantidadeErros());
                    }
                    return null;
                }
            });
            if (!this.isExibirContabilizarSucessosErros()) {
                if (retornoImport != null) {
                    JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), retornoImport, "Erro", 0);
                    return;
                }
                if (ControladorGui.getPainelAtualmenteExibido() != null) {
                    if (ControladorGui.getPainelAtualmenteExibido().getClass().isAssignableFrom(PainelAbaReceitasDespesasBrasil.class)) {
                        PainelAbaReceitasDespesasBrasil painelReceitasDespesasBrasil = (PainelAbaReceitasDespesasBrasil)PainelCacher.getInstancia().obtemUrgentemente(PainelAbaReceitasDespesasBrasil.class.getName());
                        ((IRPFTableModelAb)painelReceitasDespesasBrasil.getTabela().getModel()).fireTableDataChanged();
                    } else if (ControladorGui.getPainelAtualmenteExibido().getClass().isAssignableFrom(PainelAbaReceitasDespesasExteriorLista.class)) {
                        PainelAbaReceitasDespesasExteriorLista painelReceitasDespesasExterior = (PainelAbaReceitasDespesasExteriorLista)PainelCacher.getInstancia().obtemUrgentemente(PainelAbaReceitasDespesasExteriorLista.class.getName());
                        ((IRPFTableModelAb)painelReceitasDespesasExterior.getTabela().getModel()).fireTableDataChanged();
                    }
                }
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"importacao_ar_sucesso"), "Informa\u00e7\u00e3o", 1);
            }
        }
        this.arquivoImportacao = null;
        if (ControladorGui.getPainelAtualmenteExibido() instanceof PainelReceitasDespesas) {
            PainelAbaReceitasDespesasBrasil painelAbaReceitasDespesasBrasil = ((PainelReceitasDespesas)ControladorGui.getPainelAtualmenteExibido()).getPainelAbaBrasil();
            ((IRPFTableModelAb)painelAbaReceitasDespesasBrasil.getTableReceitasDespesasBrasil().getModel()).refresh();
            ((IRPFTableModelAb)((PainelReceitasDespesas)ControladorGui.getPainelAtualmenteExibido()).getPainelAbaExterior().getTabela().getModel()).refresh();
        }
    }

    public void setExibirContabilizarSucessosErros(boolean exibir) {
        this.exibirContabilizarSucessosErros = exibir;
    }

    public boolean isExibirContabilizarSucessosErros() {
        return this.exibirContabilizarSucessosErros;
    }

    public void setArquivoImportacao(String arquivoImportacao) {
        this.arquivoImportacao = arquivoImportacao;
    }

    public int getQuantidadeSucessos() {
        return this.quantidadeSucessos;
    }

    public void setQuantidadeSucessos(int quantidadeSucessos) {
        this.quantidadeSucessos = quantidadeSucessos;
    }

    public int getQuantidadeErros() {
        return this.quantidadeErros;
    }

    private void setQuantidadeErros(int quantidadeErros) {
        this.quantidadeErros = quantidadeErros;
    }

    public String getErro() {
        return this.erro;
    }

    public static FileChooser obterFileChooserFiltradoAR() {
        FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
        fc.setDialogTitle("Importa\u00e7\u00e3o de dados do Livro Caixa de Atividade Rural");
        fc.setApproveButtonText("OK");
        fc.setApproveButtonToolTipText("Importa\u00e7\u00e3o de dados do Livro Caixa de Atividade Rural");
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter((FileFilter)new FiltroDemonstrativoAtividadeRural());
        fc.setMultiSelectionEnabled(true);
        return fc;
    }
}

