/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.RepositorioDeclaracaoCentralTxt;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.util.LogPPGD;

public class ImportadorTxt {
    private RepositorioDeclaracaoCentralTxt repositorioTxt;

    public IdentificadorDeclaracao importarDeclaracaoAnoAnterior(File file, boolean temRec, TipoDeclaracaoAES tipoDeclaracaoAES, boolean prePreenchida) throws GeracaoTxtException, IOException {
        if (this.repositorioTxt == null) {
            this.repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPFANOANTERIOR", file);
        }
        IdentificadorDeclaracao idDecl = this.repositorioTxt.recuperarIdDeclaracaoAnoAnterior(prePreenchida);
        if (tipoDeclaracaoAES.equals((Object)TipoDeclaracaoAES.ESPOLIO) || tipoDeclaracaoAES.equals((Object)TipoDeclaracaoAES.SAIDA)) {
            idDecl.getTipoDeclaracao().setConteudo("0");
        }
        this.repositorioTxt.importarDeclaracaoAnoAnterior(idDecl, tipoDeclaracaoAES, prePreenchida);
        if (!temRec) {
            // empty if block
        }
        return idDecl;
    }

    @Deprecated
    public IdentificadorDeclaracao restaurarIdDeclaracaoNaoPersistidoAnoAnterior(File file, boolean prePreenchida) throws GeracaoTxtException, IOException {
        if (this.repositorioTxt == null) {
            this.repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPFANOANTERIOR", file);
        }
        IdentificadorDeclaracao IdentificadorDeclaracao2 = this.repositorioTxt.recuperarIdDeclaracaoAnoAnterior(prePreenchida);
        IdentificadorDeclaracao2.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        IdentificadorDeclaracao2.getDeclaracaoRetificadora().setConteudo(Logico.NAO);
        return IdentificadorDeclaracao2;
    }

    public DeclaracaoIRPF recuperarDeclaracaoPersistenciaOnline(InputStream in, boolean realizarMerge, boolean salvarRecuperarOnline, String tipoDeclaracaoAES) throws IOException, GeracaoTxtException {
        if (IRPFFacade.getInstancia().getDeclaracao() != null) {
            throw new GeracaoTxtException("N\u00e3o \u00e9 poss\u00edvel recuperar dados de declara\u00e7\u00e3o com uma declara\u00e7\u00e3o aberta.");
        }
        String nomeArq = "IRPF" + ConstantesGlobais.EXERCICIO + "-" + new Date().getTime() + ".TMP";
        File filePath = new File(IRPFUtil.DIR_TMP);
        filePath.mkdirs();
        String strArq = IRPFUtil.DIR_TMP + System.getProperty("file.separator") + nomeArq;
        try (FileOutputStream out = new FileOutputStream(strArq);){
            byte[] buffer = new byte[1024];
            int n = 0;
            while ((n = in.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            throw new IOException("N\u00e3o foi poss\u00edvel criar arquivo tempor\u00e1rio.");
        }
        File file = new File(strArq);
        RepositorioDeclaracaoCentralTxt repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", file);
        return repositorioTxt.recuperarDeclaracaoPersistenciaOnline(realizarMerge, salvarRecuperarOnline, tipoDeclaracaoAES);
    }

    public DeclaracaoIRPF restaurarDeclaracao(File file, boolean recuperouPP) throws GeracaoTxtException, IOException {
        return this.restaurarDeclaracao(file, false, recuperouPP);
    }

    public DeclaracaoIRPF restaurarDeclaracao(File file, boolean heTransmitida, boolean recuperouPP) throws GeracaoTxtException, IOException {
        if (this.repositorioTxt == null) {
            this.repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", file);
        }
        IdentificadorDeclaracao idDecl = this.repositorioTxt.recuperarIdDeclaracao(heTransmitida);
        if (file.toString().toUpperCase().endsWith(".DEC")) {
            this.repositorioTxt.lerDeclaracaoValidando();
        }
        return this.repositorioTxt.recuperarDeclaracao(idDecl, recuperouPP);
    }

    public IdentificadorDeclaracao restaurarIdDeclaracao(File file, boolean heTransmitida) throws GeracaoTxtException, IOException {
        if (this.repositorioTxt == null) {
            this.repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", file);
        }
        return this.repositorioTxt.recuperarIdDeclaracaoNaoPersistido(heTransmitida);
    }

    public IdentificadorDeclaracao restaurarIdDeclaracao(File file) throws GeracaoTxtException, IOException {
        return this.restaurarIdDeclaracao(file, false);
    }

    public boolean existeDeclaracaoExercicioAtual(File file, boolean fileEhAnoAnterior, boolean transmitida) throws GeracaoTxtException, IOException {
        if (this.repositorioTxt == null) {
            this.repositorioTxt = new RepositorioDeclaracaoCentralTxt("ARQ_IRPF", file);
        }
        IdentificadorDeclaracao idDecl = null;
        idDecl = fileEhAnoAnterior ? this.repositorioTxt.recuperarIdDeclaracaoNaoPersistidoAnoAnterior(transmitida) : this.repositorioTxt.recuperarIdDeclaracaoNaoPersistido(transmitida);
        idDecl.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        if (transmitida) {
            return IRPFFacade.existeDeclaracaoTransmitida((String)idDecl.getCpf().naoFormatado(), (boolean)Logico.SIM.equals(idDecl.getDeclaracaoRetificadora().naoFormatado()));
        }
        return IRPFFacade.existeDeclaracao((String)idDecl.getCpf().naoFormatado(), (String)"0000000000");
    }

    public RepositorioDeclaracaoCentralTxt getRepositorioTxt() {
        return this.repositorioTxt;
    }

    public String salvarInformeXML(String conteudo) throws IOException, GeracaoTxtException {
        String nomeArq = "IRPF_INFORME_RENDIMENTOS" + ConstantesGlobais.EXERCICIO + "-" + new Date().getTime() + ".TMP";
        File filePath = new File(IRPFUtil.DIR_TMP);
        filePath.mkdirs();
        String strArq = IRPFUtil.DIR_TMP + System.getProperty("file.separator") + nomeArq;
        File file = new File(strArq);
        try (FileWriter arquivo = new FileWriter(file);){
            arquivo.write(conteudo);
            arquivo.close();
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            throw new IOException("N\u00e3o foi poss\u00edvel criar arquivo tempor\u00e1rio.");
        }
        return strArq;
    }
}

