/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import serpro.ppgd.formatosexternos.txt.ConversorRegistroParaObjeto;
import serpro.ppgd.formatosexternos.txt.DocumentoTXT;
import serpro.ppgd.formatosexternos.txt.DocumentoTXTDefault;
import serpro.ppgd.gui.filechooser.FileFilter;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.declaracao.prepreenchida.DeclaracaoPrepreenchida;
import serpro.ppgd.irpf.declaracao.prepreenchida.dimob.ItemDimobPessoaFisicaPagamento;
import serpro.ppgd.irpf.declaracao.prepreenchida.dimob.ItemDimobPessoaJuridica;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.ColecaoDirfRRAPensaoAlimenticia;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.ItemDirfFundoClube;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.ItemDirfPagamentos;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.ItemDirfPrevidencia;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.ItemDirfRRA;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.ItemDirfRRAPensaoAlimenticia;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.ItemDirfRendimentos;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.RendAplicacaoFinanceira;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.RendComplementacaoAposentadoria;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.RendGenerico;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.RendGenericoComDescricao;
import serpro.ppgd.irpf.declaracao.prepreenchida.dirf.RendPJExigibilidade;
import serpro.ppgd.irpf.declaracao.prepreenchida.dmed.ItemDmed;
import serpro.ppgd.irpf.declaracao.prepreenchida.dmed.ItemDmedDirf;
import serpro.ppgd.irpf.declaracao.prepreenchida.dmed.ItemDmedPessoaFisica;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoMolestiaGrave;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroRendimentosNI;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.Validador;

public class ImportadorPrePreenchida {
    public static final String CAMINHO_TEMP_PREPREENCHIDA = IRPFUtil.DIR_DADOS + "/tmp/";
    private static final Set<String> pessoasJuridicasImportadasDirf = new HashSet<String>();
    private Map<String, String> hashPagamentosDMED = new HashMap<String, String>();

    public void importarDadosFontesPagadoras(DeclaracaoIRPF dec, File arquivoFontesPagadoras, String cpfContribuinte) throws AplicacaoException {
        DeclaracaoPrepreenchida declaracaoPrepreenchida = new DeclaracaoPrepreenchida();
        declaracaoPrepreenchida.getCpfContribuinte().setConteudo(cpfContribuinte);
        try {
            DocumentoTXTDefault documentoTxtCopiaSeguranca = new DocumentoTXTDefault("ARQ_PREPREENCHIDA", arquivoFontesPagadoras.getAbsolutePath());
            documentoTxtCopiaSeguranca.ler();
            ConversorRegistroParaObjeto conversorRegistroParaObjeto = new ConversorRegistroParaObjeto();
            conversorRegistroParaObjeto.preencheObjetoNegocio((ObjetoNegocio)declaracaoPrepreenchida, (DocumentoTXT)documentoTxtCopiaSeguranca);
            this.mesclarDadosImportadosComDeclaracao(dec, declaracaoPrepreenchida);
            pessoasJuridicasImportadasDirf.clear();
        }
        catch (Exception e) {
            throw new AplicacaoException("Ocorreu um erro durante importa\u00e7\u00e3o de Fontes Pagadoras.", (Throwable)e, false);
        }
    }

    public void mesclarDadosImportadosComDeclaracao(DeclaracaoIRPF dec, DeclaracaoPrepreenchida declaracaoPrepreenchida) {
        this.removerPensoesInvalidas(declaracaoPrepreenchida.getColecaoDirfRRAPensaoAlimenticia());
        for (ItemDirfRendimentos itemDirfRendimentos : declaracaoPrepreenchida.getColecaoDirfRendimentos().itens()) {
            if (itemDirfRendimentos.isVazio()) continue;
            this.mesclarDadosDirfComDeclaracao(dec, itemDirfRendimentos, declaracaoPrepreenchida.getCpfContribuinte().naoFormatado());
        }
        for (ItemDirfRRA itemDirfRRA : declaracaoPrepreenchida.getColecaoDirfRRA().itens()) {
            if (itemDirfRRA.isVazio()) continue;
            this.mesclarDadosDirfRRAComDeclaracao(dec, itemDirfRRA, declaracaoPrepreenchida.getColecaoDirfRRAPensaoAlimenticia(), declaracaoPrepreenchida.getCpfContribuinte().naoFormatado());
        }
        for (ItemDirfPagamentos itemDirfPagamentos : declaracaoPrepreenchida.getColecaoDirfPagamentos().itens()) {
            if (itemDirfPagamentos.isVazio()) continue;
            this.mesclarDadosDirfPagamentosComDeclaracao(dec, itemDirfPagamentos, declaracaoPrepreenchida.getCpfContribuinte().naoFormatado());
        }
        for (ItemDirfPrevidencia itemDirfPrevidencia : declaracaoPrepreenchida.getColecaoDirfPrevidencia().itens()) {
            if (itemDirfPrevidencia.isVazio()) continue;
            this.mesclarDadosDirfPrevidenciaComDeclaracao(dec, itemDirfPrevidencia, declaracaoPrepreenchida.getCpfContribuinte().naoFormatado());
        }
        for (ItemDirfFundoClube itemDirfFundoClube : declaracaoPrepreenchida.getColecaoDirfFundoClube().itens()) {
            if (itemDirfFundoClube.isVazio()) continue;
            this.mesclarDadosDirfFundoClubeComDeclaracao(dec, itemDirfFundoClube, declaracaoPrepreenchida.getCpfContribuinte().naoFormatado());
        }
        for (ItemDimobPessoaFisicaPagamento itemDimobPessoaFisica : declaracaoPrepreenchida.getColecaoDimobPessoaFisica().itens()) {
            if (itemDimobPessoaFisica.isVazio()) continue;
            this.mesclarDadosDimobPessoaFisicaComDeclaracao(dec, itemDimobPessoaFisica, declaracaoPrepreenchida.getCpfContribuinte().naoFormatado());
        }
        for (ItemDimobPessoaJuridica itemDimobPessoaJuridica : declaracaoPrepreenchida.getColecaoDimobPessoaJuridica().itens()) {
            if (itemDimobPessoaJuridica.isVazio()) continue;
            this.mesclarDadosDimobPessoaJuridicaComDeclaracao(dec, itemDimobPessoaJuridica, declaracaoPrepreenchida.getCpfContribuinte().naoFormatado());
        }
        for (ItemDimobPessoaFisicaPagamento itemDimobPagamento : declaracaoPrepreenchida.getColecaoDimobPagamentos().itens()) {
            if (itemDimobPagamento.isVazio()) continue;
            this.mesclarDadosDimobPagamentosComDeclaracao(dec, itemDimobPagamento, declaracaoPrepreenchida.getCpfContribuinte().naoFormatado());
        }
        for (ItemDmed itemDmed : declaracaoPrepreenchida.getColecaoDmed().itens()) {
            if (itemDmed.isVazio()) continue;
            this.mesclarDadosDmedComDeclaracao(dec, itemDmed, declaracaoPrepreenchida.getCpfContribuinte().naoFormatado());
        }
        for (ItemDmedDirf itemDmedDirf : declaracaoPrepreenchida.getColecaoDmedDirf().itens()) {
            if (itemDmedDirf.isVazio()) continue;
            this.mesclarDadosDmedComDeclaracao(dec, (ItemDmed)itemDmedDirf, declaracaoPrepreenchida.getCpfContribuinte().naoFormatado());
        }
    }

    private void removerPensoesInvalidas(ColecaoDirfRRAPensaoAlimenticia colecaoDirfRRAPensaoAlimenticia) {
        ArrayList<ItemDirfRRAPensaoAlimenticia> itensRemover = new ArrayList<ItemDirfRRAPensaoAlimenticia>();
        for (ItemDirfRRAPensaoAlimenticia itemDirfRRAPensaoAlimenticia : colecaoDirfRRAPensaoAlimenticia.itens()) {
            String cpf = itemDirfRRAPensaoAlimenticia.getCpfAlimentando().naoFormatado();
            if (!"".equals(cpf) && !"00000000000".equals(cpf)) continue;
            itensRemover.add(itemDirfRRAPensaoAlimenticia);
        }
        colecaoDirfRRAPensaoAlimenticia.itens().removeAll(itensRemover);
    }

    public void mesclarDadosDirfComDeclaracao(DeclaracaoIRPF dec, ItemDirfRendimentos itemDirfRendimentos, String cpfContribuinte) {
        this.importarRendPJ(dec, itemDirfRendimentos, false, cpfContribuinte);
        this.importarPensao(dec, itemDirfRendimentos, cpfContribuinte);
        this.importarTransporteDetalhado(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendIsentos().getLucroRecebidoQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getLucros(), cpfContribuinte, new Boolean[0]);
        this.importarRendPJComExigibilidadeSuspensa(dec, itemDirfRendimentos, cpfContribuinte);
        this.importarTransporteDetalhado(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendIsentos().getMedicosResidentesQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getMedicosResidentes(), cpfContribuinte, new Boolean[0]);
        this.importarTransporteDetalhado(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendIsentos().getVoluntariosCopaQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getVoluntariosCopa(), cpfContribuinte, new Boolean[0]);
        this.importarParcIsentaAposentadoria(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getParcelaIsentaAposentadoria(), itemDirfRendimentos.getParcelaIsentaAposentadoria13(), cpfContribuinte);
        this.importarTransporteDetalhado(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendIsentos().getRendSocioQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getSocio(), cpfContribuinte, new Boolean[0]);
        this.importarQuadroRendimentosNI(dec, (Colecao<ItemQuadroRendimentosNI>)dec.getRendIsentos().getIndenizacoesQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getIndenizacoes(), cpfContribuinte);
        this.importarQuadroRendimentosNI(dec, (Colecao<ItemQuadroRendimentosNI>)dec.getRendIsentos().getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getImpostoRendaAnosCalendarioAnteriores(), cpfContribuinte);
        this.importarTransporteDetalhado(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendTributacaoExclusiva().getJurosCapitalProprioQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getJurosCapitalProprio(), cpfContribuinte, false);
        this.importarTransporteDetalhado(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendTributacaoExclusiva().getParticipacaoLucrosResultadosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getParticipacaoLucrosResultados(), cpfContribuinte, false);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getDiarias(), "Di\u00e1rias e Ajudas de Custo", cpfContribuinte, new Boolean[0]);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getAbonoPecuniario(), "Abono Pecuni\u00e1rio", cpfContribuinte, new Boolean[0]);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, (RendGenerico)itemDirfRendimentos.getOutrosIsentos0561(), null, cpfContribuinte, new Boolean[0]);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, (RendGenerico)itemDirfRendimentos.getOutrosIsentos0588(), null, cpfContribuinte, new Boolean[0]);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, (RendGenerico)itemDirfRendimentos.getOutrosIsentos1895(), null, cpfContribuinte, new Boolean[0]);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, (RendGenerico)itemDirfRendimentos.getOutrosIsentos3533(), null, cpfContribuinte, new Boolean[0]);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, (RendGenerico)itemDirfRendimentos.getOutrosIsentos3540(), null, cpfContribuinte, new Boolean[0]);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, (RendGenerico)itemDirfRendimentos.getOutrosIsentos5936(), null, cpfContribuinte, new Boolean[0]);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getDecisaoJusticaFederal(), "Justi\u00e7a Federal: Rendimentos pagos sem reten\u00e7\u00e3o IR", cpfContribuinte, new Boolean[0]);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getDecisaoJusticaTrabalho(), "Justi\u00e7a do Trabalho: Rendimentos pagos sem reten\u00e7\u00e3o IR", cpfContribuinte, new Boolean[0]);
        this.importarComplementacaoAposentadoria(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getDetalheComplementacaoAposentadoria(), "Contribui\u00e7\u00f5es Previd\u00eancia Complementar 89/95 IN 1343/2013", cpfContribuinte);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getPremiosConcursos(), "Pr\u00eamios obtidos em concursos e sorteios", cpfContribuinte, false);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getResgatePrevidenciaComplementar(), "Resgate de Previd\u00eancia Complementar", cpfContribuinte, false);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getBeneficioPrevidenciaComplementar(), "Benef\u00edcio de Previd\u00eancia Complementar", cpfContribuinte, false);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getPremiosJogosBingo(), "Pr\u00eamios em sorteios dos jogos de bingo", cpfContribuinte, false);
        this.importarAplicacaoFinanceira(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getAplicFinanceira(), cpfContribuinte, false);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getFicart(), "FICART e demais rendimentos de capital (day-trade)", cpfContribuinte, false);
        this.importarOutrosRendimentos(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar(), itemDirfRendimentos, itemDirfRendimentos.getOperacoesSwap(), "Opera\u00e7\u00f5es swap", cpfContribuinte, false);
    }

    private List<ItemQuadroPensaoAlimenticia> obterPensoesPorRRA(DeclaracaoIRPF dec, ItemDirfRRA itemDirfRRA, ColecaoDirfRRAPensaoAlimenticia colecaoPensoes) {
        ArrayList<ItemQuadroPensaoAlimenticia> pensoesAlimenticias = new ArrayList<ItemQuadroPensaoAlimenticia>();
        for (ItemDirfRRAPensaoAlimenticia item : colecaoPensoes.itens()) {
            Alimentando alimentando;
            if (!item.getNumeroProcesso().naoFormatado().equals(itemDirfRRA.getNumeroProcesso().naoFormatado())) continue;
            Valor valorPago = new Valor();
            switch (itemDirfRRA.getMesRecebimento().naoFormatado()) {
                case "01": {
                    valorPago.setConteudo(item.getValorPagoJan());
                    break;
                }
                case "02": {
                    valorPago.setConteudo(item.getValorPagoFev());
                    break;
                }
                case "03": {
                    valorPago.setConteudo(item.getValorPagoMar());
                    break;
                }
                case "04": {
                    valorPago.setConteudo(item.getValorPagoAbr());
                    break;
                }
                case "05": {
                    valorPago.setConteudo(item.getValorPagoMai());
                    break;
                }
                case "06": {
                    valorPago.setConteudo(item.getValorPagoJun());
                    break;
                }
                case "07": {
                    valorPago.setConteudo(item.getValorPagoJul());
                    break;
                }
                case "08": {
                    valorPago.setConteudo(item.getValorPagoAgo());
                    break;
                }
                case "09": {
                    valorPago.setConteudo(item.getValorPagoSet());
                    break;
                }
                case "10": {
                    valorPago.setConteudo(item.getValorPagoOut());
                    break;
                }
                case "11": {
                    valorPago.setConteudo(item.getValorPagoNov());
                    break;
                }
                case "12": {
                    valorPago.setConteudo(item.getValorPagoDez());
                    break;
                }
            }
            if (valorPago.isVazio() || (alimentando = dec.getAlimentandos().getAlimentandoByCpf(item.getCpfAlimentando().naoFormatado())) == null) continue;
            ItemQuadroPensaoAlimenticia pensaoAlimenticia = new ItemQuadroPensaoAlimenticia();
            pensaoAlimenticia = new ItemQuadroPensaoAlimenticia();
            pensaoAlimenticia.getAlimentando().setConteudo(alimentando.getNome());
            pensaoAlimenticia.getValor().setConteudo(valorPago);
            pensoesAlimenticias.add(pensaoAlimenticia);
        }
        return pensoesAlimenticias;
    }

    public void mesclarDadosDirfRRAComDeclaracao(DeclaracaoIRPF dec, ItemDirfRRA itemDirfRRA, ColecaoDirfRRAPensaoAlimenticia colecaoPensoes, String cpfContribuinte) {
        if (!itemDirfRRA.isVazio()) {
            String niFontePagadora = itemDirfRRA.getHeader().getNiFontePagadora().naoFormatado();
            String mesRecebimento = itemDirfRRA.getMesRecebimento().naoFormatado();
            String inDetalhePensao = itemDirfRRA.getInDetalhePensao().naoFormatado();
            List<ItemQuadroPensaoAlimenticia> pensoesAlimenticias = null;
            if ("S".equals(inDetalhePensao.toUpperCase())) {
                pensoesAlimenticias = this.obterPensoesPorRRA(dec, itemDirfRRA, colecaoPensoes);
            }
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            boolean achou = false;
            if (titular) {
                for (Object rendAcmTitular : dec.getRendAcm().getColecaoRendAcmTitular().itens()) {
                    if (!rendAcmTitular.getNiFontePagadora().naoFormatado().equals(niFontePagadora) || !rendAcmTitular.getMesRecebimento().naoFormatado().equals(mesRecebimento) || !rendAcmTitular.getNumeroProcesso().equals(itemDirfRRA.getNumeroProcesso().naoFormatado())) continue;
                    achou = true;
                    if (pensoesAlimenticias != null) {
                        for (ItemQuadroPensaoAlimenticia item : pensoesAlimenticias) {
                            rendAcmTitular.getPensaoAlimenticiaQuadroAuxiliar().add((ObjetoNegocio)item);
                        }
                    }
                    rendAcmTitular.getRendRecebidosInformado().setConteudo(itemDirfRRA.getValorLiquidoRecebimento());
                    rendAcmTitular.getParcIsenta65Anos().setConteudo(itemDirfRRA.getRendimentoIsento65Anos());
                    rendAcmTitular.getContribuicaoPrevOficial().setConteudo(itemDirfRRA.getContribuicaoPrevidenciariaOficial());
                    rendAcmTitular.getImpostoRetidoFonte().setConteudo(itemDirfRRA.getImpostoRetidoFonte());
                    rendAcmTitular.getPensaoAlimenticia().setConteudo(itemDirfRRA.getValorPensaoAlimenticia());
                    rendAcmTitular.getMesRecebimento().setConteudo(itemDirfRRA.getMesRecebimento());
                    rendAcmTitular.getNumMeses().setConteudo(itemDirfRRA.getQtdMeses());
                    rendAcmTitular.setNumeroProcesso(itemDirfRRA.getNumeroProcesso().naoFormatado());
                    break;
                }
                if (!achou) {
                    RendAcmTitular rendAcmTitular = new RendAcmTitular(dec, (Colecao)dec.getRendAcm().getColecaoRendAcmTitular());
                    rendAcmTitular.getNiFontePagadora().setConteudo(itemDirfRRA.getHeader().getNiFontePagadora());
                    rendAcmTitular.getNomeFontePagadora().setConteudo(itemDirfRRA.getHeader().getNomeFontePagadora());
                    if (pensoesAlimenticias != null) {
                        for (ItemQuadroPensaoAlimenticia item : pensoesAlimenticias) {
                            rendAcmTitular.getPensaoAlimenticiaQuadroAuxiliar().add((ObjetoNegocio)item);
                        }
                    }
                    rendAcmTitular.getRendRecebidosInformado().setConteudo(itemDirfRRA.getValorLiquidoRecebimento());
                    rendAcmTitular.getParcIsenta65Anos().setConteudo(itemDirfRRA.getRendimentoIsento65Anos());
                    rendAcmTitular.getContribuicaoPrevOficial().setConteudo(itemDirfRRA.getContribuicaoPrevidenciariaOficial());
                    rendAcmTitular.getImpostoRetidoFonte().setConteudo(itemDirfRRA.getImpostoRetidoFonte());
                    rendAcmTitular.getPensaoAlimenticia().setConteudo(itemDirfRRA.getValorPensaoAlimenticia());
                    rendAcmTitular.getMesRecebimento().setConteudo(itemDirfRRA.getMesRecebimento());
                    rendAcmTitular.getNumMeses().setConteudo(itemDirfRRA.getQtdMeses());
                    rendAcmTitular.setNumeroProcesso(itemDirfRRA.getNumeroProcesso().naoFormatado());
                    dec.getRendAcm().getColecaoRendAcmTitular().itens().add(rendAcmTitular);
                }
            } else {
                for (RendAcmTitular rendAcmDep : dec.getRendAcm().getColecaoRendAcmDependente().itens()) {
                    RendAcmDependente rendAcmDependente = (RendAcmDependente)rendAcmDep;
                    if (!rendAcmDependente.getNiFontePagadora().naoFormatado().equals(niFontePagadora) || !rendAcmDependente.getMesRecebimento().naoFormatado().equals(mesRecebimento) || !rendAcmDependente.getNumeroProcesso().equals(itemDirfRRA.getNumeroProcesso().naoFormatado()) || !rendAcmDependente.getCpfDependente().naoFormatado().equals(cpfContribuinte)) continue;
                    achou = true;
                    if (pensoesAlimenticias != null) {
                        for (ItemQuadroPensaoAlimenticia item : pensoesAlimenticias) {
                            rendAcmDependente.getPensaoAlimenticiaQuadroAuxiliar().add((ObjetoNegocio)item);
                        }
                    }
                    rendAcmDependente.getRendRecebidosInformado().setConteudo(itemDirfRRA.getValorLiquidoRecebimento());
                    rendAcmDependente.getParcIsenta65Anos().setConteudo(itemDirfRRA.getRendimentoIsento65Anos());
                    rendAcmDependente.getContribuicaoPrevOficial().setConteudo(itemDirfRRA.getContribuicaoPrevidenciariaOficial());
                    rendAcmDependente.getImpostoRetidoFonte().setConteudo(itemDirfRRA.getImpostoRetidoFonte());
                    rendAcmDependente.getPensaoAlimenticia().setConteudo(itemDirfRRA.getValorPensaoAlimenticia());
                    rendAcmDependente.getMesRecebimento().setConteudo(itemDirfRRA.getMesRecebimento());
                    rendAcmDependente.getNumMeses().setConteudo(itemDirfRRA.getQtdMeses());
                    rendAcmDependente.setNumeroProcesso(itemDirfRRA.getNumeroProcesso().naoFormatado());
                    break;
                }
                if (!achou) {
                    RendAcmDependente rendAcmDependente = new RendAcmDependente(dec, (Colecao)dec.getRendAcm().getColecaoRendAcmDependente());
                    rendAcmDependente.getCpfDependente().setConteudo(cpfContribuinte);
                    rendAcmDependente.getNiFontePagadora().setConteudo(itemDirfRRA.getHeader().getNiFontePagadora());
                    rendAcmDependente.getNomeFontePagadora().setConteudo(itemDirfRRA.getHeader().getNomeFontePagadora());
                    if (pensoesAlimenticias != null) {
                        for (ItemQuadroPensaoAlimenticia item : pensoesAlimenticias) {
                            rendAcmDependente.getPensaoAlimenticiaQuadroAuxiliar().add((ObjetoNegocio)item);
                        }
                    }
                    rendAcmDependente.getRendRecebidosInformado().setConteudo(itemDirfRRA.getValorLiquidoRecebimento());
                    rendAcmDependente.getParcIsenta65Anos().setConteudo(itemDirfRRA.getRendimentoIsento65Anos());
                    rendAcmDependente.getContribuicaoPrevOficial().setConteudo(itemDirfRRA.getContribuicaoPrevidenciariaOficial());
                    rendAcmDependente.getImpostoRetidoFonte().setConteudo(itemDirfRRA.getImpostoRetidoFonte());
                    rendAcmDependente.getPensaoAlimenticia().setConteudo(itemDirfRRA.getValorPensaoAlimenticia());
                    rendAcmDependente.getMesRecebimento().setConteudo(itemDirfRRA.getMesRecebimento());
                    rendAcmDependente.getNumMeses().setConteudo(itemDirfRRA.getQtdMeses());
                    rendAcmDependente.setNumeroProcesso(itemDirfRRA.getNumeroProcesso().naoFormatado());
                    dec.getRendAcm().getColecaoRendAcmDependente().itens().add(rendAcmDependente);
                }
            }
        }
    }

    private void mesclarDadosDirfPagamentosComDeclaracao(DeclaracaoIRPF dec, ItemDirfPagamentos itemDirfPagamentos, String cpfContribuinte) {
        if (!itemDirfPagamentos.isVazio()) {
            String niAdvogadoEscritorio = itemDirfPagamentos.getNiAdvogadoEscritorio().naoFormatado();
            boolean achou = false;
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            for (Pagamento pagamento : dec.getPagamentos().itens()) {
                if (!pagamento.getNiBeneficiario().naoFormatado().equals(niAdvogadoEscritorio) || (!pagamento.getCodigo().naoFormatado().equals("61") || !itemDirfPagamentos.isJusticaTrabalhista().booleanValue()) && (!pagamento.getCodigo().naoFormatado().equals("60") || itemDirfPagamentos.isJusticaTrabalhista().booleanValue())) continue;
                achou = true;
                pagamento.getValorPago().append('+', itemDirfPagamentos.getPagamentoAdvogado());
                break;
            }
            if (!achou) {
                Pagamento pagamento = new Pagamento(dec);
                if (titular) {
                    pagamento.getTipo().setConteudo("T");
                } else {
                    pagamento.getTipo().setConteudo("D");
                    pagamento.getCPFDependente().setConteudo(cpfContribuinte);
                }
                pagamento.getNiBeneficiario().setConteudo(itemDirfPagamentos.getNiAdvogadoEscritorio());
                pagamento.getNomeBeneficiario().setConteudo(itemDirfPagamentos.getNomeAdvogadoEscritorio());
                String codigoPagamento = null;
                if (itemDirfPagamentos.isJusticaTrabalhista().booleanValue()) {
                    codigoPagamento = "61";
                } else if (!itemDirfPagamentos.isJusticaTrabalhista().booleanValue()) {
                    codigoPagamento = "60";
                }
                pagamento.getCodigo().setConteudo(codigoPagamento);
                pagamento.getValorPago().setConteudo(itemDirfPagamentos.getPagamentoAdvogado());
                dec.getPagamentos().itens().add(pagamento);
            }
        }
    }

    private void mesclarDadosDirfPrevidenciaComDeclaracao(DeclaracaoIRPF dec, ItemDirfPrevidencia itemDirfPrevidencia, String cpfContribuinte) {
        if (!itemDirfPrevidencia.isVazio()) {
            String cnjpPrevidencia = itemDirfPrevidencia.getCnpjPrevidencia().naoFormatado();
            String codPagamento = "0";
            if ("1".equals(itemDirfPrevidencia.getTipoPrevidencia().naoFormatado())) {
                codPagamento = "36";
            } else if ("3".equals(itemDirfPrevidencia.getTipoPrevidencia().naoFormatado())) {
                codPagamento = "37";
            }
            boolean achou = false;
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                if (!"0".equals(codPagamento)) {
                    for (Pagamento pagamento : dec.getPagamentos().itens()) {
                        if (!pagamento.getNiBeneficiario().naoFormatado().equals(cnjpPrevidencia) || !"T".equals(pagamento.getTipo().naoFormatado()) || !codPagamento.equals(pagamento.getCodigo().naoFormatado())) continue;
                        achou = true;
                        pagamento.getValorPago().append('+', itemDirfPrevidencia.getValorPagoPrevidencia());
                        if (!"37".equals(codPagamento)) break;
                        pagamento.getContribuicaoEntePatrocinador().append('+', itemDirfPrevidencia.getValorPagoEntePatrocinador());
                        break;
                    }
                    if (!achou) {
                        Pagamento pagamento = new Pagamento(dec);
                        pagamento.getTipo().setConteudo("T");
                        pagamento.getNiBeneficiario().setConteudo((NI)itemDirfPrevidencia.getCnpjPrevidencia());
                        pagamento.getNomeBeneficiario().setConteudo(itemDirfPrevidencia.getNomePrevidencia());
                        pagamento.getCodigo().setConteudo(codPagamento);
                        pagamento.getValorPago().setConteudo(itemDirfPrevidencia.getValorPagoPrevidencia());
                        if ("37".equals(codPagamento)) {
                            pagamento.getContribuicaoEntePatrocinador().setConteudo(itemDirfPrevidencia.getValorPagoEntePatrocinador());
                        }
                        dec.getPagamentos().itens().add(pagamento);
                    }
                }
            } else if (!"0".equals(codPagamento)) {
                for (Pagamento pagamento : dec.getPagamentos().itens()) {
                    if (!pagamento.getNiBeneficiario().naoFormatado().equals(cnjpPrevidencia) || !"D".equals(pagamento.getTipo().naoFormatado()) || !pagamento.getCPFDependente().naoFormatado().equals(cpfContribuinte) || !codPagamento.equals(pagamento.getCodigo().naoFormatado())) continue;
                    achou = true;
                    pagamento.getValorPago().append('+', itemDirfPrevidencia.getValorPagoPrevidencia());
                    if (!"37".equals(codPagamento)) break;
                    pagamento.getContribuicaoEntePatrocinador().append('+', itemDirfPrevidencia.getValorPagoEntePatrocinador());
                    break;
                }
                if (!achou) {
                    Pagamento pagamento = new Pagamento(dec);
                    pagamento.getTipo().setConteudo("D");
                    pagamento.getCPFDependente().setConteudo(cpfContribuinte);
                    pagamento.getNiBeneficiario().setConteudo((NI)itemDirfPrevidencia.getCnpjPrevidencia());
                    pagamento.getNomeBeneficiario().setConteudo(itemDirfPrevidencia.getNomePrevidencia());
                    pagamento.getCodigo().setConteudo(codPagamento);
                    pagamento.getValorPago().setConteudo(itemDirfPrevidencia.getValorPagoPrevidencia());
                    if ("37".equals(codPagamento)) {
                        pagamento.getContribuicaoEntePatrocinador().setConteudo(itemDirfPrevidencia.getValorPagoEntePatrocinador());
                    }
                    dec.getPagamentos().itens().add(pagamento);
                }
            }
        }
    }

    private void mesclarDadosDirfFundoClubeComDeclaracao(DeclaracaoIRPF dec, ItemDirfFundoClube itemDirfFundoClube, String cpfContribuinte) {
        this.importarTransporteDetalhadoFundoClube(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar(), itemDirfFundoClube, itemDirfFundoClube.getRendIsentoParc65Anos(), cpfContribuinte, true);
        this.importarPensaoFundoClube(dec, itemDirfFundoClube, cpfContribuinte);
        RendGenerico acumuladorRendIsentosAnosAnteriores = new RendGenerico();
        acumuladorRendIsentosAnosAnteriores.getValorRecebimento().append('+', itemDirfFundoClube.getRendIsentoIRRFAnosAnt3223().getValorRecebimento());
        acumuladorRendIsentosAnosAnteriores.getValorRecebimento().append('+', itemDirfFundoClube.getRendIsentoIRRFAnosAnt3540().getValorRecebimento());
        acumuladorRendIsentosAnosAnteriores.getValorRecebimento().append('+', itemDirfFundoClube.getRendIsentoIRRFAnosAnt3556().getValorRecebimento());
        this.importarTransporteDetalhadoNI(dec, (Colecao<ItemQuadroRendimentosNI>)dec.getRendIsentos().getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar(), itemDirfFundoClube, acumuladorRendIsentosAnosAnteriores, cpfContribuinte);
        RendGenericoComDescricao acumuladorRendIsentosOutrosContribPrev = new RendGenericoComDescricao();
        acumuladorRendIsentosOutrosContribPrev.getValorRecebimento().append('+', itemDirfFundoClube.getRendIsentoOutros3223().getValorRecebimento());
        acumuladorRendIsentosOutrosContribPrev.getValorRecebimento().append('+', itemDirfFundoClube.getRendIsentoOutros3540().getValorRecebimento());
        acumuladorRendIsentosOutrosContribPrev.getValorRecebimento().append('+', itemDirfFundoClube.getRendIsentoOutros3556().getValorRecebimento());
        acumuladorRendIsentosOutrosContribPrev.getValorRecebimento().append('+', itemDirfFundoClube.getRendIsentoOutros3579().getValorRecebimento());
        acumuladorRendIsentosOutrosContribPrev.getValorRecebimento().append('+', itemDirfFundoClube.getRendIsentoOutros5565().getValorRecebimento());
        acumuladorRendIsentosOutrosContribPrev.getDescricaoRecebimento().setConteudo("Contribui\u00e7\u00f5es Previd\u00eancia Complementar 89/95 IN 1343/2013");
        this.importarOutrosRendimentosFundoClube(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfFundoClube, (RendGenerico)acumuladorRendIsentosOutrosContribPrev, acumuladorRendIsentosOutrosContribPrev.getDescricaoRecebimento().naoFormatado(), cpfContribuinte, true);
        this.importarOutrosRendimentosFundoClube(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendIsentos().getOutrosQuadroAuxiliar(), itemDirfFundoClube, (RendGenerico)itemDirfFundoClube.getRendIsentoOutros3540Anual(), itemDirfFundoClube.getRendIsentoOutros3540Anual().getDescricaoRecebimento().naoFormatado(), cpfContribuinte, true);
        this.importarOutrosRendimentosFundoClube(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar(), itemDirfFundoClube, itemDirfFundoClube.getTribExclOutros3579(), "Resgate de Previd\u00eancia Complementar", cpfContribuinte, false);
        this.importarOutrosRendimentosFundoClube(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar(), itemDirfFundoClube, itemDirfFundoClube.getTribExclOutros5565(), "Benef\u00edcio de Previd\u00eancia Complementar", cpfContribuinte, false);
        this.importarTransporteDetalhadoFundoClube(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendTributacaoExclusiva().getJurosCapitalProprioQuadroAuxiliar(), itemDirfFundoClube, itemDirfFundoClube.getTribExclJuros(), cpfContribuinte, true);
        this.importarAplicacaoFinanceiraFundoClube(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar(), itemDirfFundoClube, itemDirfFundoClube.getTribExclAplicFin5232(), cpfContribuinte, false);
        this.importarAplicacaoFinanceiraFundoClube(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar(), itemDirfFundoClube, itemDirfFundoClube.getTribExclAplicFin6800(), cpfContribuinte, false);
        this.importarAplicacaoFinanceiraFundoClube(dec, (Colecao<ItemQuadroTransporteDetalhado>)dec.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar(), itemDirfFundoClube, itemDirfFundoClube.getTribExclAplicFin6813(), cpfContribuinte, false);
        this.importarOutrosRendimentosFundoClube(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar(), itemDirfFundoClube, itemDirfFundoClube.getTribExclOutros0924(), "FICART e demais rendimentos de capital (day-trade)", cpfContribuinte, false);
        this.importarOutrosRendimentosFundoClube(dec, (Colecao<ItemQuadroOutrosRendimentos>)dec.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar(), itemDirfFundoClube, itemDirfFundoClube.getTribExclOutros5029(), "GCAP - Integraliza\u00e7\u00e3o de cotas com ativos financeiros", cpfContribuinte, false);
        RendPJExigibilidade rendExigSuspensa = new RendPJExigibilidade();
        rendExigSuspensa.getValorRendimento().append('+', itemDirfFundoClube.getExigSusp3223().getValorRendimento());
        rendExigSuspensa.getValorRendimento().append('+', itemDirfFundoClube.getExigSusp3540().getValorRendimento());
        rendExigSuspensa.getValorRendimento().append('+', itemDirfFundoClube.getExigSusp3556().getValorRendimento());
        rendExigSuspensa.getDepositoJudicial().append('+', itemDirfFundoClube.getExigSusp3223().getDepositoJudicial());
        rendExigSuspensa.getDepositoJudicial().append('+', itemDirfFundoClube.getExigSusp3540().getDepositoJudicial());
        rendExigSuspensa.getDepositoJudicial().append('+', itemDirfFundoClube.getExigSusp3556().getDepositoJudicial());
        this.importarRendPJComExigibilidadeSuspensaFundoClube(dec, itemDirfFundoClube, rendExigSuspensa, cpfContribuinte);
        this.importarRendPJFundoClube(dec, itemDirfFundoClube, cpfContribuinte);
    }

    private void mesclarDadosDimobPessoaFisicaComDeclaracao(DeclaracaoIRPF dec, ItemDimobPessoaFisicaPagamento itemDimobPessoaFisica, String cpfContribuinte) {
        if (!itemDimobPessoaFisica.isVazio()) {
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                for (int i = 0; i < 12; ++i) {
                    dec.getRendPFTitular().getMesRendPFPorIndice(i).getAlugueis().append('+', itemDimobPessoaFisica.getValorRendimentoLiquidoPorMes(i));
                }
            } else {
                ItemRendPFDependente itemRendPFDependentedec = dec.getRendPFDependente().obterItemRendPFDependentePorCPF(cpfContribuinte);
                if (itemRendPFDependentedec == null) {
                    itemRendPFDependentedec = new ItemRendPFDependente();
                    itemRendPFDependentedec.getCpf().setConteudo(cpfContribuinte);
                    dec.getRendPFDependente().itens().add(itemRendPFDependentedec);
                } else {
                    for (ItemRendPFDependente itemRendPFDependente : dec.getRendPFDependente().itens()) {
                        if (!itemRendPFDependente.getCpf().naoFormatado().equals(cpfContribuinte)) continue;
                        itemRendPFDependentedec = itemRendPFDependente;
                    }
                }
                if (itemRendPFDependentedec != null) {
                    for (int i = 0; i < 12; ++i) {
                        itemRendPFDependentedec.getRendimentos().getMesRendPFPorIndice(i).getAlugueis().append('+', itemDimobPessoaFisica.getValorRendimentoLiquidoPorMes(i));
                    }
                }
            }
            this.incluirPagamentoAdministradoraImoveis(dec, itemDimobPessoaFisica.getCnpjDeclarante().naoFormatado(), itemDimobPessoaFisica.getNomeDeclarante().naoFormatado(), itemDimobPessoaFisica.getTotalComissao());
        }
    }

    private void mesclarDadosDimobPessoaJuridicaComDeclaracao(DeclaracaoIRPF dec, ItemDimobPessoaJuridica itemDimobPessoaJuridica, String cpfContribuinte) {
        if (!itemDimobPessoaJuridica.isVazio()) {
            String niFontePagadora = itemDimobPessoaJuridica.getNiLocadorLocatario().naoFormatado();
            if (!pessoasJuridicasImportadasDirf.contains(niFontePagadora.substring(0, 8))) {
                boolean achou = false;
                boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
                if (titular) {
                    for (RendPJTitular rendPJTitular : dec.getRendPJ().getColecaoRendPJTitular().itens()) {
                        if (!rendPJTitular.getNIFontePagadora().naoFormatado().equals(niFontePagadora) || !rendPJTitular.todosValoresZerados()) continue;
                        achou = true;
                        rendPJTitular.getRendRecebidoPJ().setConteudo(itemDimobPessoaJuridica.getValorRendimento().operacao('-', itemDimobPessoaJuridica.getValorComissao()));
                        rendPJTitular.getImpostoRetidoFonte().setConteudo(itemDimobPessoaJuridica.getValorImposto());
                        break;
                    }
                    if (!achou) {
                        RendPJTitular rendPJTitular = new RendPJTitular(dec.getIdentificadorDeclaracao());
                        rendPJTitular.getNIFontePagadora().setConteudo(niFontePagadora);
                        rendPJTitular.getNomeFontePagadora().setConteudo(itemDimobPessoaJuridica.getNomeLocadorLocatario());
                        rendPJTitular.getRendRecebidoPJ().setConteudo(itemDimobPessoaJuridica.getValorRendimento().operacao('-', itemDimobPessoaJuridica.getValorComissao()));
                        rendPJTitular.getImpostoRetidoFonte().setConteudo(itemDimobPessoaJuridica.getValorImposto());
                        dec.getRendPJ().getColecaoRendPJTitular().itens().add(rendPJTitular);
                    }
                } else {
                    for (RendPJTitular rendPJDep : dec.getRendPJ().getColecaoRendPJDependente().itens()) {
                        RendPJDependente rendPJDependente = (RendPJDependente)rendPJDep;
                        if (!rendPJDependente.getNIFontePagadora().naoFormatado().equals(niFontePagadora) || !rendPJDependente.getCpfDependente().naoFormatado().equals(cpfContribuinte) || !rendPJDependente.todosValoresZerados()) continue;
                        achou = true;
                        rendPJDependente.getRendRecebidoPJ().setConteudo(itemDimobPessoaJuridica.getValorRendimento().operacao('-', itemDimobPessoaJuridica.getValorComissao()));
                        rendPJDependente.getImpostoRetidoFonte().setConteudo(itemDimobPessoaJuridica.getValorImposto());
                        break;
                    }
                    if (!achou) {
                        RendPJDependente rendPJDependente = new RendPJDependente(dec);
                        rendPJDependente.getCpfDependente().setConteudo(cpfContribuinte);
                        rendPJDependente.getNIFontePagadora().setConteudo(niFontePagadora);
                        rendPJDependente.getNomeFontePagadora().setConteudo(itemDimobPessoaJuridica.getNomeLocadorLocatario());
                        rendPJDependente.getRendRecebidoPJ().setConteudo(itemDimobPessoaJuridica.getValorRendimento().operacao('-', itemDimobPessoaJuridica.getValorComissao()));
                        rendPJDependente.getImpostoRetidoFonte().setConteudo(itemDimobPessoaJuridica.getValorImposto());
                        dec.getRendPJ().getColecaoRendPJDependente().itens().add(rendPJDependente);
                    }
                }
            }
            this.incluirPagamentoAdministradoraImoveis(dec, itemDimobPessoaJuridica.getCnpjDeclarante().naoFormatado(), itemDimobPessoaJuridica.getNomeDeclarante().naoFormatado(), itemDimobPessoaJuridica.getValorComissao());
        }
    }

    private void incluirPagamentoAdministradoraImoveis(DeclaracaoIRPF dec, String niDeclarante, String nomeDeclarante, Valor comissao) {
        boolean achou = false;
        for (Pagamento pagamento : dec.getPagamentos().itens()) {
            if (!pagamento.getNiBeneficiario().naoFormatado().equals(niDeclarante) || !pagamento.getCodigo().naoFormatado().equals("71")) continue;
            achou = true;
            pagamento.getValorPago().append('+', comissao);
            break;
        }
        if (!achou) {
            Pagamento pagamento = new Pagamento(dec);
            pagamento.getTipo().setConteudo("T");
            pagamento.getCodigo().setConteudo("71");
            pagamento.getNiBeneficiario().setConteudo(niDeclarante);
            pagamento.getNomeBeneficiario().setConteudo(nomeDeclarante);
            pagamento.getValorPago().setConteudo(comissao);
            dec.getPagamentos().itens().add(pagamento);
        }
    }

    private void mesclarDadosDimobPagamentosComDeclaracao(DeclaracaoIRPF dec, ItemDimobPessoaFisicaPagamento itemDimobPagamentos, String cpfContribuinte) {
        if (!itemDimobPagamentos.isVazio()) {
            String niLocadorLocatario = itemDimobPagamentos.getNiLocadorLocatario().naoFormatado();
            boolean achou = false;
            for (Pagamento pagamento : dec.getPagamentos().itens()) {
                if (!pagamento.getNiBeneficiario().naoFormatado().equals(niLocadorLocatario) || !pagamento.getCodigo().naoFormatado().equals("70")) continue;
                achou = true;
                pagamento.getValorPago().append('+', itemDimobPagamentos.getTotalRendimento());
                break;
            }
            if (!achou) {
                Pagamento pagamento = new Pagamento(dec);
                boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
                if (titular) {
                    pagamento.getTipo().setConteudo("T");
                } else {
                    pagamento.getTipo().setConteudo("D");
                    pagamento.getCPFDependente().setConteudo(cpfContribuinte);
                }
                pagamento.getCodigo().setConteudo("70");
                pagamento.getNiBeneficiario().setConteudo(itemDimobPagamentos.getNiLocadorLocatario());
                pagamento.getNomeBeneficiario().setConteudo(itemDimobPagamentos.getNomeLocadorLocatario());
                pagamento.getValorPago().setConteudo(itemDimobPagamentos.getTotalRendimento());
                dec.getPagamentos().itens().add(pagamento);
            }
        }
    }

    private void mesclarDadosDmedComDeclaracao(DeclaracaoIRPF dec, ItemDmed itemDmedDirf, String cpfContribuinte) {
        if (!itemDmedDirf.isVazio()) {
            block6 : switch (itemDmedDirf.getTipoDeclaracao().naoFormatado()) {
                case "0": {
                    this.incluirPagamentoPlanoSaude(dec, itemDmedDirf, false, cpfContribuinte);
                    break;
                }
                case "2": {
                    this.incluirPagamentoPlanoSaude(dec, itemDmedDirf, true, cpfContribuinte);
                    break;
                }
                case "1": {
                    this.incluirPagamentoMedicoReembolsoAnoAnterior(dec, itemDmedDirf, false, cpfContribuinte);
                    break;
                }
                case "3": {
                    switch (itemDmedDirf.getTitularResponsavel().getPapel().naoFormatado()) {
                        case "T": {
                            this.incluirPagamentoPlanoSaude(dec, itemDmedDirf, true, cpfContribuinte);
                            break block6;
                        }
                        case "R": {
                            this.incluirPagamentoMedicoReembolsoAnoAnterior(dec, itemDmedDirf, true, cpfContribuinte);
                        }
                    }
                }
            }
        }
    }

    private void incluirPagamentoMedicoReembolsoAnoAnterior(DeclaracaoIRPF dec, ItemDmed itemDmed, boolean rendPJ, String cpfContribuinte) {
        Valor valorReembolsoAnosAnteriores = new Valor();
        for (ItemDmedPessoaFisica item : itemDmed.obterTodos()) {
            if (item.isVazio() || item.getValorPago().isVazio()) continue;
            String niBeneficiario = itemDmed.getCpfCnpjDeclarante().naoFormatado();
            boolean achou = false;
            boolean titular = false;
            if (this.existeItemHashPagamentosDMED(niBeneficiario, item)) continue;
            this.adicionarItemHashPagamentosDMED(cpfContribuinte, niBeneficiario, item);
            if (item.isTitularResponsavel().booleanValue() && dec.getContribuinte().getIdentificadorDeclaracao().getCpf().naoFormatado().equals(item.getCpf().naoFormatado())) {
                titular = true;
            }
            for (Pagamento pagamento : dec.getPagamentos().itens()) {
                if (!pagamento.getCodigo().toString().equals("21") || !pagamento.getNiBeneficiario().naoFormatado().equals(niBeneficiario) || !pagamento.getValorPago().isVazio() || !(pagamento.getTipo().toString().equals("D") && pagamento.getDependenteOuAlimentando().toString().equalsIgnoreCase(item.getNome().toString()) || pagamento.getTipo().toString().equals("A") && pagamento.getDependenteOuAlimentando().toString().equalsIgnoreCase(item.getNome().toString())) && (!pagamento.getTipo().toString().equals("T") || !titular)) continue;
                achou = true;
                pagamento.getValorPago().setConteudo(item.getValorPago());
                pagamento.getParcelaNaoDedutivel().setConteudo(item.getValorReembolso());
                pagamento.getCodigo().setConteudo("21");
                if (item.getValorReembolsoAnoAnterior().isVazio()) break;
                valorReembolsoAnosAnteriores.append('+', item.getValorReembolsoAnoAnterior());
                break;
            }
            if (achou) continue;
            Pagamento pagamento = new Pagamento(dec);
            pagamento.getCodigo().setConteudo("21");
            pagamento.getNiBeneficiario().setConteudo(itemDmed.getCpfCnpjDeclarante());
            pagamento.getNomeBeneficiario().setConteudo(itemDmed.getNomeDeclarante());
            pagamento.getValorPago().setConteudo(item.getValorPago());
            pagamento.getParcelaNaoDedutivel().setConteudo(item.getValorReembolso());
            boolean incluir = this.definirTipoPagamento(dec, item, pagamento);
            if (!incluir) continue;
            dec.getPagamentos().itens().add(pagamento);
            if (item.getValorReembolsoAnoAnterior().isVazio()) continue;
            valorReembolsoAnosAnteriores.append('+', item.getValorReembolsoAnoAnterior());
        }
        if (rendPJ && !valorReembolsoAnosAnteriores.isVazio()) {
            RendPJTitular rendPJTitular = new RendPJTitular(dec.getIdentificadorDeclaracao());
            rendPJTitular.getNIFontePagadora().setConteudo(itemDmed.getCpfCnpjDeclarante());
            rendPJTitular.getNomeFontePagadora().setConteudo(itemDmed.getNomeDeclarante());
            rendPJTitular.getRendRecebidoPJ().setConteudo(valorReembolsoAnosAnteriores);
            dec.getRendPJ().getColecaoRendPJTitular().itens().add(rendPJTitular);
        }
    }

    private void incluirPagamentoPlanoSaude(DeclaracaoIRPF dec, ItemDmed itemDmed, boolean parcelaNaoDedutivel, String cpfContribuinte) {
        Valor valorReembolsoAnosAnteriores = new Valor();
        for (ItemDmedPessoaFisica item : itemDmed.obterTodos()) {
            boolean incluir;
            if (item.isVazio() || item.getValorPago().isVazio()) continue;
            String niBeneficiario = itemDmed.getCpfCnpjDeclarante().naoFormatado();
            boolean achou = false;
            boolean titular = false;
            if (this.existeItemHashPagamentosDMED(niBeneficiario, item)) continue;
            this.adicionarItemHashPagamentosDMED(cpfContribuinte, niBeneficiario, item);
            if (item.isTitularResponsavel().booleanValue() && dec.getContribuinte().getIdentificadorDeclaracao().getCpf().naoFormatado().equals(item.getCpf().naoFormatado())) {
                titular = true;
            }
            for (Pagamento pagamento : dec.getPagamentos().itens()) {
                if (!pagamento.getCodigo().toString().equals("26") || !pagamento.getNiBeneficiario().naoFormatado().equals(niBeneficiario) || !pagamento.getValorPago().isVazio() || !(pagamento.getTipo().toString().equals("D") && pagamento.getDependenteOuAlimentando().toString().equalsIgnoreCase(item.getNome().toString()) || pagamento.getTipo().toString().equals("A") && pagamento.getDependenteOuAlimentando().toString().equalsIgnoreCase(item.getNome().toString())) && (!pagamento.getTipo().toString().equals("T") || !titular)) continue;
                achou = true;
                pagamento.getValorPago().setConteudo(item.getValorPago());
                pagamento.getParcelaNaoDedutivel().setConteudo(item.getValorReembolso());
                pagamento.getCodigo().setConteudo("26");
                if (item.getValorReembolsoAnoAnterior().isVazio()) break;
                valorReembolsoAnosAnteriores.append('+', item.getValorReembolsoAnoAnterior());
                break;
            }
            if (achou) continue;
            Pagamento pagamento = new Pagamento(dec);
            pagamento.getCodigo().setConteudo("26");
            pagamento.getNiBeneficiario().setConteudo(itemDmed.getCpfCnpjDeclarante());
            pagamento.getNomeBeneficiario().setConteudo(itemDmed.getNomeDeclarante());
            pagamento.getValorPago().setConteudo(item.getValorPago());
            if (parcelaNaoDedutivel) {
                pagamento.getParcelaNaoDedutivel().setConteudo(item.getValorReembolso());
            }
            if (!(incluir = this.definirTipoPagamento(dec, item, pagamento).booleanValue())) continue;
            dec.getPagamentos().itens().add(pagamento);
            if (item.getValorReembolsoAnoAnterior().isVazio()) continue;
            valorReembolsoAnosAnteriores.append('+', item.getValorReembolsoAnoAnterior());
        }
        if ((itemDmed.getTipoDeclaracao().naoFormatado().equals("0") || itemDmed.getTipoDeclaracao().naoFormatado().equals("2") || itemDmed.getTipoDeclaracao().naoFormatado().equals("3")) && !valorReembolsoAnosAnteriores.isVazio()) {
            RendPJTitular rendPJTitular = new RendPJTitular(dec.getIdentificadorDeclaracao());
            rendPJTitular.getNIFontePagadora().setConteudo(itemDmed.getCpfCnpjDeclarante());
            rendPJTitular.getNomeFontePagadora().setConteudo(itemDmed.getNomeDeclarante());
            rendPJTitular.getRendRecebidoPJ().setConteudo(valorReembolsoAnosAnteriores);
            dec.getRendPJ().getColecaoRendPJTitular().itens().add(rendPJTitular);
        }
    }

    private Boolean definirTipoPagamento(DeclaracaoIRPF dec, ItemDmedPessoaFisica item, Pagamento pagamento) {
        Boolean retorno = false;
        String cpf = item.getCpf().naoFormatado();
        if (!cpf.equals("")) {
            if (dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpf)) {
                retorno = true;
                pagamento.getTipo().setConteudo("T");
            } else {
                Dependente dependente = dec.getDependentes().getDependenteByCpf(item.getCpf().naoFormatado());
                if (dependente != null) {
                    retorno = true;
                    pagamento.getTipo().setConteudo("D");
                    pagamento.getCPFDependente().setConteudo(item.getCpf());
                    pagamento.getDependenteOuAlimentando().setConteudo(dependente.getNome());
                } else {
                    Alimentando alimentando = dec.getAlimentandos().getAlimentandoByCpf(item.getCpf().naoFormatado());
                    if (alimentando != null) {
                        retorno = true;
                        pagamento.getTipo().setConteudo("A");
                        pagamento.getCPFAlimentando().setConteudo(item.getCpf());
                        pagamento.getDependenteOuAlimentando().setConteudo(alimentando.getNome());
                    }
                }
            }
        }
        return retorno;
    }

    private void importarRendPJ(DeclaracaoIRPF dec, ItemDirfRendimentos itemDirfRendimentos, boolean importarVazio, String cpfContribuinte) {
        if (importarVazio || !itemDirfRendimentos.getRendPJ().isVazio()) {
            String niFontePagadora = itemDirfRendimentos.getHeader().getNiFontePagadora().naoFormatado();
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            boolean achou = false;
            if (titular) {
                for (RendPJTitular rendPJTitular : dec.getRendPJ().getColecaoRendPJTitular().itens()) {
                    if (!rendPJTitular.getNIFontePagadora().naoFormatado().equals(niFontePagadora) || !rendPJTitular.todosValoresZerados()) continue;
                    achou = true;
                    rendPJTitular.getRendRecebidoPJ().setConteudo(itemDirfRendimentos.getRendPJ().getValorRendimento());
                    rendPJTitular.getContribuicaoPrevOficial().setConteudo(itemDirfRendimentos.getRendPJ().getContribuicaoPrevidenciariaOficial());
                    rendPJTitular.getDecimoTerceiro().setConteudo(itemDirfRendimentos.getRendPJ().getDecimoTerceiro());
                    rendPJTitular.getImpostoRetidoFonte().setConteudo(itemDirfRendimentos.getRendPJ().getImpostoRetidoFonte());
                    rendPJTitular.getIRRFDecimoTerceiro().setConteudo(itemDirfRendimentos.getRendPJ().getImpostoRetidoFonteDecimoTerceiro());
                    break;
                }
                if (!achou) {
                    RendPJTitular rendPJTitular = new RendPJTitular(dec.getIdentificadorDeclaracao());
                    rendPJTitular.getNIFontePagadora().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora());
                    rendPJTitular.getNomeFontePagadora().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora());
                    rendPJTitular.getRendRecebidoPJ().setConteudo(itemDirfRendimentos.getRendPJ().getValorRendimento());
                    rendPJTitular.getContribuicaoPrevOficial().setConteudo(itemDirfRendimentos.getRendPJ().getContribuicaoPrevidenciariaOficial());
                    rendPJTitular.getDecimoTerceiro().setConteudo(itemDirfRendimentos.getRendPJ().getDecimoTerceiro());
                    rendPJTitular.getImpostoRetidoFonte().setConteudo(itemDirfRendimentos.getRendPJ().getImpostoRetidoFonte());
                    rendPJTitular.getIRRFDecimoTerceiro().setConteudo(itemDirfRendimentos.getRendPJ().getImpostoRetidoFonteDecimoTerceiro());
                    dec.getRendPJ().getColecaoRendPJTitular().itens().add(rendPJTitular);
                }
            } else {
                for (RendPJTitular rendPJDep : dec.getRendPJ().getColecaoRendPJDependente().itens()) {
                    RendPJDependente rendPJDependente = (RendPJDependente)rendPJDep;
                    if (!rendPJDependente.getNIFontePagadora().naoFormatado().equals(niFontePagadora) || !rendPJDependente.getCpfDependente().naoFormatado().equals(cpfContribuinte) || !rendPJDependente.todosValoresZerados()) continue;
                    achou = true;
                    rendPJDependente.getRendRecebidoPJ().setConteudo(itemDirfRendimentos.getRendPJ().getValorRendimento());
                    rendPJDependente.getContribuicaoPrevOficial().setConteudo(itemDirfRendimentos.getRendPJ().getContribuicaoPrevidenciariaOficial());
                    rendPJDependente.getDecimoTerceiro().setConteudo(itemDirfRendimentos.getRendPJ().getDecimoTerceiro());
                    rendPJDependente.getImpostoRetidoFonte().setConteudo(itemDirfRendimentos.getRendPJ().getImpostoRetidoFonte());
                    rendPJDependente.getIRRFDecimoTerceiro().setConteudo(itemDirfRendimentos.getRendPJ().getImpostoRetidoFonteDecimoTerceiro());
                    break;
                }
                if (!achou) {
                    RendPJDependente rendPJDependente = new RendPJDependente(dec);
                    rendPJDependente.getCpfDependente().setConteudo(cpfContribuinte);
                    rendPJDependente.getNIFontePagadora().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora());
                    rendPJDependente.getNomeFontePagadora().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora());
                    rendPJDependente.getRendRecebidoPJ().setConteudo(itemDirfRendimentos.getRendPJ().getValorRendimento());
                    rendPJDependente.getContribuicaoPrevOficial().setConteudo(itemDirfRendimentos.getRendPJ().getContribuicaoPrevidenciariaOficial());
                    rendPJDependente.getDecimoTerceiro().setConteudo(itemDirfRendimentos.getRendPJ().getDecimoTerceiro());
                    rendPJDependente.getImpostoRetidoFonte().setConteudo(itemDirfRendimentos.getRendPJ().getImpostoRetidoFonte());
                    rendPJDependente.getIRRFDecimoTerceiro().setConteudo(itemDirfRendimentos.getRendPJ().getImpostoRetidoFonteDecimoTerceiro());
                    dec.getRendPJ().getColecaoRendPJDependente().itens().add(rendPJDependente);
                }
            }
            pessoasJuridicasImportadasDirf.add(niFontePagadora.substring(0, 8));
        }
    }

    private void importarRendPJFundoClube(DeclaracaoIRPF dec, ItemDirfFundoClube itemDirfFundoClube, String cpfContribuinte) {
        if (!itemDirfFundoClube.getRendPJFundoClube().isVazio()) {
            String cnpjFundoClube = itemDirfFundoClube.getCnpjFundoClube().naoFormatado();
            boolean achou = false;
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                for (RendPJTitular rendPJTitular : dec.getRendPJ().getColecaoRendPJTitular().itens()) {
                    if (!rendPJTitular.getNIFontePagadora().naoFormatado().equals(cnpjFundoClube) || !rendPJTitular.todosValoresZerados()) continue;
                    achou = true;
                    rendPJTitular.getRendRecebidoPJ().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getValorRendimento());
                    rendPJTitular.getImpostoRetidoFonte().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getImpostoRetidoFonte());
                    rendPJTitular.getDecimoTerceiro().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getDecimoTerceiro());
                    rendPJTitular.getIRRFDecimoTerceiro().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getImpostoRetidoFonteDecimoTerceiro());
                    break;
                }
                if (!achou) {
                    RendPJTitular rendPJTitular = new RendPJTitular(dec.getIdentificadorDeclaracao());
                    rendPJTitular.getNIFontePagadora().setConteudo(cnpjFundoClube);
                    rendPJTitular.getNomeFontePagadora().setConteudo(itemDirfFundoClube.getNomeEmpresarial());
                    rendPJTitular.getRendRecebidoPJ().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getValorRendimento());
                    rendPJTitular.getImpostoRetidoFonte().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getImpostoRetidoFonte());
                    rendPJTitular.getDecimoTerceiro().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getDecimoTerceiro());
                    rendPJTitular.getIRRFDecimoTerceiro().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getImpostoRetidoFonteDecimoTerceiro());
                    dec.getRendPJ().getColecaoRendPJTitular().itens().add(rendPJTitular);
                }
            } else {
                for (RendPJTitular rendPJDep : dec.getRendPJ().getColecaoRendPJDependente().itens()) {
                    RendPJDependente rendPJDependente = (RendPJDependente)rendPJDep;
                    if (!rendPJDependente.getNIFontePagadora().naoFormatado().equals(cnpjFundoClube) || !rendPJDependente.getCpfDependente().naoFormatado().equals(cpfContribuinte) || !rendPJDependente.todosValoresZerados()) continue;
                    achou = true;
                    rendPJDependente.getRendRecebidoPJ().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getValorRendimento());
                    rendPJDependente.getImpostoRetidoFonte().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getImpostoRetidoFonte());
                    rendPJDependente.getDecimoTerceiro().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getDecimoTerceiro());
                    rendPJDependente.getIRRFDecimoTerceiro().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getImpostoRetidoFonteDecimoTerceiro());
                    break;
                }
                if (!achou) {
                    RendPJDependente rendPJDependente = new RendPJDependente(dec);
                    rendPJDependente.getCpfDependente().setConteudo(cpfContribuinte);
                    rendPJDependente.getNIFontePagadora().setConteudo(cnpjFundoClube);
                    rendPJDependente.getNomeFontePagadora().setConteudo(itemDirfFundoClube.getNomeEmpresarial());
                    rendPJDependente.getRendRecebidoPJ().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getValorRendimento());
                    rendPJDependente.getImpostoRetidoFonte().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getImpostoRetidoFonte());
                    rendPJDependente.getDecimoTerceiro().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getDecimoTerceiro());
                    rendPJDependente.getIRRFDecimoTerceiro().setConteudo(itemDirfFundoClube.getRendPJFundoClube().getImpostoRetidoFonteDecimoTerceiro());
                    dec.getRendPJ().getColecaoRendPJDependente().itens().add(rendPJDependente);
                }
            }
        }
    }

    private void importarPensao(DeclaracaoIRPF dec, ItemDirfRendimentos itemDirfRendimentos, String cpfContribuinte) {
        if (!itemDirfRendimentos.getPensao().isVazio()) {
            ItemQuadroPensaoMolestiaGrave item = new ItemQuadroPensaoMolestiaGrave(dec);
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getNiEmpresa().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora().naoFormatado());
            item.getNomeFonte().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora());
            item.getValor().setConteudo(itemDirfRendimentos.getPensao().getValorRecebimento());
            item.getValor13Salario().setConteudo(itemDirfRendimentos.getPensao().getValorDecimoTerceiro());
            dec.getRendIsentos().getPensaoQuadroAuxiliar().itens().add(item);
        }
    }

    private void importarPensaoFundoClube(DeclaracaoIRPF dec, ItemDirfFundoClube itemDirfFundoClube, String cpfContribuinte) {
        if (!itemDirfFundoClube.getRendIsentoMolestiaGrave().isVazio()) {
            ItemQuadroPensaoMolestiaGrave item = new ItemQuadroPensaoMolestiaGrave(dec);
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getNiEmpresa().setConteudo((NI)itemDirfFundoClube.getCnpjFundoClube());
            item.getNomeFonte().setConteudo(itemDirfFundoClube.getNomeEmpresarial());
            item.getValor().setConteudo(itemDirfFundoClube.getRendIsentoMolestiaGrave().getValorRecebimento());
            item.getValor13Salario().setConteudo(itemDirfFundoClube.getRendIsentoMolestiaGrave().getValorDecimoTerceiro());
            dec.getRendIsentos().getPensaoQuadroAuxiliar().itens().add(item);
        }
    }

    private void importarTransporteDetalhado(DeclaracaoIRPF dec, Colecao<ItemQuadroTransporteDetalhado> colecao, ItemDirfRendimentos itemDirfRendimentos, RendGenerico rendGenerico, String cpfContribuinte, Boolean ... isentos) {
        if (!rendGenerico.isVazio()) {
            ItemQuadroTransporteDetalhado item = isentos == null ? new ItemQuadroTransporteDetalhado(dec) : new ItemQuadroTransporteDetalhado(dec, (ObjetoNegocio)dec.getRendTributacaoExclusiva());
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getCnpjEmpresa().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora().naoFormatado());
            item.getNomeFonte().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora());
            item.getValor().setConteudo(rendGenerico.getValorRecebimento());
            colecao.itens().add(item);
        }
    }

    private void importarTransporteDetalhadoFundoClube(DeclaracaoIRPF dec, Colecao<ItemQuadroTransporteDetalhado> colecao, ItemDirfFundoClube itemDirfFundoClube, RendGenerico rendGenerico, String cpfContribuinte, Boolean ... isentos) {
        if (!rendGenerico.isVazio()) {
            ItemQuadroTransporteDetalhado item = isentos == null ? new ItemQuadroTransporteDetalhado(dec) : new ItemQuadroTransporteDetalhado(dec, (ObjetoNegocio)dec.getRendTributacaoExclusiva());
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getCnpjEmpresa().setConteudo(itemDirfFundoClube.getCnpjFundoClube());
            item.getNomeFonte().setConteudo(itemDirfFundoClube.getNomeEmpresarial());
            item.getValor().setConteudo(rendGenerico.getValorRecebimento());
            colecao.itens().add(item);
        }
    }

    private void importarTransporteDetalhadoNI(DeclaracaoIRPF dec, Colecao<ItemQuadroRendimentosNI> colecao, ItemDirfFundoClube itemDirfFundoClube, RendGenerico rendGenerico, String cpfContribuinte) {
        if (!rendGenerico.isVazio()) {
            ItemQuadroRendimentosNI item = new ItemQuadroRendimentosNI(dec);
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getCnpjEmpresa().setConteudo((NI)itemDirfFundoClube.getCnpjFundoClube());
            item.getNomeFonte().setConteudo(itemDirfFundoClube.getNomeEmpresarial());
            item.getValor().setConteudo(rendGenerico.getValorRecebimento());
            colecao.itens().add(item);
        }
    }

    private void importarAplicacaoFinanceira(DeclaracaoIRPF dec, Colecao<ItemQuadroTransporteDetalhado> colecao, ItemDirfRendimentos itemDirfRendimentos, RendAplicacaoFinanceira rendAplicacaoFinanceira, String cpfContribuinte, Boolean ... isentos) {
        Valor rendimento = rendAplicacaoFinanceira.getValorRecebimento().operacao('-', rendAplicacaoFinanceira.getImpostoRetidoFonte());
        if (rendimento.comparacao(">", "0,00")) {
            ItemQuadroTransporteDetalhado item = isentos == null ? new ItemQuadroTransporteDetalhado(dec) : new ItemQuadroTransporteDetalhado(dec, (ObjetoNegocio)dec.getRendTributacaoExclusiva());
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getCnpjEmpresa().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora().naoFormatado());
            item.getNomeFonte().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora());
            item.getValor().setConteudo(rendimento);
            colecao.itens().add(item);
        }
    }

    private void importarAplicacaoFinanceiraFundoClube(DeclaracaoIRPF dec, Colecao<ItemQuadroTransporteDetalhado> colecao, ItemDirfFundoClube itemDirfFundoClube, RendAplicacaoFinanceira rendAplicacaoFinanceira, String cpfContribuinte, Boolean ... isentos) {
        Valor rendimento = rendAplicacaoFinanceira.getValorRecebimento().operacao('-', rendAplicacaoFinanceira.getImpostoRetidoFonte());
        if (rendimento.comparacao(">", "0,00")) {
            ItemQuadroTransporteDetalhado item = isentos == null ? new ItemQuadroTransporteDetalhado(dec) : new ItemQuadroTransporteDetalhado(dec, (ObjetoNegocio)dec.getRendTributacaoExclusiva());
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getCnpjEmpresa().setConteudo(itemDirfFundoClube.getCnpjFundoClube());
            item.getNomeFonte().setConteudo(itemDirfFundoClube.getNomeEmpresarial());
            item.getValor().setConteudo(rendimento);
            colecao.itens().add(item);
        }
    }

    private void importarParcIsentaAposentadoria(DeclaracaoIRPF dec, Colecao<ItemQuadroTransporteDetalhado> colecao, ItemDirfRendimentos itemDirfRendimentos, RendGenerico valorPensao, RendGenerico valor13, String cpfContribuinte) {
        if (!valorPensao.isVazio() || !valor13.isVazio()) {
            ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(dec, true);
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getCnpjEmpresa().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora().naoFormatado());
            item.getNomeFonte().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora());
            item.getValor().setConteudo(valorPensao.getValorRecebimento());
            item.getValor13Salario().setConteudo(valor13.getValorRecebimento());
            colecao.itens().add(item);
        }
    }

    private void importarQuadroRendimentosNI(DeclaracaoIRPF dec, Colecao<ItemQuadroRendimentosNI> colecao, ItemDirfRendimentos itemDirfRendimentos, RendGenerico rendGenerico, String cpfContribuinte) {
        if (!rendGenerico.isVazio()) {
            ItemQuadroRendimentosNI item = new ItemQuadroRendimentosNI(dec);
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getCnpjEmpresa().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora().naoFormatado());
            item.getNomeFonte().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora());
            item.getValor().setConteudo(rendGenerico.getValorRecebimento());
            colecao.itens().add(item);
        }
    }

    private void importarRendPJComExigibilidadeSuspensa(DeclaracaoIRPF dec, ItemDirfRendimentos itemDirfRendimentos, String cpfContribuinte) {
        if (!itemDirfRendimentos.getRendPJexigibilidade().isVazio()) {
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                RendPJComExigibilidadeTitular rendPJComExigibilidade = new RendPJComExigibilidadeTitular(dec.getIdentificadorDeclaracao());
                rendPJComExigibilidade.getNIFontePagadora().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora().naoFormatado());
                rendPJComExigibilidade.getNomeFontePagadora().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora().naoFormatado());
                rendPJComExigibilidade.getRendExigSuspensa().setConteudo(itemDirfRendimentos.getRendPJexigibilidade().getValorRendimento());
                rendPJComExigibilidade.getDepositoJudicial().setConteudo(itemDirfRendimentos.getRendPJexigibilidade().getDepositoJudicial());
                dec.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeTitular().itens().add(rendPJComExigibilidade);
            } else {
                RendPJComExigibilidadeDependente rendPJComExigibilidade = new RendPJComExigibilidadeDependente(dec);
                rendPJComExigibilidade.getCpfDependente().setConteudo(cpfContribuinte);
                rendPJComExigibilidade.getNIFontePagadora().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora().naoFormatado());
                rendPJComExigibilidade.getNomeFontePagadora().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora().naoFormatado());
                rendPJComExigibilidade.getRendExigSuspensa().setConteudo(itemDirfRendimentos.getRendPJexigibilidade().getValorRendimento());
                rendPJComExigibilidade.getDepositoJudicial().setConteudo(itemDirfRendimentos.getRendPJexigibilidade().getDepositoJudicial());
                dec.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeDependente().itens().add(rendPJComExigibilidade);
            }
        }
    }

    private void importarRendPJComExigibilidadeSuspensaFundoClube(DeclaracaoIRPF dec, ItemDirfFundoClube itemDirfFundoClube, RendPJExigibilidade rendPJExigibilidade, String cpfContribuinte) {
        if (!rendPJExigibilidade.isVazio()) {
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                RendPJComExigibilidadeTitular rendPJComExigibilidade = new RendPJComExigibilidadeTitular(dec.getIdentificadorDeclaracao());
                rendPJComExigibilidade.getNIFontePagadora().setConteudo((NI)itemDirfFundoClube.getCnpjFundoClube());
                rendPJComExigibilidade.getNomeFontePagadora().setConteudo(itemDirfFundoClube.getNomeEmpresarial());
                rendPJComExigibilidade.getRendExigSuspensa().setConteudo(rendPJExigibilidade.getValorRendimento());
                rendPJComExigibilidade.getDepositoJudicial().setConteudo(rendPJExigibilidade.getDepositoJudicial());
                dec.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeTitular().itens().add(rendPJComExigibilidade);
            } else {
                RendPJComExigibilidadeDependente rendPJComExigibilidade = new RendPJComExigibilidadeDependente(dec);
                rendPJComExigibilidade.getCpfDependente().setConteudo(cpfContribuinte);
                rendPJComExigibilidade.getNIFontePagadora().setConteudo((NI)itemDirfFundoClube.getCnpjFundoClube());
                rendPJComExigibilidade.getNomeFontePagadora().setConteudo(itemDirfFundoClube.getNomeEmpresarial());
                rendPJComExigibilidade.getRendExigSuspensa().setConteudo(rendPJExigibilidade.getValorRendimento());
                rendPJComExigibilidade.getDepositoJudicial().setConteudo(rendPJExigibilidade.getDepositoJudicial());
                dec.getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeDependente().itens().add(rendPJComExigibilidade);
            }
        }
    }

    private void importarOutrosRendimentos(DeclaracaoIRPF dec, Colecao<ItemQuadroOutrosRendimentos> colecao, ItemDirfRendimentos itemDirfRendimentos, RendGenerico rendGenerico, String descricaoRecebimento, String cpfContribuinte, Boolean ... isentos) {
        if (!rendGenerico.isVazio()) {
            ItemQuadroOutrosRendimentos item = isentos == null ? new ItemQuadroOutrosRendimentos(dec) : new ItemQuadroOutrosRendimentos(dec, (ObjetoNegocio)dec.getRendTributacaoExclusiva());
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getCnpjEmpresa().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora().naoFormatado());
            item.getNomeFonte().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora());
            item.getValor().setConteudo(rendGenerico.getValorRecebimento());
            if (descricaoRecebimento != null && !descricaoRecebimento.trim().isEmpty()) {
                item.getDescricaoRendimento().setConteudo(descricaoRecebimento);
            } else if (rendGenerico instanceof RendGenericoComDescricao) {
                item.getDescricaoRendimento().setConteudo(((RendGenericoComDescricao)rendGenerico).getDescricaoRecebimento().naoFormatado());
            }
            colecao.itens().add(item);
        }
    }

    private void importarOutrosRendimentosFundoClube(DeclaracaoIRPF dec, Colecao<ItemQuadroOutrosRendimentos> colecao, ItemDirfFundoClube itemDirfFundoClube, RendGenerico rendGenerico, String descricaoRecebimento, String cpfContribuinte, Boolean ... isentos) {
        if (!rendGenerico.isVazio()) {
            ItemQuadroOutrosRendimentos item = isentos == null ? new ItemQuadroOutrosRendimentos(dec) : new ItemQuadroOutrosRendimentos(dec, (ObjetoNegocio)dec.getRendTributacaoExclusiva());
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getCnpjEmpresa().setConteudo((NI)itemDirfFundoClube.getCnpjFundoClube());
            item.getNomeFonte().setConteudo(itemDirfFundoClube.getNomeEmpresarial());
            item.getValor().setConteudo(rendGenerico.getValorRecebimento());
            item.getDescricaoRendimento().setConteudo(descricaoRecebimento != null ? descricaoRecebimento : ((RendGenericoComDescricao)rendGenerico).getDescricaoRecebimento().naoFormatado());
            colecao.itens().add(item);
        }
    }

    private void importarComplementacaoAposentadoria(DeclaracaoIRPF dec, Colecao<ItemQuadroOutrosRendimentos> colecao, ItemDirfRendimentos itemDirfRendimentos, RendComplementacaoAposentadoria rendGenerico, String descricaoRecebimento, String cpfContribuinte) {
        if (!rendGenerico.isVazio()) {
            ItemQuadroOutrosRendimentos item = new ItemQuadroOutrosRendimentos(dec);
            boolean titular = dec.getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfContribuinte);
            if (titular) {
                item.getTipoBeneficiario().setConteudo("Titular");
            } else {
                item.getTipoBeneficiario().setConteudo("Dependente");
                item.getCpfBeneficiario().setConteudo(cpfContribuinte);
            }
            item.getCnpjEmpresa().setConteudo(itemDirfRendimentos.getHeader().getNiFontePagadora().naoFormatado());
            item.getNomeFonte().setConteudo(itemDirfRendimentos.getHeader().getNomeFontePagadora());
            Valor valorTotal = new Valor();
            valorTotal.append('+', rendGenerico.getValorRecebimento());
            valorTotal.append('+', rendGenerico.getDecimoTerceiro());
            item.getValor().setConteudo(valorTotal);
            item.getDescricaoRendimento().setConteudo(descricaoRecebimento);
            colecao.itens().add(item);
        }
    }

    public List<File> dividirEmArquivos(File arquivoPrepreenchida) throws AplicacaoException {
        ArrayList<File> arquivosCriados = new ArrayList<File>();
        File f = null;
        try {
            LineIterator it = FileUtils.lineIterator((File)arquivoPrepreenchida);
            ArrayList<String> linhas = new ArrayList<String>();
            String nomeArquivo = null;
            int i = 0;
            if (it.hasNext()) {
                nomeArquivo = it.nextLine().trim();
                String cpfContribuinte = nomeArquivo.split("-")[0];
                while (it.hasNext()) {
                    String linha = it.nextLine();
                    if (linha.startsWith("#") || !it.hasNext()) {
                        f = i == 0 ? new File(CAMINHO_TEMP_PREPREENCHIDA + nomeArquivo + ".DEC") : new File(CAMINHO_TEMP_PREPREENCHIDA + "DIRF-" + cpfContribuinte + ".PP");
                        FileUtils.writeLines((File)f, linhas);
                        arquivosCriados.add(f);
                        ++i;
                        linhas.clear();
                        if (linha.startsWith("#FIM")) continue;
                        cpfContribuinte = linha.split("#")[1].trim();
                        continue;
                    }
                    linhas.add(linha);
                }
            }
        }
        catch (IOException e) {
            throw new AplicacaoException("Ocorreu um erro durante importa\u00e7\u00e3o da Pr\u00e9-Preenchida. Erro durante leitura/escrita de arquivo de dados da DIRF.", (Throwable)e, false);
        }
        return arquivosCriados;
    }

    private boolean existeItemHashPagamentosDMED(String niDeclarante, ItemDmedPessoaFisica itemDmedPessoaFisica) {
        String valor;
        String nome = itemDmedPessoaFisica.getNome().formatado();
        return this.hashPagamentosDMED.get(niDeclarante + "#" + nome + "#" + (valor = itemDmedPessoaFisica.getValorPago().formatado())) != null;
    }

    private void adicionarItemHashPagamentosDMED(String cpfContribuinte, String niDeclarante, ItemDmedPessoaFisica itemDmedPessoaFisica) {
        String nome = itemDmedPessoaFisica.getNome().formatado();
        String valor = itemDmedPessoaFisica.getValorPago().formatado();
        this.hashPagamentosDMED.put(niDeclarante + "#" + nome + "#" + valor, cpfContribuinte);
    }

    public static class DECFilter
    implements FileFilter {
        private final String padraoNomePrepreenchida = "(?i)\\d{11}-IRPF-PP-" + ConstantesGlobais.EXERCICIO + "(.*)\\.(DEC|DBK)";

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return Validador.validarString((String)f.getName(), (String)this.padraoNomePrepreenchida);
        }

        public String getDescription() {
            return "Arquivos Pr\u00e9-preenchida IRPF-" + ConstantesGlobais.EXERCICIO;
        }
    }
}

