/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.DocumentoTXT;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ConstantesRepositorio;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.util.PLong;

public class DocumentoAjusteTXT
extends DocumentoTXT {
    private RegistroTxt regTotal;
    private boolean incluiCharsEspeciais = false;

    public DocumentoAjusteTXT(String tipoArquivo, String path) throws GeracaoTxtException {
        super(tipoArquivo, path);
        if (tipoArquivo.equals("ARQ_IRPF")) {
            this.regTotal = new RegistroTxt(tipoArquivo, "T9");
            this.regTotal.fieldByName("NR_REG").set("T9");
            this.regTotal.fieldByName("QT_TOTAL").set(1);
            for (String elemento : ConstantesRepositorio.recuperarRegistrosDeclaracao()) {
                this.regTotal.fieldByName(elemento).set(0);
            }
        }
    }

    public DocumentoAjusteTXT(String tipoArquivo, String path, boolean aIncluirCharsEspeciais) throws GeracaoTxtException {
        this(tipoArquivo, path);
        this.setIncluiCharsEspeciais(aIncluirCharsEspeciais);
    }

    private String calculaCRCDeclaracao(String strLinha, long lHashCode) {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        pLong.setValue(lHashCode);
        long lret = crc32.CalcCrc32(strLinha, strLinha.length(), pLong);
        return crc32.getStrCrc32();
    }

    private void totalizarLinhas(String tipo, int qt) throws GeracaoTxtException {
        String campo = "QT_R";
        if (!tipo.equals("IR")) {
            this.regTotal.fieldByName(campo + tipo).set(this.regTotal.fieldByName(campo + tipo).asInteger() + qt);
            this.regTotal.fieldByName("QT_TOTAL").set(this.regTotal.fieldByName("QT_TOTAL").asInteger() + qt);
        }
    }

    protected List<RegistroTxt> transformarRegistroTXTEmObjDaDeclaracao(List<String> linhas, String tipoArquivo, String tipoReg) throws GeracaoTxtException {
        ArrayList<RegistroTxt> ficha = new ArrayList<RegistroTxt>();
        for (int i = 0; i < linhas.size(); ++i) {
            RegistroTxt objRegGeracao = new RegistroTxt(tipoArquivo, tipoReg);
            String linha = linhas.get(i);
            objRegGeracao.setLinha(linha);
            if (objRegGeracao.getTipo() != "IR" && objRegGeracao.getTipo() != "IR" && !tipoArquivo.equals("ARQ_IRPFANOANTERIOR") && !tipoArquivo.equals("ARQ_COMPLRECIBO")) {
                this.validarRegistroIRPF(objRegGeracao, linha);
            }
            ficha.add(objRegGeracao);
        }
        return ficha;
    }

    private void validarRegistroIRPF(RegistroTxt objRegGeracao, String linha) throws GeracaoTxtException {
        String hLido = objRegGeracao.fieldByName("NR_CONTROLE").asString();
        String linhaSemHash = linha.substring(0, linha.length() - 10);
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        crc32.CalcCrc32(linhaSemHash, linhaSemHash.length(), pLong);
        String hashCalculado = crc32.getStrCrc32();
    }

    protected List<String> transformarObjDaDeclaracaoEmRegistroTXT(List<RegistroTxt> ficha) throws GeracaoTxtException {
        ArrayList<String> linhas = new ArrayList<String>(ficha.size());
        for (int i = 0; i < ficha.size(); ++i) {
            RegistroTxt objRegGeracao = ficha.get(i);
            if (objRegGeracao.getTipo() != "IR") {
                objRegGeracao.calculaCRCRegistro();
            }
            if (objRegGeracao.opcional()) {
                if (!objRegGeracao.estaPreenchido()) continue;
                linhas.add(objRegGeracao.getLinha());
                continue;
            }
            linhas.add(objRegGeracao.getLinha());
        }
        return linhas;
    }

    public void setFicha(List<RegistroTxt> ficha) throws GeracaoTxtException {
        this.setFicha(ficha, true);
    }

    protected void incluirLinhasComCharEspeciais(List<String> linhas) {
        for (int i = 0; i < linhas.size(); ++i) {
            this.arquivo().add(linhas.get(i).replaceAll("\\n", " "));
        }
        this.setAlterado();
    }

    public void setFicha(List<RegistroTxt> ficha, boolean totalizar) throws GeracaoTxtException {
        String ultRegistro = "";
        int numRegistros = 0;
        List<String> linhas = this.transformarObjDaDeclaracaoEmRegistroTXT(ficha);
        if (linhas.size() > 0) {
            if (this.isIncluiCharsEspeciais()) {
                this.incluirLinhasComCharEspeciais(linhas);
            } else {
                this.incluirLinhas(linhas);
            }
            for (int i = 0; i < linhas.size(); ++i) {
                ultRegistro = linhas.get(i).substring(0, 2);
                ++numRegistros;
                if (!ultRegistro.equals(linhas.get(i).substring(0, 2))) continue;
                if (totalizar) {
                    this.totalizarLinhas(ultRegistro, numRegistros);
                }
                numRegistros = 0;
            }
        }
    }

    public void atualizarNrReciboTransmitida(String nrRecibo) throws GeracaoTxtException, IOException {
        RegistroTxt regHeader = (RegistroTxt)this.getRegistrosTxt("IR").get(0);
        regHeader.fieldByName("NR_RECIBO_DECLARACAO_TRANSMITIDA").set(nrRecibo);
        String filename = this.preparaNomeArquivoParaCrc();
        regHeader.fieldByName("NR_CONTROLE").set(regHeader.calculaCRCHeader(filename));
        this.arquivo().set(0, UtilitariosString.retiraCaracteresEspeciais((String)regHeader.getLinha()));
    }

    public void atualizaHeader(List<RegistroTxt> header, String hash) throws GeracaoTxtException {
        RegistroTxt objReg = (RegistroTxt)this.getRegistrosTxt("IR").get(0);
        objReg.fieldByName("NR_HASH").set(hash);
        String filename = this.preparaNomeArquivoParaCrc();
        objReg.fieldByName("NR_CONTROLE").set(objReg.calculaCRCHeader(filename));
        this.arquivo().set(0, UtilitariosString.retiraCaracteresEspeciais((String)objReg.getLinha()));
    }

    public void validarHeader(IdentificadorDeclaracao objId) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt(this.getTipoArquivo(), "IR");
        objRegTXT.setLinha((String)this.arquivo().get(0));
        if (!objId.getCpf().naoFormatado().equals(objRegTXT.fieldByName("NR_CPF").asString())) {
            throw new GeracaoTxtException("Declara\u00e7\u00e3o n\u00e3o pertence ao CPF " + objId.getCpf() + ". Opera\u00e7\u00e3o cancelada.");
        }
        String hLido = objRegTXT.fieldByName("NR_CONTROLE").asString();
        String filename = this.preparaNomeArquivoParaCrc();
        String hCalc = objRegTXT.calculaCRCHeader(filename);
        if (!"IRPF".equals(objRegTXT.fieldByName("SISTEMA").asString().trim())) {
            throw new GeracaoTxtException("Arquivo n\u00e3o \u00e9 declara\u00e7\u00e3o IRPF. Opera\u00e7\u00e3o cancelada.");
        }
    }

    public void validarHeaderAnoAnt(IdentificadorDeclaracao objId, boolean validaHash) throws GeracaoTxtException {
        RegistroTxt objRegTXT = new RegistroTxt(this.getTipoArquivo(), "IR");
        objRegTXT.setLinha((String)this.arquivo().get(0));
        if (!objId.getCpf().naoFormatado().equals(objRegTXT.fieldByName("NR_CPF").asString())) {
            throw new GeracaoTxtException("Declara\u00e7\u00e3o n\u00e3o pertence ao CPF " + objId.getCpf() + ". Opera\u00e7\u00e3o cancelada.");
        }
        if (validaHash) {
            String hLido = objRegTXT.fieldByName("NR_CONTROLE").asString();
            String filename = this.preparaNomeArquivoParaCrc();
            String hCalc = objRegTXT.calculaCRCHeader(filename);
            if (!hCalc.equals(hLido)) {
                throw new GeracaoTxtException("As informa\u00e7\u00f5es do Header da declara\u00e7\u00e3o foram corrompidas ap\u00f3s sua grava\u00e7\u00e3o.");
            }
        }
        if (!"IRPF".equals(objRegTXT.fieldByName("SISTEMA").asString())) {
            throw new GeracaoTxtException("Arquivo n\u00e3o \u00e9 declara\u00e7\u00e3o IRPF.");
        }
    }

    public void ler() throws IOException {
        try (BufferedReader arqDeclaracao = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getPath()), "iso-8859-1"));){
            boolean eof = false;
            while (!eof) {
                String linha = arqDeclaracao.readLine();
                if (linha != null && linha.length() > 0) {
                    this.arquivo().add(linha);
                    continue;
                }
                eof = true;
            }
        }
        catch (IOException e) {
            throw new IOException("Erro ao ler arquivo - " + this.getPath());
        }
    }

    public void validarComplRecibo(IdentificadorDeclaracao objId) throws GeracaoTxtException {
        for (int posVetor = 0; posVetor < this.arquivo().size(); ++posVetor) {
            String linha = (String)this.arquivo().get(posVetor);
            String tipReg = linha.substring(0, 2);
            RegistroTxt objRegTXT = new RegistroTxt(this.getTipoArquivo(), tipReg);
            if (!linha.startsWith("MC")) {
                objRegTXT.setLinha(linha);
            }
            if (!tipReg.equals("HC") && !tipReg.equals("RC") && !tipReg.equals("TC") || objId.getCpf().naoFormatado().equals(objRegTXT.fieldByName("NR_CPF").asString())) continue;
            throw new GeracaoTxtException("Recibo n\u00e3o pertence ao CPF " + objId.getCpf() + ".");
        }
    }

    public void validarCRC() throws GeracaoTxtException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        for (int i = 1; i < this.arquivo().size() - 1; ++i) {
            String linha = (String)this.arquivo().get(i);
            String hLido = linha.substring(linha.length() - 10);
            StringBuffer sbLinha = new StringBuffer("");
            sbLinha.append(UtilitariosString.retiraCaracteresEspeciais((String)linha.substring(0, linha.length() - 10)));
            long hash = crc32.CalcCrc32(sbLinha.toString(), sbLinha.toString().length(), pLong);
            String hCalculado = crc32.getStrCrc32();
        }
    }

    public void validarHashsDeclaracao() throws GeracaoTxtException {
        String hAcumulado = "";
        String hAcumuladoHeader = "";
        String hAcumuladoTrailler = "";
        long lCRCDeclaracao = 0L;
        for (int i = 1; i < this.arquivo().size() - 1; ++i) {
            String strLinha = (String)this.arquivo().get(i);
            try {
                lCRCDeclaracao = Long.parseLong(hAcumulado);
            }
            catch (NumberFormatException e) {
                lCRCDeclaracao = 0L;
            }
            hAcumulado = this.calculaCRCDeclaracao(strLinha, lCRCDeclaracao);
            if (i != this.arquivo().size() - 4) continue;
            hAcumuladoHeader = hAcumulado;
        }
        hAcumuladoTrailler = hAcumulado;
        RegistroTxt objRegTXT = new RegistroTxt(this.getTipoArquivo(), "IR");
        objRegTXT.setLinha((String)this.arquivo().get(0));
        String hLido = objRegTXT.fieldByName("NR_HASH").asString();
        if (!hLido.equals(hAcumuladoHeader)) {
            throw new GeracaoTxtException("Arquivo corrompido. Opera\u00e7\u00e3o cancelada.");
        }
        objRegTXT = new RegistroTxt(this.getTipoArquivo(), "R9");
        objRegTXT.setLinha((String)this.arquivo().get(this.arquivo().size() - 1));
        hLido = objRegTXT.fieldByName("NR_HASH").asString();
        if (!hLido.equals(hAcumuladoTrailler)) {
            throw new GeracaoTxtException("Arquivo corrompido. Opera\u00e7\u00e3o cancelada.");
        }
    }

    public void validarCRCAcumulado() throws GeracaoTxtException {
        PLong pLong = new PLong();
        Crc32 crc32 = new Crc32();
        String hCalculado = null;
        long hCalculadoLinhaAnterior = 0L;
        for (int i = 0; i <= this.arquivo().size() - 1; ++i) {
            long h;
            String linha = (String)this.arquivo().get(i);
            String hLido = linha.substring(linha.length() - 10);
            StringBuffer sbLinha = new StringBuffer("");
            sbLinha.append(linha.substring(0, linha.length() - 10));
            if (hCalculadoLinhaAnterior != 0L) {
                pLong.setValue(hCalculadoLinhaAnterior);
            }
            hCalculadoLinhaAnterior = h = crc32.CalcCrc32(sbLinha.toString(), sbLinha.toString().length(), pLong);
            hCalculado = crc32.getStrCrc32();
            if (!hLido.trim().equals(hCalculado.trim())) {
                if (linha.startsWith("MC") && (FabricaUtilitarios.isLinux() || FabricaUtilitarios.isMac())) {
                    return;
                }
                throw new GeracaoTxtException("As informa\u00e7\u00f5es do recibo foram corrompidas ap\u00f3s sua grava\u00e7\u00e3o, no registro " + sbLinha.toString().substring(0, 2) + ".");
            }
            if (i != this.arquivo().size() - 1 || linha.startsWith("TC")) continue;
            throw new GeracaoTxtException("O \u00faltimo registro do complemento de recibo, n\u00e3o \u00e9 o registro Trailler.");
        }
    }

    public void incluirTrailler(String cpf) throws GeracaoTxtException {
        this.regTotal.fieldByName("NR_CPF").set(cpf);
        this.regTotal.calculaCRCRegistro();
        this.arquivo().add(this.regTotal.getLinha());
    }

    public void incluirRecibo(List<RegistroTxt> ficha, String hash) throws GeracaoTxtException {
        long lCRCDeclaracao;
        try {
            lCRCDeclaracao = Long.parseLong(hash);
        }
        catch (NumberFormatException e) {
            lCRCDeclaracao = 0L;
        }
        RegistroTxt objRegGeracao = ficha.get(0);
        objRegGeracao.setLinha(UtilitariosString.retiraCaracteresEspeciais((String)objRegGeracao.getLinha()));
        objRegGeracao.calculaCRCRegistro();
        hash = this.calculaCRCDeclaracao(objRegGeracao.getLinha(), lCRCDeclaracao);
        this.arquivo().add(objRegGeracao.getLinha());
        try {
            lCRCDeclaracao = Long.parseLong(hash);
        }
        catch (NumberFormatException e) {
            lCRCDeclaracao = 0L;
        }
        objRegGeracao = ficha.get(1);
        objRegGeracao.setLinha(UtilitariosString.retiraCaracteresEspeciais((String)objRegGeracao.getLinha()));
        objRegGeracao.calculaCRCRegistro();
        hash = this.calculaCRCDeclaracao(objRegGeracao.getLinha(), lCRCDeclaracao);
        this.arquivo().add(objRegGeracao.getLinha());
        objRegGeracao = ficha.get(2);
        objRegGeracao.setLinha(UtilitariosString.retiraCaracteresEspeciais((String)objRegGeracao.getLinha()));
        objRegGeracao.fieldByName("NR_HASH").set(hash);
        objRegGeracao.calculaCRCRegistro();
        this.arquivo().add(objRegGeracao.getLinha());
    }

    public String calcularHash() {
        String hashAcumulado = "";
        long lCRCDeclaracao = 0L;
        for (int i = 1; i < this.arquivo().size(); ++i) {
            String strLinha = (String)this.arquivo().get(i);
            try {
                lCRCDeclaracao = Long.parseLong(hashAcumulado);
            }
            catch (NumberFormatException e) {
                lCRCDeclaracao = 0L;
            }
            hashAcumulado = this.calculaCRCDeclaracao(strLinha, lCRCDeclaracao);
        }
        return hashAcumulado;
    }

    private String preparaNomeArquivoParaCrc() {
        String filenameTemp = UtilitariosArquivo.extraiNomeArquivo((String)this.getPath()).toUpperCase();
        String filename = UtilitariosArquivo.extraiNomeAquivoSemExtensao((String)filenameTemp);
        if (filename.length() > 8) {
            filename = filename.substring(0, 8);
        }
        filename = filename.concat(UtilitariosArquivo.extraiExtensaoAquivo((String)filenameTemp));
        return filename;
    }

    public boolean isIncluiCharsEspeciais() {
        return this.incluiCharsEspeciais;
    }

    public void setIncluiCharsEspeciais(boolean incluiCharsEspeciais) {
        this.incluiCharsEspeciais = incluiCharsEspeciais;
    }
}

