/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.txt.gravacaorestauracao;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import serpro.ppgd.formatosexternos.txt.CampoTXT;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.atividaderural.BemAR;
import serpro.ppgd.irpf.atividaderural.DividaAR;
import serpro.ppgd.irpf.atividaderural.ImovelAR;
import serpro.ppgd.irpf.atividaderural.ItemMovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.MovimentacaoRebanho;
import serpro.ppgd.irpf.atividaderural.ParticipanteImovelAR;
import serpro.ppgd.irpf.atividaderural.brasil.ApuracaoResultadoBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.ImovelARBrasil;
import serpro.ppgd.irpf.atividaderural.brasil.MesReceitaDespesa;
import serpro.ppgd.irpf.atividaderural.exterior.ApuracaoResultadoExterior;
import serpro.ppgd.irpf.atividaderural.exterior.ReceitaDespesa;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.bens.ItemPercentualParticipacaoInventario;
import serpro.ppgd.irpf.bens.ProprietarioUsufrutuarioBem;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dividas.Divida;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoCriancaAdolescente;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoIdoso;
import serpro.ppgd.irpf.doacoes.Doacao;
import serpro.ppgd.irpf.eleicoes.DoacaoEleitoral;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.espolio.EspolioDecisaoJudicial;
import serpro.ppgd.irpf.espolio.EspolioEscrituracaoPublica;
import serpro.ppgd.irpf.espolio.EspolioPartilha;
import serpro.ppgd.irpf.gcap.IdDemonstrativoGCAP;
import serpro.ppgd.irpf.gcap.ValorBigDecimalGCME;
import serpro.ppgd.irpf.gcap.adquirente.Adquirente;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemImovel;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoBemMovel;
import serpro.ppgd.irpf.gcap.alienacao.AlienacaoParticipacaoSocietaria;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacao;
import serpro.ppgd.irpf.gcap.alienacao.ParcelaAlienacaoBem;
import serpro.ppgd.irpf.gcap.apuracao.ApuracaoBemImovel;
import serpro.ppgd.irpf.gcap.apuracao.ApuracaoBemMovel;
import serpro.ppgd.irpf.gcap.apuracao.ParcelaApuracaoCustoAquisicao;
import serpro.ppgd.irpf.gcap.aquisicao.ParcelaAquisicao;
import serpro.ppgd.irpf.gcap.consolidacao.Consolidacao;
import serpro.ppgd.irpf.gcap.consolidacao.ConsolidacaoEspecie;
import serpro.ppgd.irpf.gcap.especie.MoedaAlienada;
import serpro.ppgd.irpf.gcap.especie.MoedasAlienadasMensal;
import serpro.ppgd.irpf.gcap.especie.OperacaoEspecie;
import serpro.ppgd.irpf.gcap.especie.TotalizacaoMoedasAlienadas;
import serpro.ppgd.irpf.gcap.psocietarias.ParcelaAquisicaoParticipacaoSocietaria;
import serpro.ppgd.irpf.herdeiros.Herdeiro;
import serpro.ppgd.irpf.herdeiros.Herdeiros;
import serpro.ppgd.irpf.impostopago.ImpostoPago;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroGanhosAcoesOuro;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroGanhosAcoesOuro;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroMeacaoDissolucao;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticiaRendIsentos;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoMolestiaGrave;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroRendimentosNI;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransferenciaPatrimonial;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.GanhosLiquidosOuPerdas;
import serpro.ppgd.irpf.rendavariavel.ItemFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ItemRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.MesFundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.Operacoes;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpj.RendPJDependente;
import serpro.ppgd.irpf.rendpj.RendPJTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;

public class ConversorRegistros2ObjetosIRPF {
    public String getNumReciboComDV(String numRecibo) {
        if (numRecibo.trim().length() == 10) {
            String dvNumRecibo1 = "" + Validador.calcularModulo11((String)numRecibo, null, (int)2);
            String dvNumRecibo2 = "" + Validador.calcularModulo11((String)(numRecibo + dvNumRecibo1), null, (int)2);
            return numRecibo + dvNumRecibo1 + dvNumRecibo2;
        }
        return numRecibo;
    }

    public void montarIdDeclaracaoOnline(List<RegistroTxt> vRegIdentif, IdentificadorDeclaracao idDeclaracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT = null;
        try {
            objRegTXT = vRegIdentif.get(0);
        }
        catch (Exception e) {
            throw new GeracaoTxtException("Registro Identifica\u00e7\u00e3o n\u00e3o encontrado no arquivo.");
        }
        String cpf = objRegTXT.fieldByName("NR_CPF").asString();
        idDeclaracao.getCpf().setConteudo(cpf);
        idDeclaracao.getNome().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
        String decRetif = objRegTXT.fieldByName("IN_RETIFICADORA").asString();
        decRetif = decRetif.equals("S") || decRetif.equals("1") ? Logico.SIM : Logico.NAO;
        idDeclaracao.getDeclaracaoRetificadora().setConteudo(decRetif);
        String tipoDeclaracao = objRegTXT.fieldByName("IN_COMPLETA").asString();
        if (tipoDeclaracao.trim().isEmpty()) {
            tipoDeclaracao = "0";
        }
        idDeclaracao.getTipoDeclaracao().setConteudo(tipoDeclaracao);
        idDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
        if (decRetif == Logico.SIM) {
            String numReciboUltDecTransmitidaExercicioAtual = objRegTXT.fieldByName("NR_CONTROLE_ORIGINAL").asString();
            idDeclaracao.getNumReciboDecRetif().setConteudo(numReciboUltDecTransmitidaExercicioAtual);
        }
        SimpleDateFormat df = new SimpleDateFormat("ddMMyyyyHHmmss");
        df.setLenient(false);
        try {
            String dataCriacao = objRegTXT.fieldByName("NR_DATA_HORA_ORIGINAL_RETIFICADORA").asString();
            idDeclaracao.getDataCriacao().setConteudo(df.parse(dataCriacao));
        }
        catch (Exception e) {
            idDeclaracao.getDataCriacao().clear();
            LogPPGD.erro((String)e.getMessage());
        }
    }

    public IdentificadorDeclaracao montarIdDeclaracao(List<RegistroTxt> vRegHeader, List<RegistroTxt> vRegIdentif, boolean heTransmitida) throws GeracaoTxtException {
        IdentificadorDeclaracao idDeclaracao;
        String numReciboTransmitido;
        String tpTransmitida = null;
        RegistroTxt objRegTXT = vRegHeader.get(0);
        RegistroTxt objRegIdTXT = vRegIdentif.get(0);
        String cpf = objRegTXT.fieldByName("NR_CPF").asString();
        String tipoDeclaracaoAES = objRegIdTXT.fieldByName("IN_TIPODECLARACAO").asString();
        boolean jahExisteIdDeclaracao = false;
        if (heTransmitida) {
            boolean inRetificadora = objRegTXT.fieldByName("IN_RETIFICADORA").asString().equals(Logico.SIM);
            numReciboTransmitido = objRegTXT.fieldByName("NR_HASH").asString();
            jahExisteIdDeclaracao = IRPFFacade.existeDeclaracaoTransmitida((String)cpf, (boolean)inRetificadora);
            tpTransmitida = objRegTXT.fieldByName("IN_TRANSMITIDA").asString();
        } else {
            numReciboTransmitido = "0000000000";
            jahExisteIdDeclaracao = IRPFFacade.existeDeclaracao((String)cpf, (String)"0000000000");
        }
        if (jahExisteIdDeclaracao) {
            idDeclaracao = IRPFFacade.getInstancia().recuperarIdDeclaracao(cpf, numReciboTransmitido);
            idDeclaracao.getNumReciboTransmitido().setConteudo(numReciboTransmitido);
        } else {
            idDeclaracao = new IdentificadorDeclaracao();
            idDeclaracao.getCpf().setConteudo(cpf);
            idDeclaracao.getNumReciboTransmitido().setConteudo(numReciboTransmitido);
            if (tipoDeclaracaoAES != null && tipoDeclaracaoAES.trim().length() == 1) {
                idDeclaracao.getTipoDeclaracaoAES().setConteudo(tipoDeclaracaoAES);
            }
            IRPFFacade.criarDeclaracao((IdentificadorDeclaracao)idDeclaracao);
        }
        idDeclaracao.getNome().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
        String decRetif = objRegTXT.fieldByName("IN_RETIFICADORA").asString();
        if (!"".equals(decRetif)) {
            decRetif = decRetif.equals("S") || decRetif.equals("1") ? Logico.SIM : Logico.NAO;
            idDeclaracao.getDeclaracaoRetificadora().setConteudo(decRetif);
        }
        idDeclaracao.getTipoDeclaracao().setConteudo(objRegTXT.fieldByName("IN_COMPLETA").asBoolean() ? "0" : "1");
        idDeclaracao.getExercicio().setConteudo(objRegTXT.fieldByName("EXERCICIO").asString());
        idDeclaracao.getTpIniciada().setConteudo(objRegTXT.fieldByName("TP_INICIADA").asString());
        idDeclaracao.getInUtilizouAPP().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_APP").asString());
        idDeclaracao.getInUtilizouAssistidaFontePagadora().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_ASSISTIDA_FONTES_PAGADORAS").asString());
        idDeclaracao.getInUtilizouAssistidaPlanoSaude().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_ASSISTIDA_PLANO_SAUDE").asString());
        idDeclaracao.getInUtilizouOnLine().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_ONLINE").asString());
        idDeclaracao.getInUtilizouRascunho().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_RASCUNHO").asString());
        idDeclaracao.getPrepreenchida().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_PREPREENCHIDA").asString());
        idDeclaracao.getInUtilizouSalvarRecuperarOnLine().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_SALVAR_RECUPERAR_ONLINE").asString());
        idDeclaracao.getInCLWeb().setConteudo(objRegTXT.fieldByName("IN_CLWEB").asString());
        if (tpTransmitida != null) {
            idDeclaracao.getTpTransmitida().setConteudo(tpTransmitida);
        }
        try {
            objRegTXT = vRegIdentif.get(0);
        }
        catch (Exception e) {
            throw new GeracaoTxtException("Registro Identifica\u00e7\u00e3o n\u00e3o encontrado no arquivo.");
        }
        if (!objRegTXT.fieldByName("IN_ENDERECO").asString().trim().isEmpty()) {
            idDeclaracao.getEnderecoDiferente().setConteudo(objRegTXT.fieldByName("IN_ENDERECO").asBoolean() ? Logico.SIM : Logico.NAO);
        }
        if (decRetif == Logico.SIM) {
            String numReciboUltDecTransmitidaExercicioAtual = objRegTXT.fieldByName("NR_CONTROLE_ORIGINAL").asString();
            idDeclaracao.getNumReciboDecRetif().setConteudo(numReciboUltDecTransmitidaExercicioAtual);
        }
        SimpleDateFormat df = new SimpleDateFormat("ddMMyyyyHHmmss");
        df.setLenient(false);
        try {
            String dataCriacao = objRegTXT.fieldByName("NR_DATA_HORA_ORIGINAL_RETIFICADORA").asString();
            idDeclaracao.getDataCriacao().setConteudo(df.parse(dataCriacao));
        }
        catch (Exception e) {
            idDeclaracao.getDataCriacao().clear();
            LogPPGD.erro((String)e.getMessage());
        }
        return idDeclaracao;
    }

    public IdentificadorDeclaracao montarIdDeclaracaoAnoAnterior(List<RegistroTxt> vRegHeader, boolean prePreenchida) {
        try {
            IdentificadorDeclaracao idDeclaracao;
            RegistroTxt objRegTXT = vRegHeader.get(0);
            String cpf = objRegTXT.fieldByName("NR_CPF").asString();
            if (IRPFFacade.existeDeclaracao((String)cpf, (String)"0000000000")) {
                idDeclaracao = IRPFFacade.getInstancia().recuperarIdDeclaracao(cpf, "0000000000");
            } else {
                idDeclaracao = new IdentificadorDeclaracao();
                idDeclaracao.getCpf().setConteudo(cpf);
                idDeclaracao.getNumReciboTransmitido().setConteudo("0000000000");
            }
            idDeclaracao.getNome().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            idDeclaracao.getDeclaracaoRetificadora().setConteudo(objRegTXT.fieldByName("IN_RETIFICADORA").asString());
            idDeclaracao.getTipoDeclaracao().setConteudo(objRegTXT.fieldByName("IN_COMPLETA").asBoolean() ? "0" : "1");
            idDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
            String numReciboUltDecRec = "";
            numReciboUltDecRec = prePreenchida ? objRegTXT.fieldByName("NR_HASH").asString() : objRegTXT.fieldByName("NR_RECIBO_DECLARACAO_TRANSMITIDA").asString();
            numReciboUltDecRec = this.getNumReciboComDV(numReciboUltDecRec);
            idDeclaracao.getNumeroReciboDecAnterior().setConteudo(numReciboUltDecRec);
            return idDeclaracao;
        }
        catch (Exception e) {
            return null;
        }
    }

    public IdentificadorDeclaracao montarIdDeclaracaoPrePreenchida(List<RegistroTxt> vRegHeader) {
        try {
            IdentificadorDeclaracao idDeclaracao;
            RegistroTxt objRegTXT = vRegHeader.get(0);
            String cpf = objRegTXT.fieldByName("NR_CPF").asString();
            if (IRPFFacade.existeDeclaracao((String)cpf, (String)"0000000000")) {
                idDeclaracao = IRPFFacade.getInstancia().recuperarIdDeclaracao(cpf, "0000000000");
            } else {
                idDeclaracao = new IdentificadorDeclaracao();
                idDeclaracao.getCpf().setConteudo(cpf);
                idDeclaracao.getNumReciboTransmitido().setConteudo("0000000000");
            }
            idDeclaracao.getNome().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            idDeclaracao.getDeclaracaoRetificadora().setConteudo(objRegTXT.fieldByName("IN_RETIFICADORA").asString());
            idDeclaracao.getTipoDeclaracao().setConteudo("0");
            idDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
            return idDeclaracao;
        }
        catch (Exception e) {
            return null;
        }
    }

    public IdentificadorDeclaracao montarIdDeclaracaoNaoPersistido(List<RegistroTxt> vRegistroHeader, List<RegistroTxt> vRegistroIdentificacao, boolean anoAnterior) {
        return this.montarIdDeclaracaoNaoPersistido(vRegistroHeader, vRegistroIdentificacao, anoAnterior, false);
    }

    public IdentificadorDeclaracao montarIdDeclaracaoNaoPersistido(List<RegistroTxt> vRegistroHeader, List<RegistroTxt> vRegistroIdentificacao, boolean anoAnterior, boolean heTransmitida) {
        try {
            RegistroTxt regHeader = vRegistroHeader.get(0);
            RegistroTxt regIdentificacao = vRegistroIdentificacao.get(0);
            String cpf = regHeader.fieldByName("NR_CPF").asString();
            IdentificadorDeclaracao idDeclaracao = new IdentificadorDeclaracao();
            idDeclaracao.getCpf().setConteudo(cpf);
            idDeclaracao.getNome().setConteudo(regHeader.fieldByName("NM_NOME").asString());
            idDeclaracao.getNome().setConteudo(regHeader.fieldByName("NM_NOME").asString());
            if (heTransmitida) {
                idDeclaracao.getNumReciboTransmitido().setConteudo(regHeader.fieldByName("NR_HASH").asString());
            } else {
                idDeclaracao.getNumReciboTransmitido().setConteudo("0000000000");
            }
            try {
                String exercicioDec = regHeader.fieldByName("EXERCICIO").asString();
                String numReciboUltDecRec = "";
                if (exercicioDec.equals(ConstantesGlobais.EXERCICIO)) {
                    numReciboUltDecRec = regIdentificacao.fieldByName("NR_RECIBO_ULTIMA_DEC_ANO_ANTERIOR").asString();
                } else if (exercicioDec.equals(ConstantesGlobais.EXERCICIO_ANTERIOR)) {
                    numReciboUltDecRec = regHeader.fieldByName("NR_RECIBO_DECLARACAO_TRANSMITIDA").asString();
                }
                if (!numReciboUltDecRec.trim().isEmpty()) {
                    numReciboUltDecRec = StringUtils.leftPad((String)numReciboUltDecRec, (int)10, (char)'0');
                    numReciboUltDecRec = this.getNumReciboComDV(numReciboUltDecRec);
                    idDeclaracao.getNumeroReciboDecAnterior().setConteudo(numReciboUltDecRec);
                }
            }
            catch (Exception exercicioDec) {
                // empty catch block
            }
            idDeclaracao.getDeclaracaoRetificadora().setConteudo(regHeader.fieldByName("IN_RETIFICADORA").asString());
            idDeclaracao.getTipoDeclaracao().setConteudo(regHeader.fieldByName("IN_COMPLETA").asBoolean() ? "0" : "1");
            idDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
            if (!anoAnterior) {
                String tipoDeclaracao = regIdentificacao.fieldByName("IN_TIPODECLARACAO").asString();
                idDeclaracao.getTipoDeclaracaoAES().setConteudo(tipoDeclaracao);
            }
            return idDeclaracao;
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            return null;
        }
    }

    public void montarFichaSimplificada(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDec) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            RendIsentos rendIsentos = objDec.getRendIsentos();
            ImpostoPago impPago = objDec.getImpostoPago();
            RegistroTxt objRegTXT = vRegistro.get(0);
            Valor impostoComplementar = new Valor();
            impostoComplementar.setConteudo(objRegTXT.fieldByName("VR_IMPCOMP").asValor());
            impPago.getImpostoComplementar().setConteudo(impostoComplementar);
            Valor impostoLei11033 = new Valor();
            impostoLei11033.setConteudo(objRegTXT.fieldByName("VR_IRFONTELEI11033").asValor());
            impPago.getImpostoRetidoFonte().setConteudo(impostoLei11033);
            impPago.getImpostoPagoExterior().setConteudo(objRegTXT.fieldByName("VR_IMPEXT").asValor());
            Valor lucroRecebido = new Valor();
            lucroRecebido.setConteudo(objRegTXT.fieldByName("VR_LUCROSTIT").asValor());
            lucroRecebido.append('+', objRegTXT.fieldByName("VR_LUCROSDEPEND").asValor().naoFormatado());
            rendIsentos.getLucroRecebido().setConteudo(lucroRecebido);
        }
    }

    public void montarFichaImpostoPago(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDec) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            RegistroTxt objRegTXT = vRegistro.get(0);
            Valor impostoComplementar = new Valor();
            impostoComplementar.setConteudo(objRegTXT.fieldByName("VR_IMPCOMP").asValor());
            objDec.getImpostoPago().getImpostoComplementar().setConteudo(impostoComplementar);
        }
    }

    public void montarContribuinteIRPF(List<RegistroTxt> vRegistro, Contribuinte objContrib, IdentificadorDeclaracao identificadorDeclaracao, Bens bens) throws GeracaoTxtException {
        this.montarContribuinteIRPF(vRegistro, objContrib, identificadorDeclaracao, bens, false, null);
    }

    public void montarContribuinteIRPF(List<RegistroTxt> vRegistro, Contribuinte objContrib, IdentificadorDeclaracao identificadorDeclaracao, Bens bens, boolean realizarMerge, String tipoDeclaracaoAES) throws GeracaoTxtException {
        String reciboAnoAnterior;
        RegistroTxt objRegTXT = vRegistro.get(0);
        String campo = null;
        campo = objRegTXT.fieldByName("DT_NASCIM").asString();
        if (!realizarMerge || campo.matches("\\d+")) {
            objContrib.getDataNascimento().setConteudo(objRegTXT.fieldByName("DT_NASCIM").asString());
        }
        if (!TipoDeclaracaoAES.ESPOLIO.getTipo().equals(tipoDeclaracaoAES)) {
            campo = objRegTXT.fieldByName("CD_NATUR").asString();
            if (!realizarMerge || !campo.trim().isEmpty()) {
                objContrib.getNaturezaOcupacao().setConteudo(campo);
            }
            campo = objRegTXT.fieldByName("CD_OCUP").asString();
            if (!realizarMerge || !campo.trim().isEmpty()) {
                objContrib.getOcupacaoPrincipal().setConteudo(campo);
            }
        }
        if (!(campo = objRegTXT.fieldByName("NR_CPF_CONJUGE").asString()).trim().isEmpty()) {
            objContrib.getConjuge().setConteudo(Logico.SIM);
            objContrib.getCpfConjuge().setConteudo(campo);
        } else {
            campo = objRegTXT.fieldByName("IN_CONJUGE").asString();
            if (campo.equals("S")) {
                objContrib.getConjuge().setConteudo(Logico.SIM);
            } else if (campo.equals("N")) {
                objContrib.getConjuge().setConteudo(Logico.NAO);
            }
        }
        if (objRegTXT.fieldByName("IN_RETORNO_PAIS").asString().equals("1")) {
            objContrib.getRetornoPais().setConteudo(Logico.SIM);
            campo = objRegTXT.fieldByName("DT_RETORNO_PAIS").asString();
            if (campo.matches("\\d+")) {
                objContrib.getDataRetorno().setConteudo(objRegTXT.fieldByName("DT_RETORNO_PAIS").asString());
            }
        } else {
            if (objRegTXT.fieldByName("IN_RETORNO_PAIS").asString().equals("0")) {
                objContrib.getRetornoPais().setConteudo(Logico.NAO);
            }
            objContrib.getDataRetorno().setConteudo("");
        }
        if (!(campo = objRegTXT.fieldByName("NR_REGISTRO_PROFISSIONAL").asString()).trim().isEmpty()) {
            objContrib.getRegistroProfissional().setConteudo(campo);
        }
        campo = "";
        if (!objRegTXT.fieldByName("IN_ENDERECO").asString().trim().isEmpty()) {
            campo = objRegTXT.fieldByName("IN_ENDERECO").asBoolean() ? Logico.SIM : Logico.NAO;
        }
        identificadorDeclaracao.getEnderecoDiferente().setConteudo(campo);
        if (!realizarMerge || campo.equals(Logico.SIM)) {
            String codMunicipio;
            if (objRegTXT.fieldByName("SG_UF").asString().toUpperCase().equals("EX")) {
                objContrib.getExterior().setConteudo(Logico.SIM);
                objContrib.getCodigoExterior().setConteudo(objRegTXT.fieldByName("CD_EX").asString());
                objContrib.getPais().setConteudo(objRegTXT.fieldByName("CD_PAIS").asString());
                objContrib.getCidade().setConteudo(objRegTXT.fieldByName("NM_MUNICIP").asString());
                objContrib.getLogradouroExt().setConteudo(objRegTXT.fieldByName("NM_LOGRA").asString());
                objContrib.getNumeroExt().setConteudo(objRegTXT.fieldByName("NR_NUMERO").asString());
                objContrib.getBairroExt().setConteudo(objRegTXT.fieldByName("NM_BAIRRO").asString());
                objContrib.getComplementoExt().setConteudo(objRegTXT.fieldByName("NM_COMPLEM").asString());
                objContrib.getCepExt().setConteudo(objRegTXT.fieldByName("NR_CEP").asString());
                objContrib.getDdi().setConteudo(objRegTXT.fieldByName("NR_DDD_TELEFONE").asString().replaceAll("[^\\d\\s]", ""));
                objContrib.getTelefoneExt().setConteudo(objRegTXT.fieldByName("NR_TELEFONE").asString());
            } else {
                objContrib.getExterior().setConteudo(Logico.NAO);
                objContrib.getPais().setConteudo("105");
                objContrib.getLogradouro().setConteudo(objRegTXT.fieldByName("NM_LOGRA").asString());
                objContrib.getNumero().setConteudo(objRegTXT.fieldByName("NR_NUMERO").asString());
                objContrib.getBairro().setConteudo(objRegTXT.fieldByName("NM_BAIRRO").asString());
                objContrib.getComplemento().setConteudo(objRegTXT.fieldByName("NM_COMPLEM").asString());
                objContrib.getCep().setConteudo(objRegTXT.fieldByName("NR_CEP").asString());
                objContrib.getDdd().setConteudo(objRegTXT.fieldByName("NR_DDD_TELEFONE").asString().replaceAll("[^\\d\\s]", ""));
                objContrib.getTelefone().setConteudo(objRegTXT.fieldByName("NR_TELEFONE").asString());
                objContrib.getDddCelular().setConteudo(objRegTXT.fieldByName("NR_DDD_CELULAR").asString().replaceAll("[^\\d\\s]", ""));
                objContrib.getCelular().setConteudo(objRegTXT.fieldByName("NR_CELULAR").asString());
            }
            objContrib.getEmail().setConteudo(objRegTXT.fieldByName("NM_EMAIL").asString());
            objContrib.getProcessoDigital().setConteudo(objRegTXT.fieldByName("NR_NUMERO_PROCESSO").asString());
            String codUf = objRegTXT.fieldByName("SG_UF").asString();
            if (codUf != null && !codUf.isEmpty() && Validador.validarElementoTabela((String)codUf, (List)CadastroTabelasIRPF.recuperarUFs((int)0), null).getSeveridade() == 0) {
                objContrib.getUf().setConteudo(codUf);
            }
            if (objContrib.getUf().getConteudoAtual(0) != null && !objContrib.getUf().getConteudoAtual(0).isEmpty() && Validador.validarElementoTabela((String)(codMunicipio = objRegTXT.fieldByName("CD_MUNICIP").asString()), (List)CadastroTabelasIRPF.recuperarMunicipios((String)objContrib.getUf().getConteudoAtual(0), (int)0), null).getSeveridade() == 0) {
                objContrib.getMunicipio().setConteudo(codMunicipio);
            }
            objContrib.getTipoLogradouro().setConteudo(objRegTXT.fieldByName("TIP_LOGRA").asString());
        }
        if (!(reciboAnoAnterior = objRegTXT.fieldByName("NR_RECIBO_ULTIMA_DEC_ANO_ANTERIOR").asString()).trim().isEmpty()) {
            reciboAnoAnterior = StringUtils.leftPad((String)reciboAnoAnterior, (int)10, (char)'0');
            reciboAnoAnterior = this.getNumReciboComDV(reciboAnoAnterior);
            objContrib.getNumeroReciboDecAnterior().setConteudo(reciboAnoAnterior);
        }
        if (!realizarMerge && tipoDeclaracaoAES == null) {
            String tipoDeclaracao = objRegTXT.fieldByName("IN_TIPODECLARACAO").asString();
            identificadorDeclaracao.getTipoDeclaracaoAES().setConteudo(tipoDeclaracao);
        }
        campo = objRegTXT.fieldByName("IN_DOENCA_DEFICIENCIA").asString();
        if (!realizarMerge || !campo.trim().isEmpty()) {
            objContrib.getDeficiente().setConteudo(campo);
        }
        campo = objRegTXT.fieldByName("NR_CPF_PROCURADOR").asString();
        if (!realizarMerge || campo.matches("\\d+")) {
            objContrib.getCpfProcurador().setConteudo(campo);
        }
        bens.getExisteAtualizacaoValorBem().setConteudo(objRegTXT.fieldByName("IN_PROCESSO_ATUALIZACAO_BEM").asString());
        bens.getNumeroProcessoAtualizacaoValorBem().setConteudo(objRegTXT.fieldByName("NR_PROCESSO_ATUALIZACAO_BEM").asString());
        objContrib.getPrejuizoAnoAnteriorLei14754().setConteudo(objRegTXT.fieldByName("VR_PREJUIZO_ANO_ANTERIOR_LEI_14754").asValor());
    }

    public void montarInformacoesObrigatorias(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        String decRetif;
        RegistroTxt objRegTXT = vRegistro.get(0);
        String tipoDec = objRegTXT.fieldByName("IN_COMPLETA").asString().equals("N") ? "1" : "0";
        boolean isAjuste = objDecl.getIdentificadorDeclaracao().isAjuste();
        objDecl.getIdentificadorDeclaracao().getTipoDeclaracao().setConteudo(!isAjuste ? "0" : tipoDec);
        if (!objRegTXT.fieldByName("IN_ENDERECO").asString().trim().isEmpty()) {
            objDecl.getContribuinte().getEnderecoDiferente().setConteudo(objRegTXT.fieldByName("IN_ENDERECO").asBoolean() ? Logico.SIM : Logico.NAO);
        }
        if (!"".equals(decRetif = objRegTXT.fieldByName("IN_RETIFICADORA").asString())) {
            decRetif = decRetif.equals("S") || decRetif.equals("1") ? Logico.SIM : Logico.NAO;
            objDecl.getIdentificadorDeclaracao().getDeclaracaoRetificadora().setConteudo(decRetif);
        }
        objDecl.getResumo().getCalculoImposto().getNumQuotas().setConteudo(objRegTXT.fieldByName("NR_QUOTAS").asInteger());
        if (objDecl.getIdentificadorDeclaracao().isRetificadora()) {
            objDecl.getIdentificadorDeclaracao().getNumReciboDecRetif().setConteudoAntigo(objRegTXT.fieldByName("NR_CONTROLE_ORIGINAL").asString());
        }
    }

    public void montarInformacoesBancarias(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Bem bem;
        RegistroTxt objRegTXT = vRegistro.get(0);
        String banco = objRegTXT.fieldByName("NR_BANCO").asString();
        objDecl.getResumo().getCalculoImposto().getBanco().setConteudo(banco);
        String agencia = objRegTXT.fieldByName("NR_AGENCIA").asString();
        if (Integer.valueOf(agencia) != 0) {
            objDecl.getResumo().getCalculoImposto().getAgencia().setConteudo(agencia);
        }
        String tipoConta = objRegTXT.fieldByName("IN_TIPO_CONTA").asString();
        String conta = objRegTXT.fieldByName("NR_CONTA").asString();
        objDecl.getResumo().getCalculoImposto().getContaCredito().setConteudo(conta);
        String dvConta = objRegTXT.fieldByName("NR_DV_CONTA").asString();
        objDecl.getResumo().getCalculoImposto().getDvContaCredito().setConteudo(dvConta);
        if (tipoConta.equals("0") && (bem = objDecl.getBens().obterBemPorDadosBancarios(banco, agencia, conta, dvConta)) != null) {
            tipoConta = Bem.obterTipoContaBem((String)bem.getIndicadorContaPagamento().naoFormatado(), (String)bem.getGrupo().naoFormatado(), (String)bem.getCodigo().naoFormatado());
        }
        objDecl.getResumo().getCalculoImposto().getTipoConta().setConteudo(tipoConta);
        objDecl.getResumo().getCalculoImposto().getIndicadorPrimeiraQuota().setConteudo(objRegTXT.fieldByName("IN_DEBITO_PRIMEIRA_QUOTA").asString());
        String debitoAutom = objRegTXT.fieldByName("IN_DEBITO_AUTOM").asString();
        debitoAutom = debitoAutom.equals("S") ? "autorizado" : (debitoAutom.equals("N") ? "N" : "");
        objDecl.getResumo().getCalculoImposto().getDebitoAutomatico().setConteudo(debitoAutom);
    }

    public void montarBem(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean recuperouPP) throws GeracaoTxtException {
        this.montarBem(vRegistro, objDecl, false, recuperouPP);
    }

    public void montarBem(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean realizarMerge, boolean recuperouPP) throws GeracaoTxtException {
        if (!realizarMerge) {
            objDecl.getBens().itens().clear();
        }
        for (int i = 0; i < vRegistro.size(); ++i) {
            Bem objBem = objDecl.getBens().instanciaNovoObjeto();
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (recuperouPP) {
                String grupo = objRegTXT.fieldByName("CD_GRUPO_BEM").asString();
                String codigo = objRegTXT.fieldByName("CD_BEM").asString();
                String pais = objRegTXT.fieldByName("CD_PAIS").asString();
                objBem.reclassificar(grupo, codigo, pais);
            } else {
                objBem.getGrupo().setConteudo(objRegTXT.fieldByName("CD_GRUPO_BEM").asString());
                objBem.getCodigo().setConteudo(objRegTXT.fieldByName("CD_BEM").asString());
                objBem.getIndicadorReclassificar().setConteudo(objRegTXT.fieldByName("IN_RECLASSIFICAR").asString());
            }
            objBem.setChave(objRegTXT.fieldByName("NR_CHAVE_BEM").asString());
            objBem.getDiscriminacao().setConteudo(objRegTXT.fieldByName("TX_BEM").asString());
            objBem.getIndice().setConteudo(objBem.getChave());
            objBem.getValorExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_ANTER").asValor());
            objBem.getValorExercicioAtual().setConteudo(objRegTXT.fieldByName("VR_ATUAL").asValor());
            objBem.getIndicadorBemInventariar().setConteudo(objRegTXT.fieldByName("IN_BEM_INVENTARIAR").asString());
            int inExterior = objRegTXT.fieldByName("IN_EXTERIOR").asInteger();
            if (inExterior == 1) {
                objBem.getPais().setConteudo(objRegTXT.fieldByName("CD_PAIS").asString());
            } else {
                objBem.getPais().setConteudo("105");
            }
            if (objBem.isBemImovel()) {
                objBem.getLogradouro().setConteudo(objRegTXT.fieldByName("NM_LOGRA").asString());
                objBem.getNumero().setConteudo(objRegTXT.fieldByName("NR_NUMERO").asString());
                objBem.getComplemento().setConteudo(objRegTXT.fieldByName("NM_COMPLEM").asString());
                objBem.getBairro().setConteudo(objRegTXT.fieldByName("NM_BAIRRO").asString());
                objBem.getCep().setConteudo(objRegTXT.fieldByName("NR_CEP").asString());
                if (inExterior == 0) {
                    objBem.getUf().setConteudo(objRegTXT.fieldByName("SG_UF").asString());
                    objBem.getMunicipio().setConteudo(objRegTXT.fieldByName("CD_MUNICIP").asString());
                } else {
                    objBem.getCidade().setConteudo(objRegTXT.fieldByName("NM_MUNICIP").asString());
                    objBem.getNomeMunicipio().setConteudo(objRegTXT.fieldByName("NM_MUNICIP").asString());
                }
                if (objBem.isBemImovelRegistravel()) {
                    objBem.getRegistrado().setConteudo(objRegTXT.fieldByName("NM_IND_REG_IMOV").asString());
                    String dataAquisicao = objRegTXT.fieldByName("DT_AQUISICAO").asString().trim();
                    try {
                        if (dataAquisicao.length() == 8 && Integer.parseInt(dataAquisicao) > 0) {
                            objBem.getDataAquisicao().setConteudo(dataAquisicao);
                        }
                    }
                    catch (Exception pais) {
                        // empty catch block
                    }
                    if (objBem.getRegistrado().naoFormatado().equals("1")) {
                        objBem.getMatricula().setConteudo(objRegTXT.fieldByName("MATRIC_IMOV").asString());
                        objBem.getNomeCartorio().setConteudo(objRegTXT.fieldByName("NM_CARTORIO").asString());
                    }
                }
                objBem.getAreaTotal().setConteudo(objRegTXT.fieldByName("AREA").asValor());
                objBem.getUnidade().setConteudo(objRegTXT.fieldByName("NM_UNID").asString());
            }
            if (objBem.possuiValorIPTU()) {
                objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_IPTU").asString());
            }
            if (objBem.possuiValorCIB()) {
                objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_CIB").asString());
                if ("00000000".equals(objBem.getRegistroBem().naoFormatado())) {
                    objBem.getRegistroBem().clear();
                }
            }
            if (objBem.possuiValorRENAVAM()) {
                objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_RENAVAN").asString());
            }
            if (objBem.possuiValorRegistroAviacao()) {
                objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_DEP_AVIACAO_CIVIL").asString());
            }
            if (objBem.possuiValorRegistroPortos()) {
                objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_CAPITANIA_PORTOS").asString());
            }
            if (objBem.isImovelEmConstrucaoNoBrasil(objBem.getGrupo().naoFormatado(), objBem.getCodigo().naoFormatado(), objBem.getPais().naoFormatado())) {
                objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_CEI_CNO").asString());
            }
            if (objBem.isBemComDadosBancarios()) {
                objBem.getBanco().setConteudo(objRegTXT.fieldByName("NR_BANCO").asString());
                String agencia = objRegTXT.fieldByName("NR_AGENCIA").asString();
                if (Integer.valueOf(agencia) != 0) {
                    objBem.getAgencia().setConteudo(agencia);
                }
                String conta = objRegTXT.fieldByName("NR_CONTA").asString();
                objBem.getConta().setConteudo(conta);
                objBem.getDVConta().setConteudo(objRegTXT.fieldByName("NR_DV_CONTA").asString());
            }
            if (objBem.isBemComBeneficiario()) {
                objBem.getTipo().setConteudo(objRegTXT.fieldByName("IN_TIPO_BENEFIC").asString());
                objBem.getCPFBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            }
            if (objBem.isBemNegociadoBolsa()) {
                objBem.getNegociadoBolsa().setConteudo(objRegTXT.fieldByName("IN_BOLSA").asString());
                objBem.getCodigoNegociacao().setConteudo(objRegTXT.fieldByName("NR_COD_NEGOCIACAO_BOLSA").asString());
            }
            objBem.getIndicadorAutoCustodiante().setConteudo(objRegTXT.fieldByName("IN_CUSTODIANTE").asString());
            objBem.getCodigoAltcoin().setConteudo(objRegTXT.fieldByName("COD_ALTCOIN").asString());
            objBem.getCodigoStablecoin().setConteudo(objRegTXT.fieldByName("COD_STABLECOIN").asString());
            objBem.getNiEmpresa().setConteudo(objRegTXT.fieldByName("NM_CPFCNPJ").asString());
            if (objBem.isBemComAplicacaoFinanceira()) {
                objBem.getLucroPrejuizo().setConteudo(objRegTXT.fieldByName("VR_LUCRO_PREJUIZO_APLICACAO_FINANCEIRA").asValor());
                objBem.getImpostoPagoExterior().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO_PAGO_EXTERIOR_APLICACAO_FINANCEIRA").asValor());
            }
            if (objBem.isBemComLucrosDividendos()) {
                objBem.getValorRecebido().setConteudo(objRegTXT.fieldByName("VR_RECEBIDO_LUCROS_DIVIDENDOS").asValor());
                objBem.getImpostoPagoExteriorIRRF().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO_PAGO_EXTERIOR_LUCROS_DIVIDENDOS").asValor());
            }
            objBem.getAtualizadoValorBem().setConteudo(objRegTXT.fieldByName("IN_PROCESSO_ATUALIZACAO_BEM").asString());
            objBem.getIndicadorContaPagamento().setConteudo(objRegTXT.fieldByName("IN_CONTA_PAGAMENTO").asString());
            objDecl.getBens().itens().add(objBem);
        }
        objDecl.getBens().reordenarBens();
    }

    public void montarBemProprietarioUsufrutuario(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            ProprietarioUsufrutuarioBem proprietarioUsufrutuario = new ProprietarioUsufrutuarioBem();
            proprietarioUsufrutuario.getIndice().setConteudo(objRegTXT.fieldByName("NR_CHAVE_BEM").asString());
            proprietarioUsufrutuario.getNi().setConteudo(objRegTXT.fieldByName("NR_CPF_CNPJ").asString());
            Bem bem = objDecl.getBens().obterBemPorIndice(proprietarioUsufrutuario.getIndice().naoFormatado());
            if (bem == null) continue;
            bem.getProprietariosUsufrutuariosBem().add((ObjetoNegocio)proprietarioUsufrutuario);
        }
    }

    public void montarPercentualParticipacaoInventario(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Herdeiros herdeiros = objDecl.getHerdeiros();
        Herdeiro herdeiro = null;
        Bem bem = null;
        for (ObjetoNegocio obj : objDecl.getBens().itens()) {
            bem = (Bem)obj;
            bem.getParticipacoesInventario().itens().clear();
            for (RegistroTxt objRegTXT : vRegistro) {
                if (!objRegTXT.fieldByName("NR_CHAVE_BEM").asString().equals(bem.getChave())) continue;
                ItemPercentualParticipacaoInventario pensao = new ItemPercentualParticipacaoInventario();
                herdeiro = herdeiros.getHerdeiroByChave(objRegTXT.fieldByName("NR_CHAVE_HERDEIRO").asString());
                pensao.getNome().setConteudo(herdeiro.getNome());
                pensao.getNi().setConteudo(herdeiro.getNiHerdeiro());
                pensao.getPercentual().setConteudo(objRegTXT.fieldByName("VR_PERCENTUAL").asValor());
                bem.getParticipacoesInventario().itens().add(pensao);
            }
        }
    }

    public void montarDividas(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        this.montarDividas(vRegistro, objDecl, false);
    }

    public void montarDividas(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean realizarMerge) throws GeracaoTxtException {
        if (!realizarMerge) {
            objDecl.getDividas().itens().clear();
        }
        for (int i = 0; i < vRegistro.size(); ++i) {
            Divida objDivida = objDecl.getDividas().instanciaNovoObjeto();
            RegistroTxt objRegTXT = vRegistro.get(i);
            objDivida.getDiscriminacao().setConteudo(objRegTXT.fieldByName("TX_DIV").asString());
            objDivida.getCodigo().setConteudo(objRegTXT.fieldByName("CD_DIV").asString());
            objDivida.getValorExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_ANTER").asValor());
            objDivida.getValorExercicioAtual().setConteudo(objRegTXT.fieldByName("VR_ATUAL").asValor());
            objDivida.getValorPgtoAnual().setConteudo(objRegTXT.fieldByName("VR_PGTO_ANUAL").asValor());
            objDecl.getDividas().itens().add(objDivida);
        }
    }

    public void montarRendPJDependentesCompleta(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        this.montarRendPJDependentesCompleta(vRegistro, objDecl, false);
    }

    public void montarRendPJDependentesCompleta(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean realizarMerge) throws GeracaoTxtException {
        if (!realizarMerge) {
            objDecl.getColecaoRendPJDependente().itens().clear();
        }
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            RendPJDependente objRendPJ = null;
            boolean adicionar = false;
            if (realizarMerge) {
                String niFontePagadora = objRegTXT.fieldByName("NR_PAGADOR").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("CPF_BENEF").asString();
                objRendPJ = objDecl.getColecaoRendPJDependente().obterRendimentoPorChave(niFontePagadora, cpfBeneficiario);
            }
            if (objRendPJ == null) {
                adicionar = true;
                objRendPJ = new RendPJDependente(objDecl);
            }
            objRendPJ.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADOR").asString());
            objRendPJ.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_PAGADOR").asString());
            objRendPJ.getCpfDependente().setConteudo(objRegTXT.fieldByName("CPF_BENEF").asString());
            if (realizarMerge) {
                objRendPJ.getRendRecebidoPJ().append('+', objRegTXT.fieldByName("VR_RENDTO").asValor());
                objRendPJ.getContribuicaoPrevOficial().append('+', objRegTXT.fieldByName("VR_CONTRIB").asValor());
                objRendPJ.getImpostoRetidoFonte().append('+', objRegTXT.fieldByName("VR_IMPOSTO").asValor());
                objRendPJ.getDecimoTerceiro().append('+', objRegTXT.fieldByName("VR_DECTERC").asValor());
                objRendPJ.getIRRFDecimoTerceiro().append('+', objRegTXT.fieldByName("VR_IRRF13SALARIO").asValor());
            } else {
                objRendPJ.getRendRecebidoPJ().setConteudo(objRegTXT.fieldByName("VR_RENDTO").asValor());
                objRendPJ.getContribuicaoPrevOficial().setConteudo(objRegTXT.fieldByName("VR_CONTRIB").asValor());
                objRendPJ.getImpostoRetidoFonte().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO").asValor());
                objRendPJ.getDecimoTerceiro().setConteudo(objRegTXT.fieldByName("VR_DECTERC").asValor());
                objRendPJ.getIRRFDecimoTerceiro().setConteudo(objRegTXT.fieldByName("VR_IRRF13SALARIO").asValor());
            }
            if (objDecl.getIdentificadorDeclaracao().isSaida()) {
                objRendPJ.getDataComunicacaoSaida().setConteudo(objRegTXT.fieldByName("DT_COMUNICACAO_SAIDA").asString());
            }
            if (!adicionar) continue;
            objDecl.getColecaoRendPJDependente().itens().add(objRendPJ);
        }
    }

    public void montarRendPJExigTitular(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        this.montarRendPJExigTitular(vRegistro, objDecl, false);
    }

    public void montarRendPJExigTitular(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean realizarMerge) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            if (!realizarMerge) {
                objDecl.getColecaoRendPJComExigibilidadeTitular().itens().clear();
            }
            for (int i = 0; i < vRegistro.size(); ++i) {
                RegistroTxt objRegTXT = vRegistro.get(i);
                RendPJComExigibilidadeTitular objRendPJComExigSusp = null;
                boolean adicionar = false;
                if (realizarMerge) {
                    String niFontePagadora = objRegTXT.fieldByName("NR_PAGADOR").asString();
                    objRendPJComExigSusp = objDecl.getColecaoRendPJComExigibilidadeTitular().obterRendimentoPorChave(niFontePagadora);
                }
                if (objRendPJComExigSusp == null) {
                    adicionar = true;
                    objRendPJComExigSusp = new RendPJComExigibilidadeTitular(objDecl.getIdentificadorDeclaracao());
                }
                objRendPJComExigSusp.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADOR").asString());
                objRendPJComExigSusp.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_PAGADOR").asString());
                if (realizarMerge) {
                    objRendPJComExigSusp.getDepositoJudicial().append('+', objRegTXT.fieldByName("VR_DEP_JUDICIAL").asValor());
                    objRendPJComExigSusp.getRendExigSuspensa().append('+', objRegTXT.fieldByName("VR_RENDTO").asValor());
                } else {
                    objRendPJComExigSusp.getDepositoJudicial().setConteudo(objRegTXT.fieldByName("VR_DEP_JUDICIAL").asValor());
                    objRendPJComExigSusp.getRendExigSuspensa().setConteudo(objRegTXT.fieldByName("VR_RENDTO").asValor());
                }
                if (!adicionar) continue;
                objDecl.getColecaoRendPJComExigibilidadeTitular().itens().add(objRendPJComExigSusp);
            }
        }
    }

    public void montarRendPJExigDependente(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        this.montarRendPJExigDependente(vRegistro, objDecl, false);
    }

    public void montarRendPJExigDependente(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean realizarMerge) throws GeracaoTxtException {
        if (!realizarMerge) {
            objDecl.getColecaoRendPJComExigibilidadeDependente().itens().clear();
        }
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            RendPJComExigibilidadeDependente objRendPJComExigSuspDepen = null;
            boolean adicionar = false;
            if (realizarMerge) {
                String niFontePagadora = objRegTXT.fieldByName("NR_PAGADOR").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("CPF_BENEF").asString();
                objRendPJComExigSuspDepen = objDecl.getColecaoRendPJComExigibilidadeDependente().obterRendimentoPorChave(niFontePagadora, cpfBeneficiario);
            }
            if (objRendPJComExigSuspDepen == null) {
                adicionar = true;
                objRendPJComExigSuspDepen = new RendPJComExigibilidadeDependente(objDecl);
            }
            objRendPJComExigSuspDepen.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADOR").asString());
            objRendPJComExigSuspDepen.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_PAGADOR").asString());
            objRendPJComExigSuspDepen.getCpfDependente().setConteudo(objRegTXT.fieldByName("CPF_BENEF").asString());
            if (realizarMerge) {
                objRendPJComExigSuspDepen.getDepositoJudicial().append('+', objRegTXT.fieldByName("VR_DEP_JUDICIAL").asValor());
                objRendPJComExigSuspDepen.getRendExigSuspensa().append('+', objRegTXT.fieldByName("VR_RENDTO").asValor());
            } else {
                objRendPJComExigSuspDepen.getDepositoJudicial().setConteudo(objRegTXT.fieldByName("VR_DEP_JUDICIAL").asValor());
                objRendPJComExigSuspDepen.getRendExigSuspensa().setConteudo(objRegTXT.fieldByName("VR_RENDTO").asValor());
            }
            if (!adicionar) continue;
            objDecl.getColecaoRendPJComExigibilidadeDependente().itens().add(objRendPJComExigSuspDepen);
        }
    }

    public void montarRendAcmTitular(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getColecaoRendAcmTitular().itens().clear();
        String opcaoTributacao = null;
        for (RegistroTxt objRegTXT : vRegistro) {
            RendAcmTitular rend = new RendAcmTitular(objDecl, (Colecao)objDecl.getColecaoRendAcmTitular());
            opcaoTributacao = objRegTXT.fieldByName("OPCAO_TRIBUTACAO").asString();
            rend.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_PAGADOR").asString());
            rend.getNiFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADOR").asString());
            rend.getRendRecebidosInformado().setConteudo(objRegTXT.fieldByName("VR_RENDTO").asValor());
            rend.getParcIsenta65Anos().setConteudo(objRegTXT.fieldByName("VR_ISENTO_65").asValor());
            rend.getRendRecebidos().setConteudo(objRegTXT.fieldByName("VR_VALOR_TRIBUTAVEL").asValor());
            rend.getContribuicaoPrevOficial().setConteudo(objRegTXT.fieldByName("VR_CONTRIB").asValor());
            rend.getPensaoAlimenticia().setConteudo(objRegTXT.fieldByName("VR_PENSAO").asValor());
            rend.getImpostoRetidoFonte().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO").asValor());
            String mesRecebimento = objRegTXT.fieldByName("NR_MES_RECEBIMENTO").asString();
            if (!Integer.valueOf(mesRecebimento).equals(0)) {
                rend.getMesRecebimento().setConteudo(mesRecebimento);
            }
            rend.getValorJuros().setConteudo(objRegTXT.fieldByName("VR_JUROS").asValor());
            rend.getOpcaoTributacao().setConteudo(opcaoTributacao.equals("0") ? "A" : (opcaoTributacao.equals("1") ? "E" : "V"));
            rend.getNumMeses().setConteudo(objRegTXT.fieldByName("NUM_MESES").asValor());
            rend.getImpostoDevidoRRA().setConteudo(objRegTXT.fieldByName("IMPOSTO_RRA").asValor());
            rend.getNumMeses().forcaDisparoObservadores();
            rend.setChave(objRegTXT.fieldByName("CD_RRA_TITULAR").asString());
            objDecl.getColecaoRendAcmTitular().itens().add(rend);
        }
    }

    public void montarRendAcmTitularPensaoAlimenticia(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Alimentandos alimentandos = objDecl.getAlimentandos();
        RendAcmTitular rendAcmTitular = null;
        for (ObjetoNegocio obj : objDecl.getColecaoRendAcmTitular().itens()) {
            rendAcmTitular = (RendAcmTitular)obj;
            rendAcmTitular.getPensaoAlimenticiaQuadroAuxiliar().itens().clear();
            for (RegistroTxt objRegTXT : vRegistro) {
                if (!objRegTXT.fieldByName("CD_RRA_TITULAR").asString().equals(rendAcmTitular.getChave())) continue;
                ItemQuadroPensaoAlimenticia pensao = new ItemQuadroPensaoAlimenticia();
                pensao.getAlimentando().setConteudo(alimentandos.getNomeAlimentandoByChave(objRegTXT.fieldByName("NR_CHAVE_ALIMENT").asString()));
                pensao.getValor().setConteudo(objRegTXT.fieldByName("VR_PAGTO").asValor());
                rendAcmTitular.getPensaoAlimenticiaQuadroAuxiliar().itens().add(pensao);
            }
        }
    }

    public void montarRendAcmDependentes(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getColecaoRendAcmDependente().itens().clear();
        String opcaoTributacao = null;
        for (RegistroTxt objRegTXT : vRegistro) {
            RendAcmDependente rend = new RendAcmDependente(objDecl, (Colecao)objDecl.getColecaoRendAcmDependente());
            opcaoTributacao = objRegTXT.fieldByName("OPCAO_TRIBUTACAO").asString();
            rend.getCpfDependente().setConteudo(objRegTXT.fieldByName("CPF_BENEF").asString());
            rend.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_PAGADOR").asString());
            rend.getNiFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADOR").asString());
            rend.getRendRecebidosInformado().setConteudo(objRegTXT.fieldByName("VR_RENDTO").asValor());
            rend.getParcIsenta65Anos().setConteudo(objRegTXT.fieldByName("VR_ISENTO_65").asValor());
            rend.getRendRecebidos().setConteudo(objRegTXT.fieldByName("VR_VALOR_TRIBUTAVEL").asValor());
            rend.getContribuicaoPrevOficial().setConteudo(objRegTXT.fieldByName("VR_CONTRIB").asValor());
            rend.getPensaoAlimenticia().setConteudo(objRegTXT.fieldByName("VR_PENSAO").asValor());
            rend.getImpostoRetidoFonte().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO").asValor());
            String mesRecebimento = objRegTXT.fieldByName("NR_MES_RECEBIMENTO").asString();
            if (!Integer.valueOf(mesRecebimento).equals(0)) {
                rend.getMesRecebimento().setConteudo(mesRecebimento);
            }
            rend.getValorJuros().setConteudo(objRegTXT.fieldByName("VR_JUROS").asValor());
            rend.getOpcaoTributacao().setConteudo(opcaoTributacao.equals("0") ? "A" : (opcaoTributacao.equals("1") ? "E" : "V"));
            rend.getNumMeses().setConteudo(objRegTXT.fieldByName("NUM_MESES").asValor());
            rend.getImpostoDevidoRRA().setConteudo(objRegTXT.fieldByName("IMPOSTO_RRA").asValor());
            rend.getNumMeses().forcaDisparoObservadores();
            rend.setChave(objRegTXT.fieldByName("CD_RRA_DEPENDENTE").asString());
            rend.getPensaoAlimenticiaQuadroAuxiliar().itens().clear();
            objDecl.getColecaoRendAcmDependente().itens().add(rend);
        }
    }

    public void montarRendAcmDependentesPensaoAlimenticia(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        Alimentandos alimentandos = objDecl.getAlimentandos();
        RendAcmDependente rendAcmDependente = null;
        for (ObjetoNegocio obj : objDecl.getColecaoRendAcmDependente().itens()) {
            rendAcmDependente = (RendAcmDependente)obj;
            rendAcmDependente.getPensaoAlimenticiaQuadroAuxiliar().itens().clear();
            for (RegistroTxt objRegTXT : vRegistro) {
                if (!objRegTXT.fieldByName("CD_RRA_DEPEND").asString().equals(rendAcmDependente.getChave())) continue;
                ItemQuadroPensaoAlimenticia pensao = new ItemQuadroPensaoAlimenticia();
                pensao.getAlimentando().setConteudo(alimentandos.getNomeAlimentandoByChave(objRegTXT.fieldByName("NR_CHAVE_ALIMENT").asString()));
                pensao.getValor().setConteudo(objRegTXT.fieldByName("VR_PAGTO").asValor());
                rendAcmDependente.getPensaoAlimenticiaQuadroAuxiliar().itens().add(pensao);
            }
        }
    }

    public void montarDeclaracaoCompleta(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            RegistroTxt objRegTXT = vRegistro.get(0);
            objDecl.getImpostoPago().getImpostoPagoExterior().setConteudo(objRegTXT.fieldByName("VR_IMPEXT").asValor());
            objDecl.getImpostoPago().getImpostoComplementar().setConteudo(objRegTXT.fieldByName("VR_IMPCOMP").asValor());
            objDecl.getImpostoPago().getImpostoRetidoFonte().setConteudo(objRegTXT.fieldByName("VR_IRFONTELEI11033").asValor());
        }
    }

    public void montarRendPJTitularCompleta(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        this.montarRendPJTitularCompleta(vRegistro, objDecl, false);
    }

    public void montarRendPJTitularCompleta(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean realizarMerge) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            if (!realizarMerge) {
                objDecl.getColecaoRendPJTitular().itens().clear();
            }
            for (int i = 0; i < vRegistro.size(); ++i) {
                RegistroTxt objRegTXT = vRegistro.get(i);
                RendPJTitular objRendPJ = null;
                boolean adicionar = false;
                if (realizarMerge) {
                    String niFontePagadora = objRegTXT.fieldByName("NR_PAGADOR").asString();
                    objRendPJ = objDecl.getColecaoRendPJTitular().obterRendimentoPorChave(niFontePagadora);
                }
                if (objRendPJ == null) {
                    adicionar = true;
                    objRendPJ = new RendPJTitular(objDecl.getIdentificadorDeclaracao());
                }
                objRendPJ.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADOR").asString());
                objRendPJ.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_PAGADOR").asString());
                if (realizarMerge) {
                    objRendPJ.getRendRecebidoPJ().append('+', objRegTXT.fieldByName("VR_RENDTO").asValor());
                    objRendPJ.getContribuicaoPrevOficial().append('+', objRegTXT.fieldByName("VR_CONTRIB").asValor());
                    objRendPJ.getImpostoRetidoFonte().append('+', objRegTXT.fieldByName("VR_IMPOSTO").asValor());
                    objRendPJ.getDecimoTerceiro().append('+', objRegTXT.fieldByName("VR_DECTERC").asValor());
                    objRendPJ.getIRRFDecimoTerceiro().append('+', objRegTXT.fieldByName("VR_IRRF13SALARIO").asValor());
                } else {
                    objRendPJ.getRendRecebidoPJ().setConteudo(objRegTXT.fieldByName("VR_RENDTO").asValor());
                    objRendPJ.getContribuicaoPrevOficial().setConteudo(objRegTXT.fieldByName("VR_CONTRIB").asValor());
                    objRendPJ.getImpostoRetidoFonte().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO").asValor());
                    objRendPJ.getDecimoTerceiro().setConteudo(objRegTXT.fieldByName("VR_DECTERC").asValor());
                    objRendPJ.getIRRFDecimoTerceiro().setConteudo(objRegTXT.fieldByName("VR_IRRF13SALARIO").asValor());
                }
                if (objDecl.getIdentificadorDeclaracao().isSaida()) {
                    objRendPJ.getDataComunicacaoSaida().setConteudo(objRegTXT.fieldByName("DT_COMUNICACAO_SAIDA").asString());
                }
                if (!adicionar) continue;
                objDecl.getColecaoRendPJTitular().itens().add(objRendPJ);
            }
        }
    }

    public void recuperarRendIsentosNaoTributaveis(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (RegistroTxt objRegTXT : vRegistro) {
            RendIsentos objRendIsentos = objDecl.getRendIsentos();
            int tipo = objRegTXT.fieldByName("CD_ISENTO").asInteger();
            Valor valor = objRegTXT.fieldByName("VR_VALOR").asValor();
            switch (tipo) {
                case 1: {
                    objRendIsentos.getBolsaEstudos().setConteudo(valor);
                    break;
                }
                case 2: {
                    objRendIsentos.getMedicosResidentes().setConteudo(valor);
                    break;
                }
                case 3: {
                    objRendIsentos.getCapitalApolices().setConteudo(valor);
                    break;
                }
                case 4: {
                    objRendIsentos.getIndenizacoes().setConteudo(valor);
                    break;
                }
                case 5: {
                    objRendIsentos.getSomaBensPequenoValor().setConteudo(valor);
                    break;
                }
                case 6: {
                    objRendIsentos.getSomaUnicoImovel().setConteudo(valor);
                    break;
                }
                case 7: {
                    objRendIsentos.getSomaOutrosBensImoveis().setConteudo(valor);
                    break;
                }
                case 8: {
                    objRendIsentos.getMoedaEstrangeiraEspecieInformado().setConteudo(valor);
                    break;
                }
                case 9: {
                    objRendIsentos.getLucroRecebido().setConteudo(valor);
                    break;
                }
                case 10: {
                    objRendIsentos.getParcIsentaAposentadoria().setConteudo(valor);
                    break;
                }
                case 11: {
                    objRendIsentos.getPensao().setConteudo(valor);
                    break;
                }
                case 12: {
                    objRendIsentos.getPoupanca().setConteudo(valor);
                    break;
                }
                case 13: {
                    objRendIsentos.getRendSocio().setConteudo(valor);
                    break;
                }
                case 14: {
                    objRendIsentos.getTransferencias().setConteudo(valor);
                    break;
                }
                case 15: {
                    objRendIsentos.getParcIsentaAtivRural().setConteudo(valor);
                    break;
                }
                case 16: {
                    objRendIsentos.getImpostoRendasAnterioresCompensadoJudicialmente().setConteudo(valor);
                    break;
                }
                case 17: {
                    objRendIsentos.getRendAssalariadosMoedaEstrangeira().setConteudo(valor);
                    break;
                }
                case 18: {
                    objRendIsentos.getIncorporacaoReservaCapital().setConteudo(valor);
                    break;
                }
                case 19: {
                    objRendIsentos.getMeacaoDissolucao().setConteudo(valor);
                    break;
                }
                case 20: {
                    objRendIsentos.getGanhosLiquidosAcoes().setConteudo(valor);
                    break;
                }
                case 21: {
                    objRendIsentos.getGanhosCapitalOuro().setConteudo(valor);
                    break;
                }
                case 22: {
                    objRendIsentos.getRecuperacaoPrejuizosBolsaValores().setConteudo(valor);
                    break;
                }
                case 23: {
                    objRendIsentos.getTransportadorCargas().setConteudo(valor);
                    break;
                }
                case 24: {
                    objRendIsentos.getTransportadorPassageiros().setConteudo(valor);
                    break;
                }
                case 25: {
                    objRendIsentos.getRestituicaoImpostoRendaAnosAnteriores().setConteudo(valor);
                    break;
                }
                case 26: {
                    objRendIsentos.getOutros().setConteudo(valor);
                    break;
                }
                case 27: {
                    objRendIsentos.getJurosRra().setConteudo(valor);
                    break;
                }
                case 28: {
                    objRendIsentos.getPensaoAlimenticia().setConteudo(valor);
                    break;
                }
            }
        }
    }

    public void recuperarRendTributacaoExclusiva(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int indice = 0; indice < vRegistro.size(); ++indice) {
            RegistroTxt objRegTXT = vRegistro.get(indice);
            String tipoRendimento = objRegTXT.fieldByName("CD_EXCLUSIVO").asString();
            Valor valor = objDecl.getRendTributacaoExclusiva().getValorPorTipoRendimento(Integer.valueOf(tipoRendimento).intValue());
            valor.setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
        }
    }

    public void montarRendimentosAplicacoesFinanceiras(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!"0006".equals(objRegTXT.fieldByName("NR_COD").asString())) continue;
            ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl, (ObjetoNegocio)objDecl.getRendTributacaoExclusiva());
            item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
            item.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            item.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            item.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
            item.getCodBem().setConteudo(objRegTXT.fieldByName("NR_CHAVE_BEM").asString());
            objDecl.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar().itens().add(item);
        }
    }

    public void montarJurosCapitalProprio(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl, (ObjetoNegocio)objDecl.getRendTributacaoExclusiva());
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!"0010".equals(objRegTXT.fieldByName("NR_COD").asString())) continue;
            item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
            item.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            item.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            item.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
            item.getCodBem().setConteudo(objRegTXT.fieldByName("NR_CHAVE_BEM").asString());
            objDecl.getRendTributacaoExclusiva().getJurosCapitalProprioQuadroAuxiliar().itens().add(item);
        }
    }

    public void montarParticipacaoLucrosResultados(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl, (ObjetoNegocio)objDecl.getRendTributacaoExclusiva());
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!"0011".equals(objRegTXT.fieldByName("NR_COD").asString())) continue;
            item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
            item.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            item.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            item.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
            objDecl.getRendTributacaoExclusiva().getParticipacaoLucrosResultadosQuadroAuxiliar().itens().add(item);
        }
    }

    public void montarAlimentandos(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        this.montarAlimentandos(vRegistro, objDecl, false);
    }

    public void montarAlimentandos(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean realizarMerge) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            if (!realizarMerge) {
                objDecl.getAlimentandos().itens().clear();
            }
            for (int i = 0; i < vRegistro.size(); ++i) {
                Alimentando objAlimentando = null;
                RegistroTxt objRegTXT = vRegistro.get(i);
                boolean adicionar = false;
                String cpf = objRegTXT.fieldByName("NI_ALIMENTANDO").asString();
                String nome = objRegTXT.fieldByName("NM_NOME").asString();
                if (realizarMerge) {
                    if (!cpf.isEmpty()) {
                        objAlimentando = objDecl.getAlimentandos().getAlimentandoByCpf(cpf);
                    }
                    if (objAlimentando == null) {
                        objAlimentando = objDecl.getAlimentandos().getAlimentandoByNome(nome);
                    }
                }
                if (objAlimentando == null) {
                    adicionar = true;
                    objAlimentando = new Alimentando(objDecl);
                }
                if (!realizarMerge) {
                    objAlimentando.setChave(objRegTXT.fieldByName("NR_CHAVE").asString());
                }
                objAlimentando.getNome().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                objAlimentando.getResidente().setConteudo(objRegTXT.fieldByName("INDICADOR_RESIDENC").asString());
                String dtNasc = objRegTXT.fieldByName("DT_NASCIM").asString();
                objAlimentando.getDtNascimento().setConteudo(dtNasc);
                objAlimentando.getCpf().setConteudo(objRegTXT.fieldByName("NI_ALIMENTANDO").asString());
                objAlimentando.getCpfResponsavel().setConteudo(objRegTXT.fieldByName("NR_CPF_VINCULADO").asString());
                objAlimentando.getTipoProcesso().setConteudo(objRegTXT.fieldByName("IN_TIPO_PROCESSO").asString());
                objAlimentando.getEscrituraPublica().getCnpjCartorio().setConteudo(objRegTXT.fieldByName("NR_CNPJ_CARTORIO").asString());
                objAlimentando.getEscrituraPublica().getNome().setConteudo(objRegTXT.fieldByName("NM_CARTORIO").asString());
                objAlimentando.getEscrituraPublica().getUf().setConteudo(objRegTXT.fieldByName("SG_UFCARTORIO").asString());
                objAlimentando.getEscrituraPublica().getMunicipio().setConteudo(objRegTXT.fieldByName("CD_MUNICIP").asString());
                objAlimentando.getEscrituraPublica().getFolhas().setConteudo(objRegTXT.fieldByName("NM_FOLHA").asString());
                objAlimentando.getEscrituraPublica().getLivro().setConteudo(objRegTXT.fieldByName("NM_LIVRO").asString());
                String dt = objRegTXT.fieldByName("DT_LAVRATURA").asString();
                RetornoValidacao dtValida = Validador.validarData((String)UtilitariosString.formataData((String)dt));
                if (dtValida == null) {
                    objAlimentando.getEscrituraPublica().getDataLavratura().setConteudo(dt);
                }
                objAlimentando.getDecisaoJudicial().getNumProcessoJudicial().setConteudo(objRegTXT.fieldByName("NR_PROCESSOJUDICIAL").asString());
                objAlimentando.getDecisaoJudicial().getIdVaraCivil().setConteudo(objRegTXT.fieldByName("NR_IDENTIFICACAOVARACIVIL").asString());
                objAlimentando.getDecisaoJudicial().getComarca().setConteudo(objRegTXT.fieldByName("NM_COMARCA").asString());
                objAlimentando.getDecisaoJudicial().getUf().setConteudo(objRegTXT.fieldByName("SG_UFCOMARCA").asString());
                dt = objRegTXT.fieldByName("DT_DECJUDICIAL").asString();
                dtValida = Validador.validarData((String)UtilitariosString.formataData((String)dt));
                if (dtValida == null) {
                    objAlimentando.getDecisaoJudicial().getDtDecisaoJud().setConteudo(dt);
                }
                if (!adicionar) continue;
                objDecl.getAlimentandos().itens().add(objAlimentando);
            }
        }
    }

    public void montarHerdeiros(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getHerdeiros().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                Herdeiro objHerdeiro = new Herdeiro(objDecl.getIdentificadorDeclaracao());
                RegistroTxt objRegTXT = vRegistro.get(i);
                objHerdeiro.setChave(objRegTXT.fieldByName("NR_CHAVE_HERDEIRO").asString());
                objHerdeiro.getNome().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                objHerdeiro.getNiHerdeiro().setConteudo(objRegTXT.fieldByName("NR_CPF_CNPJ").asString());
                objDecl.getHerdeiros().itens().add(objHerdeiro);
            }
        }
    }

    public void montarPagamentos(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getPagamentos().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                Pagamento pagamento = objDecl.getPagamentos().instanciaNovoObjeto();
                RegistroTxt objRegTXT = vRegistro.get(i);
                pagamento.getNiBeneficiario().setConteudo(objRegTXT.fieldByName("NR_BENEF").asString());
                pagamento.getNomeBeneficiario().setConteudo(objRegTXT.fieldByName("NM_BENEF").asString());
                pagamento.getNitEmpregadoDomestico().setConteudo(objRegTXT.fieldByName("NR_NIT").asString());
                pagamento.getCodigo().setConteudo(objRegTXT.fieldByName("CD_PAGTO").asString());
                pagamento.getTipo().setConteudo(objRegTXT.fieldByName("IN_TIPO_PGTO").asString().isEmpty() ? "V" : objRegTXT.fieldByName("IN_TIPO_PGTO").asString());
                pagamento.getDependenteOuAlimentando().setConteudo(objDecl.getNomeDependenteOuAlimentandoPorChave(pagamento, objRegTXT.fieldByName("NR_CHAVE_DEPEND").asString()));
                pagamento.getValorPago().setConteudo(objRegTXT.fieldByName("VR_PAGTO").asValor());
                pagamento.getParcelaNaoDedutivel().setConteudo(objRegTXT.fieldByName("VR_REDUC").asValor());
                pagamento.getContribuicaoEntePatrocinador().setConteudo(objRegTXT.fieldByName("VR_CONTRIB_PATR").asValor());
                pagamento.getDescricao().setConteudo(objRegTXT.fieldByName("NM_DESCRICAO").asString());
                pagamento.getPais().setConteudo(objRegTXT.fieldByName("CD_PAIS").asString());
                objDecl.getPagamentos().itens().add(pagamento);
            }
        }
    }

    public void montarPagamentosComMerge(List<RegistroTxt> vetorRegistros, DeclaracaoIRPF objDecl, List<RegistroTxt> vetorRegistrosAlimentandos, List<RegistroTxt> vetorRegistrosDependentes) throws GeracaoTxtException {
        if (vetorRegistros.size() > 0) {
            for (int i = 0; i < vetorRegistros.size(); ++i) {
                RegistroTxt objRegTXT = vetorRegistros.get(i);
                Pagamento pagamento = null;
                boolean novoPagamento = false;
                for (Pagamento pag : objDecl.getPagamentos().itens()) {
                    String tipoPagamento = objRegTXT.fieldByName("IN_TIPO_PGTO").asString();
                    String chaveDepAli = objRegTXT.fieldByName("NR_CHAVE_DEPEND").asString();
                    String nomeDependenteAlimentando = this.obterNomeDepAli(chaveDepAli, tipoPagamento, vetorRegistrosAlimentandos, vetorRegistrosDependentes);
                    if (!pag.getCodigo().naoFormatado().equals(objRegTXT.fieldByName("CD_PAGTO").asString()) || !pag.getTipo().naoFormatado().equals(tipoPagamento) || !pag.getNiBeneficiario().naoFormatado().equals(objRegTXT.fieldByName("NR_BENEF").asString()) || !pag.getDependenteOuAlimentando().naoFormatado().equals(nomeDependenteAlimentando)) continue;
                    pagamento = pag;
                    break;
                }
                if (pagamento == null) {
                    pagamento = objDecl.getPagamentos().instanciaNovoObjeto();
                    novoPagamento = true;
                }
                pagamento.getNiBeneficiario().setConteudo(objRegTXT.fieldByName("NR_BENEF").asString());
                pagamento.getNomeBeneficiario().setConteudo(objRegTXT.fieldByName("NM_BENEF").asString());
                pagamento.getNitEmpregadoDomestico().setConteudo(objRegTXT.fieldByName("NR_NIT").asString());
                pagamento.getCodigo().setConteudo(objRegTXT.fieldByName("CD_PAGTO").asString());
                pagamento.getTipo().setConteudo(objRegTXT.fieldByName("IN_TIPO_PGTO").asString().isEmpty() ? "V" : objRegTXT.fieldByName("IN_TIPO_PGTO").asString());
                pagamento.getValorPago().append('+', objRegTXT.fieldByName("VR_PAGTO").asValor());
                pagamento.getParcelaNaoDedutivel().append('+', objRegTXT.fieldByName("VR_REDUC").asValor());
                pagamento.getContribuicaoEntePatrocinador().append('+', objRegTXT.fieldByName("VR_CONTRIB_PATR").asValor());
                String tipoPagamento = objRegTXT.fieldByName("IN_TIPO_PGTO").asString();
                String chaveDepAli = objRegTXT.fieldByName("NR_CHAVE_DEPEND").asString();
                String nomeDependenteAlimentando = this.obterNomeDepAli(chaveDepAli, tipoPagamento, vetorRegistrosAlimentandos, vetorRegistrosDependentes);
                pagamento.getDependenteOuAlimentando().setConteudo(nomeDependenteAlimentando);
                if (!novoPagamento) continue;
                objDecl.getPagamentos().itens().add(pagamento);
            }
        }
    }

    private String obterNomeDepAli(String chaveDepAli, String tipoPagamento, List<RegistroTxt> vetorRegistrosAlimentandos, List<RegistroTxt> vetorRegistrosDependentes) throws GeracaoTxtException {
        switch (tipoPagamento) {
            case "A": {
                for (int i = 0; i < vetorRegistrosAlimentandos.size(); ++i) {
                    RegistroTxt objRegTXT = vetorRegistrosAlimentandos.get(i);
                    if (!chaveDepAli.equals(objRegTXT.fieldByName("NR_CHAVE").asString())) continue;
                    return objRegTXT.fieldByName("NM_NOME").asString();
                }
                break;
            }
            case "D": {
                for (int i = 0; i < vetorRegistrosDependentes.size(); ++i) {
                    RegistroTxt objRegTXT = vetorRegistrosDependentes.get(i);
                    if (!chaveDepAli.equals(objRegTXT.fieldByName("NR_CHAVE").asString())) continue;
                    return objRegTXT.fieldByName("NM_DEPEND").asString();
                }
                break;
            }
        }
        return "";
    }

    public void montarDoacoes(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getDoacoes().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                Doacao doacao = objDecl.getDoacoes().instanciaNovoObjeto();
                RegistroTxt objRegTXT = vRegistro.get(i);
                doacao.getNiBeneficiario().setConteudo(objRegTXT.fieldByName("NR_BENEF").asString());
                doacao.getNomeBeneficiario().setConteudo(objRegTXT.fieldByName("NM_BENEF").asString());
                doacao.getCodigo().setConteudo(objRegTXT.fieldByName("CD_DOACAO").asString());
                doacao.getValorPago().setConteudo(objRegTXT.fieldByName("VR_DOACAO").asValor());
                doacao.getParcelaNaoDedutivel().setConteudo(objRegTXT.fieldByName("VR_PARC_NAO_DEDUT").asValor());
                objDecl.getDoacoes().itens().add(doacao);
            }
        }
    }

    public void montarEstatutoCriancaAdolescente(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getColecaoEstatutoCriancaAdolescente().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                EstatutoCriancaAdolescente doacao = objDecl.getColecaoEstatutoCriancaAdolescente().instanciaNovoObjeto();
                RegistroTxt objRegTXT = vRegistro.get(i);
                doacao.getTipoFundo().setConteudo(objRegTXT.fieldByName("IN_TIPO_FUNDO").asString());
                doacao.getUf().setConteudo(objRegTXT.fieldByName("SG_UF").asString());
                doacao.getValor().setConteudo(objRegTXT.fieldByName("VR_DOACAO").asValor());
                doacao.getCnpjFundo().setConteudo(objRegTXT.fieldByName("NR_CNPJ_FUNDO").asString());
                if (doacao.getTipoFundo().naoFormatado().equals("M")) {
                    doacao.getMunicipio().setConteudo(doacao.getCnpjFundo().formatado());
                }
                objDecl.getColecaoEstatutoCriancaAdolescente().itens().add(doacao);
            }
        }
    }

    public void montarEstatutoIdoso(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getColecaoEstatutoIdoso().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                EstatutoIdoso doacao = objDecl.getColecaoEstatutoIdoso().instanciaNovoObjeto();
                RegistroTxt objRegTXT = vRegistro.get(i);
                doacao.getTipoFundo().setConteudo(objRegTXT.fieldByName("IN_TIPO_FUNDO").asString());
                doacao.getUf().setConteudo(objRegTXT.fieldByName("SG_UF").asString());
                doacao.getValor().setConteudo(objRegTXT.fieldByName("VR_DOACAO").asValor());
                doacao.getCnpjFundo().setConteudo(objRegTXT.fieldByName("NR_CNPJ_FUNDO").asString());
                if (doacao.getTipoFundo().naoFormatado().equals("M")) {
                    doacao.getMunicipio().setConteudo(doacao.getCnpjFundo().formatado());
                }
                objDecl.getColecaoEstatutoIdoso().itens().add(doacao);
            }
        }
    }

    public void montarLucrosDividendos(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getLucroRecebidoQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cnpjEmpresa = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_LUCRO").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("NR_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCnpjEmpresa().setConteudo(cnpjEmpresa);
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getLucroRecebidoQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarPensao(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getPensaoQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroPensaoMolestiaGrave item = new ItemQuadroPensaoMolestiaGrave(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String niEmpresa = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                Valor valor13Salario = objRegTXT.fieldByName("VR_13SALARIO").asValor();
                Valor valorIRRF = objRegTXT.fieldByName("VR_IRRF").asValor();
                Valor valorIRRF13Salario = objRegTXT.fieldByName("VR_IRRF13SALARIO").asValor();
                Valor valorPrevidencia = objRegTXT.fieldByName("VR_PREVIDENCIA").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getNiEmpresa().setConteudo(niEmpresa);
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                item.getValor13Salario().setConteudo(valor13Salario);
                item.getValorIRRF().setConteudo(valorIRRF);
                item.getValorIRRF13Salario().setConteudo(valorIRRF13Salario);
                item.getValorPrevidenciaOficial().setConteudo(valorPrevidencia);
                objDecl.getRendIsentos().getPensaoQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarRendimentosRecebidosExterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cnpjEmpresa = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCnpjEmpresa().setConteudo(cnpjEmpresa);
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarIncorporacaoReservasCapital(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getIncorporacaoReservaCapitalQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cnpjEmpresa = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCnpjEmpresa().setConteudo(cnpjEmpresa);
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getIncorporacaoReservaCapitalQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarPoupanca(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getPoupancaQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cnpjEmpresa = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCnpjEmpresa().setConteudo(cnpjEmpresa);
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getPoupancaQuadroAuxiliar().itens().add(item);
            }
        } else if (!objDecl.getRendIsentos().getPoupanca().isVazio()) {
            ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl);
            item.getValor().setConteudo(objDecl.getRendIsentos().getPoupanca());
            objDecl.getRendIsentos().getPoupancaQuadroAuxiliar().itens().add(item);
        }
    }

    public void montarSocio(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getRendSocioQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cnpjEmpresa = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCnpjEmpresa().setConteudo(cnpjEmpresa);
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getRendSocioQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarTransferencias(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getTransferenciasQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroTransferenciaPatrimonial item = new ItemQuadroTransferenciaPatrimonial(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String niDoadorEspolio = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getNiDoadorEspolio().setConteudo(niDoadorEspolio);
                item.getNomeDoadorEspolio().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getTransferenciasQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarFicharRendimentoIsentoTipo2(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getMedicosResidentesQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                RegistroTxt objRegTXT = vRegistro.get(i);
                String tipo = objRegTXT.fieldByName("NR_COD").asString();
                if ("0019".equals(tipo)) {
                    ItemQuadroMeacaoDissolucao item19 = new ItemQuadroMeacaoDissolucao(objDecl);
                    item19.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item19.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item19.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getMeacaoDissolucaoQuadroAuxiliar().itens().add(item19);
                    continue;
                }
                if ("0020".equals(tipo)) {
                    ColecaoItemQuadroGanhosAcoesOuro colecao20 = objDecl.getRendIsentos().getGanhosLiquidosAcoesQuadroAuxiliar();
                    ItemQuadroGanhosAcoesOuro item20 = new ItemQuadroGanhosAcoesOuro(objDecl, colecao20);
                    item20.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item20.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item20.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getGanhosLiquidosAcoesQuadroAuxiliar().itens().add(item20);
                    continue;
                }
                if (!"0021".equals(tipo)) continue;
                ColecaoItemQuadroGanhosAcoesOuro colecao21 = objDecl.getRendIsentos().getGanhosCapitalOuroQuadroAuxiliar();
                ItemQuadroGanhosAcoesOuro item21 = new ItemQuadroGanhosAcoesOuro(objDecl, colecao21);
                item21.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item21.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                item21.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                objDecl.getRendIsentos().getGanhosCapitalOuroQuadroAuxiliar().itens().add(item21);
            }
        }
    }

    public void montarFicharRendimentoIsentoTipo3(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroTransporteDetalhado item17;
                RegistroTxt objRegTXT = vRegistro.get(i);
                String tipo = objRegTXT.fieldByName("NR_COD").asString();
                if ("0001".equals(tipo)) {
                    ItemQuadroTransporteDetalhado item1 = new ItemQuadroTransporteDetalhado(objDecl);
                    item1.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item1.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item1.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item1.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item1.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getBolsaEstudosQuadroAuxiliar().itens().add(item1);
                    continue;
                }
                if (tipo.equals("0002")) {
                    ItemQuadroTransporteDetalhado item2 = new ItemQuadroTransporteDetalhado(objDecl);
                    item2.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item2.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item2.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item2.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item2.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getMedicosResidentesQuadroAuxiliar().itens().add(item2);
                    continue;
                }
                if (tipo.equals("0004")) {
                    ItemQuadroRendimentosNI item4 = new ItemQuadroRendimentosNI(objDecl);
                    item4.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item4.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item4.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item4.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item4.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getIndenizacoesQuadroAuxiliar().itens().add(item4);
                    continue;
                }
                if (tipo.equals("0009")) {
                    ItemQuadroTransporteDetalhado item9 = new ItemQuadroTransporteDetalhado(objDecl);
                    item9.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item9.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item9.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item9.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item9.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    item9.getCodBem().setConteudo(objRegTXT.fieldByName("NR_CHAVE_BEM").asString());
                    objDecl.getRendIsentos().getLucroRecebidoQuadroAuxiliar().itens().add(item9);
                    continue;
                }
                if (tipo.equals("0010")) {
                    ItemQuadroTransporteDetalhado item10 = new ItemQuadroTransporteDetalhado(objDecl);
                    item10.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item10.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item10.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item10.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item10.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    item10.getValor13Salario().setConteudo(objRegTXT.fieldByName("VR_VALOR_13").asValor());
                    objDecl.getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().itens().add(item10);
                    continue;
                }
                if (tipo.equals("0012")) {
                    ItemQuadroTransporteDetalhado item12 = new ItemQuadroTransporteDetalhado(objDecl);
                    item12.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item12.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item12.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item12.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item12.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    item12.getCodBem().setConteudo(objRegTXT.fieldByName("NR_CHAVE_BEM").asString());
                    objDecl.getRendIsentos().getPoupancaQuadroAuxiliar().itens().add(item12);
                    continue;
                }
                if (tipo.equals("0013")) {
                    ItemQuadroTransporteDetalhado item13 = new ItemQuadroTransporteDetalhado(objDecl);
                    item13.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item13.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item13.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item13.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item13.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getRendSocioQuadroAuxiliar().itens().add(item13);
                    continue;
                }
                if (tipo.equals("0014")) {
                    ItemQuadroTransferenciaPatrimonial item14 = new ItemQuadroTransferenciaPatrimonial(objDecl);
                    item14.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item14.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item14.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item14.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item14.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getTransferenciasQuadroAuxiliar().itens().add(item14);
                    continue;
                }
                if (tipo.equals("0016")) {
                    ItemQuadroRendimentosNI item16 = new ItemQuadroRendimentosNI(objDecl);
                    item16.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item16.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item16.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item16.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item16.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar().itens().add(item16);
                    continue;
                }
                if (tipo.equals("0017")) {
                    item17 = new ItemQuadroTransporteDetalhado(objDecl);
                    item17.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item17.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item17.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item17.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item17.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar().itens().add(item17);
                    continue;
                }
                if (tipo.equals("0018")) {
                    item17 = new ItemQuadroTransporteDetalhado(objDecl);
                    item17.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item17.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item17.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item17.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    item17.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getIncorporacaoReservaCapitalQuadroAuxiliar().itens().add(item17);
                    continue;
                }
                if (!tipo.equals("0028")) continue;
                item17 = new ItemQuadroPensaoAlimenticiaRendIsentos(objDecl);
                item17.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item17.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                item17.getCpfAlimentante().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                item17.getNomeAlimentante().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item17.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                objDecl.getRendIsentos().getPensaoAlimenticiaQuadroAuxiliar().itens().add(item17);
            }
        }
    }

    public void montarFicharRendimentoIsentoTipo3AnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, String[] tiposRendIsentos) throws GeracaoTxtException {
        boolean rendIsento01;
        boolean rendIsento02;
        boolean rendIsento04;
        boolean rendIsento09;
        boolean rendIsento10;
        boolean rendIsento12;
        boolean rendIsento13;
        boolean rendIsento14;
        boolean rendIsento16;
        boolean rendIsento17;
        boolean rendIsento18;
        if (tiposRendIsentos != null) {
            rendIsento18 = false;
            rendIsento17 = false;
            rendIsento16 = false;
            rendIsento14 = false;
            rendIsento13 = false;
            rendIsento12 = false;
            rendIsento10 = false;
            rendIsento09 = false;
            rendIsento04 = false;
            rendIsento02 = false;
            rendIsento01 = false;
            for (String tipo : tiposRendIsentos) {
                rendIsento01 = rendIsento01 || "0001".equals(tipo);
                rendIsento02 = rendIsento02 || "0002".equals(tipo);
                rendIsento04 = rendIsento04 || "0004".equals(tipo);
                rendIsento09 = rendIsento09 || "0009".equals(tipo);
                rendIsento10 = rendIsento10 || "0010".equals(tipo);
                rendIsento12 = rendIsento12 || "0012".equals(tipo);
                rendIsento13 = rendIsento13 || "0013".equals(tipo);
                rendIsento14 = rendIsento14 || "0014".equals(tipo);
                rendIsento16 = rendIsento16 || "0016".equals(tipo);
                rendIsento17 = rendIsento17 || "0017".equals(tipo);
                rendIsento18 = rendIsento18 || "0018".equals(tipo);
            }
        } else {
            rendIsento18 = true;
            rendIsento17 = true;
            rendIsento16 = true;
            rendIsento14 = true;
            rendIsento13 = true;
            rendIsento12 = true;
            rendIsento10 = true;
            rendIsento09 = true;
            rendIsento04 = true;
            rendIsento02 = true;
            rendIsento01 = true;
        }
        if (vRegistro.size() > 0) {
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroTransporteDetalhado item17;
                RegistroTxt objRegTXT = vRegistro.get(i);
                String tipo = objRegTXT.fieldByName("NR_COD").asString();
                if (rendIsento01 && "0001".equals(tipo)) {
                    ItemQuadroTransporteDetalhado item1 = new ItemQuadroTransporteDetalhado(objDecl);
                    item1.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item1.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item1.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item1.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    objDecl.getRendIsentos().getBolsaEstudosQuadroAuxiliar().itens().add(item1);
                    continue;
                }
                if (rendIsento02 && tipo.equals("0002")) {
                    ItemQuadroTransporteDetalhado item2 = new ItemQuadroTransporteDetalhado(objDecl);
                    item2.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item2.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item2.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item2.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    objDecl.getRendIsentos().getMedicosResidentesQuadroAuxiliar().itens().add(item2);
                    continue;
                }
                if (rendIsento04 && tipo.equals("0004")) {
                    ItemQuadroRendimentosNI item4 = new ItemQuadroRendimentosNI(objDecl);
                    item4.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item4.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item4.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item4.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    objDecl.getRendIsentos().getIndenizacoesQuadroAuxiliar().itens().add(item4);
                    continue;
                }
                if (rendIsento09 && tipo.equals("0009")) {
                    ItemQuadroTransporteDetalhado item9 = new ItemQuadroTransporteDetalhado(objDecl);
                    item9.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item9.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item9.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item9.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    objDecl.getRendIsentos().getLucroRecebidoQuadroAuxiliar().itens().add(item9);
                    continue;
                }
                if (rendIsento10 && tipo.equals("0010")) {
                    ItemQuadroTransporteDetalhado item10 = new ItemQuadroTransporteDetalhado(objDecl);
                    item10.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item10.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item10.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item10.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    objDecl.getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().itens().add(item10);
                    continue;
                }
                if (rendIsento12 && tipo.equals("0012")) {
                    ItemQuadroTransporteDetalhado item12 = new ItemQuadroTransporteDetalhado(objDecl);
                    item12.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item12.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item12.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item12.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    objDecl.getRendIsentos().getPoupancaQuadroAuxiliar().itens().add(item12);
                    continue;
                }
                if (rendIsento13 && tipo.equals("0013")) {
                    ItemQuadroTransporteDetalhado item13 = new ItemQuadroTransporteDetalhado(objDecl);
                    item13.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item13.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item13.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item13.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    objDecl.getRendIsentos().getRendSocioQuadroAuxiliar().itens().add(item13);
                    continue;
                }
                if (rendIsento14 && tipo.equals("0014")) {
                    ItemQuadroTransferenciaPatrimonial item14 = new ItemQuadroTransferenciaPatrimonial(objDecl);
                    item14.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item14.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item14.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item14.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    objDecl.getRendIsentos().getTransferenciasQuadroAuxiliar().itens().add(item14);
                    continue;
                }
                if (rendIsento16 && tipo.equals("0016")) {
                    ItemQuadroRendimentosNI item16 = new ItemQuadroRendimentosNI(objDecl);
                    item16.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item16.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item16.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item16.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    objDecl.getRendIsentos().getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar().itens().add(item16);
                    continue;
                }
                if (rendIsento17 && tipo.equals("0017")) {
                    item17 = new ItemQuadroTransporteDetalhado(objDecl);
                    item17.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                    item17.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                    item17.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                    item17.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                    objDecl.getRendIsentos().getRendAssalariadoMoedaEstrangeiraQuadroAuxiliar().itens().add(item17);
                    continue;
                }
                if (!rendIsento18 || !tipo.equals("0018")) continue;
                item17 = new ItemQuadroTransporteDetalhado(objDecl);
                item17.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item17.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                item17.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                item17.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                objDecl.getRendIsentos().getIncorporacaoReservaCapitalQuadroAuxiliar().itens().add(item17);
            }
        }
    }

    public void montarFicharRendimentoIsentoTipo4(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            for (int i = 0; i < vRegistro.size(); ++i) {
                RegistroTxt objRegTXT = vRegistro.get(i);
                String tipo = objRegTXT.fieldByName("NR_COD").asString();
                if (!"0011".equals(tipo)) continue;
                ItemQuadroPensaoMolestiaGrave item11 = new ItemQuadroPensaoMolestiaGrave(objDecl);
                item11.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item11.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                item11.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                item11.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item11.getValor().setConteudo(objRegTXT.fieldByName("VR_RECEB").asValor());
                item11.getValor13Salario().setConteudo(objRegTXT.fieldByName("VR_13SALARIO").asValor());
                item11.getValorIRRF().setConteudo(objRegTXT.fieldByName("VR_IRRF").asValor());
                item11.getValorIRRF13Salario().setConteudo(objRegTXT.fieldByName("VR_IRRF13SALARIO").asValor());
                item11.getValorPrevidenciaOficial().setConteudo(objRegTXT.fieldByName("VR_PREVIDENCIA").asValor());
                objDecl.getRendIsentos().getPensaoQuadroAuxiliar().itens().add(item11);
            }
        }
    }

    public void montarFicharRendimentoIsentoTipo4AnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            for (int i = 0; i < vRegistro.size(); ++i) {
                RegistroTxt objRegTXT = vRegistro.get(i);
                String tipo = objRegTXT.fieldByName("NR_COD").asString();
                if (!"0011".equals(tipo)) continue;
                ItemQuadroPensaoMolestiaGrave item11 = new ItemQuadroPensaoMolestiaGrave(objDecl);
                item11.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item11.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                item11.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                item11.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                objDecl.getRendIsentos().getPensaoQuadroAuxiliar().itens().add(item11);
            }
        }
    }

    public void montarFicharRendimentoIsentoTipo5(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            for (int i = 0; i < vRegistro.size(); ++i) {
                RegistroTxt objRegTXT = vRegistro.get(i);
                String tipo = objRegTXT.fieldByName("NR_COD").asString();
                if (!"0026".equals(tipo)) continue;
                ItemQuadroOutrosRendimentos item = new ItemQuadroOutrosRendimentos(objDecl);
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                item.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                item.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                item.getDescricaoRendimento().setConteudo(objRegTXT.fieldByName("NM_DESCRICAO").asString());
                item.getCodBem().setConteudo(objRegTXT.fieldByName("NR_CHAVE_BEM").asString());
                objDecl.getRendIsentos().getOutrosQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarFicharRendimentoIsentoTipo6(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            for (int i = 0; i < vRegistro.size(); ++i) {
                RegistroTxt objRegTXT = vRegistro.get(i);
                String tipo = objRegTXT.fieldByName("NR_COD").asString();
                if ("0005".equals(tipo)) {
                    objDecl.getRendIsentos().getBensPequenoValorInformado().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getBensPequenoValorTransportado().setConteudo(objRegTXT.fieldByName("VR_VALORGCAP").asValor());
                }
                if ("0006".equals(tipo)) {
                    objDecl.getRendIsentos().getUnicoImovelInformado().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                    objDecl.getRendIsentos().getUnicoImovelTransportado().setConteudo(objRegTXT.fieldByName("VR_VALORGCAP").asValor());
                }
                if (!"0007".equals(tipo)) continue;
                objDecl.getRendIsentos().getOutrosBensImoveisInformado().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                objDecl.getRendIsentos().getOutrosBensImoveisTransportado().setConteudo(objRegTXT.fieldByName("VR_VALORGCAP").asValor());
            }
        }
    }

    public void montarVoluntariosCopa(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getVoluntariosCopaQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cnpjEmpresa = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                if (cnpjEmpresa == null || cnpjEmpresa.isEmpty() || Validador.validarCNPJ((String)cnpjEmpresa) != null || valor.getConteudo() == null || valor.getConteudo().equals(0L) || cpfBeneficiario == null || cpfBeneficiario.isEmpty() || Validador.validarCPF((String)cpfBeneficiario) != null) continue;
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCnpjEmpresa().setConteudo(cnpjEmpresa);
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getVoluntariosCopaQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarOutrosRendimentosIsentosTributacaoExclusivaTipo12(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                RegistroTxt objRegTXT = vRegistro.get(i);
                ItemQuadroOutrosRendimentos item = new ItemQuadroOutrosRendimentos(objDecl, (ObjetoNegocio)objDecl.getRendTributacaoExclusiva());
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
                item.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
                item.getDescricaoRendimento().setConteudo(objRegTXT.fieldByName("NM_DESCRICAO").asString());
                objDecl.getRendTributacaoExclusiva().getOutrosQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarBolsaEstudosNaoMedico(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getBolsaEstudosQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cnpjEmpresa = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCnpjEmpresa().setConteudo(cnpjEmpresa);
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getBolsaEstudosQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarIndenizacoes(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getIndenizacoesQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroRendimentosNI item = new ItemQuadroRendimentosNI(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cnpjEmpresa = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCnpjEmpresa().setConteudo(cnpjEmpresa);
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getIndenizacoesQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarIRRFAnosAnteriores(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroRendimentosNI item = new ItemQuadroRendimentosNI(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cnpjEmpresa = objRegTXT.fieldByName("NR_PAGADORA").asString();
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getCnpjEmpresa().setConteudo(cnpjEmpresa);
                item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getImpostoRendasAnterioresCompensadoJudicialmenteQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarMeacaoDissolucao(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getRendIsentos().getMeacaoDissolucaoQuadroAuxiliar().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroMeacaoDissolucao item = new ItemQuadroMeacaoDissolucao(objDecl);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getMeacaoDissolucaoQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarGanhosAcoes(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ColecaoItemQuadroGanhosAcoesOuro colecao = objDecl.getRendIsentos().getGanhosLiquidosAcoesQuadroAuxiliar();
        if (vRegistro.size() > 0) {
            colecao.itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroGanhosAcoesOuro item = new ItemQuadroGanhosAcoesOuro(objDecl, colecao);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getGanhosLiquidosAcoesQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarGanhosOuro(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        ColecaoItemQuadroGanhosAcoesOuro colecao = objDecl.getRendIsentos().getGanhosCapitalOuroQuadroAuxiliar();
        if (vRegistro.size() > 0) {
            colecao.itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                ItemQuadroGanhosAcoesOuro item = new ItemQuadroGanhosAcoesOuro(objDecl, colecao);
                RegistroTxt objRegTXT = vRegistro.get(i);
                String cpfBeneficiario = objRegTXT.fieldByName("NR_CPF_BENEFIC").asString();
                Valor valor = objRegTXT.fieldByName("VR_RECEB").asValor();
                item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
                item.getValor().setConteudo(valor);
                item.getCpfBeneficiario().setConteudo(cpfBeneficiario);
                objDecl.getRendIsentos().getGanhosCapitalOuroQuadroAuxiliar().itens().add(item);
            }
        }
    }

    public void montarDoacoesCampanha(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getDoacoesEleitorais().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                DoacaoEleitoral item = new DoacaoEleitoral();
                RegistroTxt objRegTXT = vRegistro.get(i);
                item.getCNPJ().setConteudo(objRegTXT.fieldByName("NR_PARTIDO").asString());
                item.getNome().setConteudo(objRegTXT.fieldByName("NM_PARTIDO").asString());
                item.getValor().setConteudo(objRegTXT.fieldByName("VR_DOACAO").asValor());
                objDecl.getDoacoesEleitorais().itens().add(item);
            }
        }
    }

    public void montarPagamentosAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            objDecl.getPagamentos().itens().clear();
            for (int i = 0; i < vRegistro.size(); ++i) {
                RegistroTxt objRegTXT = vRegistro.get(i);
                Pagamento pagamento = objDecl.getPagamentos().instanciaNovoObjeto();
                pagamento.getNiBeneficiario().setConteudo(objRegTXT.fieldByName("NR_BENEF").asString());
                pagamento.getNitEmpregadoDomestico().setConteudo(objRegTXT.fieldByName("NR_NIT").asString());
                pagamento.getNomeBeneficiario().setConteudo(objRegTXT.fieldByName("NM_BENEF").asString());
                pagamento.getDescricao().setConteudo(objRegTXT.fieldByName("NM_DESCRICAO").asString());
                String codigoPagamento = objRegTXT.fieldByName("CD_PAGTO").asString();
                if (codigoPagamento.equals("38")) {
                    pagamento.getCodigo().setConteudo("36");
                } else {
                    pagamento.getCodigo().setConteudo(objRegTXT.fieldByName("CD_PAGTO").asString());
                }
                pagamento.getTipo().setConteudo(objRegTXT.fieldByName("IN_TIPO_PGTO").asString());
                pagamento.getDependenteOuAlimentando().setConteudo(objDecl.getNomeDependenteOuAlimentandoPorChave(pagamento, objRegTXT.fieldByName("NR_CHAVE_DEPEND").asString()));
                objDecl.getPagamentos().itens().add(pagamento);
            }
        }
    }

    private void montarMesRendPF(RegistroTxt objRegTXT, DeclaracaoIRPF objDecl, RendPF rendPF) throws GeracaoTxtException {
        int mes = objRegTXT.fieldByName("NR_MES").asInteger();
        MesRendPF objRendPF = rendPF.getMesRendPFPorIndice(mes - 1);
        objRendPF.getMes().setConteudo(mes - 1);
        objRendPF.getPessoaFisica().setConteudo(objRegTXT.fieldByName("VR_RENDTO").asValor());
        objRendPF.getAlugueis().setConteudo(objRegTXT.fieldByName("VR_ALUGUEIS").asValor());
        objRendPF.getOutros().setConteudo(objRegTXT.fieldByName("VR_OUTROS").asValor());
        objRendPF.getExterior().setConteudo(objRegTXT.fieldByName("VR_EXTER").asValor());
        objRendPF.getPrevidencia().setConteudo(objRegTXT.fieldByName("VR_PREVID").asValor());
        objRendPF.getDependentes().setConteudo(objRegTXT.fieldByName("VR_DEDUC").asValor());
        objRendPF.getPensao().setConteudo(objRegTXT.fieldByName("VR_ALIMENT").asValor());
        objRendPF.getLivroCaixa().setConteudo(objRegTXT.fieldByName("VR_LIVCAIX").asValor());
        objRendPF.getDarfPago().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO").asValor());
    }

    public void montarRendimentosPFTrabalhoNaoAssalariado(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        List<RegistroTxt> registros = this.filtrarRegsRendPFTrabNaoAssalariadoPorContribuinte(vRegistro, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), "           ");
        this.montarRendPFTrabalhoNaoAssalariado(registros, objDecl.getRendPFTitular(), true);
        for (ItemRendPFDependente lItem : objDecl.getRendPFDependente().itens()) {
            registros = this.filtrarRegsRendPFTrabNaoAssalariadoPorContribuinte(vRegistro, objDecl.getIdentificadorDeclaracao().getCpf().naoFormatado(), lItem.getCpf().naoFormatado());
            this.montarRendPFTrabalhoNaoAssalariado(registros, lItem.getRendimentos(), false);
        }
    }

    private List<RegistroTxt> filtrarRegsRendPFTrabNaoAssalariadoPorContribuinte(List<RegistroTxt> vRegistro, String cpfTitular, String cpfDependente) throws GeracaoTxtException {
        ArrayList<RegistroTxt> registros = new ArrayList<RegistroTxt>();
        String padrao = "49" + cpfTitular + cpfDependente;
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!objRegTXT.getLinha().startsWith(padrao)) continue;
            registros.add(objRegTXT);
        }
        return registros;
    }

    private void montarRendPFTrabalhoNaoAssalariado(List<RegistroTxt> vRegistro, RendPF rendpf, boolean isTitular) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            Conta conta = new Conta();
            conta.getCpfTitularPagamento().setConteudo(objRegTXT.fieldByName("NR_CPF_TITULAR_PAGAMENTO").asString());
            conta.getCpfBeneficiarioServico().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            conta.getDataMesAno().setConteudo(objRegTXT.fieldByName("NR_MES").asString() + String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() - 1));
            if (isTitular) {
                conta.getCpfContribuinte().setConteudo(objRegTXT.fieldByName("NR_CPF_TITULAR").asString());
            } else {
                conta.getCpfContribuinte().setConteudo(objRegTXT.fieldByName("NR_CPF_DEPENDENTE").asString());
            }
            conta.getValor().setConteudo(objRegTXT.fieldByName("NR_VALOR").asValor());
            if (!conta.getCpfTitularPagamento().isVazio() && conta.getCpfTitularPagamento().naoFormatado().equals(conta.getCpfBeneficiarioServico().naoFormatado())) {
                conta.getIndTitularEhBeneficiario().setConteudo("1");
            } else {
                conta.getIndTitularEhBeneficiario().setConteudo("0");
            }
            if (conta.getCpfBeneficiarioServico().naoFormatado().length() != 11 && !conta.getCpfTitularPagamento().isVazio()) {
                conta.getIndBeneficiarioNaoPossuiCPF().setConteudo("1");
            } else {
                conta.getIndBeneficiarioNaoPossuiCPF().setConteudo("0");
            }
            rendpf.getContasAno().obterMesEscrituracaoPorNumeroMes(Integer.valueOf(conta.getDataMesAno().naoFormatado().substring(0, 2)).intValue()).itens().add(conta);
        }
    }

    public void montarRendPFDependentes(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendPFDependente().clear();
        int countRendimentos = 0;
        ItemRendPFDependente dependente = null;
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!objRegTXT.fieldByName("E_DEPENDENTE").asBoolean()) continue;
            if (countRendimentos % 12 == 0) {
                dependente = new ItemRendPFDependente();
                dependente.getCpf().setConteudo(objRegTXT.fieldByName("NR_CPF_DEPEN").asString());
                objDecl.getRendPFDependente().itens().add(dependente);
            }
            this.montarMesRendPF(objRegTXT, objDecl, dependente.getRendimentos());
            ++countRendimentos;
        }
    }

    public void montarRendPFTitular(List<RegistroTxt> vRegistrosRendPF, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendPFTitular().clear();
        int j = 0;
        for (int i = 0; i < vRegistrosRendPF.size() && j < 12; ++i) {
            RegistroTxt objRegTXT = vRegistrosRendPF.get(i);
            if (objRegTXT.fieldByName("E_DEPENDENTE").asBoolean()) continue;
            this.montarMesRendPF(objRegTXT, objDecl, objDecl.getRendPFTitular());
            ++j;
        }
    }

    public void montarNITPISPASEPDeIdentificacaoEmRendPFTitular(List<RegistroTxt> vRegistro, RendPF rendPF) throws GeracaoTxtException {
        RegistroTxt registroTXT = vRegistro.get(0);
        rendPF.getNITPISPASEP().setConteudo(registroTXT.fieldByName("NR_NITPISPASEP").asString());
    }

    public void montarNITPISPASEPDeDependenteEmRendPFDependente(List<RegistroTxt> vRegistro, ColecaoRendPFDependente rendPFDependentes) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt registroTXT = vRegistro.get(i);
            String cpfDependente = registroTXT.fieldByName("NI_DEPEND").asString();
            String nitpispasep = registroTXT.fieldByName("NR_NITPISPASEP").asString();
            ItemRendPFDependente itemRendPFDependente = rendPFDependentes.obterItemRendPFDependentePorCPF(cpfDependente);
            if (itemRendPFDependente == null) continue;
            itemRendPFDependente.getRendimentos().getNITPISPASEP().setConteudo(nitpispasep);
        }
    }

    public void montarDependentes(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        this.montarDependentes(vRegistro, objDecl, false);
    }

    public void montarDependentes(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean realizarMerge) throws GeracaoTxtException {
        if (!realizarMerge) {
            objDecl.getDependentes().itens().clear();
        }
        for (int i = 0; i < vRegistro.size(); ++i) {
            String codDependente;
            Dependente objDependente = null;
            RegistroTxt objRegTXT = vRegistro.get(i);
            boolean adicionar = false;
            String cpf = objRegTXT.fieldByName("NI_DEPEND").asString();
            String nome = objRegTXT.fieldByName("NM_DEPEND").asString();
            if (realizarMerge) {
                if (!cpf.isEmpty()) {
                    objDependente = objDecl.getDependentes().getDependenteByCpf(cpf);
                }
                if (objDependente == null) {
                    objDependente = objDecl.getDependentes().getDependenteByNome(nome);
                }
            }
            if (objDependente == null) {
                adicionar = true;
                objDependente = new Dependente(objDecl);
            }
            if (!realizarMerge) {
                objDependente.setChave(objRegTXT.fieldByName("NR_CHAVE").asString());
            }
            if ((codDependente = objRegTXT.fieldByName("CD_DEPEND").asString()) != null && !codDependente.isEmpty() && Validador.validarElementoTabela((String)codDependente, (List)CadastroTabelasIRPF.recuperarDependencias(), null).getSeveridade() == 0) {
                objDependente.getCodigo().setConteudo(codDependente);
            }
            objDependente.getNome().setConteudo(nome);
            String dtNasc = objRegTXT.fieldByName("DT_NASCIM").asString();
            if (!"00000000".equals(dtNasc)) {
                objDependente.getDataNascimento().setConteudo(dtNasc);
            }
            if (objDecl.getIdentificadorDeclaracao().isSaida()) {
                String saiuMesmaData = objRegTXT.fieldByName("IN_SAIDA").asString();
                objDependente.getIndSaidaPaisMesmaData().setConteudo(saiuMesmaData.trim().isEmpty() ? "2" : saiuMesmaData);
            }
            objDependente.getIndMoraComTitular().setConteudo(objRegTXT.fieldByName("IN_ENDERECO_TITULAR").asString());
            objDependente.getDdd().setConteudo(objRegTXT.fieldByName("NR_DDD_CELULAR").asString());
            objDependente.getTelefone().setConteudo(objRegTXT.fieldByName("NR_CELULAR").asString());
            objDependente.getEmail().setConteudo(objRegTXT.fieldByName("NM_EMAIL").asString());
            objDependente.getCpfDependente().setConteudo(cpf);
            if (!adicionar) continue;
            objDecl.getDependentes().itens().add(objDependente);
        }
    }

    public void montarInventariante(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            RegistroTxt objRegTXT = vRegistro.get(0);
            Espolio espolio = objDecl.getEspolio();
            if (!espolio.isBensInventariarMarcado()) {
                EspolioPartilha infoEspolio;
                String inSobrepartilha = objRegTXT.fieldByName("IN_SOBREPARTILHA").asString();
                if (Logico.SIM.equals(inSobrepartilha)) {
                    infoEspolio = objDecl.getEspolio().getSobrepartilha();
                    espolio.getIndicadorSobrepartilha().setConteudo(Logico.SIM);
                } else {
                    infoEspolio = espolio.getPartilha();
                    espolio.getIndicadorSobrepartilha().setConteudo(Logico.NAO);
                }
                infoEspolio.getNomeInventariante().setConteudo(objRegTXT.fieldByName("NM_INVENT").asString());
                infoEspolio.getCpfInventariante().setConteudo(objRegTXT.fieldByName("NR_INVENT").asString());
            } else if (espolio.isBensInventariarMarcado()) {
                String inSobrepartilha = objRegTXT.fieldByName("IN_SOBREPARTILHA").asString();
                if (Logico.SIM.equals(inSobrepartilha)) {
                    espolio.getIndicadorSobrepartilha().setConteudo(Logico.SIM);
                } else {
                    espolio.getIndicadorSobrepartilha().setConteudo(Logico.NAO);
                }
                espolio.getNomeInventariante().setConteudo(objRegTXT.fieldByName("NM_INVENT").asString());
                espolio.getCpfInventariante().setConteudo(objRegTXT.fieldByName("NR_INVENT").asString());
            }
        }
    }

    public void montarFinalEspolio(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            Espolio espolio = objDecl.getEspolio();
            for (RegistroTxt objRegTXT : vRegistro) {
                String anoObito = objRegTXT.fieldByName("NR_ANOOBITO").asString();
                espolio.getAnoObito().setConteudo(anoObito);
                String inFaseFinalEspolio = objRegTXT.fieldByName("IN_STATUS_SOBREPARTILHA").asString();
                if ("0".equals(inFaseFinalEspolio)) {
                    espolio.getIndicadorFinalEspolio().setConteudo("0");
                } else if ("1".equals(inFaseFinalEspolio)) {
                    espolio.getIndicadorFinalEspolio().setConteudo("1");
                } else if ("3".equals(inFaseFinalEspolio)) {
                    espolio.getIndicadorFinalEspolio().setConteudo("3");
                }
                espolio.getIndicadorBensInventariar().setConteudo(objRegTXT.fieldByName("IN_BENS_INVENTARIAR").asString());
                String inSobrepartilha = objRegTXT.fieldByName("IN_SOBREPARTILHA").asString();
                if (Logico.SIM.equals(inSobrepartilha)) {
                    this.montarFinalEspolio(objRegTXT, espolio.getSobrepartilha());
                    continue;
                }
                this.montarFinalEspolio(objRegTXT, espolio.getPartilha());
            }
        }
    }

    public void montarFinalEspolio(RegistroTxt objRegTXT, EspolioPartilha infoEspolio) throws GeracaoTxtException {
        String tipoJudicial = objRegTXT.fieldByName("IN_TIPO_PROCESSO").asString().equals("J") ? Logico.SIM : Logico.NAO;
        infoEspolio.getTipoJudicial().setConteudo(tipoJudicial);
        infoEspolio.getNomeInventariante().setConteudo(objRegTXT.fieldByName("NM_INVENT").asString());
        infoEspolio.getCpfInventariante().setConteudo(objRegTXT.fieldByName("NR_INVENT").asString());
        if (tipoJudicial.equals(Logico.SIM)) {
            EspolioDecisaoJudicial decisaoJudicial = infoEspolio.getDecisaoJudicial();
            decisaoJudicial.getNumProcessoJudicial().setConteudo(objRegTXT.fieldByName("NR_PROCESSO_JUDICIAL").asString());
            decisaoJudicial.getIdVaraCivil().setConteudo(objRegTXT.fieldByName("NR_VARACIVIL").asString());
            decisaoJudicial.getComarca().setConteudo(objRegTXT.fieldByName("NM_COMARCA").asString());
            String dt = objRegTXT.fieldByName("DT_DECJUDICIALPARTILHA").asString();
            RetornoValidacao dtValida = Validador.validarData((String)UtilitariosString.formataData((String)dt));
            if (dtValida == null) {
                decisaoJudicial.getDtDecisaoJud().setConteudo(dt);
            }
            if ((dtValida = Validador.validarData((String)UtilitariosString.formataData((String)(dt = objRegTXT.fieldByName("DT_TRANSITOJULGADO").asString())), (int)Integer.parseInt("9999"))) == null) {
                decisaoJudicial.getDtTransito().setConteudo(dt);
            }
            decisaoJudicial.getUf().setConteudo(objRegTXT.fieldByName("SG_UFCOMARCA").asString());
        } else {
            EspolioEscrituracaoPublica escrituracaoPub = infoEspolio.getEscrituracaoPublica();
            escrituracaoPub.getCnpjCartorio().setConteudo(objRegTXT.fieldByName("NR_CNPJ_CARTORIO").asString());
            escrituracaoPub.getNome().setConteudo(objRegTXT.fieldByName("NM_CARTORIO").asString());
            escrituracaoPub.getLivro().setConteudo(objRegTXT.fieldByName("NM_LIVRO").asString());
            escrituracaoPub.getFolhas().setConteudo(objRegTXT.fieldByName("NM_FOLHA").asString());
            escrituracaoPub.getMunicipio().setConteudo(objRegTXT.fieldByName("NM_MUNICIPIO").asString());
            escrituracaoPub.getUf().setConteudo(objRegTXT.fieldByName("SG_UFCARTORIO").asString());
            String dt = objRegTXT.fieldByName("DT_LAVRATURA").asString();
            RetornoValidacao dtValida = Validador.validarData((String)UtilitariosString.formataData((String)dt));
            if (dtValida == null) {
                escrituracaoPub.getDataLavratura().setConteudo(dt);
            }
        }
        infoEspolio.getMorteAmbosConjuges().setConteudo(objRegTXT.fieldByName("IN_MORTEAMBOSCONJUGES").asString());
        String inventarioConjunto = objRegTXT.fieldByName("IN_INVENTARIOCONJUNTO").asString();
        infoEspolio.getInventarioConjunto().setConteudo(inventarioConjunto);
        infoEspolio.getConjugeMeeiro().setConteudo(objRegTXT.fieldByName("IN_MEEIRO").asString());
        if (inventarioConjunto.equals(Logico.SIM)) {
            infoEspolio.getNomeConjugeCompanheiro().setConteudo(objRegTXT.fieldByName("NM_CONJUGE").asString());
        }
    }

    public void montarSaida(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            String dtCondicaoResidente;
            RegistroTxt objRegTXT = vRegistro.get(0);
            objDecl.getSaida().getCpfProcurador().setConteudo(objRegTXT.fieldByName("NR_PROCURADOR").asString());
            objDecl.getSaida().getNomeProcurador().setConteudo(objRegTXT.fieldByName("NM_PROCURADOR").asString());
            objDecl.getSaida().getEndProcurador().setConteudo(objRegTXT.fieldByName("NM_END_PROCURADOR").asString());
            String dtCondicaoNaoResidente = objRegTXT.fieldByName("DT_NAORESIDENTE").asString();
            RetornoValidacao dtValida = Validador.validarData((String)UtilitariosString.formataData((String)dtCondicaoNaoResidente));
            if (dtValida == null) {
                objDecl.getSaida().getDtCondicaoNaoResidente().setConteudo(dtCondicaoNaoResidente);
            }
            if ((dtValida = Validador.validarData((String)UtilitariosString.formataData((String)(dtCondicaoResidente = objRegTXT.fieldByName("DT_RESIDENTE").asString())))) == null || dtValida.isValido() && !dtCondicaoResidente.equals("00000000")) {
                objDecl.getSaida().getDtCondicaoResidente().setConteudo(dtCondicaoResidente);
            }
            objDecl.getSaida().getPaisResidencia().setConteudo(objRegTXT.fieldByName("CD_NOVO_PAIS_RESIDENCIA").asString());
        }
    }

    public void montarInventarianteAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            RegistroTxt objRegTXT = vRegistro.get(0);
            objDecl.getEspolio().getPartilha().getCpfInventariante().setConteudo(objRegTXT.fieldByName("NR_INVENT").asString());
            objDecl.getEspolio().getPartilha().getNomeInventariante().setConteudo(objRegTXT.fieldByName("NM_INVENT").asString());
            objDecl.getEspolio().getIndicadorSobrepartilha().setConteudo(Logico.NAO);
        }
    }

    public void montarRendPJTitularSimplificada(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getColecaoRendPJTitular().itens().clear();
        if (vRegistro.size() > 0) {
            for (int i = 0; i < vRegistro.size(); ++i) {
                RendPJTitular objRendPJ = new RendPJTitular(objDecl.getIdentificadorDeclaracao());
                RegistroTxt objRegTXT = vRegistro.get(i);
                objRendPJ.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADOR").asString());
                objRendPJ.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_PAGADOR").asString());
                objRendPJ.getRendRecebidoPJ().setConteudo(objRegTXT.fieldByName("VR_RENDTO").asValor());
                objRendPJ.getImpostoRetidoFonte().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO").asValor());
                objDecl.getColecaoRendPJTitular().itens().add(objRendPJ);
            }
        }
    }

    public void montarRendaVariavel(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean ehDependente) throws GeracaoTxtException {
        if (!ehDependente) {
            this.montarRendaVariavelTitular(vRegistro, objDecl);
        } else {
            this.montarRendaVariavelDependentes(vRegistro, objDecl);
        }
    }

    private void montarRendaVariavelTitular(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendaVariavel().clear();
        for (int i = 0; i < vRegistro.size() && i < 12; ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (objRegTXT.fieldByName("E_DEPENDENTE").asBoolean()) continue;
            this.montarMesRendaVariavel(objRegTXT, objDecl.getRendaVariavel());
        }
    }

    private void montarRendaVariavelDependentes(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendaVariavelDependente().clear();
        ItemRendaVariavelDependente dependente = null;
        String cpfDependenteAnterior = null;
        String cpfDependenteAtual = null;
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!objRegTXT.fieldByName("E_DEPENDENTE").asBoolean()) continue;
            cpfDependenteAnterior = cpfDependenteAtual;
            cpfDependenteAtual = objRegTXT.fieldByName("NR_CPF_DEPEN").asString();
            if (!cpfDependenteAtual.equals(cpfDependenteAnterior)) {
                dependente = new ItemRendaVariavelDependente(objDecl);
                dependente.getCpf().setConteudo(cpfDependenteAtual);
                objDecl.getRendaVariavelDependente().itens().add(dependente);
            }
            this.montarMesRendaVariavel(objRegTXT, dependente.getRendaVariavel());
        }
    }

    private void montarMesRendaVariavel(RegistroTxt objRegTXT, RendaVariavel rendaVariavel) throws GeracaoTxtException {
        int mes = objRegTXT.fieldByName("NR_MES").asInteger();
        GanhosLiquidosOuPerdas objGanhosLiq = rendaVariavel.getGanhosPorIndice(mes - 1);
        Operacoes opComuns = objGanhosLiq.getOperacoesComuns();
        opComuns.getMercadoVistaAcoes().setConteudo(objRegTXT.fieldByName("VR_COMUM_MVISTA_ACOES").asValor());
        opComuns.getMercadoVistaOuro().setConteudo(objRegTXT.fieldByName("VR_COMUM_MVISTA_OURO").asValor());
        opComuns.getMercadoVistaForaBolsa().setConteudo(objRegTXT.fieldByName("VR_COMUM_MVISTA_OUROFORA").asValor());
        opComuns.getMercadoOpcoesAcoes().setConteudo(objRegTXT.fieldByName("VR_COMUM_MOPC_ACOES").asValor());
        opComuns.getMercadoOpcoesOuro().setConteudo(objRegTXT.fieldByName("VR_COMUM_MOPC_OURO").asValor());
        opComuns.getMercadoOpcoesForaDeBolsa().setConteudo(objRegTXT.fieldByName("VR_COMUM_MOPC_OUROFORA").asValor());
        opComuns.getMercadoOpcoesOutros().setConteudo(objRegTXT.fieldByName("VR_COMUM_MOPC_OUTROS").asValor());
        opComuns.getMercadoFuturoDolar().setConteudo(objRegTXT.fieldByName("VR_COMUM_MFUT_DOLAR").asValor());
        opComuns.getMercadoFuturoIndices().setConteudo(objRegTXT.fieldByName("VR_COMUM_MFUT_INDICES").asValor());
        opComuns.getMercadoFuturoJuros().setConteudo(objRegTXT.fieldByName("VR_COMUM_MFUT_JUROS").asValor());
        opComuns.getMercadoFuturoOutros().setConteudo(objRegTXT.fieldByName("VR_COMUM_MFUT_OUTROS").asValor());
        opComuns.getMercadoTermoAcoes().setConteudo(objRegTXT.fieldByName("VR_COMUM_MTERMO_ACOESOURO").asValor());
        opComuns.getMercadoTermoOutros().setConteudo(objRegTXT.fieldByName("VR_COMUM_MTERMO_OUTROS").asValor());
        Operacoes opDayTrade = objGanhosLiq.getOperacoesDayTrade();
        opDayTrade.getMercadoVistaAcoes().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MVISTA_ACOES").asValor());
        opDayTrade.getMercadoVistaOuro().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MVISTA_OURO").asValor());
        opDayTrade.getMercadoVistaForaBolsa().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MVISTA_OUROFORA").asValor());
        opDayTrade.getMercadoOpcoesAcoes().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MOPC_ACOES").asValor());
        opDayTrade.getMercadoOpcoesOuro().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MOPC_OURO").asValor());
        opDayTrade.getMercadoOpcoesForaDeBolsa().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MOPC_OUROFORA").asValor());
        opDayTrade.getMercadoOpcoesOutros().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MOPC_OUTROS").asValor());
        opDayTrade.getMercadoFuturoDolar().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MFUT_DOLAR").asValor());
        opDayTrade.getMercadoFuturoIndices().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MFUT_INDICES").asValor());
        opDayTrade.getMercadoFuturoJuros().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MFUT_JUROS").asValor());
        opDayTrade.getMercadoFuturoOutros().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MFUT_OUTROS").asValor());
        opDayTrade.getMercadoTermoAcoes().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MTERMO_ACOESOURO").asValor());
        opDayTrade.getMercadoTermoOutros().setConteudo(objRegTXT.fieldByName("VR_DAYTR_MTERMO_OUTROS").asValor());
        opComuns.getResultadoNegativoMesAnterior().setConteudo(objRegTXT.fieldByName("VR_RESULTNEG_MESANT_COMUM").asValor());
        opDayTrade.getResultadoNegativoMesAnterior().setConteudo(objRegTXT.fieldByName("VR_RESULTNEG_MESANT_DAYTR").asValor());
        objGanhosLiq.getIrFonteDayTradeMesAtual().setConteudo(objRegTXT.fieldByName("VR_FONTE_DAYTRADE").asValor());
        objGanhosLiq.getImpostoRetidoFonteLei11033().setConteudo(objRegTXT.fieldByName("VR_IMPRENDAFONTE").asValor());
        objGanhosLiq.getImpostoPago().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO_PAGO").asValor());
    }

    public void montarRendaVariavelFII(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean ehDependente) throws GeracaoTxtException {
        if (!ehDependente) {
            this.montarRendaVariavelFIITitular(vRegistro, objDecl);
        } else {
            this.montarRendaVariavelFIIDependentes(vRegistro, objDecl);
        }
    }

    private void montarRendaVariavelFIITitular(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getFundosInvestimentos().clear();
        for (int i = 0; i < vRegistro.size() && i < 12; ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (objRegTXT.fieldByName("E_DEPENDENTE").asBoolean()) continue;
            this.montarMesRendaVariavelFII(objRegTXT, objDecl.getFundosInvestimentos());
        }
    }

    private void montarRendaVariavelFIIDependentes(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getFundosInvestimentosDependente().clear();
        ItemFundosInvestimentosDependente dependente = null;
        String cpfDependenteAnterior = null;
        String cpfDependenteAtual = null;
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!objRegTXT.fieldByName("E_DEPENDENTE").asBoolean()) continue;
            cpfDependenteAnterior = cpfDependenteAtual;
            cpfDependenteAtual = objRegTXT.fieldByName("NR_CPF_DEPEN").asString();
            if (!cpfDependenteAtual.equals(cpfDependenteAnterior)) {
                dependente = new ItemFundosInvestimentosDependente(objDecl);
                dependente.getCpf().setConteudo(cpfDependenteAtual);
                objDecl.getFundosInvestimentosDependente().itens().add(dependente);
            }
            this.montarMesRendaVariavelFII(objRegTXT, dependente.getFundosInvestimentos());
        }
    }

    private void montarMesRendaVariavelFII(RegistroTxt objRegTXT, FundosInvestimentos fundosInvestimentos) throws GeracaoTxtException {
        int mes = objRegTXT.fieldByName("NR_MES").asInteger();
        if (mes < 1 || mes > 12) {
            throw new GeracaoTxtException("Registro Fundo de Investimentos, M\u00eas Inv\u00e1lido.");
        }
        MesFundosInvestimentos fundoInvest = fundosInvestimentos.getMeses()[mes - 1];
        fundoInvest.clear();
        fundoInvest.getResultLiquidoMes().setConteudo(objRegTXT.fieldByName("VR_RESLIQUIDO_MES").asValor());
        fundoInvest.getResultNegativoAnterior().setConteudo(objRegTXT.fieldByName("VR_RESULT_NEG_MESANT").asValor());
        fundoInvest.getBaseCalcImposto().setConteudo(objRegTXT.fieldByName("VR_BASECALCULO_MES").asValor());
        fundoInvest.getPrejuizoCompensar().setConteudo(objRegTXT.fieldByName("VR_PREJACOMPENSAR_MES_OPCOMUNS").asValor());
        fundoInvest.getAliquotaImposto().setConteudo(objRegTXT.fieldByName("VR_ALIQUOTA_IMPOSTO_OPCOMUNS").asValor());
        fundoInvest.getImpostoDevido().setConteudo(objRegTXT.fieldByName("VR_IMPOSTODEVIDO_MES_OPCOMUNS").asValor());
        fundoInvest.getImpostoRetidoMesesAnteriores().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO_RETIDO_MESES_ANTERIORES").asValor());
        fundoInvest.getImpostoRetidoFonte().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO_RETIDO_FONTE").asValor());
        fundoInvest.getImpostoRetidoCompensar().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO_RETIDO_COMPENSAR").asValor());
        fundoInvest.getImpostoAPagar().setConteudo(objRegTXT.fieldByName("VR_IMPOSTO_PAGAR").asValor());
        fundoInvest.getImpostoPago().setConteudo(objRegTXT.fieldByName("VR_IMPOSTOPAGO").asValor());
    }

    public void montarAtividadeRuralImoveis(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBrasil().getIdentificacaoImovel().itens().clear();
        objDecl.getAtividadeRural().getExterior().getIdentificacaoImovel().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            String codCondicaoExploracao;
            RegistroTxt objRegTXT = vRegistro.get(i);
            String inExt = objRegTXT.fieldByName("IN_EXTERIOR").asString();
            Object imovelAtual = inExt.equals("0") ? objDecl.getAtividadeRural().getBrasil().getIdentificacaoImovel().instanciaNovoObjeto() : objDecl.getAtividadeRural().getExterior().getIdentificacaoImovel().instanciaNovoObjeto();
            String codAtividadeRural = objRegTXT.fieldByName("CD_ATIV").asString();
            if (codAtividadeRural != null && !codAtividadeRural.isEmpty() && Validador.validarElementoTabela((String)codAtividadeRural, (List)CadastroTabelasIRPF.recuperarTipoAtividadesRural(), null).getSeveridade() == 0) {
                imovelAtual.getCodigo().setConteudo(codAtividadeRural);
            }
            if ((codCondicaoExploracao = objRegTXT.fieldByName("CD_EXPLOR").asString()) != null && !codCondicaoExploracao.isEmpty() && Validador.validarElementoTabela((String)codCondicaoExploracao, (List)CadastroTabelasIRPF.recuperarCondicoesExploracao(), null).getSeveridade() == 0) {
                imovelAtual.getCondicaoExploracao().setConteudo(codCondicaoExploracao);
            }
            imovelAtual.getArea().setConteudo(objRegTXT.fieldByName("QT_AREA").asValor());
            imovelAtual.getLocalizacao().setConteudo(objRegTXT.fieldByName("NM_LOCAL").asString());
            imovelAtual.getNome().setConteudo(objRegTXT.fieldByName("NM_IMOVEL").asString());
            imovelAtual.getParticipacao().setConteudo(objRegTXT.fieldByName("PC_PARTIC").asValor());
            imovelAtual.getIndice().setConteudo(objRegTXT.fieldByName("NR_CHAVE_AR").asString());
            if (imovelAtual instanceof ImovelARBrasil) {
                objDecl.getAtividadeRural().getBrasil().getIdentificacaoImovel().itens().add(imovelAtual);
                imovelAtual.getCIB().setConteudo(objRegTXT.fieldByName("NR_INCRA").asString());
                continue;
            }
            objDecl.getAtividadeRural().getExterior().getIdentificacaoImovel().itens().add(imovelAtual);
        }
    }

    public void montarAtividadeRuralImoveisAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBrasil().getIdentificacaoImovel().itens().clear();
        objDecl.getAtividadeRural().getExterior().getIdentificacaoImovel().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            String inExt = objRegTXT.fieldByName("IN_EXTERIOR").asString();
            Object imovelAtual = inExt.equals("0") ? objDecl.getAtividadeRural().getBrasil().getIdentificacaoImovel().instanciaNovoObjeto() : objDecl.getAtividadeRural().getExterior().getIdentificacaoImovel().instanciaNovoObjeto();
            imovelAtual.getCodigo().setConteudo(objRegTXT.fieldByName("CD_ATIV").asString());
            imovelAtual.getCondicaoExploracao().setConteudo(objRegTXT.fieldByName("CD_EXPLOR").asString());
            imovelAtual.getArea().setConteudo(objRegTXT.fieldByName("QT_AREA").asValor());
            imovelAtual.getLocalizacao().setConteudo(objRegTXT.fieldByName("NM_LOCAL").asString());
            imovelAtual.getNome().setConteudo(objRegTXT.fieldByName("NM_IMOVEL").asString());
            imovelAtual.getParticipacao().setConteudo(objRegTXT.fieldByName("PC_PARTIC").asValor());
            if (imovelAtual instanceof ImovelARBrasil) {
                objDecl.getAtividadeRural().getBrasil().getIdentificacaoImovel().itens().add(imovelAtual);
                imovelAtual.getCIB().setConteudo(objRegTXT.fieldByName("NR_INCRA").asString());
                continue;
            }
            objDecl.getAtividadeRural().getExterior().getIdentificacaoImovel().itens().add(imovelAtual);
        }
    }

    public void montarAtividadeRuralApuracaoResultadoAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBrasil().getApuracaoResultado().clear();
        objDecl.getAtividadeRural().getExterior().getApuracaoResultado().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            String inExt = objRegTXT.fieldByName("IN_EXTERIOR").asString();
            if (inExt.equals("0")) {
                objDecl.getAtividadeRural().getBrasil().getApuracaoResultado().getPrejuizoExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_PREJUIZO").asValor());
                continue;
            }
            objDecl.getAtividadeRural().getExterior().getApuracaoResultado().getPrejuizoExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_PREJUIZO").asValor());
        }
    }

    public void montarAtividadeRuralBens(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, boolean recuperouPP) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBens().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            BemAR bemAtual = objDecl.getAtividadeRural().getBens().instanciaNovoObjeto();
            bemAtual.getCodigo().setConteudo(objRegTXT.fieldByName("CD_BEMAR").asString());
            bemAtual.getDiscriminacao().setConteudo(objRegTXT.fieldByName("TX_BEM").asString());
            bemAtual.getValorExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_BEM_ANTERIOR").asValor());
            bemAtual.getValorExercicioAtual().setConteudo(objRegTXT.fieldByName("VR_BEM").asValor());
            bemAtual.getPais().setConteudo(objRegTXT.fieldByName("CD_PAIS").asString());
            objDecl.getAtividadeRural().getBens().itens().add(bemAtual);
        }
    }

    public void montarAtividadeRuralBensAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBens().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            BemAR bemAtual = objDecl.getAtividadeRural().getBens().instanciaNovoObjeto();
            bemAtual.getCodigo().setConteudo(objRegTXT.fieldByName("CD_BEMAR").asString());
            bemAtual.getDiscriminacao().setConteudo(objRegTXT.fieldByName("TX_BEM").asString());
            bemAtual.getPais().setConteudo(objRegTXT.fieldByName("CD_PAIS").asString());
            bemAtual.getValorExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_BEM").asValor());
            if (!bemAtual.getValorExercicioAnterior().comparacao(">", "0,00")) continue;
            objDecl.getAtividadeRural().getBens().itens().add(bemAtual);
        }
    }

    public void montarAtividadeRuralDividas(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBrasil().getDividas().itens().clear();
        objDecl.getAtividadeRural().getExterior().getDividas().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            DividaAR dividaAtual = new DividaAR();
            RegistroTxt objRegTXT = vRegistro.get(i);
            dividaAtual.getDiscriminacao().setConteudo(objRegTXT.fieldByName("TX_DIVIDA").asString());
            dividaAtual.getContraidasAteExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_DIVATE").asValor());
            dividaAtual.getContraidasAteExercicioAtual().setConteudo(objRegTXT.fieldByName("VR_DIVATU").asValor());
            dividaAtual.getValorPagamentoAnual().setConteudo(objRegTXT.fieldByName("VR_PAGAMENTOANUAL").asValor());
            String inExt = objRegTXT.fieldByName("IN_EXTERIOR").asString();
            if (inExt.equals("0")) {
                objDecl.getAtividadeRural().getBrasil().getDividas().itens().add(dividaAtual);
                continue;
            }
            objDecl.getAtividadeRural().getExterior().getDividas().itens().add(dividaAtual);
        }
    }

    public void montarAtividadeRuralDividasAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBrasil().getDividas().itens().clear();
        objDecl.getAtividadeRural().getExterior().getDividas().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            DividaAR dividaAtual = new DividaAR();
            RegistroTxt objRegTXT = vRegistro.get(i);
            Valor contraidasAteAnoCalendario = new Valor();
            contraidasAteAnoCalendario = objRegTXT.fieldByName("VR_DIVATU").asValor();
            if (contraidasAteAnoCalendario.isVazio()) continue;
            dividaAtual.getDiscriminacao().setConteudo(objRegTXT.fieldByName("TX_DIVIDA").asString());
            dividaAtual.getContraidasAteExercicioAnterior().setConteudo(contraidasAteAnoCalendario);
            String inExt = objRegTXT.fieldByName("IN_EXTERIOR").asString();
            if (inExt.equals("0")) {
                objDecl.getAtividadeRural().getBrasil().getDividas().itens().add(dividaAtual);
                continue;
            }
            objDecl.getAtividadeRural().getExterior().getDividas().itens().add(dividaAtual);
        }
    }

    public void montarAtividadeRuralMovimentacaoRebanho(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBrasil().getMovimentacaoRebanho().clear();
        objDecl.getAtividadeRural().getExterior().getMovimentacaoRebanho().clear();
        block7: for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            String inExt = objRegTXT.fieldByName("IN_EXTERIOR").asString();
            MovimentacaoRebanho movRebAtual = inExt.equals("0") ? objDecl.getAtividadeRural().getBrasil().getMovimentacaoRebanho() : objDecl.getAtividadeRural().getExterior().getMovimentacaoRebanho();
            int tipoDadoMov = objRegTXT.fieldByName("CD_ESPEC").asInteger();
            switch (tipoDadoMov) {
                case 1: {
                    this.setarValoresTipoDadoMovimentacaoRebanho(movRebAtual.getBovinos(), vRegistro, objDecl, objRegTXT);
                    continue block7;
                }
                case 2: {
                    this.setarValoresTipoDadoMovimentacaoRebanho(movRebAtual.getSuinos(), vRegistro, objDecl, objRegTXT);
                    continue block7;
                }
                case 3: {
                    this.setarValoresTipoDadoMovimentacaoRebanho(movRebAtual.getCaprinos(), vRegistro, objDecl, objRegTXT);
                    continue block7;
                }
                case 4: {
                    this.setarValoresTipoDadoMovimentacaoRebanho(movRebAtual.getAsininos(), vRegistro, objDecl, objRegTXT);
                    continue block7;
                }
                case 5: {
                    this.setarValoresTipoDadoMovimentacaoRebanho(movRebAtual.getOutros(), vRegistro, objDecl, objRegTXT);
                }
            }
        }
    }

    public void montarAtividadeRuralProprietario(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            ImovelAR imovelAR;
            RegistroTxt objRegTXT = vRegistro.get(i);
            ParticipanteImovelAR participanteImovelAR = new ParticipanteImovelAR();
            participanteImovelAR.getNi().setConteudo(objRegTXT.fieldByName("NR_CPF_CNPJ_PROPRIETARIO").asString());
            participanteImovelAR.getNome().setConteudo(objRegTXT.fieldByName("NM_NOME_PROPRIETARIO").asString());
            participanteImovelAR.getEstrangeiro().setConteudo(objRegTXT.fieldByName("IN_EXTERIOR").asString());
            participanteImovelAR.getIndice().setConteudo(objRegTXT.fieldByName("NR_CHAVE_AR").asString());
            ImovelARBrasil imovelARBrasil = objDecl.getAtividadeRural().getBrasil().getIdentificacaoImovel().localizaImovelPorIndice(participanteImovelAR.getIndice().naoFormatado());
            if (imovelARBrasil != null) {
                imovelARBrasil.getParticipantesImovelAR().add((ObjetoNegocio)participanteImovelAR);
            }
            if ((imovelAR = objDecl.getAtividadeRural().getExterior().getIdentificacaoImovel().localizaImovelPorIndice(participanteImovelAR.getIndice().naoFormatado())) == null) continue;
            imovelAR.getParticipantesImovelAR().add((ObjetoNegocio)participanteImovelAR);
        }
    }

    private void setarValoresTipoDadoMovimentacaoRebanho(ItemMovimentacaoRebanho pTipo, List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, RegistroTxt objRegTXT) throws GeracaoTxtException {
        pTipo.getEstoqueInicial().setConteudo(objRegTXT.fieldByName("QT_INIC").asValor());
        pTipo.getAquisicoesAno().setConteudo(objRegTXT.fieldByName("QT_COMPRA").asValor());
        pTipo.getNascidosAno().setConteudo(objRegTXT.fieldByName("QT_NASCIM").asValor());
        pTipo.getEstoqueFinal().setConteudo(objRegTXT.fieldByName("QT_ESTFINAL").asValor());
        pTipo.getConsumo().setConteudo(objRegTXT.fieldByName("QT_PERDA").asValor());
        pTipo.getVendas().setConteudo(objRegTXT.fieldByName("QT_VENDA").asValor());
    }

    public void montarAtividadeRuralMovimentacaoRebanhoAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBrasil().getMovimentacaoRebanho().clear();
        objDecl.getAtividadeRural().getExterior().getMovimentacaoRebanho().clear();
        block7: for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            String inExt = objRegTXT.fieldByName("IN_EXTERIOR").asString();
            MovimentacaoRebanho movRebAtual = inExt.equals("0") ? objDecl.getAtividadeRural().getBrasil().getMovimentacaoRebanho() : objDecl.getAtividadeRural().getExterior().getMovimentacaoRebanho();
            int tipoDadoMov = objRegTXT.fieldByName("CD_ESPEC").asInteger();
            switch (tipoDadoMov) {
                case 1: {
                    this.setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(movRebAtual.getBovinos(), vRegistro, objDecl, objRegTXT);
                    continue block7;
                }
                case 2: {
                    this.setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(movRebAtual.getSuinos(), vRegistro, objDecl, objRegTXT);
                    continue block7;
                }
                case 3: {
                    this.setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(movRebAtual.getCaprinos(), vRegistro, objDecl, objRegTXT);
                    continue block7;
                }
                case 4: {
                    this.setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(movRebAtual.getAsininos(), vRegistro, objDecl, objRegTXT);
                    continue block7;
                }
                case 5: {
                    this.setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(movRebAtual.getOutros(), vRegistro, objDecl, objRegTXT);
                }
            }
        }
    }

    private void setarValoresTipoDadoMovimentacaoRebanhoAnoAnterior(ItemMovimentacaoRebanho pTipo, List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl, RegistroTxt objRegTXT) throws GeracaoTxtException {
        pTipo.getEstoqueInicial().setConteudo(objRegTXT.fieldByName("QT_ESTFINAL").asValor());
    }

    public void montarAtividadeRuralApuracaoResultado(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBrasil().getApuracaoResultado().clear();
        objDecl.getAtividadeRural().getExterior().getApuracaoResultado().clear();
        ApuracaoResultadoBrasil apurBR = objDecl.getAtividadeRural().getBrasil().getApuracaoResultado();
        ApuracaoResultadoExterior apurEXT = objDecl.getAtividadeRural().getExterior().getApuracaoResultado();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            String inExt = objRegTXT.fieldByName("IN_EXTERIOR").asString();
            if (inExt.equals("0")) {
                apurBR.getValorAdiantamento().setConteudo(objRegTXT.fieldByName("VR_ADIANT").asValor());
                apurBR.getDespesaCusteio().setConteudo(objRegTXT.fieldByName("VR_DESPTOTAL").asValor());
                apurBR.getLimiteVintePorCentoReceitaBruta().setConteudo(objRegTXT.fieldByName("VR_OPCAO").asValor());
                apurBR.getPrejuizoExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_PREJEXERCANT").asValor());
                apurBR.getPrejuizoCompensar().setConteudo(objRegTXT.fieldByName("VR_PREJUIZO").asValor());
                apurBR.getReceitaBrutaTotal().setConteudo(objRegTXT.fieldByName("VR_RECTOTAL").asValor());
                apurBR.getReceitaRecebidaContaVenda().setConteudo(objRegTXT.fieldByName("VR_RECVENDAFUTURA").asValor());
                apurBR.getResultadoI().setConteudo(objRegTXT.fieldByName("VR_RES1REAL").asValor());
                apurBR.getCompensacaoPrejuizoExerciciosAnteriores().setConteudo(objRegTXT.fieldByName("VR_COMP_PREJ_EXERC_ANT").asValor());
                apurBR.getResultadoNaoTributavel().setConteudo(objRegTXT.fieldByName("VR_RESNAOTRIBAR").asValor());
                apurBR.getResultadoTributavel().setConteudo(objRegTXT.fieldByName("VR_RESTRIB").asValor());
                apurBR.getOpcaoFormaApuracao().setConteudo(objRegTXT.fieldByName("IN_OPC_APURRESTRIB").asString());
                continue;
            }
            apurEXT.getValorAdiantamento().setConteudo(objRegTXT.fieldByName("VR_ADIANT").asValor());
            apurEXT.getLimiteVintePorCentoReceitaBruta().setConteudo(objRegTXT.fieldByName("VR_OPCAO").asValor());
            apurEXT.getPrejuizoExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_PREJEXERCANT").asValor());
            apurEXT.getPrejuizoCompensar().setConteudo(objRegTXT.fieldByName("VR_PREJUIZO").asValor());
            apurEXT.getReceitaRecebidaContaVenda().setConteudo(objRegTXT.fieldByName("VR_RECVENDAFUTURA").asValor());
            apurEXT.getResultadoI_EmReais().setConteudo(objRegTXT.fieldByName("VR_RES1REAL").asValor());
            apurEXT.getResultadoI_EmDolar().setConteudo(objRegTXT.fieldByName("VR_RES1DOLAR").asValor());
            apurEXT.getResultadoTributavel().setConteudo(objRegTXT.fieldByName("VR_RES1DOLAR").asValor());
            apurEXT.getCompensacaoPrejuizoExerciciosAnteriores().setConteudo(objRegTXT.fieldByName("VR_COMP_PREJ_EXERC_ANT").asValor());
            apurEXT.getResultadoNaoTributavel().setConteudo(objRegTXT.fieldByName("VR_RESNAOTRIBAR").asValor());
            apurEXT.getResultadoTributavel().setConteudo(objRegTXT.fieldByName("VR_RESTRIB").asValor());
            apurEXT.getOpcaoFormaApuracao().setConteudo(objRegTXT.fieldByName("IN_OPC_APURRESTRIB").asString());
        }
    }

    public void montarAtividadeRuralReceitasDespesasBrasil(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getBrasil().getReceitasDespesas().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            int mes = objRegTXT.fieldByName("NR_MES").asInteger();
            MesReceitaDespesa receitaAtual = objDecl.getAtividadeRural().getBrasil().getReceitasDespesas().getMesReceitaPorIndice(--mes);
            receitaAtual.getDespesaCusteioInvestimento().setConteudo(objRegTXT.fieldByName("VR_DESP").asValor());
            receitaAtual.getReceitaBrutaMensal().setConteudo(objRegTXT.fieldByName("VR_REC").asValor());
        }
    }

    public void montarAtividadeRuralReceitasDespesasExterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAtividadeRural().getExterior().getReceitasDespesas().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            ReceitaDespesa receitaAtual = new ReceitaDespesa();
            receitaAtual.getPais().setConteudo(objRegTXT.fieldByName("CD_PAIS").asString());
            receitaAtual.getDespesaCusteio().setConteudo(objRegTXT.fieldByName("DESPCUSTEIO").asValor());
            receitaAtual.getReceitaBruta().setConteudo(objRegTXT.fieldByName("RECBRUTA").asValor());
            receitaAtual.getResultadoI_EmDolar().setConteudo(objRegTXT.fieldByName("RESDOLAR").asValor());
            receitaAtual.getResultadoIMoedaOriginal().setConteudo(objRegTXT.fieldByName("RESORIGINAL").asValor());
            objDecl.getAtividadeRural().getExterior().getReceitasDespesas().itens().add(receitaAtual);
        }
    }

    public void montarContribuinteIRPFAnoAnterior(List<RegistroTxt> vRegistro, Contribuinte objContrib, IdentificadorDeclaracao idDecl) throws GeracaoTxtException {
        RegistroTxt objRegTXT = vRegistro.get(0);
        String tituloEleitor = objRegTXT.fieldByName("NR_TITELEITOR").asString();
        if (tituloEleitor.matches("\\d+")) {
            objContrib.getTituloEleitor().setConteudo(tituloEleitor);
        }
        objContrib.getDataNascimento().setConteudo(objRegTXT.fieldByName("DT_NASCIM").asString());
        objContrib.getCpfConjuge().setConteudo(objRegTXT.fieldByName("NR_CPF_CONJUGE").asString());
        if (!objContrib.getCpfConjuge().isVazio()) {
            objContrib.getConjuge().setConteudo(Logico.SIM);
        }
        if (idDecl.isEspolio()) {
            objContrib.getNaturezaOcupacao().setConteudo("81");
        } else {
            objContrib.getNaturezaOcupacao().setConteudo(objRegTXT.fieldByName("CD_NATUR").asString());
        }
        objContrib.getOcupacaoPrincipal().setConteudo(objRegTXT.fieldByName("CD_OCUP").asString());
        objContrib.getTipoLogradouro().setConteudo(objRegTXT.fieldByName("TIP_LOGRA").asString());
        objContrib.getRegistroProfissional().setConteudo(objRegTXT.fieldByName("NR_REGISTRO_PROFISSIONAL").asString());
        if (objRegTXT.fieldByName("SG_UF").asString().trim().equals("EX")) {
            objContrib.getExterior().setConteudo(Logico.SIM);
            objContrib.getPais().setConteudo(objRegTXT.fieldByName("CD_PAIS").asString());
            objContrib.getCodigoExterior().setConteudo(objRegTXT.fieldByName("CD_EX").asString());
            objContrib.getCidade().setConteudo(objRegTXT.fieldByName("NM_MUNICIP").asString());
            objContrib.getLogradouroExt().setConteudo(objRegTXT.fieldByName("NM_LOGRA").asString());
            objContrib.getNumeroExt().setConteudo(objRegTXT.fieldByName("NR_NUMERO").asString());
            objContrib.getBairroExt().setConteudo(objRegTXT.fieldByName("NM_BAIRRO").asString());
            objContrib.getComplementoExt().setConteudo(objRegTXT.fieldByName("NM_COMPLEM").asString());
            objContrib.getCepExt().setConteudo(objRegTXT.fieldByName("NR_CEP").asString());
            objContrib.getDdi().setConteudo(objRegTXT.fieldByName("NR_DDD_TELEFONE").asString().replaceAll("[^\\d\\s]", ""));
            objContrib.getTelefoneExt().setConteudo(objRegTXT.fieldByName("NR_TELEFONE").asString());
            objContrib.getEmail().setConteudo(objRegTXT.fieldByName("NM_EMAIL").asString());
        } else {
            objContrib.getExterior().setConteudo(Logico.NAO);
            objContrib.getUf().setConteudo(objRegTXT.fieldByName("SG_UF").asString());
            objContrib.getMunicipio().setConteudo(objRegTXT.fieldByName("CD_MUNICIP").asString());
            objContrib.getPais().setConteudo("105");
            objContrib.getLogradouro().setConteudo(objRegTXT.fieldByName("NM_LOGRA").asString());
            objContrib.getNumero().setConteudo(objRegTXT.fieldByName("NR_NUMERO").asString());
            objContrib.getBairro().setConteudo(objRegTXT.fieldByName("NM_BAIRRO").asString());
            objContrib.getComplemento().setConteudo(objRegTXT.fieldByName("NM_COMPLEM").asString());
            objContrib.getCep().setConteudo(objRegTXT.fieldByName("NR_CEP").asString());
            objContrib.getDdd().setConteudo(objRegTXT.fieldByName("NR_DDD_TELEFONE").asString().replaceAll("[^\\d\\s]", ""));
            objContrib.getTelefone().setConteudo(objRegTXT.fieldByName("NR_TELEFONE").asString());
            objContrib.getDddCelular().setConteudo(objRegTXT.fieldByName("NR_DDD_CELULAR").asString());
            objContrib.getCelular().setConteudo(objRegTXT.fieldByName("NR_CELULAR").asString());
            objContrib.getEmail().setConteudo(objRegTXT.fieldByName("NM_EMAIL").asString());
        }
    }

    public void montarDependentesAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getDependentes().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            Dependente objDependente = new Dependente(objDecl);
            RegistroTxt objRegTXT = vRegistro.get(i);
            objDependente.setChave(objRegTXT.fieldByName("NR_CHAVE").asString());
            objDependente.getNome().setConteudo(objRegTXT.fieldByName("NM_DEPEND").asString());
            objDependente.getDataNascimento().setConteudo(objRegTXT.fieldByName("DT_NASCIM").asString());
            objDependente.getCpfDependente().setConteudo(objRegTXT.fieldByName("NI_DEPEND").asString());
            objDependente.getEmail().setConteudo(objRegTXT.fieldByName("NM_EMAIL").asString());
            objDependente.getDdd().setConteudo(objRegTXT.fieldByName("NR_DDD_CELULAR").asString());
            objDependente.getTelefone().setConteudo(objRegTXT.fieldByName("NR_CELULAR").asString());
            objDependente.getIndMoraComTitular().setConteudo(objRegTXT.fieldByName("IN_ENDERECO_TITULAR").asString());
            objDecl.getDependentes().itens().add(objDependente);
        }
    }

    public void montarAlimentandosAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getAlimentandos().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            Alimentando objAlimentando = new Alimentando(objDecl);
            RegistroTxt objRegTXT = vRegistro.get(i);
            objAlimentando.setChave(objRegTXT.fieldByName("NR_CHAVE").asString());
            objAlimentando.getNome().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            objAlimentando.getDtNascimento().setConteudo(objRegTXT.fieldByName("DT_NASCIM").asString());
            objAlimentando.getCpf().setConteudo(objRegTXT.fieldByName("NI_ALIMENTANDO").asString());
            objAlimentando.getResidente().setConteudo(objRegTXT.fieldByName("INDICADOR_RESIDENC").asString());
            objAlimentando.getCpfResponsavel().setConteudo(objRegTXT.fieldByName("NR_CPF_VINCULADO").asString());
            objDecl.getAlimentandos().itens().add(objAlimentando);
        }
    }

    public void montarRendPJTitularAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendPJ().getColecaoRendPJTitular().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RendPJTitular objRendPJTitular = new RendPJTitular(objDecl.getIdentificadorDeclaracao());
            RegistroTxt objRegTXT = vRegistro.get(i);
            objRendPJTitular.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADOR").asString());
            objRendPJTitular.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_PAGADOR").asString());
            objDecl.getRendPJ().getColecaoRendPJTitular().itens().add(objRendPJTitular);
        }
    }

    public void montarRendPJDependentesAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendPJ().getColecaoRendPJDependente().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RendPJDependente objRendPJDependente = new RendPJDependente(objDecl);
            RegistroTxt objRegTXT = vRegistro.get(i);
            objRendPJDependente.getCpfDependente().setConteudo(objRegTXT.fieldByName("CPF_BENEF").asString());
            objRendPJDependente.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADOR").asString());
            objRendPJDependente.getNomeFontePagadora().setConteudo(objRegTXT.fieldByName("NM_PAGADOR").asString());
            objDecl.getRendPJ().getColecaoRendPJDependente().itens().add(objRendPJDependente);
        }
    }

    public void montarBensAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getBens().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            Bem objBem = objDecl.getBens().instanciaNovoObjeto();
            String grupo = objRegTXT.fieldByName("CD_GRUPO_BEM").asString();
            String codigo = objRegTXT.fieldByName("CD_BEM").asString();
            String pais = objRegTXT.fieldByName("CD_PAIS").asString();
            objBem.reclassificar(grupo, codigo, pais);
            if (!objRegTXT.fieldByName("VR_ATUAL").asValor().comparacao(">", "0,00") && !objBem.isBemComDadosBancarios()) continue;
            objBem.getDiscriminacao().setConteudo(objRegTXT.fieldByName("TX_BEM").asString());
            objBem.getValorExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_ATUAL").asValor());
            objBem.getAreaTotal().setConteudo(objRegTXT.fieldByName("AREA").asValor());
            objBem.getComplemento().setConteudo(objRegTXT.fieldByName("NM_COMPLEM").asString());
            objBem.getUf().setConteudo(objRegTXT.fieldByName("SG_UF").asString());
            objBem.getMunicipio().setConteudo(objRegTXT.fieldByName("CD_MUNICIP").asString());
            objBem.getNomeMunicipio().setConteudo(objRegTXT.fieldByName("NM_MUNICIP").asString());
            objBem.getNumero().setConteudo(objRegTXT.fieldByName("NR_NUMERO").asString());
            objBem.getLogradouro().setConteudo(objRegTXT.fieldByName("NM_LOGRA").asString());
            objBem.getCep().setConteudo(objRegTXT.fieldByName("NR_CEP").asString());
            objBem.getBairro().setConteudo(objRegTXT.fieldByName("NM_BAIRRO").asString());
            objBem.getDataAquisicao().setConteudo(objRegTXT.fieldByName("DT_AQUISICAO").asString());
            if ("00000000".equals(objBem.getDataAquisicao().naoFormatado())) {
                objBem.getDataAquisicao().clear();
            }
            if (objBem.isBemImovel()) {
                if (objBem.possuiValorIPTU()) {
                    objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_IPTU").asString());
                } else if (objBem.possuiValorCIB()) {
                    objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_CIB").asString());
                    if ("00000000".equals(objBem.getRegistroBem().naoFormatado())) {
                        objBem.getRegistroBem().clear();
                    }
                }
            } else if ("02".equals(objBem.getGrupo().naoFormatado())) {
                if (objBem.getCodigo().naoFormatado().equals("01")) {
                    objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_RENAVAN").asString());
                } else if (objBem.getCodigo().naoFormatado().equals("02")) {
                    objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_DEP_AVIACAO_CIVIL").asString());
                } else if (objBem.getCodigo().naoFormatado().equals("03")) {
                    objBem.getRegistroBem().setConteudo(objRegTXT.fieldByName("NR_CAPITANIA_PORTOS").asString());
                }
            }
            objBem.getNomeCartorio().setConteudo(objRegTXT.fieldByName("NM_CARTORIO").asString());
            objBem.getMatricula().setConteudo(objRegTXT.fieldByName("MATRIC_IMOV").asString());
            objBem.getUnidade().setConteudo(objRegTXT.fieldByName("NM_UNID").asString());
            objBem.getRegistrado().setConteudo(objRegTXT.fieldByName("NM_IND_REG_IMOV").asString());
            objBem.getTipo().setConteudo(objRegTXT.fieldByName("IN_TIPO_BENEFIC").asString());
            objBem.getCPFBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            objBem.getBanco().setConteudo(objRegTXT.fieldByName("NR_BANCO").asString());
            String agencia = objRegTXT.fieldByName("NR_AGENCIA").asString();
            if (Integer.valueOf(agencia) != 0) {
                objBem.getAgencia().setConteudo(agencia);
            }
            String conta = objRegTXT.fieldByName("NR_CONTA").asString();
            objBem.getConta().setConteudo(conta);
            objBem.getDVConta().setConteudo(objRegTXT.fieldByName("NR_DV_CONTA").asString());
            objBem.getDVConta().setConteudo(objRegTXT.fieldByName("NR_DV_CONTA").asString());
            objBem.getNiEmpresa().setConteudo(objRegTXT.fieldByName("NM_CPFCNPJ").asString());
            objBem.getValorExercicioAtual().clear();
            int inExterior = objRegTXT.fieldByName("IN_EXTERIOR").asInteger();
            if (inExterior == 1) {
                objBem.getPais().setConteudo(objRegTXT.fieldByName("CD_PAIS").asString());
                objBem.getCidade().setConteudo(objBem.getNomeMunicipio().formatado());
            } else if (grupo.equals("07") && codigo.equals("99")) {
                objBem.getPais().setConteudo("");
            } else {
                objBem.getPais().setConteudo("105");
            }
            objBem.getNegociadoBolsa().setConteudo(objRegTXT.fieldByName("IN_BOLSA").asString());
            objBem.getCodigoNegociacao().setConteudo(objRegTXT.fieldByName("NR_COD_NEGOCIACAO_BOLSA").asString());
            objDecl.getBens().itens().add(objBem);
        }
        objDecl.getBens().reordenarBens();
    }

    public void montarDividasAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getDividas().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!objRegTXT.fieldByName("VR_ATUAL").asValor().comparacao(">", "0,00")) continue;
            Divida objDivida = objDecl.getDividas().instanciaNovoObjeto();
            objDivida.getDiscriminacao().setConteudo(objRegTXT.fieldByName("TX_DIV").asString());
            objDivida.getCodigo().setConteudo(objRegTXT.fieldByName("CD_DIV").asString());
            objDivida.getValorExercicioAnterior().setConteudo(objRegTXT.fieldByName("VR_ATUAL").asValor());
            objDivida.getValorExercicioAtual().clear();
            objDecl.getDividas().itens().add(objDivida);
        }
    }

    public void montarConjugeAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            RegistroTxt objRegTXT = vRegistro.get(0);
            objDecl.getContribuinte().getCpfConjuge().setConteudo(objRegTXT.fieldByName("NR_CONJ").asString());
            if (objDecl.getContribuinte().getCpfConjuge().naoFormatado().length() > 0) {
                objDecl.getContribuinte().getConjuge().setConteudo(Logico.SIM);
            }
        }
    }

    public void montarLucrosDividendosAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendIsentos().getLucroRecebidoQuadroAuxiliar().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            ItemQuadroTransporteDetalhado objLucroDividendo = objDecl.getRendIsentos().getLucroRecebidoQuadroAuxiliar().instanciaNovoObjeto();
            String tipo = objRegTXT.fieldByName("NR_TIPO").asString();
            objLucroDividendo.getTipoBeneficiario().setConteudo(tipo.equals("T") ? "Titular" : (tipo.equals("D") ? "Dependente" : ""));
            objLucroDividendo.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            objLucroDividendo.getCnpjEmpresa().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            objLucroDividendo.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            objDecl.getRendIsentos().getLucroRecebidoQuadroAuxiliar().itens().add(objLucroDividendo);
        }
    }

    public void montarParcelaIsentaAposentadoriaAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            ItemQuadroTransporteDetalhado objParcIsentaAposentadoria = objDecl.getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().instanciaNovoObjeto();
            String tipo = objRegTXT.fieldByName("IN_TIPO").asString();
            objParcIsentaAposentadoria.getTipoBeneficiario().setConteudo(tipo.equals("T") ? "Titular" : (tipo.equals("D") ? "Dependente" : ""));
            objParcIsentaAposentadoria.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            objParcIsentaAposentadoria.getCnpjEmpresa().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            objParcIsentaAposentadoria.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            objDecl.getRendIsentos().getParcIsentaAposentadoriaQuadroAuxiliar().itens().add(objParcIsentaAposentadoria);
        }
    }

    public void montarPensaoAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendIsentos().getPensaoQuadroAuxiliar().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            ItemQuadroPensaoMolestiaGrave objPensao = objDecl.getRendIsentos().getPensaoQuadroAuxiliar().instanciaNovoObjeto();
            String tipo = objRegTXT.fieldByName("IN_TIPO").asString();
            objPensao.getTipoBeneficiario().setConteudo(tipo.equals("T") ? "Titular" : (tipo.equals("D") ? "Dependente" : ""));
            objPensao.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            objPensao.getNiEmpresa().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            objPensao.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            objDecl.getRendIsentos().getPensaoQuadroAuxiliar().itens().add(objPensao);
        }
    }

    public void montarPoupancaAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendIsentos().getPoupancaQuadroAuxiliar().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            ItemQuadroTransporteDetalhado objPoupanca = objDecl.getRendIsentos().getPoupancaQuadroAuxiliar().instanciaNovoObjeto();
            String tipo = objRegTXT.fieldByName("IN_TIPO").asString();
            objPoupanca.getTipoBeneficiario().setConteudo(tipo.equals("T") ? "Titular" : (tipo.equals("D") ? "Dependente" : ""));
            objPoupanca.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            objPoupanca.getCnpjEmpresa().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            objPoupanca.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            objDecl.getRendIsentos().getPoupancaQuadroAuxiliar().itens().add(objPoupanca);
        }
    }

    public void montarSocioAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        objDecl.getRendIsentos().getRendSocioQuadroAuxiliar().itens().clear();
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            ItemQuadroTransporteDetalhado objSocio = objDecl.getRendIsentos().getRendSocioQuadroAuxiliar().instanciaNovoObjeto();
            String tipo = objRegTXT.fieldByName("IN_TIPO").asString();
            objSocio.getTipoBeneficiario().setConteudo(tipo.equals("T") ? "Titular" : (tipo.equals("D") ? "Dependente" : ""));
            objSocio.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            objSocio.getCnpjEmpresa().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            objSocio.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            objDecl.getRendIsentos().getRendSocioQuadroAuxiliar().itens().add(objSocio);
        }
    }

    public void montarRendimentosAplicacoesFinanceirasAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!"0006".equals(objRegTXT.fieldByName("NR_COD").asString())) continue;
            ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl, (ObjetoNegocio)objDecl.getRendTributacaoExclusiva());
            item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
            item.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            item.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            objDecl.getRendTributacaoExclusiva().getRendAplicacoesQuadroAuxiliar().itens().add(item);
        }
    }

    public void montarJurosCapitalProprioAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl, (ObjetoNegocio)objDecl.getRendTributacaoExclusiva());
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!"0010".equals(objRegTXT.fieldByName("NR_COD").asString())) continue;
            item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
            item.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            item.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            objDecl.getRendTributacaoExclusiva().getJurosCapitalProprioQuadroAuxiliar().itens().add(item);
        }
    }

    public void montarParticipacaoLucrosResultadosAnoAnterior(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            ItemQuadroTransporteDetalhado item = new ItemQuadroTransporteDetalhado(objDecl, (ObjetoNegocio)objDecl.getRendTributacaoExclusiva());
            RegistroTxt objRegTXT = vRegistro.get(i);
            if (!"0011".equals(objRegTXT.fieldByName("NR_COD").asString())) continue;
            item.getTipoBeneficiario().setConteudo(objRegTXT.fieldByName("IN_TIPO").asString().equals("T") ? "Titular" : "Dependente");
            item.getCpfBeneficiario().setConteudo(objRegTXT.fieldByName("NR_CPF_BENEFIC").asString());
            item.getNIFontePagadora().setConteudo(objRegTXT.fieldByName("NR_PAGADORA").asString());
            item.getNomeFonte().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
            objDecl.getRendTributacaoExclusiva().getParticipacaoLucrosResultadosQuadroAuxiliar().itens().add(item);
        }
    }

    public RegistroTxt getRegistroRecibo(List<RegistroTxt> vRegistro) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            RegistroTxt objRegTXT = vRegistro.get(0);
            return objRegTXT;
        }
        throw new GeracaoTxtException("Detalhe do recibo n\u00e3o encontrado.");
    }

    public RegistroTxt getRegistroHeader(List<RegistroTxt> vRegistro) throws GeracaoTxtException {
        if (vRegistro.size() > 0) {
            RegistroTxt objRegTXT = vRegistro.get(0);
            return objRegTXT;
        }
        throw new GeracaoTxtException("Registro Header do arquivo n\u00e3o encontrado.");
    }

    public ValorBigDecimalGCME obterValorBigDecimalGCME(CampoTXT campo) throws GeracaoTxtException {
        return new ValorBigDecimalGCME(new StringBuffer(campo.asString()).insert(campo.getTamanho() - campo.getDecimais(), ",").toString());
    }

    public void importaRegistro60(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            IdDemonstrativoGCAP id = new IdDemonstrativoGCAP();
            id.getCpf().setConteudo(reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim());
            id.getDataInicioPermanencia().setConteudo(reg.fieldByName("DT_INICIO").asString().trim());
            id.getDataFimPermanencia().setConteudo(reg.fieldByName("DT_FIM").asString().trim());
            id.getPaisDeclarante().setConteudo(reg.fieldByName("CD_PAIS").asString().trim());
            objDecl.getGCAP().getIds().itens().add(id);
            Consolidacao consolidacao = new Consolidacao();
            consolidacao.getCpf().setConteudo(id.getCpf());
            consolidacao.getDataInicioPermanencia().setConteudo(id.getDataInicioPermanencia());
            consolidacao.getDataFimPermanencia().setConteudo(id.getDataFimPermanencia());
            consolidacao.getTotalRendSujeitosTributacao().setConteudo(reg.fieldByName("GC_TRANSP_VR_EXCLUSIVO").asValor());
            consolidacao.getTotalImpostoPago().setConteudo(reg.fieldByName("GC_TRANSP_VR_IMPOSTOPAGO").asValor());
            consolidacao.getImpostoDevidoAnoAtual().setConteudo(reg.fieldByName("GC_TRANSP_VR_IMPOSTODEVIDO").asValor());
            consolidacao.getImpostoDiferidoAnosPosteriores().setConteudo(reg.fieldByName("GC_TRANSP_VR_IMPOSTODIFERIDOANOSPOSTERIORES").asValor());
            objDecl.getGCAP().getConsolidacoesBrasil().itens().add(consolidacao);
            consolidacao = new Consolidacao();
            consolidacao.getCpf().setConteudo(id.getCpf());
            consolidacao.getDataInicioPermanencia().setConteudo(id.getDataInicioPermanencia());
            consolidacao.getDataFimPermanencia().setConteudo(id.getDataFimPermanencia());
            consolidacao.getTotalRendSujeitosTributacao().setConteudo(reg.fieldByName("GC_TRANSP_VR_EXCLUSIVO_EXTERIOR").asValor());
            consolidacao.getTotalImpostoPago().setConteudo(reg.fieldByName("GC_TRANSP_VR_IMPOSTOPAGO_EXTERIOR").asValor());
            consolidacao.getTotalRendIsentosNaoTributaveis().setConteudo(reg.fieldByName("GC_TRANSP_VR_ISENTO_EXTERIOR").asValor());
            objDecl.getGCAP().getConsolidacoesExterior().itens().add(consolidacao);
            ConsolidacaoEspecie consolidacaoEspecie = new ConsolidacaoEspecie();
            consolidacaoEspecie.getCpf().setConteudo(id.getCpf());
            consolidacaoEspecie.getDataInicioPermanencia().setConteudo(id.getDataInicioPermanencia());
            consolidacaoEspecie.getDataFimPermanencia().setConteudo(id.getDataFimPermanencia());
            consolidacaoEspecie.getGanhoCapitalTotal().setConteudo(reg.fieldByName("GC_GCAP_MOEDA").asValor());
            consolidacaoEspecie.getImpostoDevido().setConteudo(reg.fieldByName("GC_IMPOSTO_DEVIDO_MOEDA").asValor());
            consolidacaoEspecie.getAliquotaMedia().setConteudo(reg.fieldByName("GC_MOEDA_ALIQUOTA_MEDIA").asValor());
            objDecl.getGCAP().getConsolidacaoGeralEspecie().itens().add(consolidacaoEspecie);
        }
    }

    public void importaRegistro61(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        IdDemonstrativoGCAP idDemonstrativo = null;
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            AlienacaoBemImovel alienacao = new AlienacaoBemImovel();
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4) + ConstantesGlobais.ANO_BASE;
            String dataFim = reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4) + ConstantesGlobais.ANO_BASE;
            if (!(idDemonstrativo != null && idDemonstrativo.getCpf().naoFormatado().equals(cpfDemonstrativo) && idDemonstrativo.getDataInicioPermanencia().naoFormatado().equals(dataInicio) && idDemonstrativo.getDataFimPermanencia().naoFormatado().equals(dataFim))) {
                idDemonstrativo = objDecl.getGCAP().obterIdDemonstrativoGCAP(cpfDemonstrativo, dataInicio, dataFim);
            }
            alienacao.getCpf().setConteudo(cpfDemonstrativo);
            alienacao.getDataInicioPermanencia().setConteudo(dataInicio);
            alienacao.getDataFimPermanencia().setConteudo(dataFim);
            alienacao.getCodigoOperacao().setConteudo(reg.fieldByName("NR_OPERACAO").asString().trim());
            alienacao.getNomePaisDeclarante().setConteudo(idDemonstrativo.getPaisDeclarante().getConteudoAtual(1));
            alienacao.getBemImovel().getBemAdquiridoNoBrasil().setConteudo(reg.fieldByName("IN_BRASIL_EXTERIOR").asString().trim());
            alienacao.getBemImovel().getEspecificacao().setConteudo(reg.fieldByName("NM_IMOVEL_DESCRICAO").asString().trim());
            alienacao.getBemImovel().getAquisicao().getDataAquisicao().setConteudo(reg.fieldByName("DT_AQUISICAO").asString().trim());
            alienacao.getBemImovel().getAquisicao().getHouveReforma().setConteudo(reg.fieldByName("IN_REFORMA").asString().trim());
            if (alienacao.getBemImovel().isAdquiridoNoBrasil()) {
                alienacao.getBemImovel().getEndereco().getTipoLogradouro().setConteudo(reg.fieldByName("END_TIPO_LOGRADOURO").asString().trim());
                alienacao.getBemImovel().getEndereco().getLogradouro().setConteudo(reg.fieldByName("END_LOGRADOURO").asString().trim());
                alienacao.getBemImovel().getEndereco().getNumero().setConteudo(reg.fieldByName("END_NUMERO").asString().trim());
                alienacao.getBemImovel().getEndereco().getComplemento().setConteudo(reg.fieldByName("END_COMPLEMENTO").asString().trim());
                alienacao.getBemImovel().getEndereco().getBairro().setConteudo(reg.fieldByName("END_BAIRRO").asString().trim());
                alienacao.getBemImovel().getEndereco().getCep().setConteudo(reg.fieldByName("END_CEP").asString().trim());
                alienacao.getBemImovel().getEndereco().getUf().setConteudo(reg.fieldByName("END_UF").asString().trim());
                alienacao.getBemImovel().getEndereco().getMunicipio().setConteudo(reg.fieldByName("END_CD_MUNICIPIO").asString().trim());
                alienacao.getValorAlienacao().setConteudo(reg.fieldByName("VR_OPERACAO").asValor());
                alienacao.getCustoCorretagem().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                alienacao.getBemImovel().getAquisicao().getCustoAquisicaoTorna().setConteudo(reg.fieldByName("VR_TORNA").asValor());
                if (alienacao.getBemImovel().getAquisicao().houveReforma()) {
                    alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicao().setConteudo(reg.fieldByName("VR_AQUISICAO").asValor());
                } else {
                    alienacao.getBemImovel().getAquisicao().getCustoAquisicao().setConteudo(reg.fieldByName("VR_AQUISICAO").asValor());
                }
            } else if (alienacao.getBemImovel().isAdquiridoNoExterior()) {
                alienacao.getBemImovel().getEndereco().getLogradouroEx().setConteudo(reg.fieldByName("END_LOGRADOURO").asString().trim());
                alienacao.getBemImovel().getEndereco().getNumeroEx().setConteudo(reg.fieldByName("END_NUMERO").asString().trim());
                alienacao.getBemImovel().getEndereco().getComplementoEx().setConteudo(reg.fieldByName("END_COMPLEMENTO").asString().trim());
                alienacao.getBemImovel().getEndereco().getBairroEx().setConteudo(reg.fieldByName("END_BAIRRO").asString().trim());
                alienacao.getBemImovel().getEndereco().getCodigoPostalEx().setConteudo(reg.fieldByName("END_CEP").asString().trim());
                alienacao.getBemImovel().getEndereco().getCidadeEx().setConteudo(reg.fieldByName("END_MUNICIPIO").asString().trim());
                alienacao.getBemImovel().getEndereco().getPaisEx().setConteudo(reg.fieldByName("END_COD_PAIS").asString().trim());
                alienacao.getValorAlienacaoReal().setConteudo(reg.fieldByName("VR_OPERACAO").asValor());
                alienacao.getValorCorretagemReal().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                alienacao.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNReal().setConteudo(reg.fieldByName("VR_TORNA").asValor());
                if (alienacao.getBemImovel().getAquisicao().houveReforma()) {
                    alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNReal().setConteudo(reg.fieldByName("VR_AQUISICAO").asValor());
                } else {
                    alienacao.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal().setConteudo(reg.fieldByName("VR_AQUISICAO").asValor());
                }
            }
            String bemPequenoValor = reg.fieldByName("IN_PEQUENO_VALOR").asString().trim();
            alienacao.getBemGrandeValor().setConteudo(Logico.SIM.equals(bemPequenoValor) ? Logico.NAO : (Logico.NAO.equals(bemPequenoValor) ? Logico.SIM : ""));
            alienacao.getPerguntas().getPropriedadeOutroImovel().setConteudo(reg.fieldByName("IN_PROPR_OUTRO_IMOVEL").asString().trim());
            alienacao.getPerguntas().getOutraAlienacao().setConteudo(reg.fieldByName("IN_OUTRA_ALIENACAO").asString().trim());
            alienacao.getPerguntas().getImovelResidencial().setConteudo(reg.fieldByName("IN_RESIDENCIAL").asString().trim());
            alienacao.getPerguntas().getMP252().setConteudo(reg.fieldByName("IN_UTILIZAZAOOUTROIMOVEL").asString().trim());
            alienacao.getPerguntas().getMP252Parte2().setConteudo(reg.fieldByName("IN_UTILIZACAOOUTROIMOVEL_PARTE2").asString().trim());
            alienacao.getValorAplicado().setConteudo(reg.fieldByName("VR_UTILIZAZAOOUTROIMOVEL").asValor());
            try {
                alienacao.getNatureza().setConteudo(Integer.parseInt(reg.fieldByName("CD_OPERACAO").asString().trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (alienacao.isTransmissaoCausaMortis()) {
                alienacao.getDataVencimentoTCM().setConteudo(reg.fieldByName("DT_DATA_DARF_TCM").asString().trim());
                alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().setConteudo(reg.fieldByName("IN_DECISAO_JUDICIAL").asString().trim());
                if (Logico.SIM.equals(alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado())) {
                    alienacao.getDataAlienacao().setConteudo(reg.fieldByName("DT_DECISAO_JUDICIAL").asString().trim());
                    alienacao.getDataTransitoJulgado().setConteudo(reg.fieldByName("DT_TRANSITO_JULGADO").asString().trim());
                } else if (Logico.NAO.equals(alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado())) {
                    alienacao.getDataAlienacao().setConteudo(reg.fieldByName("DT_LAVRATURA").asString().trim());
                }
            } else {
                alienacao.getDataAlienacao().setConteudo(reg.fieldByName("DT_ALIENACAO").asString().trim());
            }
            alienacao.getAlienacaoParcial().setConteudo(reg.fieldByName("IN_GCAP_ANTERIOR").asString().trim());
            alienacao.getGanhoCapitalAlienacaoAnterior().setConteudo(reg.fieldByName("VR_GCAP_ANTERIOR").asValor());
            alienacao.getValorRecebidoAnosAnteriores().setConteudo(reg.fieldByName("VR_OPERACAO_BRUTO_ANT").asValor());
            alienacao.getCorretagemAnosAnteriores().setConteudo(reg.fieldByName("VR_CORRETAGEM_ANT").asValor());
            alienacao.getValorLiquidoRecebidoAnosAnteriores().setConteudo(reg.fieldByName("VR_GCAP_CI_ANT_LIGUIDO").asValor());
            alienacao.getAlienacaoAPrazo().setConteudo(reg.fieldByName("IN_ALIENPRAZO").asString().trim());
            if (alienacao.isAlienacaoAVista()) {
                alienacao.getCalculoImposto().getGanhoCapitalTotal().setConteudo(reg.fieldByName("VR_GCAP_CI").asValor());
                alienacao.getCalculoImposto().getAliquotaMedia().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_ALIQUOTA_MEDIA_CI")));
                alienacao.getCalculoImposto().getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_CI").asValor());
                alienacao.getCalculoImposto().getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_CI").asValor());
            } else if (alienacao.isAlienacaoAPrazo()) {
                if (alienacao.getBemImovel().isAdquiridoNoBrasil()) {
                    alienacao.getColecaoParcelaAlienacao().getGanho5ProporcionalTotal().setConteudo(reg.fieldByName("VR_GCAP_CI").asValor());
                } else if (alienacao.getBemImovel().isAdquiridoNoExterior()) {
                    alienacao.getColecaoParcelaAlienacao().getGanhoCapital5ProporcionalRealTotal().setConteudo(reg.fieldByName("VR_GCAP_CI").asValor());
                }
                alienacao.getCalculoImposto().getAliquotaMedia().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_ALIQUOTA_MEDIA_CI")));
                alienacao.getColecaoParcelaAlienacao().getImpostoDevidoTotal().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_CI").asValor());
                alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_CI").asValor());
                alienacao.getColecaoParcelaAlienacao().getValorRecebidoTotal().setConteudo(reg.fieldByName("VR_RECEBIDO_CL").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoCorretagemTotal().setConteudo(reg.fieldByName("VR_CORRETAGEM_CL").asValor());
                alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoTotal().setConteudo(reg.fieldByName("VR_VALOR_LIQUIDO").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalTotal().setConteudo(reg.fieldByName("VR_AQUISICAO_PROPORCIONAL_CL").asValor());
            }
            alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setConteudo(reg.fieldByName("VR_DIFERIDO_ANTERIORES_CB").asValor());
            alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().setConteudo(reg.fieldByName("VR_EXERCICIO_CB").asValor());
            alienacao.getConsolidacao().getImpostoTotal().setConteudo(reg.fieldByName("VR_TOTAL_CB").asValor());
            alienacao.getConsolidacao().getValorIRF().setConteudo(reg.fieldByName("VR_IR_CB").asValor());
            alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(reg.fieldByName("VR_IR_DEVIDO_CB").asValor());
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().setConteudo(reg.fieldByName("VR_DIFERIDO_POSTERIOR_CB").asValor());
            alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_CB").asValor());
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(reg.fieldByName("VR_ISENTO_CB").asValor());
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(reg.fieldByName("VR_EXCLUSIVO_CB").asValor());
            String dataUltimaParcela = reg.fieldByName("DT_DATA_ULTIMA_PARCELA").asString().trim();
            if ("00000000".equals(dataUltimaParcela)) {
                alienacao.getTemUltimaParcela().setConteudo(Logico.NAO);
            } else {
                alienacao.getDataRecebimentoUltimaParcela().setConteudo(dataUltimaParcela);
                alienacao.getTemUltimaParcela().setConteudo(Logico.SIM);
            }
            alienacao.getTerritorioParaisoFiscal().setConteudo(reg.fieldByName("IND_TER_PARAISO_FISCAL").asString());
            alienacao.getPaisResidencia().setConteudo(reg.fieldByName("CD_PAIS_PARAISO_FISCAL").asString());
            alienacao.getPerguntas().getMP252PrimeiraAlienacao().setConteudo(reg.fieldByName("IN_MULTIPLO_IMOVEL").asString().trim());
            String dataPrimeiraAlienacao = reg.fieldByName("DT_DATA_MULTIPLO_IMOVEL").asString().trim();
            if (!"00000000".equals(dataPrimeiraAlienacao)) {
                alienacao.getPerguntas().getDataPrimeiraAlienacao().setConteudo(dataPrimeiraAlienacao);
            }
            objDecl.getGCAP().getBensImoveis().itens().add(alienacao);
        }
    }

    public void importaRegistro62(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        IdDemonstrativoGCAP idDemonstrativo = null;
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            AlienacaoBemMovel alienacao = new AlienacaoBemMovel();
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4) + ConstantesGlobais.ANO_BASE;
            String dataFim = reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4) + ConstantesGlobais.ANO_BASE;
            if (!(idDemonstrativo != null && idDemonstrativo.getCpf().naoFormatado().equals(cpfDemonstrativo) && idDemonstrativo.getDataInicioPermanencia().naoFormatado().equals(dataInicio) && idDemonstrativo.getDataFimPermanencia().naoFormatado().equals(dataFim))) {
                idDemonstrativo = objDecl.getGCAP().obterIdDemonstrativoGCAP(cpfDemonstrativo, dataInicio, dataFim);
            }
            alienacao.getCpf().setConteudo(cpfDemonstrativo);
            alienacao.getDataInicioPermanencia().setConteudo(dataInicio);
            alienacao.getDataFimPermanencia().setConteudo(dataFim);
            alienacao.getNomePaisDeclarante().setConteudo(idDemonstrativo.getPaisDeclarante().getConteudoAtual(1));
            alienacao.getCodigoOperacao().setConteudo(reg.fieldByName("NR_OPERACAO").asString().trim());
            alienacao.getBemMovel().getBemAdquiridoNoBrasil().setConteudo(reg.fieldByName("IN_BRASIL_EXTERIOR").asString().trim());
            alienacao.getBemMovel().getEspecificacao().setConteudo(reg.fieldByName("NM_MOVEL_DESCRICAO").asString().trim());
            alienacao.getBemMovel().getSujeitoRegistroPublico().setConteudo(reg.fieldByName("IN_REGISTRO_PUBLICO").asString().trim());
            alienacao.getBemMovel().getAquisicao().getDataAquisicao().setConteudo(reg.fieldByName("DT_AQUISICAO").asString().trim());
            String bemPequenoValor = reg.fieldByName("IN_PEQUENO_VALOR").asString().trim();
            alienacao.getBemGrandeValor().setConteudo(Logico.SIM.equals(bemPequenoValor) ? Logico.NAO : (Logico.NAO.equals(bemPequenoValor) ? Logico.SIM : ""));
            try {
                alienacao.getNatureza().setConteudo(Integer.parseInt(reg.fieldByName("CD_OPERACAO").asString().trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (alienacao.isTransmissaoCausaMortis()) {
                alienacao.getDataVencimentoTCM().setConteudo(reg.fieldByName("DT_DATA_DARF_TCM").asString().trim());
                alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().setConteudo(reg.fieldByName("IN_DECISAO_JUDICIAL").asString().trim());
                if (Logico.SIM.equals(alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado())) {
                    alienacao.getDataAlienacao().setConteudo(reg.fieldByName("DT_DECISAO_JUDICIAL").asString().trim());
                    alienacao.getDataTransitoJulgado().setConteudo(reg.fieldByName("DT_TRANSITO_JULGADO").asString().trim());
                } else {
                    alienacao.getDataAlienacao().setConteudo(reg.fieldByName("DT_LAVRATURA").asString().trim());
                }
            } else {
                alienacao.getDataAlienacao().setConteudo(reg.fieldByName("DT_ALIENACAO").asString().trim());
            }
            if (alienacao.getBemMovel().isAdquiridoNoBrasil()) {
                alienacao.getValorAlienacao().setConteudo(reg.fieldByName("VR_OPERACAO").asValor());
                alienacao.getCustoCorretagem().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                alienacao.getBemMovel().getAquisicao().getCustoAquisicao().setConteudo(reg.fieldByName("VR_AQUISICAO").asValor());
            } else if (alienacao.getBemMovel().isAdquiridoNoExterior()) {
                alienacao.getValorAlienacaoReal().setConteudo(reg.fieldByName("VR_OPERACAO").asValor());
                alienacao.getValorCorretagemReal().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                alienacao.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalReal().setConteudo(reg.fieldByName("VR_AQUISICAO").asValor());
            }
            alienacao.getAlienacaoAPrazo().setConteudo(reg.fieldByName("IN_ALIENPRAZO").asString().trim());
            alienacao.getAlienacaoParcial().setConteudo(reg.fieldByName("IN_GCAP_ANTERIOR").asString().trim());
            alienacao.getGanhoCapitalAlienacaoAnterior().setConteudo(reg.fieldByName("VR_GCAP_ANTERIOR").asValor());
            alienacao.getValorRecebidoAnosAnteriores().setConteudo(reg.fieldByName("VR_OPERACAO_BRUTO_ANT").asValor());
            alienacao.getCorretagemAnosAnteriores().setConteudo(reg.fieldByName("VR_CORRETAGEM_ANT").asValor());
            alienacao.getValorLiquidoRecebidoAnosAnteriores().setConteudo(reg.fieldByName("VR_GCAP_CI_ANT_LIGUIDO").asValor());
            if (alienacao.isAlienacaoAVista()) {
                alienacao.getCalculoImposto().getGanhoCapitalTotal().setConteudo(reg.fieldByName("VR_GCAP_CI").asValor());
                alienacao.getCalculoImposto().getAliquotaMedia().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_ALIQUOTA_MEDIA_CI")));
                alienacao.getCalculoImposto().getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_CI").asValor());
                alienacao.getCalculoImposto().getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_CI").asValor());
            } else {
                if (alienacao.getBemMovel().isAdquiridoNoBrasil()) {
                    alienacao.getColecaoParcelaAlienacao().getGanho1ProporcionalTotal().setConteudo(reg.fieldByName("VR_GCAP_CI").asValor());
                } else if (alienacao.getBemMovel().isAdquiridoNoExterior()) {
                    alienacao.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalRealTotal().setConteudo(reg.fieldByName("VR_GCAP_CI").asValor());
                }
                alienacao.getCalculoImposto().getAliquotaMedia().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_ALIQUOTA_MEDIA_CI")));
                alienacao.getColecaoParcelaAlienacao().getImpostoDevidoTotal().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_CI").asValor());
                alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_CI").asValor());
                alienacao.getColecaoParcelaAlienacao().getValorRecebidoTotal().setConteudo(reg.fieldByName("VR_RECEBIDO_CL").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoCorretagemTotal().setConteudo(reg.fieldByName("VR_CORRETAGEM_CL").asValor());
                alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoTotal().setConteudo(reg.fieldByName("VR_VALOR_LIQUIDO").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalTotal().setConteudo(reg.fieldByName("VR_AQUISICAO_PROPORCIONAL_CL").asValor());
            }
            alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setConteudo(reg.fieldByName("VR_DIFERIDO_ANTERIORES_CB").asValor());
            alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().setConteudo(reg.fieldByName("VR_EXERCICIO_CB").asValor());
            alienacao.getConsolidacao().getImpostoTotal().setConteudo(reg.fieldByName("VR_TOTAL_CB").asValor());
            alienacao.getConsolidacao().getValorIRF().setConteudo(reg.fieldByName("VR_IR_CB").asValor());
            alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(reg.fieldByName("VR_IR_DEVIDO_CB").asValor());
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().setConteudo(reg.fieldByName("VR_DIFERIDO_POSTERIOR_CB").asValor());
            alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_CB").asValor());
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(reg.fieldByName("VR_ISENTO_CB").asValor());
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(reg.fieldByName("VR_EXCLUSIVO_CB").asValor());
            String dataUltimaParcela = reg.fieldByName("DT_DATA_ULTIMA_PARCELA").asString().trim();
            if ("00000000".equals(dataUltimaParcela)) {
                alienacao.getTemUltimaParcela().setConteudo(Logico.NAO);
            } else {
                alienacao.getDataRecebimentoUltimaParcela().setConteudo(dataUltimaParcela);
                alienacao.getTemUltimaParcela().setConteudo(Logico.SIM);
            }
            alienacao.getTerritorioParaisoFiscal().setConteudo(reg.fieldByName("IND_TER_PARAISO_FISCAL").asString());
            alienacao.getPaisResidencia().setConteudo(reg.fieldByName("CD_PAIS_PARAISO_FISCAL").asString());
            objDecl.getGCAP().getBensMoveis().itens().add(alienacao);
        }
    }

    public void importaRegistro63(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        IdDemonstrativoGCAP idDemonstrativo = null;
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            AlienacaoParticipacaoSocietaria alienacao = new AlienacaoParticipacaoSocietaria();
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4) + ConstantesGlobais.ANO_BASE;
            String dataFim = reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4) + ConstantesGlobais.ANO_BASE;
            if (!(idDemonstrativo != null && idDemonstrativo.getCpf().naoFormatado().equals(cpfDemonstrativo) && idDemonstrativo.getDataInicioPermanencia().naoFormatado().equals(dataInicio) && idDemonstrativo.getDataFimPermanencia().naoFormatado().equals(dataFim))) {
                idDemonstrativo = objDecl.getGCAP().obterIdDemonstrativoGCAP(cpfDemonstrativo, dataInicio, dataFim);
            }
            alienacao.getCpf().setConteudo(cpfDemonstrativo);
            alienacao.getDataInicioPermanencia().setConteudo(dataInicio);
            alienacao.getDataFimPermanencia().setConteudo(dataFim);
            alienacao.getNomePaisDeclarante().setConteudo(idDemonstrativo.getPaisDeclarante().getConteudoAtual(1));
            alienacao.getCodigoOperacao().setConteudo(reg.fieldByName("NR_OPERACAO").asString().trim());
            alienacao.getParticipacaoSocietaria().getNome().setConteudo(reg.fieldByName("NM_SOCIEDADE").asString().trim());
            alienacao.getParticipacaoSocietaria().getCnpj().setConteudo(reg.fieldByName("NR_CNPJ").asString().trim());
            alienacao.getParticipacaoSocietaria().getUf().setConteudo(reg.fieldByName("NM_UF").asString().trim());
            alienacao.getParticipacaoSocietaria().getMunicipio().setConteudo(reg.fieldByName("CD_MUNICIPIO").asString().trim());
            try {
                alienacao.getNatureza().setConteudo(Integer.parseInt(reg.fieldByName("CD_OPERACAO").asString().trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            alienacao.getParticipacaoSocietaria().getEspecie().setConteudo(reg.fieldByName("CD_ESPECIE").asString().trim());
            if (alienacao.isTransmissaoCausaMortis()) {
                alienacao.getDataVencimentoTCM().setConteudo(reg.fieldByName("DT_DATA_DARF_TCM").asString().trim());
                alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().setConteudo(reg.fieldByName("IN_DECISAO_JUDICIAL").asString().trim());
                if (Logico.SIM.equals(alienacao.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado())) {
                    alienacao.getDataAlienacao().setConteudo(reg.fieldByName("DT_DECISAO_JUDICIAL").asString().trim());
                    alienacao.getDataTransitoJulgado().setConteudo(reg.fieldByName("DT_TRANSITO_JULGADO").asString().trim());
                } else {
                    alienacao.getDataAlienacao().setConteudo(reg.fieldByName("DT_LAVRATURA").asString().trim());
                }
            } else {
                alienacao.getDataAlienacao().setConteudo(reg.fieldByName("DT_ALIENACAO").asString().trim());
            }
            alienacao.getAlienacaoAPrazo().setConteudo(reg.fieldByName("IN_ALIENPRAZO").asString().trim());
            alienacao.getValorAlienacao().setConteudo(reg.fieldByName("VR_OPERACAO").asValor());
            alienacao.getCustoCorretagem().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
            String bemPequenoValor = reg.fieldByName("IN_PEQUENO_VALOR").asString().trim();
            alienacao.getBemGrandeValor().setConteudo(Logico.SIM.equals(bemPequenoValor) ? Logico.NAO : (Logico.NAO.equals(bemPequenoValor) ? Logico.SIM : ""));
            alienacao.getAlienacaoParcial().setConteudo(reg.fieldByName("IN_GCAP_ANTERIOR").asString().trim());
            alienacao.getGanhoCapitalAlienacaoAnterior().setConteudo(reg.fieldByName("VR_GCAP_ANTERIOR").asValor());
            alienacao.getApuracao().getValorAlienacao().setConteudo(reg.fieldByName("VR_VALOR_ALIENACAO_AP").asValor());
            alienacao.getApuracao().getCustoCorretagem().setConteudo(reg.fieldByName("VR_CUSTO_CORRETAGEM_AP").asValor());
            alienacao.getApuracao().getValorLiquidoAlienacao().setConteudo(reg.fieldByName("VR_LIGUIDO_ALIENACAO_AP").asValor());
            alienacao.getApuracao().getCustoAquisicao().setConteudo(reg.fieldByName("VR_CUSTO_AQUISICAO_AP").asValor());
            alienacao.getApuracao().getGanhoCapital1().setConteudo(reg.fieldByName("VR_GCAP_AP").asValor());
            alienacao.getValorRecebidoAnosAnteriores().setConteudo(reg.fieldByName("VR_OPERACAO_BRUTO_ANT").asValor());
            alienacao.getCorretagemAnosAnteriores().setConteudo(reg.fieldByName("VR_CORRETAGEM_ANT").asValor());
            alienacao.getValorLiquidoRecebidoAnosAnteriores().setConteudo(reg.fieldByName("VR_GCAP_CI_ANT_LIGUIDO").asValor());
            if (alienacao.isAlienacaoAVista()) {
                alienacao.getCalculoImposto().getGanhoCapitalTotal().setConteudo(reg.fieldByName("VR_GCAP_CI").asValor());
                alienacao.getCalculoImposto().getAliquotaMedia().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_ALIQUOTA_MEDIA_CI")));
                alienacao.getCalculoImposto().getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_CI").asValor());
                alienacao.getCalculoImposto().getIRRFLei110332004().setConteudo(reg.fieldByName("VR_IRRF_CI").asValor());
                alienacao.getCalculoImposto().getImpostoDevido2().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_APOS_COMPENSACAO_CI").asValor());
                alienacao.getCalculoImposto().getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_CI").asValor());
            } else {
                alienacao.getColecaoParcelaAlienacao().getGanhoProporcionalTotal().setConteudo(reg.fieldByName("VR_GCAP_CI").asValor());
                alienacao.getCalculoImposto().getAliquotaMedia().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_ALIQUOTA_MEDIA_CI")));
                alienacao.getColecaoParcelaAlienacao().getImpostoDevidoTotal().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_CI").asValor());
                alienacao.getColecaoParcelaAlienacao().getIrrfLei110332004Total().setConteudo(reg.fieldByName("VR_IRRF_CI").asValor());
                alienacao.getColecaoParcelaAlienacao().getImpostoDevido2Total().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_APOS_COMPENSACAO_CI").asValor());
                alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_CI").asValor());
                alienacao.getColecaoParcelaAlienacao().getValorRecebidoTotal().setConteudo(reg.fieldByName("VR_RECEBIDO_CL").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoCorretagemTotal().setConteudo(reg.fieldByName("VR_CORRETAGEM_CL").asValor());
                alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoTotal().setConteudo(reg.fieldByName("VR_VALOR_LIQUIDO").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalTotal().setConteudo(reg.fieldByName("VR_AQUISICAO_PROPORCIONAL_CL").asValor());
            }
            alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores().setConteudo(reg.fieldByName("VR_DIFERIDO_ANTERIORES_CB").asValor());
            alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual().setConteudo(reg.fieldByName("VR_EXERCICIO_CB").asValor());
            alienacao.getConsolidacao().getImpostoTotal().setConteudo(reg.fieldByName("VR_TOTAL_CB").asValor());
            alienacao.getConsolidacao().getValorIRF().setConteudo(reg.fieldByName("VR_IR_CB").asValor());
            alienacao.getConsolidacao().getImpostoDevidoAnoAtual().setConteudo(reg.fieldByName("VR_IR_DEVIDO_CB").asValor());
            alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores().setConteudo(reg.fieldByName("VR_DIFERIDO_POSTERIOR_CB").asValor());
            alienacao.getConsolidacao().getTotalImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_CB").asValor());
            alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis().setConteudo(reg.fieldByName("VR_ISENTO_CB").asValor());
            alienacao.getConsolidacao().getTotalRendSujeitosTributacao().setConteudo(reg.fieldByName("VR_EXCLUSIVO_CB").asValor());
            alienacao.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoAquisicaoTotal().setConteudo(reg.fieldByName("VR_CUSTO_TOTAL_AQUISICAO").asValor());
            String dataUltimaParcela = reg.fieldByName("DT_DATA_ULTIMA_PARCELA").asString().trim();
            if ("00000000".equals(dataUltimaParcela)) {
                alienacao.getTemUltimaParcela().setConteudo(Logico.NAO);
            } else {
                alienacao.getDataRecebimentoUltimaParcela().setConteudo(dataUltimaParcela);
                alienacao.getTemUltimaParcela().setConteudo(Logico.SIM);
            }
            alienacao.getTerritorioParaisoFiscal().setConteudo(reg.fieldByName("IND_TER_PARAISO_FISCAL").asString());
            alienacao.getPaisResidencia().setConteudo(reg.fieldByName("CD_PAIS_PARAISO_FISCAL").asString());
            objDecl.getGCAP().getpSocietarias().itens().add(alienacao);
        }
    }

    public void importaRegistro64(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            String msgIsencao;
            AlienacaoBemImovel alienacao;
            RegistroTxt reg = vRegistro.get(i);
            String tipo = reg.fieldByName("IN_TIPO").asString().trim();
            String cpf = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            if ("1".equals(tipo)) {
                alienacao = objDecl.getGCAP().obterAlienacaoBemImovelPorCPFPeriodo(cpf, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensImoveis());
                if (alienacao == null || !alienacao.getBemImovel().isAdquiridoNoExterior()) continue;
                alienacao.getCotacaoDolarDataAlienacao().setConteudo(reg.fieldByName("VR_COTACAO_OP").asValor());
                alienacao.getValorAlienacaoDolar().setConteudo(reg.fieldByName("VR_OPERACAO_DOLAR").asValor());
                alienacao.getValorCorretagemDolar().setConteudo(reg.fieldByName("VR_CORRETAGEM_DOLAR").asValor());
                alienacao.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMNDolar().setConteudo(reg.fieldByName("VR_TORNA_MN_DOLAR").asValor());
                alienacao.getBemImovel().getAquisicao().getCustoAquisicaoTornaOrigemMEDolar().setConteudo(reg.fieldByName("VR_TORNA_ME_DOLAR").asValor());
                alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().setConteudo(reg.fieldByName("IN_ORIGEM_REND").asString().trim());
                alienacao.getBemImovel().getAquisicao().getCotacaoDolarDataAquisicao().setConteudo(reg.fieldByName("VR_COTACAO_AQUISICAO").asValor());
                if ("3".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                    alienacao.getApuracao().getValorAlienacaoDolar().setConteudo(reg.fieldByName("VR_VALOR_ALIENACAO_AP_AMBAS").asValor());
                    alienacao.getApuracao().getCustoCorretagemDolar().setConteudo(reg.fieldByName("VR_CUSTO_CORRETAGEM_AP_AMBAS").asValor());
                    alienacao.getApuracao().getValorLiquidoAlienacaoDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_ALIENACAO_AP_AMBAS").asValor());
                    alienacao.getApuracao().getGanhoCapitalTotalExterior().setConteudo(reg.fieldByName("VR_GCAP_TOTAL_AP_AMBAS").asValor());
                }
                if (alienacao.getBemImovel().getAquisicao().houveReforma()) {
                    alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_DOLAR").asValor());
                    if ("1".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                        alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_DOLAR").asValor());
                    } else if ("2".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                        alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_DOLAR").asValor());
                    } else if ("3".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                        alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMNDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_RMN").asValor());
                        alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getPercentualCustoAquisicaoOrigemNacional().setConteudo(reg.fieldByName("FT_BEM_AQUISICAO_RMN").asValor());
                        alienacao.getApuracao().getPercentualCustoAquisicaoOrigemMN().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_BEM_AQUISICAO_RMN")));
                        alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getTotalCustoAquisicaoOrigemMEDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_RME").asValor());
                        alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().getPercentualCustoAquisicaoOrigemME().setConteudo(reg.fieldByName("FT_BEM_AQUISICAO_RME").asValor());
                        alienacao.getApuracao().getPercentualCustoAquisicaoOrigemME().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_BEM_AQUISICAO_RME")));
                    }
                } else {
                    alienacao.getBemImovel().getAquisicao().getCustoAquisicaoTotalDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_DOLAR").asValor());
                    if ("1".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                        alienacao.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_DOLAR").asValor());
                    } else if ("2".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                        alienacao.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_DOLAR").asValor());
                    } else if ("3".equals(alienacao.getBemImovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                        alienacao.getBemImovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_RMN").asValor());
                        alienacao.getBemImovel().getAquisicao().getPercentualCustoAquisicaoOrigemNacional().setConteudo(reg.fieldByName("FT_BEM_AQUISICAO_RMN").asValor());
                        alienacao.getBemImovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_RME").asValor());
                        alienacao.getBemImovel().getAquisicao().getPercentualCustoAquisicaoOrigemME().setConteudo(reg.fieldByName("FT_BEM_AQUISICAO_RME").asValor());
                    }
                }
                alienacao.getPaisAcordo().setConteudo(reg.fieldByName("COD_PAIS_ACORDO").asString().trim());
                alienacao.getValorImpostoExteriorReal().setConteudo(reg.fieldByName("VR_IMPOSTO_REAL_ACORDO").asValor());
                if (alienacao.isAlienacaoAPrazo()) {
                    alienacao.getAjuste().getGanhoCapitalTotal().setConteudo(reg.fieldByName("VR_GCAP_TOTAL_AJUSTE").asValor());
                    alienacao.getAjuste().getAliquotaMedia().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_ALIQUOTA_MEDIA_AJUSTE")));
                    alienacao.getAjuste().getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_TOTAL_AJUSTE").asValor());
                    alienacao.getAjuste().getImpostoPagoExterior().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                    alienacao.getAjuste().getImpostoDevido2().setConteudo(reg.fieldByName("VR_SALDO_IMPOSTO_DEVIDO").asValor());
                    alienacao.getAjuste().getImpostoDevidoNoBrasilRelativoParcelasAnteriores().setConteudo(reg.fieldByName("VR_IMPOSTO_PARCELA_AJUSTE").asValor());
                    alienacao.getAjuste().getSaldoImpostoDevidoNoBrasil().setConteudo(reg.fieldByName("VR_SALDO_IMPOSTO_AJUSTE").asValor());
                    alienacao.getAjuste().getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_AJUSTE").asValor());
                } else {
                    alienacao.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                    alienacao.getCalculoImposto().getImpostoDevido2().setConteudo(reg.fieldByName("VR_SALDO_IMPOSTO_DEVIDO").asValor());
                }
                alienacao.getInCobranca().setConteudo(reg.fieldByName("IN_COBRANCA").asString().trim());
                alienacao.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_RECEBIDO_DOLAR").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_CUSTO_CORRETAGEM_DOLAR").asValor());
                alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_LIQUIDO_RECEBIDO_DOLAR").asValor());
                alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal().setConteudo(reg.fieldByName("VR_TOTAL_LIQUIDO_RECEBIDO_REAL").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_AQUISICAO_DOLAR").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal().setConteudo(reg.fieldByName("VR_TOTAL_AQUISICAO_REAL").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemMEDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_AQUISICAO_TORNA_DOLAR").asValor());
                alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal().setConteudo(reg.fieldByName("VR_TOTAL_AQUISICAO_TORNA_REAL").asValor());
                alienacao.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalRealTotal().setConteudo(reg.fieldByName("VR_TOTAL_RESULTADO1").asValor());
                alienacao.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMEDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_GCAP_DOLAR").asValor());
                alienacao.getColecaoParcelaAlienacao().getImpostoDevido2Total().setConteudo(reg.fieldByName("VR_TOTAL_IR").asValor());
                alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal().setConteudo(reg.fieldByName("VR_TOTAL_IR_PAGO").asValor());
                msgIsencao = reg.fieldByName("NM_MENSAGEM").asString();
                if (msgIsencao.indexOf("O IMPOSTO DEVIDO SERA INTEGRALMENTE COBRADO NA ULTIMA PARCELA") != -1) {
                    alienacao.getBemGrandeValorOperacao().setConteudo(Logico.NAO);
                }
                alienacao.getAquisicao().getMoedaEstrangeira().setConteudo(reg.fieldByName("CD_MOEDA_ESTRANGEIRA").asString());
                alienacao.getAquisicao().getResidenteBrasilAplicacaoExterior().setConteudo(reg.fieldByName("IN_RESIDENTE_BRASIL_APLICACAO_EXTERIOR").asString());
                continue;
            }
            if (!"2".equals(tipo) || (alienacao = objDecl.getGCAP().obterAlienacaoBemMovelPorCPFPeriodo(cpf, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensMoveis())) == null || !alienacao.getBemMovel().isAdquiridoNoExterior()) continue;
            alienacao.getCotacaoDolarDataAlienacao().setConteudo(reg.fieldByName("VR_COTACAO_OP").asValor());
            alienacao.getValorAlienacaoDolar().setConteudo(reg.fieldByName("VR_OPERACAO_DOLAR").asValor());
            alienacao.getValorCorretagemDolar().setConteudo(reg.fieldByName("VR_CORRETAGEM_DOLAR").asValor());
            alienacao.getAquisicao().getOrigemRendimentos().setConteudo(reg.fieldByName("IN_ORIGEM_REND").asString().trim());
            if ("3".equals(alienacao.getBemMovel().getAquisicao().getOrigemRendimentos().naoFormatado())) {
                alienacao.getApuracao().getValorAlienacaoDolar().setConteudo(reg.fieldByName("VR_VALOR_ALIENACAO_AP_AMBAS").asValor());
                alienacao.getApuracao().getCustoCorretagemDolar().setConteudo(reg.fieldByName("VR_CUSTO_CORRETAGEM_AP_AMBAS").asValor());
                alienacao.getApuracao().getValorLiquidoAlienacaoDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_ALIENACAO_AP_AMBAS").asValor());
                alienacao.getApuracao().getGanhoCapitalTotalExterior().setConteudo(reg.fieldByName("VR_GCAP_TOTAL_AP_AMBAS").asValor());
            }
            alienacao.getBemMovel().getAquisicao().getCotacaoDolarDataAquisicao().setConteudo(reg.fieldByName("VR_COTACAO_AQUISICAO").asValor());
            alienacao.getAquisicao().getCustoAquisicaoTotalDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_DOLAR").asValor());
            alienacao.getBemMovel().getAquisicao().getCustoAquisicaoOrigemNacionalDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_RMN").asValor());
            alienacao.getBemMovel().getAquisicao().getPercentualCustoAquisicaoOrigemNacional().setConteudo(reg.fieldByName("FT_BEM_AQUISICAO_RMN").asValor());
            alienacao.getBemMovel().getAquisicao().getCustoAquisicaoOrigemMEDolar().setConteudo(reg.fieldByName("VR_BEM_AQUISICAO_RME").asValor());
            alienacao.getBemMovel().getAquisicao().getPercentualCustoAquisicaoOrigemME().setConteudo(reg.fieldByName("FT_BEM_AQUISICAO_RME").asValor());
            alienacao.getPaisAcordo().setConteudo(reg.fieldByName("COD_PAIS_ACORDO").asString().trim());
            alienacao.getValorImpostoExteriorReal().setConteudo(reg.fieldByName("VR_IMPOSTO_REAL_ACORDO").asValor());
            if (alienacao.isAlienacaoAPrazo()) {
                alienacao.getAjuste().getGanhoCapitalTotal().setConteudo(reg.fieldByName("VR_GCAP_TOTAL_AJUSTE").asValor());
                alienacao.getAjuste().getAliquotaMedia().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_ALIQUOTA_MEDIA_AJUSTE")));
                alienacao.getAjuste().getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_TOTAL_AJUSTE").asValor());
                alienacao.getAjuste().getImpostoPagoExterior().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                alienacao.getAjuste().getImpostoDevido2().setConteudo(reg.fieldByName("VR_SALDO_IMPOSTO_DEVIDO").asValor());
                alienacao.getAjuste().getImpostoDevidoNoBrasilRelativoParcelasAnteriores().setConteudo(reg.fieldByName("VR_IMPOSTO_PARCELA_AJUSTE").asValor());
                alienacao.getAjuste().getSaldoImpostoDevidoNoBrasil().setConteudo(reg.fieldByName("VR_SALDO_IMPOSTO_AJUSTE").asValor());
                alienacao.getAjuste().getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_AJUSTE").asValor());
            } else {
                alienacao.getCalculoImposto().getTotalImpostoPagoExteriorPassivelCompensacao().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                alienacao.getCalculoImposto().getImpostoDevido2().setConteudo(reg.fieldByName("VR_SALDO_IMPOSTO_DEVIDO").asValor());
            }
            alienacao.getInCobranca().setConteudo(reg.fieldByName("IN_COBRANCA").asString().trim());
            alienacao.getColecaoParcelaAlienacao().getValorRecebidoDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_RECEBIDO_DOLAR").asValor());
            alienacao.getColecaoParcelaAlienacao().getCustoCorretagemDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_CUSTO_CORRETAGEM_DOLAR").asValor());
            alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_LIQUIDO_RECEBIDO_DOLAR").asValor());
            alienacao.getColecaoParcelaAlienacao().getValorLiquidoAlienacaoRealTotal().setConteudo(reg.fieldByName("VR_TOTAL_LIQUIDO_RECEBIDO_REAL").asValor());
            alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemMEDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_AQUISICAO_DOLAR").asValor());
            alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoProporcionalOrigemNacionalRealTotal().setConteudo(reg.fieldByName("VR_TOTAL_AQUISICAO_REAL").asValor());
            alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemMEDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_AQUISICAO_TORNA_DOLAR").asValor());
            alienacao.getColecaoParcelaAlienacao().getCustoAquisicaoTornaProporcionalOrigemNacionalRealTotal().setConteudo(reg.fieldByName("VR_TOTAL_AQUISICAO_TORNA_REAL").asValor());
            alienacao.getColecaoParcelaAlienacao().getGanhoCapital1ProporcionalMEDolarTotal().setConteudo(reg.fieldByName("VR_TOTAL_GCAP_DOLAR").asValor());
            alienacao.getColecaoParcelaAlienacao().getImpostoDevido2Total().setConteudo(reg.fieldByName("VR_TOTAL_IR").asValor());
            alienacao.getColecaoParcelaAlienacao().getImpostoPagoTotal().setConteudo(reg.fieldByName("VR_TOTAL_IR_PAGO").asValor());
            msgIsencao = reg.fieldByName("NM_MENSAGEM").asString();
            if (msgIsencao.indexOf("O IMPOSTO DEVIDO SERA INTEGRALMENTE COBRADO NA ULTIMA PARCELA") != -1) {
                alienacao.getBemGrandeValorOperacao().setConteudo(Logico.NAO);
            }
            alienacao.getAquisicao().getMoedaEstrangeira().setConteudo(reg.fieldByName("CD_MOEDA_ESTRANGEIRA").asString());
            alienacao.getAquisicao().getResidenteBrasilAplicacaoExterior().setConteudo(reg.fieldByName("IN_RESIDENTE_BRASIL_APLICACAO_EXTERIOR").asString());
        }
    }

    public void importaRegistro65(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            Adquirente adquirente;
            AlienacaoBemImovel alienacao;
            RegistroTxt reg = vRegistro.get(i);
            String tipo = reg.fieldByName("IN_TIPO").asString().trim();
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            if ("1".equals(tipo) && (alienacao = objDecl.getGCAP().obterAlienacaoBemImovelPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensImoveis())) != null) {
                adquirente = new Adquirente();
                adquirente.getCpfCnpj().setConteudo(reg.fieldByName("NR_CPFCNPJ").asString().trim());
                adquirente.getNome().setConteudo(reg.fieldByName("NR_NOME").asString().trim());
                alienacao.getBemImovel().getAdquirentes().itens().add(adquirente);
            }
            if ("2".equals(tipo) && (alienacao = objDecl.getGCAP().obterAlienacaoBemMovelPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensMoveis())) != null) {
                adquirente = new Adquirente();
                adquirente.getCpfCnpj().setConteudo(reg.fieldByName("NR_CPFCNPJ").asString().trim());
                adquirente.getNome().setConteudo(reg.fieldByName("NR_NOME").asString().trim());
                alienacao.getBemMovel().getAdquirentes().itens().add(adquirente);
            }
            if (!"3".equals(tipo) || (alienacao = objDecl.getGCAP().obterAlienacaoPArticipacaoSocietariaPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getpSocietarias())) == null) continue;
            adquirente = new Adquirente();
            adquirente.getCpfCnpj().setConteudo(reg.fieldByName("NR_CPFCNPJ").asString().trim());
            adquirente.getNome().setConteudo(reg.fieldByName("NR_NOME").asString().trim());
            alienacao.getAdquirentes().itens().add(adquirente);
        }
    }

    public void importaRegistro66(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            AlienacaoBemImovel alienacao = objDecl.getGCAP().obterAlienacaoBemImovelPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensImoveis());
            if (alienacao == null || !alienacao.getBemImovel().isAdquiridoNoBrasil()) continue;
            ParcelaAquisicao parcela = new ParcelaAquisicao();
            parcela.getData().setConteudo(reg.fieldByName("DT_DATA").asString().trim());
            parcela.getCustoAquisicao().setConteudo(reg.fieldByName("VR_VALOR_REAIS").asValor());
            parcela.getPercentualCustoTotal().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_PARCELA")));
            ParcelaApuracaoCustoAquisicao parcelaApuracao = new ParcelaApuracaoCustoAquisicao();
            parcelaApuracao.getData().setConteudo(reg.fieldByName("DT_DATA").asString().trim());
            parcelaApuracao.getPercentualCustoTotal().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_PARCELA")));
            parcelaApuracao.getValorPassivelReducao().setConteudo(reg.fieldByName("VR_VALOR_REDUCAO").asValor());
            parcelaApuracao.getPercentualReducaoLei7713().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_RED7713")));
            parcelaApuracao.getPercentualReducaoLei11196FR1().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_REDFR1")));
            parcelaApuracao.getPercentualReducaoLei11196FR2().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_REDFR2")));
            alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().itens().add(parcela);
            alienacao.getApuracao().getParcelasCustoAquisicao().itens().add(parcelaApuracao);
        }
    }

    public void importaRegistro67(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            AlienacaoBemImovel alienacao = objDecl.getGCAP().obterAlienacaoBemImovelPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensImoveis());
            if (alienacao == null || !alienacao.getBemImovel().isAdquiridoNoExterior()) continue;
            ParcelaAquisicao parcela = new ParcelaAquisicao();
            parcela.getData().setConteudo(reg.fieldByName("DT_DATA").asString().trim());
            parcela.getCustoAquisicaoOrigemNacionalReal().setConteudo(reg.fieldByName("VR_VALOR_RMN_REAIS").asValor());
            parcela.getPercentualCustoTotalReal().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_PARCELA_RMN")));
            parcela.getCotacaoDolar().setConteudo(reg.fieldByName("VR_COTACAO_AMPLIACAO").asValor());
            parcela.getCustoAquisicaoOrigemNacionalDolar().setConteudo(reg.fieldByName("VR_VALOR_RMN_DOLAR").asValor());
            parcela.getCustoAquisicaoOrigemMEDolar().setConteudo(reg.fieldByName("VR_VALOR_RME_DOLAR").asValor());
            parcela.getCustoAquisicaoTotalDolar().setConteudo(reg.fieldByName("VR_TOTAL_PARCELA_DOLAR").asValor());
            parcela.getPercentualCustoTotalDolar().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_PARCELA_RME")));
            ParcelaApuracaoCustoAquisicao parcelaApuracao = new ParcelaApuracaoCustoAquisicao();
            parcelaApuracao.getData().setConteudo(reg.fieldByName("DT_DATA").asString().trim());
            parcelaApuracao.getPercentualCustoTotalReal().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_PARCELA_RMN")));
            parcelaApuracao.getPercentualCustoTotalDolar().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_PARCELA_RME")));
            parcelaApuracao.getValorPassivelReducaoOrigemMN().setConteudo((Valor)this.obterValorBigDecimalGCME(reg.fieldByName("VR_VALOR_REDUCAO_RMN")));
            parcelaApuracao.getValorPassivelReducaoOrigemME().setConteudo((Valor)this.obterValorBigDecimalGCME(reg.fieldByName("VR_VALOR_REDUCAO_RME")));
            parcelaApuracao.getPercentualReducaoLei7713().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_RED7713")));
            parcelaApuracao.getPercentualReducaoLei11196FR1().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_REDFR1")));
            parcelaApuracao.getPercentualReducaoLei11196FR2().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_PORCENTAGEM_REDFR2")));
            alienacao.getBemImovel().getAquisicao().getParcelasAquisicao().itens().add(parcela);
            alienacao.getApuracao().getParcelasCustoAquisicao().itens().add(parcelaApuracao);
        }
    }

    public void importaRegistro68(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        block13: for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            int tipo = 0;
            try {
                tipo = Integer.valueOf(reg.fieldByName("NR_TIPO_APURACAO").asString().trim());
            }
            catch (NumberFormatException ex) {
                throw new GeracaoTxtException(MensagemUtil.getMensagem((String)"erro_restaurar"));
            }
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            AlienacaoBemImovel alienacao = objDecl.getGCAP().obterAlienacaoBemImovelPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensImoveis());
            if (alienacao == null) continue;
            switch (tipo) {
                case 1: {
                    this.preencherRegistro68ImovelBrasil(reg, alienacao, alienacao.getApuracao());
                    continue block13;
                }
                case 2: {
                    this.preencherRegistro68ImovelExMN(reg, alienacao, alienacao.getApuracao());
                    continue block13;
                }
                case 3: {
                    this.preencherRegistro68ImovelExME(reg, alienacao, alienacao.getApuracao());
                    continue block13;
                }
                case 4: {
                    this.preencherRegistro68ImovelExMN(reg, alienacao, alienacao.getApuracao());
                    continue block13;
                }
                case 5: {
                    this.preencherRegistro68ImovelExME(reg, alienacao, alienacao.getApuracao());
                    continue block13;
                }
                case 6: {
                    this.preencherRegistro68ImovelExMN(reg, alienacao, alienacao.getApuracaoFinal());
                    continue block13;
                }
                case 7: {
                    this.preencherRegistro68ImovelExME(reg, alienacao, alienacao.getApuracaoFinal());
                    continue block13;
                }
                case 8: {
                    this.preencherRegistro68ImovelExMN(reg, alienacao, alienacao.getApuracaoFinal());
                    continue block13;
                }
                case 9: {
                    this.preencherRegistro68ImovelExME(reg, alienacao, alienacao.getApuracaoFinal());
                }
            }
        }
    }

    private RegistroTxt preencherRegistro68ImovelBrasil(RegistroTxt objRegTXT, AlienacaoBemImovel alienacao, ApuracaoBemImovel apuracao) throws GeracaoTxtException {
        apuracao.getValorAlienacao().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
        apuracao.getCustoCorretagem().setConteudo(objRegTXT.fieldByName("VR_CORRETAGEM").asValor());
        apuracao.getValorLiquidoAlienacao().setConteudo(objRegTXT.fieldByName("VR_LIQUIDO_APURACAO").asValor());
        if (alienacao.isPermutaComTorna()) {
            apuracao.getCustoAquisicaoTorna().setConteudo(objRegTXT.fieldByName("VR_CUSTO_APURACAO").asValor());
        } else {
            apuracao.getCustoAquisicao().setConteudo(objRegTXT.fieldByName("VR_CUSTO_APURACAO").asValor());
        }
        apuracao.getGanhoCapital1().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").asValor());
        apuracao.getPercentualReducaoLei7713().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_REDUCAO_LEI7713_APURACAO")));
        apuracao.getValorReducaoLei7713().setConteudo(objRegTXT.fieldByName("VR_REDUCAO_LEI7713_APURACAO").asValor());
        apuracao.getGanhoCapital2().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_2_APURACAO").asValor());
        apuracao.getPercentualReducaoLei11196FR1().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR1")));
        apuracao.getValorReducaoLei11196FR1().setConteudo(objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR1").asValor());
        apuracao.getGanhoCapital3().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_3_APURACAO").asValor());
        apuracao.getPercentualReducaoLei11196FR2().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR2")));
        apuracao.getValorReducaoLei11196FR2().setConteudo(objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR2").asValor());
        apuracao.getGanhoCapital4().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_4_APURACAO").asValor());
        apuracao.getPercentualReducaoAplicacaoOutroImovel().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_APLICA_OUTRO_APURACAO")));
        apuracao.getValorReducaoAplicacaoOutroImovel().setConteudo(objRegTXT.fieldByName("VR_APLICA_OUTRO_APURACAO").asValor());
        apuracao.getPercentualReducaoBemPequenoValor().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_APLICA_PEQUENO_APURACAO")));
        apuracao.getValorReducaoBemPequenoValor().setConteudo(objRegTXT.fieldByName("VR_APLICA_PEQUENO_APURACAO").asValor());
        apuracao.getPercentualReducaoUnicoImovel().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_APLICA_UNICO_APURACAO")));
        apuracao.getValorReducaoUnicoImovel().setConteudo(objRegTXT.fieldByName("VR_APLICA_UNICO_APURACAO").asValor());
        apuracao.getGanhoCapital5().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_5_APURACAO").asValor());
        return objRegTXT;
    }

    private RegistroTxt preencherRegistro68ImovelExMN(RegistroTxt objRegTXT, AlienacaoBemImovel alienacao, ApuracaoBemImovel apuracao) throws GeracaoTxtException {
        apuracao.getCustoCorretagemOrigemNacionalDolar().setConteudo(objRegTXT.fieldByName("VR_CORRETAGEM").asValor());
        apuracao.getValorAlienacaoOrigemNacionalDolar().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
        apuracao.getValorLiquidoAlienacaoOrigemNacionalReal().setConteudo(objRegTXT.fieldByName("VR_LIQUIDO_APURACAO").asValor());
        apuracao.getValorLiquidoAlienacaoOrigemNacionalDolar().setConteudo(objRegTXT.fieldByName("VR_LIQUIDO_APURACAO_DOLAR").asValor());
        if (alienacao.isPermutaComTorna()) {
            apuracao.getCustoAquisicaoTornaOrigemMNReal().setConteudo(objRegTXT.fieldByName("VR_CUSTO_APURACAO").asValor());
        } else {
            apuracao.getCustoAquisicaoOrigemNacionalReal().setConteudo(objRegTXT.fieldByName("VR_CUSTO_APURACAO").asValor());
        }
        apuracao.getGanhoCapital1OrigemNacionalReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").asValor());
        apuracao.getPercentualReducaoLei7713OrigemMN().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_REDUCAO_LEI7713_APURACAO")));
        apuracao.getValorReducaoLei7713OrigemMN().setConteudo(objRegTXT.fieldByName("VR_REDUCAO_LEI7713_APURACAO").asValor());
        apuracao.getGanhoCapital2OrigemMNReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_2_APURACAO").asValor());
        apuracao.getPercentualReducaoLei11196FR1OrigemMN().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR1")));
        apuracao.getValorReducaoLei11196FR1OrigemMN().setConteudo(objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR1").asValor());
        apuracao.getGanhoCapital3OrigemMNReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_3_APURACAO").asValor());
        apuracao.getPercentualReducaoLei11196FR2OrigemMN().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR2")));
        apuracao.getValorReducaoLei11196FR2OrigemMN().setConteudo(objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR2").asValor());
        apuracao.getGanhoCapital4OrigemMNReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_4_APURACAO").asValor());
        apuracao.getPercentualReducaoAplicacaoOutroImovelOrigemMN().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_APLICA_OUTRO_APURACAO")));
        apuracao.getValorReducaoAplicacaoOutroImovelOrigemMN().setConteudo(objRegTXT.fieldByName("VR_APLICA_OUTRO_APURACAO").asValor());
        apuracao.getPercentualReducaoBemPequenoValorOrigemMN().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_APLICA_PEQUENO_APURACAO")));
        apuracao.getValorReducaoBemPequenoValorOrigemMN().setConteudo(objRegTXT.fieldByName("VR_APLICA_PEQUENO_APURACAO").asValor());
        apuracao.getPercentualReducaoUnicoImovelOrigemMN().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_APLICA_UNICO_APURACAO")));
        apuracao.getValorReducaoUnicoImovelOrigemMN().setConteudo(objRegTXT.fieldByName("VR_APLICA_UNICO_APURACAO").asValor());
        apuracao.getGanhoCapital5OrigemMNReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_5_APURACAO").asValor());
        apuracao.getCotacaoDolarOrigemNacional().setConteudo(objRegTXT.fieldByName("VR_COTACAO_APURACAO").asValor());
        return objRegTXT;
    }

    private RegistroTxt preencherRegistro68ImovelExME(RegistroTxt objRegTXT, AlienacaoBemImovel alienacao, ApuracaoBemImovel apuracao) throws GeracaoTxtException {
        apuracao.getValorAlienacaoOrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
        apuracao.getCustoCorretagemOrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_CORRETAGEM").asValor());
        apuracao.getValorLiquidoAlienacaoOrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_LIQUIDO_APURACAO_DOLAR").asValor());
        if (alienacao.isPermutaComTorna()) {
            apuracao.getCustoAquisicaoTornaOrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_CUSTO_APURACAO").asValor());
        } else {
            apuracao.getCustoAquisicaoOrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_CUSTO_APURACAO").asValor());
        }
        apuracao.getGanhoCapital1OrigemMEReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").asValor());
        apuracao.getGanhoCapital1OrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO_DOLAR").asValor());
        apuracao.getPercentualReducaoLei7713OrigemME().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_REDUCAO_LEI7713_APURACAO")));
        apuracao.getValorReducaoLei7713OrigemME().setConteudo(objRegTXT.fieldByName("VR_REDUCAO_LEI7713_APURACAO").asValor());
        apuracao.getGanhoCapital2OrigemMEReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_2_APURACAO").asValor());
        apuracao.getPercentualReducaoLei11196FR1OrigemME().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR1")));
        apuracao.getValorReducaoLei11196FR1OrigemME().setConteudo(objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR1").asValor());
        apuracao.getGanhoCapital3OrigemMEReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_3_APURACAO").asValor());
        apuracao.getPercentualReducaoLei11196FR2OrigemME().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_REDUCAO_LEI11196FR2")));
        apuracao.getValorReducaoLei11196FR2OrigemME().setConteudo(objRegTXT.fieldByName("VR_REDUCAO_LEI11196FR2").asValor());
        apuracao.getGanhoCapital4OrigemMEReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_4_APURACAO").asValor());
        apuracao.getPercentualReducaoAplicacaoOutroImovelOrigemME().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_APLICA_OUTRO_APURACAO")));
        apuracao.getValorReducaoAplicacaoOutroImovelOrigemME().setConteudo(objRegTXT.fieldByName("VR_APLICA_OUTRO_APURACAO").asValor());
        apuracao.getPercentualReducaoBemPequenoValorOrigemME().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_APLICA_PEQUENO_APURACAO")));
        apuracao.getValorReducaoBemPequenoValorOrigemME().setConteudo(objRegTXT.fieldByName("VR_APLICA_PEQUENO_APURACAO").asValor());
        apuracao.getPercentualReducaoUnicoImovelOrigemME().setConteudo(this.obterValorBigDecimalGCME(objRegTXT.fieldByName("FT_APLICA_UNICO_APURACAO")));
        apuracao.getValorReducaoUnicoImovelOrigemME().setConteudo(objRegTXT.fieldByName("VR_APLICA_UNICO_APURACAO").asValor());
        apuracao.getGanhoCapital5OrigemMEReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_5_APURACAO").asValor());
        apuracao.getCotacaoDolarOrigemME().setConteudo(objRegTXT.fieldByName("VR_COTACAO_APURACAO").asValor());
        return objRegTXT;
    }

    public void importaRegistro69(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        block13: for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            int tipo = 0;
            try {
                tipo = Integer.valueOf(reg.fieldByName("NR_TIPO_APURACAO").asString().trim());
            }
            catch (NumberFormatException ex) {
                throw new GeracaoTxtException(MensagemUtil.getMensagem((String)"erro_restaurar"));
            }
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            AlienacaoBemMovel alienacao = objDecl.getGCAP().obterAlienacaoBemMovelPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensMoveis());
            if (alienacao == null) continue;
            switch (tipo) {
                case 1: {
                    this.preencherRegistro69MovelBrasil(reg, alienacao.getApuracao());
                    continue block13;
                }
                case 2: {
                    this.preencherRegistro69MovelExMN(reg, alienacao.getApuracao());
                    continue block13;
                }
                case 3: {
                    this.preencherRegistro69MovelExME(reg, alienacao.getApuracao());
                    continue block13;
                }
                case 4: {
                    this.preencherRegistro69MovelExMN(reg, alienacao.getApuracao());
                    continue block13;
                }
                case 5: {
                    this.preencherRegistro69MovelExME(reg, alienacao.getApuracao());
                    continue block13;
                }
                case 6: {
                    this.preencherRegistro69MovelExMN(reg, alienacao.getApuracaoFinal());
                    continue block13;
                }
                case 7: {
                    this.preencherRegistro69MovelExME(reg, alienacao.getApuracaoFinal());
                    continue block13;
                }
                case 8: {
                    this.preencherRegistro69MovelExMN(reg, alienacao.getApuracaoFinal());
                    continue block13;
                }
                case 9: {
                    this.preencherRegistro69MovelExME(reg, alienacao.getApuracaoFinal());
                }
            }
        }
    }

    private RegistroTxt preencherRegistro69MovelBrasil(RegistroTxt objRegTXT, ApuracaoBemMovel apuracao) throws GeracaoTxtException {
        apuracao.getValorAlienacao().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
        apuracao.getCustoCorretagem().setConteudo(objRegTXT.fieldByName("VR_CORRETAGEM").asValor());
        apuracao.getValorLiquidoAlienacao().setConteudo(objRegTXT.fieldByName("VR_LIQUIDO_APURACAO").asValor());
        apuracao.getCustoAquisicao().setConteudo(objRegTXT.fieldByName("VR_CUSTO_APURACAO").asValor());
        apuracao.getGanhoCapital1().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").asValor());
        return objRegTXT;
    }

    private RegistroTxt preencherRegistro69MovelExMN(RegistroTxt objRegTXT, ApuracaoBemMovel apuracao) throws GeracaoTxtException {
        apuracao.getValorAlienacaoOrigemNacionalDolar().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
        apuracao.getCustoCorretagemOrigemNacionalDolar().setConteudo(objRegTXT.fieldByName("VR_CORRETAGEM").asValor());
        apuracao.getValorLiquidoAlienacaoOrigemNacionalReal().setConteudo(objRegTXT.fieldByName("VR_LIQUIDO_APURACAO").asValor());
        apuracao.getValorLiquidoAlienacaoOrigemNacionalDolar().setConteudo(objRegTXT.fieldByName("VR_LIQUIDO_APURACAO_DOLAR").asValor());
        apuracao.getCustoAquisicaoOrigemNacionalReal().setConteudo(objRegTXT.fieldByName("VR_CUSTO_APURACAO").asValor());
        apuracao.getGanhoCapital1OrigemNacionalReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").asValor());
        apuracao.getCotacaoDolarOrigemNacional().setConteudo(objRegTXT.fieldByName("VR_COTACAO_APURACAO").asValor());
        return objRegTXT;
    }

    private RegistroTxt preencherRegistro69MovelExME(RegistroTxt objRegTXT, ApuracaoBemMovel apuracao) throws GeracaoTxtException {
        apuracao.getValorAlienacaoOrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_VALOR").asValor());
        apuracao.getCustoCorretagemOrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_CORRETAGEM").asValor());
        apuracao.getValorLiquidoAlienacaoOrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_LIQUIDO_APURACAO_DOLAR").asValor());
        apuracao.getCustoAquisicaoOrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_CUSTO_APURACAO").asValor());
        apuracao.getGanhoCapital1OrigemMEReal().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO").asValor());
        apuracao.getGanhoCapital1OrigemMEDolar().setConteudo(objRegTXT.fieldByName("VR_RESULTADO_1_APURACAO_DOLAR").asValor());
        apuracao.getCotacaoDolarOrigemME().setConteudo(objRegTXT.fieldByName("VR_COTACAO_APURACAO").asValor());
        return objRegTXT;
    }

    public void importaRegistro70(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            ParcelaAlienacaoBem parcela;
            AlienacaoBemImovel alienacao;
            RegistroTxt reg = vRegistro.get(i);
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            String tipoBem = reg.fieldByName("IN_TIPO").asString().trim();
            String dataParcela = reg.fieldByName("DT_PARCELA").asString().trim();
            if ("1".equals(tipoBem)) {
                alienacao = objDecl.getGCAP().obterAlienacaoBemImovelPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensImoveis());
                if (alienacao == null || (parcela = alienacao.getColecaoParcelaAlienacao().obterParcelaPorData(dataParcela)) == null) continue;
                parcela.getValorRecebidoDolar().setConteudo(reg.fieldByName("VR_VALOR").asValor());
                parcela.getCustoCorretagemDolar().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                parcela.getValorLiquidoAlienacaoDolar().setConteudo(reg.fieldByName("VR_LIQUIDO").asValor());
                parcela.getGanhoCapital5ProporcionalTotalReal().setConteudo(reg.fieldByName("VR_GCAP_TOTAL").asValor());
                parcela.getGanhoCapital1ProporcionalTotalReal().setConteudo(parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().operacao('+', (Valor)parcela.getGanhoCapital1ProporcionalOrigemMEReal()));
                parcela.getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").asValor());
                parcela.getImpostoPagoExterior().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                parcela.getImpostoDevido2().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").asValor());
                parcela.getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").asValor());
                parcela.getValorInformadoReducaoAplicacaoOutroImovelAmbas().setConteudo(reg.fieldByName("VR_APLICA_OUTRO_INFORMADO_PARCELA").asValor());
                continue;
            }
            if (!"2".equals(tipoBem) || (alienacao = objDecl.getGCAP().obterAlienacaoBemMovelPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensMoveis())) == null || (parcela = alienacao.getColecaoParcelaAlienacao().obterParcelaPorData(dataParcela)) == null) continue;
            parcela.getValorRecebidoDolar().setConteudo(reg.fieldByName("VR_VALOR").asValor());
            parcela.getCustoCorretagemDolar().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
            parcela.getValorLiquidoAlienacaoDolar().setConteudo(reg.fieldByName("VR_LIQUIDO").asValor());
            parcela.getGanhoCapital1ProporcionalTotalReal().setConteudo(reg.fieldByName("VR_GCAP_TOTAL").asValor());
            parcela.getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").asValor());
            parcela.getImpostoPagoExterior().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
            parcela.getImpostoDevido2().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").asValor());
            parcela.getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").asValor());
        }
    }

    public void importaRegistro71(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        AlienacaoBemImovel alienacao = null;
        ParcelaAlienacaoBem parcela = null;
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            String tipoParcela = reg.fieldByName("NR_TIPO_PARCELA").asString().trim();
            String dataRecebimento = reg.fieldByName("DT_PARCELA").asString().trim();
            if (!(alienacao != null && alienacao.getCpf().naoFormatado().equals(cpfDemonstrativo) && alienacao.getDataInicioPermanencia().naoFormatado().equals(dataInicio) && alienacao.getDataFimPermanencia().naoFormatado().equals(dataFim) && alienacao.getCodigoOperacao().naoFormatado().equals(idAlienacao))) {
                alienacao = objDecl.getGCAP().obterAlienacaoBemImovelPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensImoveis());
                parcela = null;
            }
            if (alienacao == null) continue;
            if ((parcela == null || !parcela.getDataRecebimento().naoFormatado().equals(dataRecebimento)) && ("1".equals(tipoParcela) || "2".equals(tipoParcela) || "3".equals(tipoParcela) || (parcela = alienacao.getColecaoParcelaAlienacao().obterParcelaPorData(dataRecebimento)) == null)) {
                parcela = new ParcelaAlienacaoBem();
                alienacao.getColecaoParcelaAlienacao().itens().add(parcela);
            }
            if ("1".equals(tipoParcela)) {
                parcela.getValorRecebido().setConteudo(reg.fieldByName("VR_VALOR").asValor());
                parcela.getCustoCorretagem().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                parcela.getValorLiquidoAlienacao().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA").asValor());
                if (alienacao.isPermutaComTorna()) {
                    parcela.getCustoAquisicaoTornaProporcional().setConteudo(reg.fieldByName("VR_CUSTO_PARCELA").asValor());
                } else {
                    parcela.getCustoAquisicaoProporcional().setConteudo(reg.fieldByName("VR_CUSTO_PARCELA").asValor());
                }
                parcela.getGanhoCapital1Proporcional().setConteudo(reg.fieldByName("VR_RESULTADO_1_PARCELA").asValor());
                parcela.getPercentualReducaoLei7713().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_REDUCAO_LEI7713_PARCELA")));
                parcela.getValorReducaoLei7713().setConteudo(reg.fieldByName("VR_REDUCAO_LEI7713_PARCELA").asValor());
                parcela.getGanhoCapital2Proporcional().setConteudo(reg.fieldByName("VR_RESULTADO_2_PARCELA").asValor());
                parcela.getPercentualReducaoLei11196FR1().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_REDUCAO_LEI11196FR1")));
                parcela.getValorReducaoLei11196FR1().setConteudo(reg.fieldByName("VR_REDUCAO_LEI11196FR1").asValor());
                parcela.getGanhoCapital3Proporcional().setConteudo(reg.fieldByName("VR_RESULTADO_3_PARCELA").asValor());
                parcela.getPercentualReducaoLei11196FR2().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_REDUCAO_LEI11196FR2")));
                parcela.getValorReducaoLei11196FR2().setConteudo(reg.fieldByName("VR_REDUCAO_LEI11196FR2").asValor());
                parcela.getGanhoCapital4Proporcional().setConteudo(reg.fieldByName("VR_RESULTADO_4_PARCELA").asValor());
                parcela.getValorInformadoReducaoAplicacaoOutroImovel().setConteudo(reg.fieldByName("VR_APLICA_OUTRO_INFORMADO_PARCELA").asValor());
                parcela.getPercentualReducaoAplicacaoOutroImovel().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_APLICA_OUTRO_PARCELA")));
                parcela.getValorReducaoAplicacaoOutroImovel().setConteudo(reg.fieldByName("VR_APLICA_OUTRO_PARCELA").asValor());
                parcela.getPercentualReducaoBemPequenoValor().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_APLICA_PEQUENO_PARCELA")));
                parcela.getValorReducaoBemPequenoValor().setConteudo(reg.fieldByName("VR_APLICA_PEQUENO_PARCELA").asValor());
                parcela.getPercentualReducaoUnicoImovel().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_APLICA_UNICO_PARCELA")));
                parcela.getValorReducaoUnicoImovel().setConteudo(reg.fieldByName("VR_APLICA_UNICO_PARCELA").asValor());
                parcela.getGanhoCapital5Proporcional().setConteudo(reg.fieldByName("VR_RESULTADO_5_PARCELA").asValor());
                parcela.getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").asValor());
                parcela.getImpostoPagoExterior().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                parcela.getImpostoDevido2().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").asValor());
                parcela.getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").asValor());
            } else if ("2".equals(tipoParcela) || "4".equals(tipoParcela)) {
                if ("4".equals(tipoParcela)) {
                    parcela.getValorAlienacaoOrigemNacionalReal().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA").asValor());
                    parcela.getValorAlienacaoOrigemNacionalDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").asValor());
                } else if ("2".equals(tipoParcela)) {
                    parcela.getValorInformadoReducaoAplicacaoOutroImovelMN().setConteudo(reg.fieldByName("VR_APLICA_OUTRO_INFORMADO_PARCELA").asValor());
                    parcela.getValorLiquidoAlienacaoReal().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA").asValor());
                    parcela.getValorLiquidoAlienacaoDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").asValor());
                    parcela.getValorRecebidoDolar().setConteudo(reg.fieldByName("VR_VALOR").asValor());
                    parcela.getCustoCorretagemDolar().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                    parcela.getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").asValor());
                    parcela.getImpostoPagoExterior().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                    parcela.getImpostoDevido2().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").asValor());
                    parcela.getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").asValor());
                }
                if (alienacao.isPermutaComTorna()) {
                    parcela.getCustoAquisicaoTornaProporcionalOrigemNacionalReal().setConteudo(reg.fieldByName("VR_CUSTO_PARCELA").asValor());
                } else {
                    parcela.getCustoAquisicaoProporcionalOrigemNacionalReal().setConteudo(reg.fieldByName("VR_CUSTO_PARCELA").asValor());
                }
                parcela.getGanhoCapital1ProporcionalOrigemNacionalReal().setConteudo(reg.fieldByName("VR_RESULTADO_1_PARCELA").asValor());
                parcela.getPercentualReducaoLei7713MN().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_REDUCAO_LEI7713_PARCELA")));
                parcela.getValorReducaoLei7713MN().setConteudo(reg.fieldByName("VR_REDUCAO_LEI7713_PARCELA").asValor());
                parcela.getGanhoCapital2ProporcionalMN().setConteudo(reg.fieldByName("VR_RESULTADO_2_PARCELA").asValor());
                parcela.getPercentualReducaoLei11196FR1MN().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_REDUCAO_LEI11196FR1")));
                parcela.getValorReducaoLei11196FR1MN().setConteudo(reg.fieldByName("VR_REDUCAO_LEI11196FR1").asValor());
                parcela.getGanhoCapital3ProporcionalMN().setConteudo(reg.fieldByName("VR_RESULTADO_3_PARCELA").asValor());
                parcela.getPercentualReducaoLei11196FR2MN().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_REDUCAO_LEI11196FR2")));
                parcela.getValorReducaoLei11196FR2MN().setConteudo(reg.fieldByName("VR_REDUCAO_LEI11196FR2").asValor());
                parcela.getGanhoCapital4ProporcionalMN().setConteudo(reg.fieldByName("VR_RESULTADO_4_PARCELA").asValor());
                parcela.getPercentualReducaoAplicacaoOutroImovelMN().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_APLICA_OUTRO_PARCELA")));
                parcela.getValorReducaoAplicacaoOutroImovelMN().setConteudo(reg.fieldByName("VR_APLICA_OUTRO_PARCELA").asValor());
                parcela.getPercentualReducaoBemPequenoValorMN().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_APLICA_PEQUENO_PARCELA")));
                parcela.getValorReducaoBemPequenoValorMN().setConteudo(reg.fieldByName("VR_APLICA_PEQUENO_PARCELA").asValor());
                parcela.getPercentualReducaoUnicoImovelMN().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_APLICA_UNICO_PARCELA")));
                parcela.getValorReducaoUnicoImovelMN().setConteudo(reg.fieldByName("VR_APLICA_UNICO_PARCELA").asValor());
                parcela.getGanhoCapital5ProporcionalMN().setConteudo(reg.fieldByName("VR_RESULTADO_5_PARCELA").asValor());
                parcela.getCotacaoDolar().setConteudo(reg.fieldByName("VR_COTACAO_PARCELA").asValor());
            } else if ("3".equals(tipoParcela) || "5".equals(tipoParcela)) {
                if ("5".equals(tipoParcela)) {
                    parcela.getValorAlienacaoOrigemMEDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").asValor());
                } else if ("3".equals(tipoParcela)) {
                    parcela.getValorRecebidoDolar().setConteudo(reg.fieldByName("VR_VALOR").asValor());
                    parcela.getCustoCorretagemDolar().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                    parcela.getValorInformadoReducaoAplicacaoOutroImovelME().setConteudo(reg.fieldByName("VR_APLICA_OUTRO_INFORMADO_PARCELA").asValor());
                    parcela.getValorLiquidoAlienacaoDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").asValor());
                    parcela.getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").asValor());
                    parcela.getImpostoPagoExterior().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                    parcela.getImpostoDevido2().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").asValor());
                    parcela.getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").asValor());
                }
                if (alienacao.isPermutaComTorna()) {
                    parcela.getCustoAquisicaoTornaProporcionalOrigemMEDolar().setConteudo(reg.fieldByName("VR_CUSTO_PARCELA").asValor());
                } else {
                    parcela.getCustoAquisicaoProporcionalOrigemMEDolar().setConteudo(reg.fieldByName("VR_CUSTO_PARCELA").asValor());
                }
                parcela.getGanhoCapital1ProporcionalOrigemMEReal().setConteudo(reg.fieldByName("VR_RESULTADO_1_PARCELA").asValor());
                parcela.getGanhoCapital1ProporcionalOrigemMEDolar().setConteudo(reg.fieldByName("VR_RESULTADO_1_PARCELA_DOLAR").asValor());
                parcela.getPercentualReducaoLei7713ME().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_REDUCAO_LEI7713_PARCELA")));
                parcela.getValorReducaoLei7713ME().setConteudo(reg.fieldByName("VR_REDUCAO_LEI7713_PARCELA").asValor());
                parcela.getGanhoCapital2ProporcionalME().setConteudo(reg.fieldByName("VR_RESULTADO_2_PARCELA").asValor());
                parcela.getPercentualReducaoLei11196FR1ME().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_REDUCAO_LEI11196FR1")));
                parcela.getValorReducaoLei11196FR1ME().setConteudo(reg.fieldByName("VR_REDUCAO_LEI11196FR1").asValor());
                parcela.getGanhoCapital3ProporcionalME().setConteudo(reg.fieldByName("VR_RESULTADO_3_PARCELA").asValor());
                parcela.getPercentualReducaoLei11196FR2ME().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_REDUCAO_LEI11196FR2")));
                parcela.getValorReducaoLei11196FR2ME().setConteudo(reg.fieldByName("VR_REDUCAO_LEI11196FR2").asValor());
                parcela.getGanhoCapital4ProporcionalME().setConteudo(reg.fieldByName("VR_RESULTADO_4_PARCELA").asValor());
                parcela.getPercentualReducaoAplicacaoOutroImovelME().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_APLICA_OUTRO_PARCELA")));
                parcela.getValorReducaoAplicacaoOutroImovelME().setConteudo(reg.fieldByName("VR_APLICA_OUTRO_PARCELA").asValor());
                parcela.getPercentualReducaoBemPequenoValorME().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_APLICA_PEQUENO_PARCELA")));
                parcela.getValorReducaoBemPequenoValorME().setConteudo(reg.fieldByName("VR_APLICA_PEQUENO_PARCELA").asValor());
                parcela.getPercentualReducaoUnicoImovelME().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("FT_APLICA_UNICO_PARCELA")));
                parcela.getValorReducaoUnicoImovelME().setConteudo(reg.fieldByName("VR_APLICA_UNICO_PARCELA").asValor());
                parcela.getGanhoCapital5ProporcionalME().setConteudo(reg.fieldByName("VR_RESULTADO_5_PARCELA").asValor());
                parcela.getCotacaoDolar().setConteudo(reg.fieldByName("VR_COTACAO_PARCELA").asValor());
            }
            parcela.getDataRecebimento().setConteudo(reg.fieldByName("DT_PARCELA").asString().trim());
            parcela.getUltimaParcela().setConteudo(reg.fieldByName("IN_ULTIMA_PARCELA").asString().trim());
            parcela.getAliquotaMedia().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_ALIQUOTA_MEDIA_PARCELA")));
        }
    }

    public void importaRegistro72(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        AlienacaoBemMovel alienacao = null;
        ParcelaAlienacao parcela = null;
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            String tipoBem = reg.fieldByName("IN_TIPO").asString().trim();
            String tipoParcela = reg.fieldByName("NR_TIPO_PARCELA").asString().trim();
            String dataRecebimento = reg.fieldByName("DT_PARCELA").asString().trim();
            if (!(alienacao != null && alienacao.getCpf().naoFormatado().equals(cpfDemonstrativo) && alienacao.getDataInicioPermanencia().naoFormatado().equals(dataInicio) && alienacao.getDataFimPermanencia().naoFormatado().equals(dataFim) && alienacao.getCodigoOperacao().naoFormatado().equals(idAlienacao))) {
                if ("1".equals(tipoBem)) {
                    alienacao = objDecl.getGCAP().obterAlienacaoBemMovelPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensMoveis());
                } else if ("2".equals(tipoBem)) {
                    alienacao = objDecl.getGCAP().obterAlienacaoPArticipacaoSocietariaPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getpSocietarias());
                }
                parcela = null;
            }
            if (alienacao == null) continue;
            if ("2".equals(tipoBem)) {
                parcela = new ParcelaAlienacao();
                ((AlienacaoParticipacaoSocietaria)alienacao).getColecaoParcelaAlienacao().itens().add(parcela);
            } else if (parcela == null || !parcela.getDataRecebimento().naoFormatado().equals(dataRecebimento) || (parcela = alienacao.getColecaoParcelaAlienacao().obterParcelaPorData(dataRecebimento)) == null) {
                parcela = new ParcelaAlienacaoBem();
                alienacao.getColecaoParcelaAlienacao().itens().add((ParcelaAlienacaoBem)parcela);
            }
            if (parcela instanceof ParcelaAlienacaoBem && alienacao.getBemMovel().isAdquiridoNoExterior()) {
                ParcelaAlienacaoBem parcelaBem = (ParcelaAlienacaoBem)parcela;
                if ("2".equals(tipoParcela) || "4".equals(tipoParcela)) {
                    if ("4".equals(tipoParcela)) {
                        parcelaBem.getValorLiquidoAlienacaoDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA_AMBAS").asValor());
                        parcelaBem.getValorAlienacaoOrigemNacionalReal().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA").asValor());
                        parcelaBem.getValorAlienacaoOrigemNacionalDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").asValor());
                    } else if ("2".equals(tipoParcela)) {
                        parcelaBem.getValorLiquidoAlienacaoReal().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA").asValor());
                        parcelaBem.getValorLiquidoAlienacaoDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").asValor());
                        parcelaBem.getValorRecebidoDolar().setConteudo(reg.fieldByName("VR_VALOR").asValor());
                        parcelaBem.getCustoCorretagemDolar().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                        parcelaBem.getImpostoPagoExterior().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                        parcelaBem.getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").asValor());
                        parcelaBem.getImpostoDevido2().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").asValor());
                        parcelaBem.getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").asValor());
                    }
                    parcelaBem.getCustoAquisicaoProporcionalOrigemNacionalReal().setConteudo(reg.fieldByName("VR_CUSTO_PARCELA").asValor());
                    parcelaBem.getGanhoCapital1ProporcionalOrigemNacionalReal().setConteudo(reg.fieldByName("VR_RESULTADO_1_PARCELA").asValor());
                    parcelaBem.getCotacaoDolar().setConteudo(reg.fieldByName("VR_COTACAO_PARCELA").asValor());
                } else if ("3".equals(tipoParcela) || "5".equals(tipoParcela)) {
                    if ("5".equals(tipoParcela)) {
                        parcelaBem.getValorLiquidoAlienacaoDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA_AMBAS").asValor());
                        parcelaBem.getValorAlienacaoOrigemMEDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").asValor());
                    } else if ("3".equals(tipoParcela)) {
                        parcelaBem.getValorLiquidoAlienacaoDolar().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA_DOLAR").asValor());
                        parcelaBem.getValorRecebidoDolar().setConteudo(reg.fieldByName("VR_VALOR").asValor());
                        parcelaBem.getCustoCorretagemDolar().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                        parcelaBem.getImpostoPagoExterior().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                        parcelaBem.getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").asValor());
                        parcelaBem.getImpostoDevido2().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").asValor());
                        parcelaBem.getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").asValor());
                    }
                    parcelaBem.getCustoAquisicaoProporcionalOrigemMEDolar().setConteudo(reg.fieldByName("VR_CUSTO_PARCELA").asValor());
                    parcelaBem.getGanhoCapital1ProporcionalOrigemMEReal().setConteudo(reg.fieldByName("VR_RESULTADO_1_PARCELA").asValor());
                    parcelaBem.getGanhoCapital1ProporcionalOrigemMEDolar().setConteudo(reg.fieldByName("VR_RESULTADO_1_PARCELA_DOLAR").asValor());
                    parcelaBem.getCotacaoDolar().setConteudo(reg.fieldByName("VR_COTACAO_PARCELA").asValor());
                }
            } else {
                parcela.getValorRecebido().setConteudo(reg.fieldByName("VR_VALOR").asValor());
                parcela.getCustoCorretagem().setConteudo(reg.fieldByName("VR_CORRETAGEM").asValor());
                parcela.getValorLiquidoAlienacao().setConteudo(reg.fieldByName("VR_LIQUIDO_PARCELA").asValor());
                parcela.getCustoAquisicaoProporcional().setConteudo(reg.fieldByName("VR_CUSTO_PARCELA").asValor());
                parcela.getGanhoCapital1Proporcional().setConteudo(reg.fieldByName("VR_RESULTADO_1_PARCELA").asValor());
                parcela.getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_PARCELA").asValor());
                parcela.getIrrfLei110332004().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_COMPENSACAO").asValor());
                parcela.getImpostoDevido2().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO_BRASIL").asValor());
                parcela.getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO_PARCELA_BRASIL").asValor());
            }
            parcela.getDataRecebimento().setConteudo(reg.fieldByName("DT_PARCELA").asString().trim());
            parcela.getUltimaParcela().setConteudo(reg.fieldByName("IN_ULTIMA_PARCELA").asString().trim());
            parcela.getAliquotaMedia().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_ALIQUOTA_MEDIA_PARCELA")));
        }
    }

    public void importaRegistro73(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            AlienacaoParticipacaoSocietaria alienacao = objDecl.getGCAP().obterAlienacaoPArticipacaoSocietariaPorCPFPeriodo(cpfDemonstrativo, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getpSocietarias());
            if (alienacao == null) continue;
            ParcelaAquisicaoParticipacaoSocietaria parcela = new ParcelaAquisicaoParticipacaoSocietaria();
            parcela.getEspecieAquisicao().setConteudo(reg.fieldByName("IN_ESPECIE").asString().trim());
            parcela.getQuantidadeQuotas().setConteudo(reg.fieldByName("VR_QUANTIDADE_ALIENADA").asString().trim());
            parcela.getCustoMedio().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_CUSTO_MEDIO")));
            parcela.getCustoAquisicao().setConteudo(reg.fieldByName("VR_CUSTO_TOTAL").asValor());
            alienacao.getColecaoParcelaAquisicaoParticipacaoSocietaria().itens().add(parcela);
        }
    }

    public void importaRegistro74(List<RegistroTxt> vRegistro, DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        MoedaAlienada moeda = null;
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            String cpfDemonstrativo = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String tipoOperacaoTxt = reg.fieldByName("TIPO_OPERACAO").asString().trim();
            if ("1".equals(tipoOperacaoTxt)) {
                moeda = new MoedaAlienada();
                moeda.getCpf().setConteudo(cpfDemonstrativo);
                moeda.getDataInicioPermanencia().setConteudo(dataInicio);
                moeda.getDataFimPermanencia().setConteudo(dataFim);
                moeda.getMoeda().setConteudo(reg.fieldByName("CD_MOEDA").asString().trim());
                moeda.getCustoMedioInicial().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_CUSTO")));
                moeda.getOperacoesEspecie().getCustoMedioInicial().setConteudo(moeda.getCustoMedioInicial());
                moeda.getSaldoInicial().setConteudo(reg.fieldByName("VR_SALDO_REAIS").asValor());
                moeda.getOperacoesEspecie().getSaldoInicial().setConteudo((Valor)moeda.getSaldoInicial());
                moeda.getEstoqueInicial().setConteudo(reg.fieldByName("VR_SALDO_ME").asValor());
                moeda.getOperacoesEspecie().getEstoqueInicial().setConteudo((Valor)moeda.getEstoqueInicial());
                declaracao.getGCAP().getEspecie().itens().add(moeda);
                continue;
            }
            if (!"2".equals(tipoOperacaoTxt) && !"3".equals(tipoOperacaoTxt) || moeda == null) continue;
            OperacaoEspecie operacao = new OperacaoEspecie();
            if ("2".equals(tipoOperacaoTxt)) {
                operacao.getTipo().setConteudo("1");
            } else if ("3".equals(tipoOperacaoTxt)) {
                operacao.getTipo().setConteudo("2");
                operacao.getNomeAdquirente().setConteudo(reg.fieldByName("NM_ADQUIR").asString().trim());
                operacao.getNiAdquirente().setConteudo(reg.fieldByName("NR_ADQUIR").asString().trim());
                operacao.getCustoAlienacao().setConteudo(reg.fieldByName("VR_CUSTOTOTAQUIS").asValor());
                operacao.getGanhoCapital().setConteudo(reg.fieldByName("VR_GANHOCAPITAL").asValor());
                operacao.getCotacaoDolar().setConteudo(reg.fieldByName("VR_COTACAO_MOEDA_ESTRANGEIRA_DOLAR").asValor());
            }
            operacao.getData().setConteudo(reg.fieldByName("DT_OPERACAO").asString().trim());
            operacao.getValor().setConteudo(reg.fieldByName("VR_OPERACAO").asValor());
            operacao.getQuantidade().setConteudo(reg.fieldByName("NR_QUANTIDADE").asValor());
            operacao.getCustoMedio().setConteudo(this.obterValorBigDecimalGCME(reg.fieldByName("VR_CUSTO")));
            operacao.getSaldo().setConteudo(reg.fieldByName("VR_SALDO_REAIS").asValor());
            operacao.getEstoque().setConteudo(reg.fieldByName("VR_SALDO_ME").asValor());
            moeda.getOperacoesEspecie().itens().add(operacao);
        }
    }

    public void importaRegistro75(List<RegistroTxt> vRegistro, DeclaracaoIRPF objDecl) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            String cpf = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
            String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
            String idAlienacao = reg.fieldByName("NR_OPERACAO").asString().trim();
            String tipo = reg.fieldByName("IN_TIPO").asString().trim();
            String tipoApuracao = reg.fieldByName("IN_APURACAO").asString().trim();
            AlienacaoBemImovel alienacao = null;
            if ("1".equals(tipo)) {
                AlienacaoBemImovel imovel;
                alienacao = imovel = objDecl.getGCAP().obterAlienacaoBemImovelPorCPFPeriodo(cpf, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensImoveis());
            } else if ("2".equals(tipo)) {
                AlienacaoBemMovel movel = objDecl.getGCAP().obterAlienacaoBemMovelPorCPFPeriodo(cpf, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getBensMoveis());
                alienacao = movel;
            } else if ("3".equals(tipo)) {
                AlienacaoParticipacaoSocietaria pSocietaria = objDecl.getGCAP().obterAlienacaoPArticipacaoSocietariaPorCPFPeriodo(cpf, dataInicio, dataFim, idAlienacao, (Colecao)objDecl.getGCAP().getpSocietarias());
                alienacao = pSocietaria;
            }
            if (alienacao == null) continue;
            String faixasCalculoImposto = this.obterFaixasCalculoImpostoRegistro75(reg);
            if ("1".equals(tipoApuracao)) {
                alienacao.getCalculoImposto().getFaixasCalculoImposto().setConteudo(faixasCalculoImposto);
                continue;
            }
            if (!"2".equals(tipoApuracao)) continue;
            alienacao.getAjuste().getFaixasCalculoImposto().setConteudo(faixasCalculoImposto);
        }
    }

    private String obterFaixasCalculoImpostoRegistro75(RegistroTxt reg) throws GeracaoTxtException {
        Object faixasCalculoImposto = "";
        Valor faixa1Atual = reg.fieldByName("VR_FAIXA1_ATUAL").asValor();
        Valor faixa1Anterior = reg.fieldByName("VR_FAIXA1_ANTERIOR").asValor();
        Valor faixa1Total = reg.fieldByName("VR_FAIXA1_TOTAL").asValor();
        Valor faixa2Atual = reg.fieldByName("VR_FAIXA2_ATUAL").asValor();
        Valor faixa2Anterior = reg.fieldByName("VR_FAIXA2_ANTERIOR").asValor();
        Valor faixa2Total = reg.fieldByName("VR_FAIXA2_TOTAL").asValor();
        Valor faixa3Atual = reg.fieldByName("VR_FAIXA3_ATUAL").asValor();
        Valor faixa3Anterior = reg.fieldByName("VR_FAIXA3_ANTERIOR").asValor();
        Valor faixa3Total = reg.fieldByName("VR_FAIXA3_TOTAL").asValor();
        Valor faixa4Atual = reg.fieldByName("VR_FAIXA4_ATUAL").asValor();
        Valor faixa4Anterior = reg.fieldByName("VR_FAIXA4_ANTERIOR").asValor();
        Valor faixa4Total = reg.fieldByName("VR_FAIXA4_TOTAL").asValor();
        Valor faixaTAtual = reg.fieldByName("VR_FAIXAT_ATUAL").asValor();
        Valor faixaTAnterior = reg.fieldByName("VR_FAIXAT_ANTERIOR").asValor();
        Valor faixaTTotal = reg.fieldByName("VR_FAIXAT_TOTAL").asValor();
        faixasCalculoImposto = faixa1Total + ";" + faixa1Anterior.formatado() + ";" + faixa1Atual.formatado() + " " + faixa2Total + ";" + faixa2Anterior.formatado() + ";" + faixa2Atual.formatado() + " " + faixa3Total + ";" + faixa3Anterior.formatado() + ";" + faixa3Atual.formatado() + " " + faixa4Total + ";" + faixa4Anterior.formatado() + ";" + faixa4Atual.formatado() + " " + faixaTTotal + ";" + faixaTAnterior.formatado() + ";" + faixaTAtual.formatado();
        return faixasCalculoImposto;
    }

    public void importaRegistro76(List<RegistroTxt> vRegistro, DeclaracaoIRPF declaracao) throws GeracaoTxtException {
        for (int i = 0; i < vRegistro.size(); ++i) {
            RegistroTxt reg = vRegistro.get(i);
            String cpfBeneficiario = reg.fieldByName("NR_CPF_BENEFICIARIO").asString().trim();
            TotalizacaoMoedasAlienadas totalizacaoMoedasAlienadas = declaracao.getGCAP().getColecaoTotalizacaoMoedasAlienadas().obterTotalizacaoPorCPF(cpfBeneficiario);
            if (totalizacaoMoedasAlienadas == null) {
                String dataInicio = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(0, 4)).append(ConstantesGlobais.ANO_BASE).toString();
                String dataFim = new StringBuffer(reg.fieldByName("NR_IDENTIFICACAO").asString().trim().substring(4)).append(ConstantesGlobais.ANO_BASE).toString();
                totalizacaoMoedasAlienadas = new TotalizacaoMoedasAlienadas();
                totalizacaoMoedasAlienadas.getCpf().setConteudo(cpfBeneficiario);
                totalizacaoMoedasAlienadas.getDataInicioPermanencia().setConteudo(dataInicio);
                totalizacaoMoedasAlienadas.getDataFimPermanencia().setConteudo(dataFim);
                declaracao.getGCAP().getColecaoTotalizacaoMoedasAlienadas().add((ObjetoNegocio)totalizacaoMoedasAlienadas);
            }
            String txtMes = reg.fieldByName("NR_MES").asString();
            int indMes = Integer.parseInt(txtMes) - 1;
            MoedasAlienadasMensal mes = totalizacaoMoedasAlienadas.getMes(indMes);
            mes.getMes().setConteudo(mes.obterNomeMesPorValorTxt(txtMes));
            mes.getAlienacoesDolar().setConteudo(reg.fieldByName("VR_ALIENACAO_DOLAR").asValor());
            mes.getAlienacoesConsolidadasDolar().setConteudo(reg.fieldByName("VR_ALIENACAO_CONSOLIDADA_DOLAR").asValor());
            mes.getGanhosCapital().setConteudo(reg.fieldByName("VR_GANHO_CAPITAL").asValor());
            mes.getGanhosCapitalTributavel().setConteudo(reg.fieldByName("VR_GANHO_CAPITAL_TRIBUTAVEL").asValor());
            mes.getAliquotaMedia().setConteudo(reg.fieldByName("VR_ALIQUOTA_MEDIA").asValor());
            mes.getImpostoDevido().setConteudo(reg.fieldByName("VR_IMPOSTO_DEVIDO").asValor());
            mes.getImpostoPago().setConteudo(reg.fieldByName("VR_IMPOSTO_PAGO").asValor());
        }
    }

    public void montarIndicadoresPersistenciaOnline(List<RegistroTxt> vetorRegistros, IdentificadorDeclaracao idDeclaracao, boolean salvarRecuperarOnline) throws GeracaoTxtException {
        RegistroTxt objRegTXT = vetorRegistros.get(0);
        idDeclaracao.getInUtilizouRascunho().setConteudo(Logico.NAO);
        String tpIniciada = objRegTXT.fieldByName("TP_INICIADA").asString();
        idDeclaracao.getTpIniciada().setConteudo(tpIniciada);
        idDeclaracao.getInUtilizouAPP().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_APP").asString());
        idDeclaracao.getInUtilizouAssistidaFontePagadora().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_ASSISTIDA_FONTES_PAGADORAS").asString());
        idDeclaracao.getInUtilizouAssistidaPlanoSaude().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_ASSISTIDA_PLANO_SAUDE").asString());
        idDeclaracao.getInUtilizouOnLine().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_ONLINE").asString());
        idDeclaracao.getPrepreenchida().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_PREPREENCHIDA").asString());
        if (salvarRecuperarOnline) {
            idDeclaracao.getInUtilizouSalvarRecuperarOnLine().setConteudo(Logico.SIM);
        } else {
            idDeclaracao.getInUtilizouSalvarRecuperarOnLine().setConteudo(objRegTXT.fieldByName("IN_UTILIZOU_SALVAR_RECUPERAR_ONLINE").asString());
        }
    }
}

