/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util.scriptlet;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.text.MaskFormatter;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.LogPPGD;

public class FuncoesFormatacao
extends JRDefaultScriptlet {
    private static String corrigirString(String value) {
        if (value == null) {
            value = "";
        }
        return value.replaceAll("(\\A(\\n|\\s|\\t)+)|((\\n|\\s|\\t)+\\z)", "");
    }

    public static String formatarCPF(String value) {
        value = FuncoesFormatacao.corrigirString(value);
        try {
            MaskFormatter mask = new MaskFormatter("###.###.###-##");
            mask.setValueContainsLiteralCharacters(false);
            return mask.valueToString(value);
        }
        catch (ParseException e) {
            LogPPGD.erro((String)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public static String formatarCNPJ(String value) {
        value = FuncoesFormatacao.corrigirString(value);
        try {
            MaskFormatter mask = new MaskFormatter("##.###.###/####-##");
            mask.setValueContainsLiteralCharacters(false);
            return mask.valueToString(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatarNI(String value) {
        if ((value = FuncoesFormatacao.corrigirString(value)).length() < 12) {
            return FuncoesFormatacao.formatarCPF(value);
        }
        return FuncoesFormatacao.formatarCNPJ(value);
    }

    public static String formatarMoeda(String value) {
        value = FuncoesFormatacao.corrigirString(value);
        NumberFormat nf = NumberFormat.getInstance(new Locale("pt", "BR"));
        nf.setMinimumFractionDigits(2);
        return "R$ " + nf.format(new Double(value.replace(',', '.')));
    }

    public static String formatarNome(String value) {
        value = FuncoesFormatacao.corrigirString(value);
        return value.replaceAll("(\\n|\\s|\\t)+", " ");
    }

    public static String getDescricaoPagamentoPrevidenciaPorCodigo(String codigo) {
        codigo = FuncoesFormatacao.corrigirString(codigo);
        int cod = 0;
        String descricao = "";
        try {
            cod = Integer.parseInt(codigo);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (cod) {
            case 1: 
            case 2: {
                descricao = "Previd\u00eancia Complementar (inclusive FAPI)";
                break;
            }
            case 3: {
                descricao = "Contribui\u00e7\u00f5es para as entidades de previd\u00eancia complementar fechadas de natureza p\u00fablica";
            }
        }
        return descricao;
    }

    public static String getDescricaoRendimentoIsento(String codigo) {
        codigo = FuncoesFormatacao.corrigirString(codigo);
        int cod = 0;
        String descricao = "";
        try {
            cod = Integer.parseInt(codigo);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (cod) {
            case 1: {
                descricao = FuncoesFormatacao.obterDescricaoRendIsentos("10");
                break;
            }
            case 2: {
                descricao = FuncoesFormatacao.obterDescricaoRendIsentos("11");
                break;
            }
            case 3: {
                descricao = FuncoesFormatacao.obterDescricaoRendIsentos("09");
                break;
            }
            case 4: {
                descricao = FuncoesFormatacao.obterDescricaoRendIsentos("13");
                break;
            }
            case 5: {
                descricao = FuncoesFormatacao.obterDescricaoRendIsentos("04");
                break;
            }
            case 6: {
                descricao = "Benef\u00edcios indiretos e reembolso de despesas recebidos por volunt\u00e1rio da Fifa.";
                break;
            }
            case 7: {
                descricao = FuncoesFormatacao.obterDescricaoRendIsentos("02");
                break;
            }
            case 8: {
                descricao = FuncoesFormatacao.obterDescricaoRendIsentos("01");
                break;
            }
            case 9: {
                descricao = FuncoesFormatacao.obterDescricaoRendIsentos("16");
                break;
            }
            case 10: {
                descricao = "Di\u00e1rias e ajuda de custo.";
                break;
            }
            case 11: {
                descricao = "Abono pecuni\u00e1rio.";
            }
        }
        return descricao;
    }

    private static String obterDescricaoRendIsentos(String codigo) {
        String descricao = "";
        for (ElementoTabela et : CadastroTabelasIRPF.recuperarTiposRendimentosIsentos()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            descricao = et.getConteudo(2);
            break;
        }
        return descricao;
    }

    public static String getDescricaoRendTribExclusiva(String codigo) {
        codigo = FuncoesFormatacao.corrigirString(codigo);
        int cod = 0;
        String descricao = "";
        try {
            cod = Integer.parseInt(codigo);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (cod) {
            case 1: {
                descricao = FuncoesFormatacao.obterDescricaoRendTribExclusiva("10");
                break;
            }
            case 2: {
                descricao = FuncoesFormatacao.obterDescricaoRendTribExclusiva("11");
            }
        }
        return descricao;
    }

    private static String obterDescricaoRendTribExclusiva(String codigo) {
        String descricao = "";
        for (ElementoTabela et : CadastroTabelasIRPF.recuperarTiposRendimentosTributacaoExclusiva()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            descricao = et.getConteudo(2);
            break;
        }
        return descricao;
    }

    public static String getMesExtenso(String mes) {
        mes = FuncoesFormatacao.corrigirString(mes);
        int cod = 0;
        String mesExtenso = "";
        try {
            cod = Integer.parseInt(mes) - 1;
            Calendar calendar = Calendar.getInstance(new Locale("pt", "BR"));
            calendar.set(2000, cod, 1);
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM", new Locale("pt", "BR"));
            mesExtenso = dateFormat.format(calendar.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mesExtenso;
    }

    public static void main(String[] args) {
        System.out.println("M\u00eas-1: " + FuncoesFormatacao.formatarNome("\n\n00000\n11111\n\n\n22222\n    \n  33333        "));
    }
}

