/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.impressao;

import java.awt.Frame;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.view.JasperViewer;
import serpro.ppgd.formatosexternos.RelatorioMultiploXML;
import serpro.ppgd.irpf.impressao.Lancamento;
import serpro.ppgd.irpf.impressao.RelatorioUtil;
import serpro.ppgd.irpf.impressao.RendimentosRecebidosPFCollectionDS;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.ContasAno;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.LogPPGD;

public class ImpressaoRendimentosRecebidosPF {
    private List<List<Lancamento>> listRendPF;
    private String titulo;
    private RelatorioMultiploXML relatorio;
    private Map<String, Object> parametros = new HashMap<String, Object>();
    private String cpfcnpj;
    private String nome;
    private InputStream rel1;
    private String rel2;
    private RendimentosRecebidosPFCollectionDS pcrPF;
    private ContasAno escrituracao;
    private String nomePdf;

    public ImpressaoRendimentosRecebidosPF(String aTitulo, String aRelatorioJasper, String bRelatorioJasper, ContasAno escrituracao, String cpfCnpj, String nome) {
        this.nome = nome;
        this.escrituracao = escrituracao;
        this.cpfcnpj = cpfCnpj;
        this.titulo = aTitulo;
        this.nomePdf = IRPFUtil.obterNomeArquivoPDF((String)this.cpfcnpj, (String)"rendimentos-recebidos-pf", null, null);
        this.rel1 = Thread.currentThread().getContextClassLoader().getResourceAsStream(aRelatorioJasper);
        this.rel2 = bRelatorioJasper;
        this.parametros.put("PATH", "");
        this.parametros.put("cpf", this.cpfcnpj);
        this.parametros.put("nome", nome);
        this.parametros.put("exercicio", ConstantesGlobais.EXERCICIO);
        this.listRendPF = this.preencheLista();
        this.pcrPF = new RendimentosRecebidosPFCollectionDS(this.listRendPF);
    }

    private List<List<Lancamento>> preencheLista() {
        ArrayList<List<Lancamento>> itens = new ArrayList<List<Lancamento>>();
        for (int i = 1; i <= 12; ++i) {
            ArrayList<Lancamento> lancamentos = new ArrayList<Lancamento>();
            for (ObjetoNegocio obj : this.escrituracao.obterMesEscrituracaoPorNumeroMes(i).itens()) {
                Conta conta = (Conta)obj;
                String numMes = conta.getDataMesAno().formatado().length() >= 2 ? conta.getDataMesAno().formatado().substring(0, 2) : "";
                String siglaMes = numMes.length() == 2 ? ContasMes.obterSiglaMes((int)Integer.valueOf(numMes)) : "";
                Lancamento lancamento = new Lancamento("", numMes, siglaMes, conta.getValor().formatado(), conta.getCpfTitularPagamento().formatado(), conta.getCpfBeneficiarioServico().formatado());
                if (conta.getCpfTitularPagamento().formatado().indexOf(" ") != -1) {
                    lancamento.setCpfTitularPagamento("n\u00e3o informado");
                }
                if (conta.getIndBeneficiarioNaoPossuiCPF().formatado().equals("1")) {
                    lancamento.setCpfBeneficiario("CPF n\u00e3o informado");
                } else if (conta.getCpfBeneficiarioServico().formatado().indexOf(" ") != -1) {
                    lancamento.setCpfBeneficiario("n\u00e3o informado");
                }
                lancamentos.add(lancamento);
            }
            Collections.sort(lancamentos, new Comparator<Lancamento>(){
                private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");

                @Override
                public int compare(Lancamento o1, Lancamento o2) {
                    try {
                        Date data1 = this.sdf.parse(o1.getNumMes());
                        Date data2 = this.sdf.parse(o2.getNumMes());
                        return data1.compareTo(data2);
                    }
                    catch (ParseException parseException) {
                        return 0;
                    }
                }
            });
            if (lancamentos.isEmpty()) continue;
            itens.add(lancamentos);
        }
        return itens;
    }

    public void visualizar() {
        if (IRPFUtil.isAccessibleMode()) {
            this.imprimir();
        }
        try {
            JasperPrint impressao = JasperFillManager.fillReport((InputStream)this.rel1, this.parametros, (JRDataSource)this.pcrPF);
            JasperViewer viewer = new JasperViewer(impressao, false);
            viewer.setTitle(this.titulo);
            viewer.setIconImage(Frame.getFrames()[0].getIconImage());
            viewer.setVisible(true);
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    public void imprimir() {
        try {
            JasperPrint impressao = JasperFillManager.fillReport((InputStream)this.rel1, this.parametros, (JRDataSource)this.pcrPF);
            RelatorioUtil.removerPaginasEmBranco(impressao);
            JasperPrintManager.printReport((JasperPrint)impressao, (boolean)false);
        }
        catch (JRException e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    public void gerarPDF() {
        try {
            JasperPrint impressao = JasperFillManager.fillReport((InputStream)this.rel1, this.parametros, (JRDataSource)this.pcrPF);
            RelatorioUtil.removerPaginasEmBranco(impressao);
            byte[] bytes = JasperExportManager.exportReportToPdf((JasperPrint)impressao);
            IRPFUtil.exibirArquivoNavegador((byte[])bytes, (String)this.nomePdf);
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }
}

