/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.impressao;

import serpro.ppgd.irpf.impressao.RelatorioDeclaracao;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.ConstantesGlobais;

public class ImpressaoDeclaracao {
    private RelatorioDeclaracao relatorio;
    private String xmlDados;
    private boolean relatorioVazio;
    private int tipoOperacao;
    private String nomeArquivo;

    public ImpressaoDeclaracao() {
    }

    public ImpressaoDeclaracao(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz, int tipoOperacao, String nomeArquivo) {
        String jasper = aRelatorioJasper;
        this.relatorio = new RelatorioDeclaracao(aTitulo, jasper, aXml, aRaiz, tipoOperacao, nomeArquivo);
        this.relatorioVazio = false;
        this.tipoOperacao = tipoOperacao;
    }

    public ImpressaoDeclaracao(int tipoOperacao, String nomeArquivo) {
        this.relatorioVazio = true;
        this.tipoOperacao = tipoOperacao;
        this.nomeArquivo = nomeArquivo;
    }

    public void addImpressaoDeclaracao(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz) {
        if (this.relatorioVazio) {
            String jasper = aRelatorioJasper;
            this.relatorio = new RelatorioDeclaracao(aTitulo, jasper, aXml, aRaiz, this.tipoOperacao, this.nomeArquivo);
            this.relatorio.addParametroUltimo("anobase", ConstantesGlobais.ANO_BASE);
            this.relatorio.addParametroUltimo("exercicio", ConstantesGlobais.EXERCICIO);
            this.relatorioVazio = false;
        } else {
            String jasper = aRelatorioJasper;
            this.relatorio.addRelatorioXML(aTitulo, jasper, aXml, aRaiz);
            this.relatorio.addParametroUltimo("anobase", ConstantesGlobais.ANO_BASE);
            this.relatorio.addParametroUltimo("exercicio", ConstantesGlobais.EXERCICIO);
        }
    }

    public void addParametro(String nome, String valor, int indice) {
        this.relatorio.addParametro(nome, valor, indice);
    }

    public void addParametro(String nome, String valor) {
        this.relatorio.addParametro(nome, valor);
    }

    public void addParametroUltimo(String nome, String valor) {
        this.relatorio.addParametroUltimo(nome, valor);
    }

    public void visualizar() {
        if (IRPFUtil.isAccessibleMode()) {
            this.relatorio.imprimir();
        } else {
            this.relatorio.visualizar();
        }
    }

    public static class ItemPendencia {
        private String tipo;
        private String titulo;
        private String campo;
        private String icone;

        public ItemPendencia() {
            this.tipo = "";
            this.titulo = "";
            this.campo = "";
            this.icone = "";
        }

        public ItemPendencia(String numero, String titulo, String campo, String tipo) {
            this.tipo = numero;
            this.titulo = titulo;
            this.campo = campo;
            this.icone = tipo;
        }

        public String getCampo() {
            return this.campo;
        }

        public void setCampo(String campo) {
            this.campo = campo;
        }

        public String getTipo() {
            return this.tipo;
        }

        public void setTipo(String numero) {
            this.tipo = numero;
        }

        public String getIcone() {
            return this.icone;
        }

        public void setIcone(String tipo) {
            this.icone = tipo;
        }

        public String getTitulo() {
            return this.titulo;
        }

        public void setTitulo(String titulo) {
            this.titulo = titulo;
        }
    }
}

