/*
 * Decompiled with CFR 0.152.
 */
package serpro.receitanet.envelope;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import serpro.receitanet.envelope.AssinaturaEnvelope;
import serpro.receitanet.envelope.ByteList;
import serpro.receitanet.envelope.Conversoes;
import serpro.receitanet.envelope.ExcecaoEnvelope;
import serpro.receitanet.envelope.Misc;

public class Envelope {
    public static final int TIPO_CPF = 1;
    public static final int TIPO_CNPJ = 2;
    public static final int TIPO_NIRF = 3;
    private boolean _versaoDesenvolvimento;
    private boolean _certificavel = true;
    private String _identificadorSistema;
    private String _uf;
    private String _pendenciaUpload;
    private String _exercicioPA;
    private String _exercicioArquivo;
    private String _ni;
    private Integer _periodoCompetencia;
    private Integer _anoCompetencia;
    private Integer _versaoPA;
    private String _versaoEnvelope;
    private Integer _idArquivo;
    private int _tipoNI;
    private Long _tamanhoAssinado = new Long(0L);
    private int _indicadorRetificador;
    private List<AssinaturaEnvelope> _assinaturas;
    private byte[] _hashArquivo;
    private byte[] _dadosValidador;
    private String _nomeDeclarado;
    private String _rotuloNomeDeclarado;
    private Map<String, String> _dadosExtras;
    private long _posEnvelope = -1L;
    private long _controleRFB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] obterEnvelope(File arquivo) throws IOException {
        RandomAccessFile arq = null;
        int bytesLidos = 0;
        try {
            arq = new RandomAccessFile(arquivo, "r");
            String match = "tenatiecer<";
            if (arq.length() == 0L) {
                byte[] byArray = null;
                return byArray;
            }
            long i = arq.length() - 1L;
            boolean encontrou = false;
            int MAX_NUM_BYTES = 131072;
            assert (!encontrou);
            int j = 0;
            arq.seek(i);
            while (!encontrou) {
                char ch = (char)arq.read();
                ++bytesLidos;
                if (ch == match.charAt(j)) {
                    if (++j == match.length()) {
                        encontrou = true;
                    }
                } else {
                    j = 0;
                }
                if (--i < 0L || bytesLidos >= 131072) {
                    byte[] byArray = null;
                    return byArray;
                }
                arq.seek(i);
            }
            assert (encontrou);
            arq.read();
            byte[] envelope = new byte[bytesLidos];
            int numRead = 0;
            for (int offset = 0; offset < envelope.length && (numRead = arq.read(envelope, offset, envelope.length - offset)) >= 0; offset += numRead) {
            }
            int k = envelope.length - 1;
            byte b = envelope[k];
            while (b == 32 || b == 10 || b == 13 || b == 9) {
                b = envelope[--k];
            }
            byte[] tagFechamento = Conversoes.bytesFromString(">tenatiecer/<");
            for (int m = 0; m < tagFechamento.length; ++m) {
                if (tagFechamento[m] == envelope[k - m]) continue;
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = envelope;
            return byArray;
        }
        finally {
            try {
                if (arq != null) {
                    arq.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] obterEnvelope(byte[] arquivo) {
        int bytesLidos = 0;
        String match = "tenatiecer<";
        if (arquivo.length == 0) {
            return null;
        }
        int i = arquivo.length - 1;
        boolean encontrou = false;
        int MAX_NUM_BYTES = 131072;
        assert (!encontrou);
        int j = 0;
        while (!encontrou) {
            char ch = (char)arquivo[i];
            ++bytesLidos;
            if (ch == match.charAt(j)) {
                if (++j == match.length()) {
                    encontrou = true;
                }
            } else {
                j = 0;
            }
            if (--i >= 0 && bytesLidos < 131072) continue;
            return null;
        }
        assert (encontrou);
        byte[] envelope = new byte[bytesLidos];
        System.arraycopy(arquivo, arquivo.length - bytesLidos, envelope, 0, bytesLidos);
        int k = envelope.length - 1;
        byte b = envelope[k];
        while (b == 32 || b == 10 || b == 13 || b == 9) {
            b = envelope[--k];
        }
        byte[] tagFechamento = Conversoes.bytesFromString(">tenatiecer/<");
        for (int m = 0; m < tagFechamento.length; ++m) {
            if (tagFechamento[m] == envelope[k - m]) continue;
            return null;
        }
        return envelope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] removerEnvelope(File arquivo) throws IOException {
        byte[] envelope = Envelope.obterEnvelope(arquivo);
        if (envelope == null) {
            return null;
        }
        RandomAccessFile arq = null;
        try {
            arq = new RandomAccessFile(arquivo, "rw");
            arq.setLength(arq.length() - (long)envelope.length);
        }
        finally {
            if (arq != null) {
                arq.close();
            }
        }
        return envelope;
    }

    public boolean importar(File arquivo) throws IOException, ExcecaoEnvelope {
        byte[] envelope = Envelope.obterEnvelope(arquivo);
        boolean fOk = this.importar(envelope);
        if (fOk) {
            this._posEnvelope = arquivo.length() - (long)envelope.length;
        }
        return fOk;
    }

    public boolean importar(byte[] envelope) throws ExcecaoEnvelope {
        Document doc;
        if (envelope == null) {
            return false;
        }
        try {
            doc = Envelope.carregarXML(envelope);
        }
        catch (SAXException e) {
            Logger.getLogger("serpro.receitanet").info(e.getMessage());
            return false;
        }
        if (!Envelope.validarEstruturaEnvelope(doc)) {
            return false;
        }
        if (!this.validarHashDoEnvelope(envelope)) {
            return false;
        }
        return this.obterDadosDoEnvelope(doc);
    }

    public boolean eCertificavel() {
        return this._certificavel;
    }

    public boolean eVersaoDesenvolvimento() {
        return this._versaoDesenvolvimento;
    }

    public int getAnoCompetencia() {
        return this._anoCompetencia;
    }

    public List<AssinaturaEnvelope> getAssinaturas() {
        return Collections.unmodifiableList(this._assinaturas);
    }

    public long getControleRFB() {
        return this._controleRFB;
    }

    public String getCriticaPendenciaUpload() {
        return this._pendenciaUpload;
    }

    public Map<String, String> getDadosExtras() {
        return Collections.unmodifiableMap(this._dadosExtras);
    }

    public byte[] getDadosValidador() {
        return this._dadosValidador;
    }

    public String getExercicioArquivo() {
        return this._exercicioArquivo;
    }

    public String getExercicioPA() {
        return this._exercicioPA;
    }

    public byte[] getHashArquivo() {
        return this._hashArquivo;
    }

    public int getCodigoTipoArquivo() {
        return this._idArquivo;
    }

    public String getSistema() {
        return this._identificadorSistema;
    }

    public String getNI() {
        return this._ni;
    }

    public String getNome() {
        return this._nomeDeclarado;
    }

    public String getRotuloNome() {
        return this._rotuloNomeDeclarado;
    }

    public int getPeriodoCompetencia() {
        return this._periodoCompetencia;
    }

    public long getPosicaoEnvelope() {
        return this._posEnvelope;
    }

    public int getRetificador() {
        return this._indicadorRetificador;
    }

    public long getTamanhoAssinado() {
        return this._tamanhoAssinado;
    }

    public int getTipoNI() {
        return this._tipoNI;
    }

    public String getUF() {
        return this._uf;
    }

    public int getVersaoPA() {
        return this._versaoPA;
    }

    private static List<Node> getNosExtrasEnvelope(Document doc) {
        ArrayList<Node> extras = new ArrayList<Node>();
        NodeList filhosRaiz = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < filhosRaiz.getLength(); ++i) {
            NamedNodeMap atributos;
            Node noAtributo;
            Node n = filhosRaiz.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().toLowerCase().startsWith("ext_") || (noAtributo = (atributos = n.getAttributes()).getNamedItem("valor")) == null) continue;
            extras.add(n);
        }
        return extras;
    }

    private static String removerPrefixoExtra(String nomeTagExtra) {
        if (!nomeTagExtra.toLowerCase().startsWith("ext_")) {
            throw new IllegalArgumentException("Nome de dado adicional deve possuir o prefixo ext_");
        }
        return nomeTagExtra.substring(4);
    }

    private static boolean conferirCampoNumerico(String valor, int maxLength) {
        char[] caracteres = valor.toCharArray();
        boolean ok = true;
        for (int i = 0; i < caracteres.length; ++i) {
            ok = ok && Character.isDigit(caracteres[i]);
        }
        if (maxLength >= 0) {
            ok = ok && valor.length() <= maxLength;
        }
        return ok;
    }

    private static String obterAtributo(Node nodo, String nomeAtributo) {
        NamedNodeMap atributos = nodo.getAttributes();
        Node noAtributo = atributos.getNamedItem(nomeAtributo);
        if (noAtributo == null) {
            return null;
        }
        return noAtributo.getNodeValue();
    }

    private static boolean validarEstruturaEnvelope(Document envelope) throws ExcecaoEnvelope {
        Map<String, Node> nos = Envelope.getNosFilhos(envelope.getDocumentElement());
        if (!Envelope.validarNo(nos.get("receitanet"), true, "id,versao", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("desenvolvimento"), false, "", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("certificavel"), false, "", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("retificadora"), true, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("sistema"), true, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("formulario"), true, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("exercicio_pgd"), false, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("exercicio_arquivo"), true, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("pend_upload"), false, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("versao_pgd"), true, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("uf"), true, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("id"), true, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("competencia"), true, "periodo,ano", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("nome"), true, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("ni"), true, "tipo,valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("area_reservada"), true, "", true)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("controle_rfb"), true, "valor", false)) {
            return false;
        }
        if (!Envelope.validarNo(nos.get("assinaturas"), false, "num_bytes_assinados", false)) {
            return false;
        }
        if (nos.get("assinaturas") != null) {
            Node noAssinatura = nos.get("assinaturas");
            Node n = noAssinatura.getFirstChild();
            while (n != null) {
                if (!n.getNodeName().equals("pkcs7")) {
                    n = n.getNextSibling();
                    continue;
                }
                if (!Envelope.validarNo(n, false, "", true)) {
                    return false;
                }
                n = n.getNextSibling();
            }
        }
        return true;
    }

    private static Map<String, Node> getNosFilhos(Node no) {
        HashMap<String, Node> nos = new HashMap<String, Node>();
        nos.put(no.getNodeName(), no);
        NodeList filhosRaiz = no.getChildNodes();
        for (int i = 0; i < filhosRaiz.getLength(); ++i) {
            Node n = filhosRaiz.item(i);
            if (n.getNodeType() != 1) continue;
            nos.put(n.getNodeName(), n);
        }
        return nos;
    }

    private static boolean validarNo(Node no, boolean eObrigatorio, String atributosObrigatorios, boolean devePossuirTextoEntreTags) {
        if (eObrigatorio && no == null) {
            return false;
        }
        if (!eObrigatorio && no == null) {
            return true;
        }
        String[] atributos = atributosObrigatorios.equals("") ? new String[]{} : atributosObrigatorios.split(",");
        for (int k = 0; k < atributos.length; ++k) {
            String atributo = atributos[k];
            if (no.getAttributes().getNamedItem(atributo) != null) continue;
            return false;
        }
        if (devePossuirTextoEntreTags) {
            NodeList filhosTag = no.getChildNodes();
            boolean temFilhoTexto = false;
            for (int iFilhosTag = 0; iFilhosTag < filhosTag.getLength(); ++iFilhosTag) {
                Node filho = filhosTag.item(iFilhosTag);
                if (filho.getNodeType() != 3 || filho.getNodeValue().length() <= 0) continue;
                temFilhoTexto = true;
            }
            if (!temFilhoTexto) {
                return false;
            }
        }
        return true;
    }

    private static Document carregarXML(byte[] envelope) throws SAXException, ExcecaoEnvelope {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        if (dbf == null) {
            throw new ExcecaoEnvelope("Erro ao ler envelope.");
        }
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ExcecaoEnvelope("Erro ao ler envelope.");
        }
        Document doc = null;
        try {
            doc = db.parse(new InputSource(new InputStreamReader((InputStream)new ByteArrayInputStream(envelope), "ISO-8859-1")));
        }
        catch (IOException e) {
            throw new ExcecaoEnvelope("Erro ao ler envelope.");
        }
        return doc;
    }

    private boolean validarHashDoEnvelope(byte[] envelope) throws ExcecaoEnvelope {
        int i;
        byte[] match = new byte[]{105, 100, 61, 34};
        boolean encontrou = false;
        int j = 0;
        for (i = 0; i < envelope.length && !encontrou; ++i) {
            if (match[j] == envelope[i]) {
                if (++j != match.length) continue;
                encontrou = true;
                continue;
            }
            j = 0;
        }
        if (encontrou) {
            byte[] hashEnvCalculado;
            int inicioHash = i - match.length;
            ByteList hash = new ByteList();
            while (i < envelope.length && envelope[i] != 34) {
                hash.add(envelope[i]);
                ++i;
            }
            byte[] hashEnvelope = hash.toArray();
            byte[] envelopeSemHash = new byte[envelope.length - hashEnvelope.length - match.length - 2];
            System.arraycopy(envelope, 0, envelopeSemHash, 0, inicioHash);
            System.arraycopy(envelope, i + 2, envelopeSemHash, inicioHash, envelope.length - (i + 2));
            hashEnvelope = Conversoes.bytesFromBase64Bytes(hashEnvelope);
            try {
                hashEnvCalculado = Misc.calcularHash("MD5", envelopeSemHash);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ExcecaoEnvelope("Algoritmo MD5 n\u00e3o dispon\u00edvel");
            }
            return Arrays.equals(hashEnvelope, hashEnvCalculado);
        }
        return false;
    }

    private boolean obterDadosDoEnvelope(Document envelope) throws ExcecaoEnvelope {
        if (!this.carregarVersaoEnvelope(envelope)) {
            return false;
        }
        this._versaoDesenvolvimento = this.obterTagUnicaOpcional(envelope, "desenvolvimento") != null;
        boolean bl = this._certificavel = this.obterTagUnicaOpcional(envelope, "certificavel") != null;
        if (!(this.carregarIdSistema(envelope) && this.carregarCompetencia(envelope) && this.carregarVersaoPA(envelope) && this.carregarUF(envelope) && this.carregarCritUpload(envelope) && this.carregarExercicios(envelope) && this.carregarHashArquivo(envelope) && this.carregarNI(envelope) && this.carregarRetificador(envelope) && this.carregarFormulario(envelope) && this.carregarNome(envelope) && this.carregarDadosValidador(envelope) && this.carregarControleRFB(envelope) && this.carregarAssinaturas(envelope))) {
            return false;
        }
        this.carregarDadosExtras(envelope);
        return true;
    }

    private void carregarDadosExtras(Document doc) {
        this._dadosExtras = new HashMap<String, String>();
        List<Node> lsNoExtra = Envelope.getNosExtrasEnvelope(doc);
        for (Node noExtra : lsNoExtra) {
            String nomeTagExtra = noExtra.getNodeName();
            String valor = noExtra.getAttributes().getNamedItem("valor").getNodeValue();
            if (valor == null || nomeTagExtra == null) continue;
            this._dadosExtras.put(Envelope.removerPrefixoExtra(nomeTagExtra), valor);
        }
    }

    private boolean carregarAssinaturas(Document doc) {
        Node noAssi = this.obterTagUnicaOpcional(doc, "assinaturas");
        if (noAssi != null) {
            NamedNodeMap atributos = noAssi.getAttributes();
            Node atributo = atributos.getNamedItem("num_bytes_assinados");
            if (atributo == null) {
                return false;
            }
            try {
                if (!Envelope.conferirCampoNumerico(atributo.getNodeValue(), -1)) {
                    return false;
                }
                this._tamanhoAssinado = new Long(atributo.getNodeValue());
            }
            catch (NumberFormatException e) {
                return false;
            }
            List<Node> nosPKCS7 = this.obterFilhos(noAssi, "pkcs7");
            this._assinaturas = new ArrayList<AssinaturaEnvelope>();
            for (int i = 0; i < nosPKCS7.size(); ++i) {
                Node nodo = nosPKCS7.get(i);
                String conteudo = nodo.getFirstChild().getNodeValue().trim();
                this._assinaturas.add(AssinaturaEnvelope.criar(Conversoes.bytesFromBase64String(conteudo)));
            }
        }
        return true;
    }

    private boolean carregarControleRFB(Document doc) throws ExcecaoEnvelope {
        Node nodo = this.obterTagUnicaObrigatoria(doc, "controle_rfb");
        NamedNodeMap atributos = nodo.getAttributes();
        String valorControleRFB = (nodo = atributos.getNamedItem("valor")).getNodeValue().trim();
        if (!Envelope.conferirCampoNumerico(valorControleRFB, 10)) {
            return false;
        }
        long tempRFB = Long.parseLong(valorControleRFB);
        if (!Misc.eValidoControleRFB(tempRFB)) {
            return false;
        }
        this._controleRFB = tempRFB;
        return true;
    }

    private boolean carregarDadosValidador(Document doc) throws ExcecaoEnvelope {
        Node nodo = this.obterTagUnicaObrigatoria(doc, "area_reservada");
        String dadosValidador = nodo.getFirstChild().getNodeValue().trim();
        this._dadosValidador = Conversoes.bytesFromBase64String(dadosValidador);
        return true;
    }

    private boolean carregarNome(Document doc) throws ExcecaoEnvelope {
        Node nodo = this.obterTagUnicaObrigatoria(doc, "nome");
        this._nomeDeclarado = Envelope.obterAtributo(nodo, "valor");
        if (this._nomeDeclarado == null) {
            return false;
        }
        this._rotuloNomeDeclarado = Envelope.obterAtributo(nodo, "label");
        return true;
    }

    private boolean carregarFormulario(Document doc) throws ExcecaoEnvelope {
        Node nodo = this.obterTagUnicaObrigatoria(doc, "formulario");
        NamedNodeMap atributos = nodo.getAttributes();
        if (!Envelope.conferirCampoNumerico((nodo = atributos.getNamedItem("valor")).getNodeValue(), 5)) {
            return false;
        }
        this._idArquivo = new Integer(nodo.getNodeValue());
        return true;
    }

    private boolean carregarRetificador(Document doc) {
        Node noRet = this.obterTagUnicaOpcional(doc, "retificadora");
        if (noRet == null) {
            boolean original = false;
            this._indicadorRetificador = 0;
        } else {
            NamedNodeMap atributos = noRet.getAttributes();
            Node nodo = atributos.getNamedItem("valor");
            if (!Envelope.conferirCampoNumerico(nodo.getNodeValue(), 2)) {
                return false;
            }
            this._indicadorRetificador = Integer.parseInt(nodo.getNodeValue());
        }
        return true;
    }

    private boolean carregarNI(Document doc) throws ExcecaoEnvelope {
        Node nodo = this.obterTagUnicaObrigatoria(doc, "ni");
        this._ni = Envelope.obterAtributo(nodo, "valor");
        if (this._ni == null) {
            return false;
        }
        String stTipo = Envelope.obterAtributo(nodo, "tipo");
        if (stTipo == null) {
            return false;
        }
        if (!Envelope.conferirCampoNumerico(stTipo, 1)) {
            return false;
        }
        int codTipoNI = Integer.parseInt(stTipo);
        if (codTipoNI != 1 && codTipoNI != 2 && codTipoNI != 3) {
            return false;
        }
        this._tipoNI = codTipoNI;
        return true;
    }

    private boolean carregarHashArquivo(Document doc) throws ExcecaoEnvelope {
        Node nodo = this.obterTagUnicaObrigatoria(doc, "id");
        NamedNodeMap atributos = nodo.getAttributes();
        nodo = atributos.getNamedItem("valor");
        this._hashArquivo = Conversoes.bytesFromBase64String(nodo.getNodeValue());
        return true;
    }

    private boolean carregarExercicios(Document doc) throws ExcecaoEnvelope {
        NamedNodeMap atributos;
        Node nodo = this.obterTagUnicaOpcional(doc, "exercicio_pgd");
        if (nodo != null) {
            atributos = nodo.getAttributes();
            if (!Envelope.conferirCampoNumerico((nodo = atributos.getNamedItem("valor")).getNodeValue(), 4)) {
                return false;
            }
            this._exercicioPA = nodo.getNodeValue();
        }
        nodo = this.obterTagUnicaObrigatoria(doc, "exercicio_arquivo");
        atributos = nodo.getAttributes();
        if (!Envelope.conferirCampoNumerico((nodo = atributos.getNamedItem("valor")).getNodeValue(), 4)) {
            return false;
        }
        this._exercicioArquivo = nodo.getNodeValue();
        return true;
    }

    private boolean carregarCritUpload(Document doc) {
        Node noPend = this.obterTagUnicaOpcional(doc, "pend_upload");
        if (noPend != null) {
            NamedNodeMap atributos = noPend.getAttributes();
            Node nodo = atributos.getNamedItem("valor");
            this._pendenciaUpload = nodo.getNodeValue();
        }
        return true;
    }

    private boolean carregarUF(Document doc) throws ExcecaoEnvelope {
        Node nodo = this.obterTagUnicaObrigatoria(doc, "uf");
        NamedNodeMap atributos = nodo.getAttributes();
        if ((nodo = atributos.getNamedItem("valor")).getNodeValue().length() != 2) {
            return false;
        }
        this._uf = nodo.getNodeValue();
        return true;
    }

    private boolean carregarVersaoPA(Document doc) throws ExcecaoEnvelope {
        Node nodo = this.obterTagUnicaObrigatoria(doc, "versao_pgd");
        NamedNodeMap atributos = nodo.getAttributes();
        if (!Envelope.conferirCampoNumerico((nodo = atributos.getNamedItem("valor")).getNodeValue(), 3)) {
            return false;
        }
        this._versaoPA = new Integer(nodo.getNodeValue());
        return true;
    }

    private boolean carregarCompetencia(Document doc) throws ExcecaoEnvelope {
        Node nodo = this.obterTagUnicaObrigatoria(doc, "competencia");
        NamedNodeMap atributos = nodo.getAttributes();
        if (!Envelope.conferirCampoNumerico((nodo = atributos.getNamedItem("periodo")).getNodeValue(), 2)) {
            return false;
        }
        this._periodoCompetencia = new Integer(nodo.getNodeValue());
        nodo = atributos.getNamedItem("ano");
        if (!Envelope.conferirCampoNumerico(nodo.getNodeValue(), 4)) {
            return false;
        }
        this._anoCompetencia = new Integer(nodo.getNodeValue());
        return true;
    }

    private boolean carregarIdSistema(Document doc) throws ExcecaoEnvelope {
        Node nodo = this.obterTagUnicaObrigatoria(doc, "sistema");
        NamedNodeMap atributos = nodo.getAttributes();
        if ((nodo = atributos.getNamedItem("valor")).getNodeValue().length() == 0) {
            return false;
        }
        this._identificadorSistema = nodo.getNodeValue();
        return true;
    }

    private boolean carregarVersaoEnvelope(Document doc) {
        this._versaoEnvelope = doc.getDocumentElement().getAttributes().getNamedItem("versao").getNodeValue();
        return this._versaoEnvelope.equalsIgnoreCase("1");
    }

    private Node obterTagUnicaObrigatoria(Document doc, String nomeTag) throws ExcecaoEnvelope {
        Node encontrado = this.obterTagUnicaOpcional(doc, nomeTag);
        if (encontrado == null) {
            throw new ExcecaoEnvelope("O envelope do arquivo est\u00e1 incompleto.");
        }
        return encontrado;
    }

    private Node obterTagUnicaOpcional(Document doc, String nomeTag) {
        NodeList list = doc.getDocumentElement().getChildNodes();
        Node encontrado = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 1 || !item.getNodeName().equals(nomeTag)) continue;
            encontrado = item;
        }
        return encontrado;
    }

    private List<Node> obterFilhos(Node no, String nomeTag) {
        ArrayList<Node> saida = new ArrayList<Node>();
        NodeList list = no.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            if (item.getNodeType() != 1 || !item.getNodeName().equals(nomeTag)) continue;
            saida.add(item);
        }
        return saida;
    }
}

