/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.barcodedesigners;

import java.awt.Graphics;
import java.awt.Point;
import serpro.ppgd.formatosexternos.barcodedesigners.BarCode2DRendererIf;

public abstract class AbstractBarCode2DRenderer
implements BarCode2DRendererIf {
    protected String pattern;
    protected int quietZoneWidth;
    public static final int DEFAULT_BARCODE_HEIGHT = 25;
    public static final int DEFAULT_QUIETZONE_WIDTH = 22;
    public static final int WIDE_ELEMENT_WIDTH = 4;
    public static final int NARROW_ELEMENT_WIDTH = 2;

    public AbstractBarCode2DRenderer() {
        this.pattern = "";
        this.quietZoneWidth = 22;
    }

    public AbstractBarCode2DRenderer(String t) {
        this.pattern = !this.invalidPattern(t) ? t : "";
        this.quietZoneWidth = 22;
    }

    public AbstractBarCode2DRenderer(String t, int qzw) {
        this.pattern = !this.invalidPattern(t) ? t : "";
        this.quietZoneWidth = qzw;
    }

    @Override
    public abstract void render(Graphics var1, int var2, int var3, int var4);

    public void render(Graphics g, Point p, int height) {
        this.render(g, p.x, p.y, height);
    }

    public void render(Graphics g, int x, int y) {
        this.render(g, x, y, 25);
    }

    public void render(Graphics g, Point p) {
        this.render(g, p.x, p.y, 25);
    }

    @Override
    public void setQuietZoneWidth(int qzw) {
        this.quietZoneWidth = qzw;
    }

    @Override
    public int getQuietZoneWidth() {
        return this.quietZoneWidth;
    }

    @Override
    public void setPattern(String t) {
        this.pattern = !this.invalidPattern(t) ? t : "";
    }

    private boolean invalidPattern(String t) {
        if (t == null) {
            return true;
        }
        if (t.length() == 0) {
            return true;
        }
        block3: for (int i = 0; i < t.length(); ++i) {
            switch (t.charAt(i)) {
                case '!': 
                case 'N': 
                case 'W': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }
}

