;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: wasm-opt %s --enable-bulk-memory --post-emscripten -S -o - | filecheck %s

;; Checks that the start/stop exports are removed and that the data they
;; refer to is either zero'd out, or the segment emptied.

;; Two of the segments used here are active, so their offsets are trivial
;; to dirive.  One segment is passive and its offset is derived from the
;; memory.init instruction.

;; Explictly use a data address that is larger then INT_MAX to verify
;; that these offset are correctly interpreted as unsigned.

(module
 ;; CHECK:      (type $0 (func))

 ;; CHECK:      (global $em_asm_start i32 (i32.const 1000))
 (global $em_asm_start i32 (i32.const 1000))
 ;; CHECK:      (global $em_asm_stop i32 (i32.const 1011))
 (global $em_asm_stop i32 (i32.const 1011))
 ;; CHECK:      (global $em_js_start i32 (i32.const -1294967290))
 (global $em_js_start i32 (i32.const 3000000006))
 ;; CHECK:      (global $em_js_stop i32 (i32.const -1294967281))
 (global $em_js_stop i32 (i32.const 3000000015))
 ;; CHECK:      (global $em_lib_deps_start i32 (i32.const 3000))
 (global $em_lib_deps_start i32 (i32.const 3000))
 ;; CHECK:      (global $em_lib_deps_stop i32 (i32.const 3009))
 (global $em_lib_deps_stop i32 (i32.const 3009))
 ;; CHECK:      (global $foo_start i32 (i32.const 4000))
 (global $foo_start i32 (i32.const 4000))
 ;; CHECK:      (global $foo_stop i32 (i32.const 4015))
 (global $foo_stop i32 (i32.const 4015))
 ;; CHECK:      (memory $mem 10 10)
 (memory $mem 10 10)
 ;; CHECK:      (data $data1 (i32.const 1000) "")
 (data $data1 (i32.const 1000) "hello world")
 ;; CHECK:      (data $data2 "hello \00\00\00\00\00\00\00\00\00 world")
 (data $data2 "hello DELETE ME world")
 ;; CHECK:      (data $data3 (i32.const 3000) "")
 (data $data3 (i32.const 3000) "some deps")
 (export "__start_em_asm" (global $em_asm_start))
 (export "__stop_em_asm" (global $em_asm_stop))
 (export "__start_em_js" (global $em_js_start))
 (export "__stop_em_js" (global $em_js_stop))
 (export "__start_em_lib_deps" (global $em_lib_deps_start))
 (export "__stop_em_lib_deps" (global $em_lib_deps_stop))
 ;; CHECK:      (export "__start_foo" (global $foo_start))
 (export "__start_foo" (global $foo_start))
 ;; CHECK:      (export "__stop_foo" (global $foo_stop))
 (export "__stop_foo" (global $foo_stop))
 ;; CHECK:      (func $meminit
 ;; CHECK-NEXT:  (memory.init $data2
 ;; CHECK-NEXT:   (i32.const -1294967296)
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:   (i32.const 21)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $meminit
  (memory.init $mem $data2
   (i32.const 3000000000)
   (i32.const 0)
   (i32.const 21)
  )
 )
)
