/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import alt.jiapi.reflect.Instruction;
import java.io.ByteArrayOutputStream;

public class SwitchInstruction
extends Instruction {
    private Instruction deflt;
    private Instruction[] targets;
    private int padding;
    private int defaultOffset;
    private int nPairs;
    private int[] keys;
    private int[] targetOffsets;

    SwitchInstruction(byte[] bytes, int padding, int nPairs) {
        super(bytes);
        this.padding = padding;
        this.defaultOffset = this.toInt(bytes, 1 + padding);
        this.nPairs = nPairs;
        this.keys = new int[nPairs];
        this.targetOffsets = new int[nPairs];
        if (bytes[0] == -85) {
            int start;
            int i;
            for (i = 0; i < this.keys.length; ++i) {
                start = 1 + padding + 8 + i * 4 * 2;
                this.keys[i] = this.toInt(bytes, start);
            }
            for (i = 0; i < this.targetOffsets.length; ++i) {
                start = 1 + padding + 8 + i * 4 * 2 + 4;
                this.targetOffsets[i] = this.toInt(bytes, start);
            }
        } else {
            int i;
            int low = this.toInt(bytes, padding + 5);
            int high = this.toInt(bytes, padding + 9);
            for (i = low; i < high; ++i) {
                this.keys[i] = i;
            }
            for (i = 0; i < this.targetOffsets.length; ++i) {
                int start = padding + 13 + i * 4;
                this.targetOffsets[i] = this.toInt(bytes, start);
            }
        }
    }

    public Instruction getDefault() {
        return this.deflt;
    }

    public Target[] getTargets() {
        Target[] __targets = new Target[this.targets.length];
        for (int i = 0; i < __targets.length; ++i) {
            __targets[i] = new Target(this.keys[i], this.targets[i]);
        }
        return __targets;
    }

    private Instruction[] __getTargets() {
        return this.targets;
    }

    private int[] __getKeys() {
        return this.keys;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(", default:");
        sb.append(this.getDefault());
        sb.append("(offset:");
        sb.append(this.getDefault().getOffset());
        sb.append(")");
        sb.append(", ");
        Target[] t = this.getTargets();
        for (int i = 0; i < t.length; ++i) {
            sb.append("{");
            sb.append(t[i].getKey());
            sb.append(":");
            sb.append(t[i].getTarget());
            sb.append("(offset:");
            sb.append(t[i].getTarget().getOffset());
            sb.append(")");
            sb.append("}");
        }
        return sb.toString();
    }

    public byte[] getBytes() {
        byte[] bytes = super.getBytes();
        short offset = this.getOffset();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.getOpcode());
        int pCount = 3 - offset % 4;
        for (int i = 0; i < pCount; ++i) {
            baos.write(0);
        }
        short dOffset = this.getDefault().getOffset();
        byte[] dBytes = this.toBytes(dOffset - offset - pCount - 1);
        for (int i = 0; i < dBytes.length; ++i) {
            baos.write(dBytes[i]);
        }
        if (this.getOpcode() == -85) {
            int i;
            byte[] np = this.toBytes(this.targets.length);
            for (i = 0; i < np.length; ++i) {
                baos.write(np[i]);
            }
            for (i = 0; i < this.targets.length; ++i) {
                try {
                    baos.write(this.toBytes(this.keys[i]));
                    baos.write(this.toBytes(this.targets[i].getOffset() - offset - pCount - 1));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else {
            int low = this.keys[0];
            int high = this.keys[this.keys.length - 1];
            try {
                baos.write(this.toBytes(low));
                baos.write(this.toBytes(high));
            }
            catch (Exception e) {
                // empty catch block
            }
            for (int i = 0; i < this.targets.length; ++i) {
                try {
                    baos.write(this.toBytes(this.targets[i].getOffset() - offset - pCount - 1));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        byte[] __bytes = baos.toByteArray();
        return __bytes;
    }

    int getDefaultOffset() {
        return this.defaultOffset;
    }

    void setDefault(Instruction deflt) {
        this.deflt = deflt;
    }

    int[] getTargetOffsets() {
        return this.targetOffsets;
    }

    void setTargets(Instruction[] targets) {
        this.targets = targets;
    }

    int toInt(byte[] bytes, int start) {
        byte b1 = bytes[start];
        byte b2 = bytes[start + 1];
        byte b3 = bytes[start + 2];
        byte b4 = bytes[start + 3];
        int i = b1 << 24 & 0xFF000000 | b2 << 16 & 0xFF0000 | b3 << 8 & 0xFF00 | b4 & 0xFF;
        return i;
    }

    byte[] toBytes(int i) {
        byte[] bytes = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return bytes;
    }

    public class Target {
        private int key;
        private Instruction target;

        Target(int key, Instruction target) {
            this.key = key;
            this.target = target;
        }

        public int getKey() {
            return this.key;
        }

        public Instruction getTarget() {
            return this.target;
        }
    }
}

