/*
 * Copyright (C) 2019  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _vcn_2_5_OFFSET_HEADER
#define _vcn_2_5_OFFSET_HEADER

// addressBlock: uvd0_mmsch_dec
// base address: 0x1e000
#define mmMMSCH_VF_VMID                                                                                0x000b
#define mmMMSCH_VF_VMID_BASE_IDX                                                                       0
#define mmMMSCH_VF_CTX_ADDR_LO                                                                         0x000c
#define mmMMSCH_VF_CTX_ADDR_LO_BASE_IDX                                                                0
#define mmMMSCH_VF_CTX_ADDR_HI                                                                         0x000d
#define mmMMSCH_VF_CTX_ADDR_HI_BASE_IDX                                                                0
#define mmMMSCH_VF_CTX_SIZE                                                                            0x000e
#define mmMMSCH_VF_CTX_SIZE_BASE_IDX                                                                   0
#define mmMMSCH_VF_MAILBOX_HOST                                                                        0x0012
#define mmMMSCH_VF_MAILBOX_HOST_BASE_IDX                                                               0
#define mmMMSCH_VF_MAILBOX_RESP                                                                        0x0013
#define mmMMSCH_VF_MAILBOX_RESP_BASE_IDX                                                               0


// addressBlock: uvd0_jpegnpdec
// base address: 0x1e200
#define mmUVD_JPEG_CNTL                                                                                0x0080
#define mmUVD_JPEG_CNTL_BASE_IDX                                                                       0
#define mmUVD_JPEG_RB_BASE                                                                             0x0081
#define mmUVD_JPEG_RB_BASE_BASE_IDX                                                                    0
#define mmUVD_JPEG_RB_WPTR                                                                             0x0082
#define mmUVD_JPEG_RB_WPTR_BASE_IDX                                                                    0
#define mmUVD_JPEG_RB_RPTR                                                                             0x0083
#define mmUVD_JPEG_RB_RPTR_BASE_IDX                                                                    0
#define mmUVD_JPEG_RB_SIZE                                                                             0x0084
#define mmUVD_JPEG_RB_SIZE_BASE_IDX                                                                    0
#define mmUVD_JPEG_DEC_SCRATCH0                                                                        0x0089
#define mmUVD_JPEG_DEC_SCRATCH0_BASE_IDX                                                               0
#define mmUVD_JPEG_INT_EN                                                                              0x008a
#define mmUVD_JPEG_INT_EN_BASE_IDX                                                                     0
#define mmUVD_JPEG_INT_STAT                                                                            0x008b
#define mmUVD_JPEG_INT_STAT_BASE_IDX                                                                   0
#define mmUVD_JPEG_PITCH                                                                               0x009f
#define mmUVD_JPEG_PITCH_BASE_IDX                                                                      0
#define mmUVD_JPEG_UV_PITCH                                                                            0x00a0
#define mmUVD_JPEG_UV_PITCH_BASE_IDX                                                                   0
#define mmJPEG_DEC_Y_GFX8_TILING_SURFACE                                                               0x00a1
#define mmJPEG_DEC_Y_GFX8_TILING_SURFACE_BASE_IDX                                                      0
#define mmJPEG_DEC_UV_GFX8_TILING_SURFACE                                                              0x00a2
#define mmJPEG_DEC_UV_GFX8_TILING_SURFACE_BASE_IDX                                                     0
#define mmJPEG_DEC_GFX8_ADDR_CONFIG                                                                    0x00a3
#define mmJPEG_DEC_GFX8_ADDR_CONFIG_BASE_IDX                                                           0
#define mmJPEG_DEC_Y_GFX10_TILING_SURFACE                                                              0x00a4
#define mmJPEG_DEC_Y_GFX10_TILING_SURFACE_BASE_IDX                                                     0
#define mmJPEG_DEC_UV_GFX10_TILING_SURFACE                                                             0x00a5
#define mmJPEG_DEC_UV_GFX10_TILING_SURFACE_BASE_IDX                                                    0
#define mmJPEG_DEC_GFX10_ADDR_CONFIG                                                                   0x00a6
#define mmJPEG_DEC_GFX10_ADDR_CONFIG_BASE_IDX                                                          0
#define mmJPEG_DEC_ADDR_MODE                                                                           0x00a7
#define mmJPEG_DEC_ADDR_MODE_BASE_IDX                                                                  0
#define mmUVD_JPEG_GPCOM_CMD                                                                           0x00a9
#define mmUVD_JPEG_GPCOM_CMD_BASE_IDX                                                                  0
#define mmUVD_JPEG_GPCOM_DATA0                                                                         0x00aa
#define mmUVD_JPEG_GPCOM_DATA0_BASE_IDX                                                                0
#define mmUVD_JPEG_GPCOM_DATA1                                                                         0x00ab
#define mmUVD_JPEG_GPCOM_DATA1_BASE_IDX                                                                0
#define mmUVD_JPEG_SCRATCH1                                                                            0x00ae
#define mmUVD_JPEG_SCRATCH1_BASE_IDX                                                                   0
#define mmUVD_JPEG_DEC_SOFT_RST                                                                        0x00af
#define mmUVD_JPEG_DEC_SOFT_RST_BASE_IDX                                                               0


// addressBlock: uvd0_uvd_jpeg_enc_dec
// base address: 0x1e300
#define mmUVD_JPEG_ENC_INT_EN                                                                          0x00c1
#define mmUVD_JPEG_ENC_INT_EN_BASE_IDX                                                                 0
#define mmUVD_JPEG_ENC_INT_STATUS                                                                      0x00c2
#define mmUVD_JPEG_ENC_INT_STATUS_BASE_IDX                                                             0
#define mmUVD_JPEG_ENC_ENGINE_CNTL                                                                     0x00c5
#define mmUVD_JPEG_ENC_ENGINE_CNTL_BASE_IDX                                                            0
#define mmUVD_JPEG_ENC_SCRATCH1                                                                        0x00ce
#define mmUVD_JPEG_ENC_SCRATCH1_BASE_IDX                                                               0


// addressBlock: uvd0_uvd_jpeg_enc_sclk_dec
// base address: 0x1e380
#define mmUVD_JPEG_ENC_STATUS                                                                          0x00e5
#define mmUVD_JPEG_ENC_STATUS_BASE_IDX                                                                 0
#define mmUVD_JPEG_ENC_PITCH                                                                           0x00e6
#define mmUVD_JPEG_ENC_PITCH_BASE_IDX                                                                  0
#define mmUVD_JPEG_ENC_LUMA_BASE                                                                       0x00e7
#define mmUVD_JPEG_ENC_LUMA_BASE_BASE_IDX                                                              0
#define mmUVD_JPEG_ENC_CHROMAU_BASE                                                                    0x00e8
#define mmUVD_JPEG_ENC_CHROMAU_BASE_BASE_IDX                                                           0
#define mmUVD_JPEG_ENC_CHROMAV_BASE                                                                    0x00e9
#define mmUVD_JPEG_ENC_CHROMAV_BASE_BASE_IDX                                                           0
#define mmJPEG_ENC_Y_GFX10_TILING_SURFACE                                                              0x00ea
#define mmJPEG_ENC_Y_GFX10_TILING_SURFACE_BASE_IDX                                                     0
#define mmJPEG_ENC_UV_GFX10_TILING_SURFACE                                                             0x00eb
#define mmJPEG_ENC_UV_GFX10_TILING_SURFACE_BASE_IDX                                                    0
#define mmJPEG_ENC_GFX10_ADDR_CONFIG                                                                   0x00ec
#define mmJPEG_ENC_GFX10_ADDR_CONFIG_BASE_IDX                                                          0
#define mmJPEG_ENC_ADDR_MODE                                                                           0x00ed
#define mmJPEG_ENC_ADDR_MODE_BASE_IDX                                                                  0
#define mmUVD_JPEG_ENC_GPCOM_CMD                                                                       0x00ee
#define mmUVD_JPEG_ENC_GPCOM_CMD_BASE_IDX                                                              0
#define mmUVD_JPEG_ENC_GPCOM_DATA0                                                                     0x00ef
#define mmUVD_JPEG_ENC_GPCOM_DATA0_BASE_IDX                                                            0
#define mmUVD_JPEG_ENC_GPCOM_DATA1                                                                     0x00f0
#define mmUVD_JPEG_ENC_GPCOM_DATA1_BASE_IDX                                                            0
#define mmUVD_JPEG_ENC_CGC_CNTL                                                                        0x00f5
#define mmUVD_JPEG_ENC_CGC_CNTL_BASE_IDX                                                               0
#define mmUVD_JPEG_ENC_SCRATCH0                                                                        0x00f6
#define mmUVD_JPEG_ENC_SCRATCH0_BASE_IDX                                                               0
#define mmUVD_JPEG_ENC_SOFT_RST                                                                        0x00f7
#define mmUVD_JPEG_ENC_SOFT_RST_BASE_IDX                                                               0


// addressBlock: uvd0_uvd_jrbc_dec
// base address: 0x1e400
#define mmUVD_JRBC_RB_WPTR                                                                             0x0100
#define mmUVD_JRBC_RB_WPTR_BASE_IDX                                                                    0
#define mmUVD_JRBC_RB_CNTL                                                                             0x0101
#define mmUVD_JRBC_RB_CNTL_BASE_IDX                                                                    0
#define mmUVD_JRBC_IB_SIZE                                                                             0x0102
#define mmUVD_JRBC_IB_SIZE_BASE_IDX                                                                    0
#define mmUVD_JRBC_URGENT_CNTL                                                                         0x0103
#define mmUVD_JRBC_URGENT_CNTL_BASE_IDX                                                                0
#define mmUVD_JRBC_RB_REF_DATA                                                                         0x0104
#define mmUVD_JRBC_RB_REF_DATA_BASE_IDX                                                                0
#define mmUVD_JRBC_RB_COND_RD_TIMER                                                                    0x0105
#define mmUVD_JRBC_RB_COND_RD_TIMER_BASE_IDX                                                           0
#define mmUVD_JRBC_SOFT_RESET                                                                          0x0108
#define mmUVD_JRBC_SOFT_RESET_BASE_IDX                                                                 0
#define mmUVD_JRBC_STATUS                                                                              0x0109
#define mmUVD_JRBC_STATUS_BASE_IDX                                                                     0
#define mmUVD_JRBC_RB_RPTR                                                                             0x010a
#define mmUVD_JRBC_RB_RPTR_BASE_IDX                                                                    0
#define mmUVD_JRBC_RB_BUF_STATUS                                                                       0x010b
#define mmUVD_JRBC_RB_BUF_STATUS_BASE_IDX                                                              0
#define mmUVD_JRBC_IB_BUF_STATUS                                                                       0x010c
#define mmUVD_JRBC_IB_BUF_STATUS_BASE_IDX                                                              0
#define mmUVD_JRBC_IB_SIZE_UPDATE                                                                      0x010d
#define mmUVD_JRBC_IB_SIZE_UPDATE_BASE_IDX                                                             0
#define mmUVD_JRBC_IB_COND_RD_TIMER                                                                    0x010e
#define mmUVD_JRBC_IB_COND_RD_TIMER_BASE_IDX                                                           0
#define mmUVD_JRBC_IB_REF_DATA                                                                         0x010f
#define mmUVD_JRBC_IB_REF_DATA_BASE_IDX                                                                0
#define mmUVD_JPEG_PREEMPT_CMD                                                                         0x0110
#define mmUVD_JPEG_PREEMPT_CMD_BASE_IDX                                                                0
#define mmUVD_JPEG_PREEMPT_FENCE_DATA0                                                                 0x0111
#define mmUVD_JPEG_PREEMPT_FENCE_DATA0_BASE_IDX                                                        0
#define mmUVD_JPEG_PREEMPT_FENCE_DATA1                                                                 0x0112
#define mmUVD_JPEG_PREEMPT_FENCE_DATA1_BASE_IDX                                                        0
#define mmUVD_JRBC_RB_SIZE                                                                             0x0113
#define mmUVD_JRBC_RB_SIZE_BASE_IDX                                                                    0
#define mmUVD_JRBC_SCRATCH0                                                                            0x0114
#define mmUVD_JRBC_SCRATCH0_BASE_IDX                                                                   0


// addressBlock: uvd0_uvd_jrbc_enc_dec
// base address: 0x1e480
#define mmUVD_JRBC_ENC_RB_WPTR                                                                         0x0120
#define mmUVD_JRBC_ENC_RB_WPTR_BASE_IDX                                                                0
#define mmUVD_JRBC_ENC_RB_CNTL                                                                         0x0121
#define mmUVD_JRBC_ENC_RB_CNTL_BASE_IDX                                                                0
#define mmUVD_JRBC_ENC_IB_SIZE                                                                         0x0122
#define mmUVD_JRBC_ENC_IB_SIZE_BASE_IDX                                                                0
#define mmUVD_JRBC_ENC_URGENT_CNTL                                                                     0x0123
#define mmUVD_JRBC_ENC_URGENT_CNTL_BASE_IDX                                                            0
#define mmUVD_JRBC_ENC_RB_REF_DATA                                                                     0x0124
#define mmUVD_JRBC_ENC_RB_REF_DATA_BASE_IDX                                                            0
#define mmUVD_JRBC_ENC_RB_COND_RD_TIMER                                                                0x0125
#define mmUVD_JRBC_ENC_RB_COND_RD_TIMER_BASE_IDX                                                       0
#define mmUVD_JRBC_ENC_SOFT_RESET                                                                      0x0128
#define mmUVD_JRBC_ENC_SOFT_RESET_BASE_IDX                                                             0
#define mmUVD_JRBC_ENC_STATUS                                                                          0x0129
#define mmUVD_JRBC_ENC_STATUS_BASE_IDX                                                                 0
#define mmUVD_JRBC_ENC_RB_RPTR                                                                         0x012a
#define mmUVD_JRBC_ENC_RB_RPTR_BASE_IDX                                                                0
#define mmUVD_JRBC_ENC_RB_BUF_STATUS                                                                   0x012b
#define mmUVD_JRBC_ENC_RB_BUF_STATUS_BASE_IDX                                                          0
#define mmUVD_JRBC_ENC_IB_BUF_STATUS                                                                   0x012c
#define mmUVD_JRBC_ENC_IB_BUF_STATUS_BASE_IDX                                                          0
#define mmUVD_JRBC_ENC_IB_SIZE_UPDATE                                                                  0x012d
#define mmUVD_JRBC_ENC_IB_SIZE_UPDATE_BASE_IDX                                                         0
#define mmUVD_JRBC_ENC_IB_COND_RD_TIMER                                                                0x012e
#define mmUVD_JRBC_ENC_IB_COND_RD_TIMER_BASE_IDX                                                       0
#define mmUVD_JRBC_ENC_IB_REF_DATA                                                                     0x012f
#define mmUVD_JRBC_ENC_IB_REF_DATA_BASE_IDX                                                            0
#define mmUVD_JPEG_ENC_PREEMPT_CMD                                                                     0x0130
#define mmUVD_JPEG_ENC_PREEMPT_CMD_BASE_IDX                                                            0
#define mmUVD_JPEG_ENC_PREEMPT_FENCE_DATA0                                                             0x0131
#define mmUVD_JPEG_ENC_PREEMPT_FENCE_DATA0_BASE_IDX                                                    0
#define mmUVD_JPEG_ENC_PREEMPT_FENCE_DATA1                                                             0x0132
#define mmUVD_JPEG_ENC_PREEMPT_FENCE_DATA1_BASE_IDX                                                    0
#define mmUVD_JRBC_ENC_RB_SIZE                                                                         0x0133
#define mmUVD_JRBC_ENC_RB_SIZE_BASE_IDX                                                                0
#define mmUVD_JRBC_ENC_SCRATCH0                                                                        0x0134
#define mmUVD_JRBC_ENC_SCRATCH0_BASE_IDX                                                               0


// addressBlock: uvd0_uvd_jmi_dec
// base address: 0x1e500
#define mmUVD_JMI_CTRL                                                                                 0x0145
#define mmUVD_JMI_CTRL_BASE_IDX                                                                        0
#define mmUVD_LMI_JRBC_CTRL                                                                            0x0146
#define mmUVD_LMI_JRBC_CTRL_BASE_IDX                                                                   0
#define mmUVD_LMI_JPEG_CTRL                                                                            0x0147
#define mmUVD_LMI_JPEG_CTRL_BASE_IDX                                                                   0
#define mmUVD_JMI_EJRBC_CTRL                                                                           0x0148
#define mmUVD_JMI_EJRBC_CTRL_BASE_IDX                                                                  0
#define mmUVD_LMI_EJPEG_CTRL                                                                           0x0149
#define mmUVD_LMI_EJPEG_CTRL_BASE_IDX                                                                  0
#define mmUVD_LMI_JRBC_IB_VMID                                                                         0x014f
#define mmUVD_LMI_JRBC_IB_VMID_BASE_IDX                                                                0
#define mmUVD_LMI_JRBC_RB_VMID                                                                         0x0150
#define mmUVD_LMI_JRBC_RB_VMID_BASE_IDX                                                                0
#define mmUVD_LMI_JPEG_VMID                                                                            0x0151
#define mmUVD_LMI_JPEG_VMID_BASE_IDX                                                                   0
#define mmUVD_JMI_ENC_JRBC_IB_VMID                                                                     0x0152
#define mmUVD_JMI_ENC_JRBC_IB_VMID_BASE_IDX                                                            0
#define mmUVD_JMI_ENC_JRBC_RB_VMID                                                                     0x0153
#define mmUVD_JMI_ENC_JRBC_RB_VMID_BASE_IDX                                                            0
#define mmUVD_JMI_ENC_JPEG_VMID                                                                        0x0154
#define mmUVD_JMI_ENC_JPEG_VMID_BASE_IDX                                                               0
#define mmUVD_JMI_PERFMON_CTRL                                                                         0x015c
#define mmUVD_JMI_PERFMON_CTRL_BASE_IDX                                                                0
#define mmUVD_JMI_PERFMON_COUNT_LO                                                                     0x015d
#define mmUVD_JMI_PERFMON_COUNT_LO_BASE_IDX                                                            0
#define mmUVD_JMI_PERFMON_COUNT_HI                                                                     0x015e
#define mmUVD_JMI_PERFMON_COUNT_HI_BASE_IDX                                                            0
#define mmUVD_LMI_JPEG_READ_64BIT_BAR_LOW                                                              0x0160
#define mmUVD_LMI_JPEG_READ_64BIT_BAR_LOW_BASE_IDX                                                     0
#define mmUVD_LMI_JPEG_READ_64BIT_BAR_HIGH                                                             0x0161
#define mmUVD_LMI_JPEG_READ_64BIT_BAR_HIGH_BASE_IDX                                                    0
#define mmUVD_LMI_JPEG_WRITE_64BIT_BAR_LOW                                                             0x0162
#define mmUVD_LMI_JPEG_WRITE_64BIT_BAR_LOW_BASE_IDX                                                    0
#define mmUVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH                                                            0x0163
#define mmUVD_LMI_JPEG_WRITE_64BIT_BAR_HIGH_BASE_IDX                                                   0
#define mmUVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                                     0x0164
#define mmUVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                            0
#define mmUVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                                    0x0165
#define mmUVD_LMI_JPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                           0
#define mmUVD_LMI_JRBC_RB_64BIT_BAR_LOW                                                                0x0166
#define mmUVD_LMI_JRBC_RB_64BIT_BAR_LOW_BASE_IDX                                                       0
#define mmUVD_LMI_JRBC_RB_64BIT_BAR_HIGH                                                               0x0167
#define mmUVD_LMI_JRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                                      0
#define mmUVD_LMI_JRBC_IB_64BIT_BAR_LOW                                                                0x0168
#define mmUVD_LMI_JRBC_IB_64BIT_BAR_LOW_BASE_IDX                                                       0
#define mmUVD_LMI_JRBC_IB_64BIT_BAR_HIGH                                                               0x0169
#define mmUVD_LMI_JRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                                      0
#define mmUVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW                                                         0x016a
#define mmUVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                                0
#define mmUVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH                                                        0x016b
#define mmUVD_LMI_JRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                               0
#define mmUVD_LMI_JRBC_RB_MEM_RD_64BIT_BAR_LOW                                                         0x016c
#define mmUVD_LMI_JRBC_RB_MEM_RD_64BIT_BAR_LOW_BASE_IDX                                                0
#define mmUVD_LMI_JRBC_RB_MEM_RD_64BIT_BAR_HIGH                                                        0x016d
#define mmUVD_LMI_JRBC_RB_MEM_RD_64BIT_BAR_HIGH_BASE_IDX                                               0
#define mmUVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW                                                         0x016e
#define mmUVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                                0
#define mmUVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH                                                        0x016f
#define mmUVD_LMI_JRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                               0
#define mmUVD_LMI_JRBC_IB_MEM_RD_64BIT_BAR_LOW                                                         0x0170
#define mmUVD_LMI_JRBC_IB_MEM_RD_64BIT_BAR_LOW_BASE_IDX                                                0
#define mmUVD_LMI_JRBC_IB_MEM_RD_64BIT_BAR_HIGH                                                        0x0171
#define mmUVD_LMI_JRBC_IB_MEM_RD_64BIT_BAR_HIGH_BASE_IDX                                               0
#define mmUVD_LMI_EJPEG_PREEMPT_FENCE_64BIT_BAR_LOW                                                    0x017a
#define mmUVD_LMI_EJPEG_PREEMPT_FENCE_64BIT_BAR_LOW_BASE_IDX                                           0
#define mmUVD_LMI_EJPEG_PREEMPT_FENCE_64BIT_BAR_HIGH                                                   0x017b
#define mmUVD_LMI_EJPEG_PREEMPT_FENCE_64BIT_BAR_HIGH_BASE_IDX                                          0
#define mmUVD_LMI_EJRBC_RB_64BIT_BAR_LOW                                                               0x017c
#define mmUVD_LMI_EJRBC_RB_64BIT_BAR_LOW_BASE_IDX                                                      0
#define mmUVD_LMI_EJRBC_RB_64BIT_BAR_HIGH                                                              0x017d
#define mmUVD_LMI_EJRBC_RB_64BIT_BAR_HIGH_BASE_IDX                                                     0
#define mmUVD_LMI_EJRBC_IB_64BIT_BAR_LOW                                                               0x017e
#define mmUVD_LMI_EJRBC_IB_64BIT_BAR_LOW_BASE_IDX                                                      0
#define mmUVD_LMI_EJRBC_IB_64BIT_BAR_HIGH                                                              0x017f
#define mmUVD_LMI_EJRBC_IB_64BIT_BAR_HIGH_BASE_IDX                                                     0
#define mmUVD_LMI_EJRBC_RB_MEM_WR_64BIT_BAR_LOW                                                        0x0180
#define mmUVD_LMI_EJRBC_RB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                               0
#define mmUVD_LMI_EJRBC_RB_MEM_WR_64BIT_BAR_HIGH                                                       0x0181
#define mmUVD_LMI_EJRBC_RB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                              0
#define mmUVD_LMI_EJRBC_RB_MEM_RD_64BIT_BAR_LOW                                                        0x0182
#define mmUVD_LMI_EJRBC_RB_MEM_RD_64BIT_BAR_LOW_BASE_IDX                                               0
#define mmUVD_LMI_EJRBC_RB_MEM_RD_64BIT_BAR_HIGH                                                       0x0183
#define mmUVD_LMI_EJRBC_RB_MEM_RD_64BIT_BAR_HIGH_BASE_IDX                                              0
#define mmUVD_LMI_EJRBC_IB_MEM_WR_64BIT_BAR_LOW                                                        0x0184
#define mmUVD_LMI_EJRBC_IB_MEM_WR_64BIT_BAR_LOW_BASE_IDX                                               0
#define mmUVD_LMI_EJRBC_IB_MEM_WR_64BIT_BAR_HIGH                                                       0x0185
#define mmUVD_LMI_EJRBC_IB_MEM_WR_64BIT_BAR_HIGH_BASE_IDX                                              0
#define mmUVD_LMI_EJRBC_IB_MEM_RD_64BIT_BAR_LOW                                                        0x0186
#define mmUVD_LMI_EJRBC_IB_MEM_RD_64BIT_BAR_LOW_BASE_IDX                                               0
#define mmUVD_LMI_EJRBC_IB_MEM_RD_64BIT_BAR_HIGH                                                       0x0187
#define mmUVD_LMI_EJRBC_IB_MEM_RD_64BIT_BAR_HIGH_BASE_IDX                                              0
#define mmUVD_LMI_JPEG_PREEMPT_VMID                                                                    0x0188
#define mmUVD_LMI_JPEG_PREEMPT_VMID_BASE_IDX                                                           0
#define mmUVD_LMI_ENC_JPEG_PREEMPT_VMID                                                                0x0189
#define mmUVD_LMI_ENC_JPEG_PREEMPT_VMID_BASE_IDX                                                       0
#define mmUVD_LMI_JPEG2_VMID                                                                           0x018a
#define mmUVD_LMI_JPEG2_VMID_BASE_IDX                                                                  0
#define mmUVD_LMI_JPEG2_READ_64BIT_BAR_LOW                                                             0x018b
#define mmUVD_LMI_JPEG2_READ_64BIT_BAR_LOW_BASE_IDX                                                    0
#define mmUVD_LMI_JPEG2_READ_64BIT_BAR_HIGH                                                            0x018c
#define mmUVD_LMI_JPEG2_READ_64BIT_BAR_HIGH_BASE_IDX                                                   0
#define mmUVD_LMI_JPEG2_WRITE_64BIT_BAR_LOW                                                            0x018d
#define mmUVD_LMI_JPEG2_WRITE_64BIT_BAR_LOW_BASE_IDX                                                   0
#define mmUVD_LMI_JPEG2_WRITE_64BIT_BAR_HIGH                                                           0x018e
#define mmUVD_LMI_JPEG2_WRITE_64BIT_BAR_HIGH_BASE_IDX                                                  0
#define mmUVD_LMI_JPEG_CTRL2                                                                           0x018f
#define mmUVD_LMI_JPEG_CTRL2_BASE_IDX                                                                  0
#define mmUVD_JMI_DEC_SWAP_CNTL                                                                        0x0190
#define mmUVD_JMI_DEC_SWAP_CNTL_BASE_IDX                                                               0
#define mmUVD_JMI_ENC_SWAP_CNTL                                                                        0x0191
#define mmUVD_JMI_ENC_SWAP_CNTL_BASE_IDX                                                               0
#define mmUVD_JMI_CNTL                                                                                 0x0192
#define mmUVD_JMI_CNTL_BASE_IDX                                                                        0
#define mmUVD_JMI_HUFF_FENCE_64BIT_BAR_LOW                                                             0x019a
#define mmUVD_JMI_HUFF_FENCE_64BIT_BAR_LOW_BASE_IDX                                                    0
#define mmUVD_JMI_HUFF_FENCE_64BIT_BAR_HIGH                                                            0x019b
#define mmUVD_JMI_HUFF_FENCE_64BIT_BAR_HIGH_BASE_IDX                                                   0
#define mmUVD_JMI_DEC_SWAP_CNTL2                                                                       0x019c
#define mmUVD_JMI_DEC_SWAP_CNTL2_BASE_IDX                                                              0


// addressBlock: uvd0_uvd_jpeg_common_dec
// base address: 0x1e700
#define mmJPEG_SOFT_RESET_STATUS                                                                       0x01c0
#define mmJPEG_SOFT_RESET_STATUS_BASE_IDX                                                              0
#define mmJPEG_SYS_INT_EN                                                                              0x01c1
#define mmJPEG_SYS_INT_EN_BASE_IDX                                                                     0
#define mmJPEG_SYS_INT_STATUS                                                                          0x01c2
#define mmJPEG_SYS_INT_STATUS_BASE_IDX                                                                 0
#define mmJPEG_SYS_INT_ACK                                                                             0x01c3
#define mmJPEG_SYS_INT_ACK_BASE_IDX                                                                    0
#define mmJPEG_MASTINT_EN                                                                              0x01c8
#define mmJPEG_MASTINT_EN_BASE_IDX                                                                     0
#define mmJPEG_IH_CTRL                                                                                 0x01c9
#define mmJPEG_IH_CTRL_BASE_IDX                                                                        0
#define mmJRBBM_ARB_CTRL                                                                               0x01cb
#define mmJRBBM_ARB_CTRL_BASE_IDX                                                                      0


// addressBlock: uvd0_uvd_jpeg_common_sclk_dec
// base address: 0x1e780
#define mmJPEG_CGC_GATE                                                                                0x01e0
#define mmJPEG_CGC_GATE_BASE_IDX                                                                       0
#define mmJPEG_CGC_CTRL                                                                                0x01e1
#define mmJPEG_CGC_CTRL_BASE_IDX                                                                       0
#define mmJPEG_CGC_STATUS                                                                              0x01e2
#define mmJPEG_CGC_STATUS_BASE_IDX                                                                     0
#define mmJPEG_COMN_CGC_MEM_CTRL                                                                       0x01e3
#define mmJPEG_COMN_CGC_MEM_CTRL_BASE_IDX                                                              0
#define mmJPEG_DEC_CGC_MEM_CTRL                                                                        0x01e4
#define mmJPEG_DEC_CGC_MEM_CTRL_BASE_IDX                                                               0
#define mmJPEG2_DEC_CGC_MEM_CTRL                                                                       0x01e5
#define mmJPEG2_DEC_CGC_MEM_CTRL_BASE_IDX                                                              0
#define mmJPEG_ENC_CGC_MEM_CTRL                                                                        0x01e6
#define mmJPEG_ENC_CGC_MEM_CTRL_BASE_IDX                                                               0
#define mmJPEG_SOFT_RESET2                                                                             0x01e7
#define mmJPEG_SOFT_RESET2_BASE_IDX                                                                    0
#define mmJPEG_PERF_BANK_CONF                                                                          0x01e8
#define mmJPEG_PERF_BANK_CONF_BASE_IDX                                                                 0
#define mmJPEG_PERF_BANK_EVENT_SEL                                                                     0x01e9
#define mmJPEG_PERF_BANK_EVENT_SEL_BASE_IDX                                                            0
#define mmJPEG_PERF_BANK_COUNT0                                                                        0x01ea
#define mmJPEG_PERF_BANK_COUNT0_BASE_IDX                                                               0
#define mmJPEG_PERF_BANK_COUNT1                                                                        0x01eb
#define mmJPEG_PERF_BANK_COUNT1_BASE_IDX                                                               0
#define mmJPEG_PERF_BANK_COUNT2                                                                        0x01ec
#define mmJPEG_PERF_BANK_COUNT2_BASE_IDX                                                               0
#define mmJPEG_PERF_BANK_COUNT3                                                                        0x01ed
#define mmJPEG_PERF_BANK_COUNT3_BASE_IDX                                                               0


// addressBlock: uvd0_uvd_pg_dec
// base address: 0x1f800
#define mmUVD_PGFSM_CONFIG                                                                             0x0000
#define mmUVD_PGFSM_CONFIG_BASE_IDX                                                                    1
#define mmUVD_PGFSM_STATUS                                                                             0x0001
#define mmUVD_PGFSM_STATUS_BASE_IDX                                                                    1
#define mmUVD_POWER_STATUS                                                                             0x0004
#define mmUVD_POWER_STATUS_BASE_IDX                                                                    1
#define mmUVD_PG_IND_INDEX                                                                             0x0005
#define mmUVD_PG_IND_INDEX_BASE_IDX                                                                    1
#define mmUVD_PG_IND_DATA                                                                              0x0006
#define mmUVD_PG_IND_DATA_BASE_IDX                                                                     1
#define mmCC_UVD_HARVESTING                                                                            0x0007
#define mmCC_UVD_HARVESTING_BASE_IDX                                                                   1
#define mmUVD_JPEG_POWER_STATUS                                                                        0x000a
#define mmUVD_JPEG_POWER_STATUS_BASE_IDX                                                               1
#define mmUVD_DPG_LMA_CTL                                                                              0x0011
#define mmUVD_DPG_LMA_CTL_BASE_IDX                                                                     1
#define mmUVD_DPG_LMA_DATA                                                                             0x0012
#define mmUVD_DPG_LMA_DATA_BASE_IDX                                                                    1
#define mmUVD_DPG_LMA_MASK                                                                             0x0013
#define mmUVD_DPG_LMA_MASK_BASE_IDX                                                                    1
#define mmUVD_DPG_PAUSE                                                                                0x0014
#define mmUVD_DPG_PAUSE_BASE_IDX                                                                       1
#define mmUVD_SCRATCH1                                                                                 0x0015
#define mmUVD_SCRATCH1_BASE_IDX                                                                        1
#define mmUVD_SCRATCH2                                                                                 0x0016
#define mmUVD_SCRATCH2_BASE_IDX                                                                        1
#define mmUVD_SCRATCH3                                                                                 0x0017
#define mmUVD_SCRATCH3_BASE_IDX                                                                        1
#define mmUVD_SCRATCH4                                                                                 0x0018
#define mmUVD_SCRATCH4_BASE_IDX                                                                        1
#define mmUVD_SCRATCH5                                                                                 0x0019
#define mmUVD_SCRATCH5_BASE_IDX                                                                        1
#define mmUVD_SCRATCH6                                                                                 0x001a
#define mmUVD_SCRATCH6_BASE_IDX                                                                        1
#define mmUVD_SCRATCH7                                                                                 0x001b
#define mmUVD_SCRATCH7_BASE_IDX                                                                        1
#define mmUVD_SCRATCH8                                                                                 0x001c
#define mmUVD_SCRATCH8_BASE_IDX                                                                        1
#define mmUVD_SCRATCH9                                                                                 0x001d
#define mmUVD_SCRATCH9_BASE_IDX                                                                        1
#define mmUVD_SCRATCH10                                                                                0x001e
#define mmUVD_SCRATCH10_BASE_IDX                                                                       1
#define mmUVD_SCRATCH11                                                                                0x001f
#define mmUVD_SCRATCH11_BASE_IDX                                                                       1
#define mmUVD_SCRATCH12                                                                                0x0020
#define mmUVD_SCRATCH12_BASE_IDX                                                                       1
#define mmUVD_SCRATCH13                                                                                0x0021
#define mmUVD_SCRATCH13_BASE_IDX                                                                       1
#define mmUVD_SCRATCH14                                                                                0x0022
#define mmUVD_SCRATCH14_BASE_IDX                                                                       1
#define mmUVD_FREE_COUNTER_REG                                                                         0x0024
#define mmUVD_FREE_COUNTER_REG_BASE_IDX                                                                1
#define mmUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_LOW                                                         0x0025
#define mmUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_LOW_BASE_IDX                                                1
#define mmUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_HIGH                                                        0x0026
#define mmUVD_DPG_LMI_VCPU_CACHE_64BIT_BAR_HIGH_BASE_IDX                                               1
#define mmUVD_DPG_VCPU_CACHE_OFFSET0                                                                   0x0027
#define mmUVD_DPG_VCPU_CACHE_OFFSET0_BASE_IDX                                                          1
#define mmUVD_DPG_LMI_VCPU_CACHE_VMID                                                                  0x0028
#define mmUVD_DPG_LMI_VCPU_CACHE_VMID_BASE_IDX                                                         1
#define mmUVD_PF_STATUS                                                                                0x0039
#define mmUVD_PF_STATUS_BASE_IDX                                                                       1
#define mmUVD_DPG_CLK_EN_VCPU_REPORT                                                                   0x003c
#define mmUVD_DPG_CLK_EN_VCPU_REPORT_BASE_IDX                                                          1
#define mmUVD_GFX8_ADDR_CONFIG                                                                         0x0049
#define mmUVD_GFX8_ADDR_CONFIG_BASE_IDX                                                                1
#define mmUVD_GFX10_ADDR_CONFIG                                                                        0x004a
#define mmUVD_GFX10_ADDR_CONFIG_BASE_IDX                                                               1
#define mmUVD_GPCNT2_CNTL                                                                              0x004b
#define mmUVD_GPCNT2_CNTL_BASE_IDX                                                                     1
#define mmUVD_GPCNT2_TARGET_LOWER                                                                      0x004c
#define mmUVD_GPCNT2_TARGET_LOWER_BASE_IDX                                                             1
#define mmUVD_GPCNT2_STATUS_LOWER                                                                      0x004d
#define mmUVD_GPCNT2_STATUS_LOWER_BASE_IDX                                                             1
#define mmUVD_GPCNT2_TARGET_UPPER                                                                      0x004e
#define mmUVD_GPCNT2_TARGET_UPPER_BASE_IDX                                                             1
#define mmUVD_GPCNT2_STATUS_UPPER                                                                      0x004f
#define mmUVD_GPCNT2_STATUS_UPPER_BASE_IDX                                                             1
#define mmUVD_GPCNT3_CNTL                                                                              0x0050
#define mmUVD_GPCNT3_CNTL_BASE_IDX                                                                     1
#define mmUVD_GPCNT3_TARGET_LOWER                                                                      0x0051
#define mmUVD_GPCNT3_TARGET_LOWER_BASE_IDX                                                             1
#define mmUVD_GPCNT3_STATUS_LOWER                                                                      0x0052
#define mmUVD_GPCNT3_STATUS_LOWER_BASE_IDX                                                             1
#define mmUVD_GPCNT3_TARGET_UPPER                                                                      0x0053
#define mmUVD_GPCNT3_TARGET_UPPER_BASE_IDX                                                             1
#define mmUVD_GPCNT3_STATUS_UPPER                                                                      0x0054
#define mmUVD_GPCNT3_STATUS_UPPER_BASE_IDX                                                             1


// addressBlock: uvd0_uvddec
// base address: 0x1fa00
#define mmUVD_STATUS                                                                                   0x0080
#define mmUVD_STATUS_BASE_IDX                                                                          1
#define mmUVD_ENC_PIPE_BUSY                                                                            0x0081
#define mmUVD_ENC_PIPE_BUSY_BASE_IDX                                                                   1
#define mmUVD_SOFT_RESET                                                                               0x0084
#define mmUVD_SOFT_RESET_BASE_IDX                                                                      1
#define mmUVD_SOFT_RESET2                                                                              0x0085
#define mmUVD_SOFT_RESET2_BASE_IDX                                                                     1
#define mmUVD_MMSCH_SOFT_RESET                                                                         0x0086
#define mmUVD_MMSCH_SOFT_RESET_BASE_IDX                                                                1
#define mmUVD_CGC_GATE                                                                                 0x0088
#define mmUVD_CGC_GATE_BASE_IDX                                                                        1
#define mmUVD_CGC_STATUS                                                                               0x0089
#define mmUVD_CGC_STATUS_BASE_IDX                                                                      1
#define mmUVD_CGC_CTRL                                                                                 0x008a
#define mmUVD_CGC_CTRL_BASE_IDX                                                                        1
#define mmUVD_CGC_UDEC_STATUS                                                                          0x008b
#define mmUVD_CGC_UDEC_STATUS_BASE_IDX                                                                 1
#define mmUVD_SUVD_CGC_GATE                                                                            0x008c
#define mmUVD_SUVD_CGC_GATE_BASE_IDX                                                                   1
#define mmUVD_SUVD_CGC_STATUS                                                                          0x008d
#define mmUVD_SUVD_CGC_STATUS_BASE_IDX                                                                 1
#define mmUVD_SUVD_CGC_CTRL                                                                            0x008e
#define mmUVD_SUVD_CGC_CTRL_BASE_IDX                                                                   1
#define mmUVD_GPCOM_VCPU_CMD                                                                           0x008f
#define mmUVD_GPCOM_VCPU_CMD_BASE_IDX                                                                  1
#define mmUVD_GPCOM_VCPU_DATA0                                                                         0x0090
#define mmUVD_GPCOM_VCPU_DATA0_BASE_IDX                                                                1
#define mmUVD_GPCOM_VCPU_DATA1                                                                         0x0091
#define mmUVD_GPCOM_VCPU_DATA1_BASE_IDX                                                                1
#define mmUVD_GPCOM_SYS_CMD                                                                            0x0092
#define mmUVD_GPCOM_SYS_CMD_BASE_IDX                                                                   1
#define mmUVD_GPCOM_SYS_DATA0                                                                          0x0093
#define mmUVD_GPCOM_SYS_DATA0_BASE_IDX                                                                 1
#define mmUVD_GPCOM_SYS_DATA1                                                                          0x0094
#define mmUVD_GPCOM_SYS_DATA1_BASE_IDX                                                                 1
#define mmUVD_VCPU_INT_EN                                                                              0x0095
#define mmUVD_VCPU_INT_EN_BASE_IDX                                                                     1
#define mmUVD_VCPU_INT_ACK                                                                             0x0097
#define mmUVD_VCPU_INT_ACK_BASE_IDX                                                                    1
#define mmUVD_VCPU_INT_ROUTE                                                                           0x0098
#define mmUVD_VCPU_INT_ROUTE_BASE_IDX                                                                  1
#define mmUVD_ENC_VCPU_INT_EN                                                                          0x009e
#define mmUVD_ENC_VCPU_INT_EN_BASE_IDX                                                                 1
#define mmUVD_ENC_VCPU_INT_ACK                                                                         0x00a0
#define mmUVD_ENC_VCPU_INT_ACK_BASE_IDX                                                                1
#define mmUVD_MASTINT_EN                                                                               0x00a1
#define mmUVD_MASTINT_EN_BASE_IDX                                                                      1
#define mmUVD_SYS_INT_EN                                                                               0x00a2
#define mmUVD_SYS_INT_EN_BASE_IDX                                                                      1
#define mmUVD_SYS_INT_STATUS                                                                           0x00a3
#define mmUVD_SYS_INT_STATUS_BASE_IDX                                                                  1
#define mmUVD_SYS_INT_ACK                                                                              0x00a4
#define mmUVD_SYS_INT_ACK_BASE_IDX                                                                     1
#define mmUVD_JOB_DONE                                                                                 0x00a5
#define mmUVD_JOB_DONE_BASE_IDX                                                                        1
#define mmUVD_CBUF_ID                                                                                  0x00a6
#define mmUVD_CBUF_ID_BASE_IDX                                                                         1
#define mmUVD_CONTEXT_ID                                                                               0x00a7
#define mmUVD_CONTEXT_ID_BASE_IDX                                                                      1
#define mmUVD_CONTEXT_ID2                                                                              0x00a8
#define mmUVD_CONTEXT_ID2_BASE_IDX                                                                     1
#define mmUVD_NO_OP                                                                                    0x00a9
#define mmUVD_NO_OP_BASE_IDX                                                                           1
#define mmUVD_RB_BASE_LO                                                                               0x00aa
#define mmUVD_RB_BASE_LO_BASE_IDX                                                                      1
#define mmUVD_RB_BASE_HI                                                                               0x00ab
#define mmUVD_RB_BASE_HI_BASE_IDX                                                                      1
#define mmUVD_RB_SIZE                                                                                  0x00ac
#define mmUVD_RB_SIZE_BASE_IDX                                                                         1
#define mmUVD_RB_RPTR                                                                                  0x00ad
#define mmUVD_RB_RPTR_BASE_IDX                                                                         1
#define mmUVD_RB_WPTR                                                                                  0x00ae
#define mmUVD_RB_WPTR_BASE_IDX                                                                         1
#define mmUVD_RB_BASE_LO2                                                                              0x00af
#define mmUVD_RB_BASE_LO2_BASE_IDX                                                                     1
#define mmUVD_RB_BASE_HI2                                                                              0x00b0
#define mmUVD_RB_BASE_HI2_BASE_IDX                                                                     1
#define mmUVD_RB_SIZE2                                                                                 0x00b1
#define mmUVD_RB_SIZE2_BASE_IDX                                                                        1
#define mmUVD_RB_RPTR2                                                                                 0x00b2
#define mmUVD_RB_RPTR2_BASE_IDX                                                                        1
#define mmUVD_RB_WPTR2                                                                                 0x00b3
#define mmUVD_RB_WPTR2_BASE_IDX                                                                        1
#define mmUVD_RB_BASE_LO3                                                                              0x00b4
#define mmUVD_RB_BASE_LO3_BASE_IDX                                                                     1
#define mmUVD_RB_BASE_HI3                                                                              0x00b5
#define mmUVD_RB_BASE_HI3_BASE_IDX                                                                     1
#define mmUVD_RB_SIZE3                                                                                 0x00b6
#define mmUVD_RB_SIZE3_BASE_IDX                                                                        1
#define mmUVD_RB_RPTR3                                                                                 0x00b7
#define mmUVD_RB_RPTR3_BASE_IDX                                                                        1
#define mmUVD_RB_WPTR3                                                                                 0x00b8
#define mmUVD_RB_WPTR3_BASE_IDX                                                                        1
#define mmUVD_RB_BASE_LO4                                                                              0x00b9
#define mmUVD_RB_BASE_LO4_BASE_IDX                                                                     1
#define mmUVD_RB_BASE_HI4                                                                              0x00ba
#define mmUVD_RB_BASE_HI4_BASE_IDX                                                                     1
#define mmUVD_RB_SIZE4                                                                                 0x00bb
#define mmUVD_RB_SIZE4_BASE_IDX                                                                        1
#define mmUVD_RB_RPTR4                                                                                 0x00bc
#define mmUVD_RB_RPTR4_BASE_IDX                                                                        1
#define mmUVD_RB_WPTR4                                                                                 0x00bd
#define mmUVD_RB_WPTR4_BASE_IDX                                                                        1
#define mmUVD_OUT_RB_BASE_LO                                                                           0x00be
#define mmUVD_OUT_RB_BASE_LO_BASE_IDX                                                                  1
#define mmUVD_OUT_RB_BASE_HI                                                                           0x00bf
#define mmUVD_OUT_RB_BASE_HI_BASE_IDX                                                                  1
#define mmUVD_OUT_RB_SIZE                                                                              0x00c0
#define mmUVD_OUT_RB_SIZE_BASE_IDX                                                                     1
#define mmUVD_OUT_RB_RPTR                                                                              0x00c1
#define mmUVD_OUT_RB_RPTR_BASE_IDX                                                                     1
#define mmUVD_OUT_RB_WPTR                                                                              0x00c2
#define mmUVD_OUT_RB_WPTR_BASE_IDX                                                                     1
#define mmUVD_RB_ARB_CTRL                                                                              0x00c6
#define mmUVD_RB_ARB_CTRL_BASE_IDX                                                                     1
#define mmUVD_CTX_INDEX                                                                                0x00c7
#define mmUVD_CTX_INDEX_BASE_IDX                                                                       1
#define mmUVD_CTX_DATA                                                                                 0x00c8
#define mmUVD_CTX_DATA_BASE_IDX                                                                        1
#define mmUVD_CXW_WR                                                                                   0x00c9
#define mmUVD_CXW_WR_BASE_IDX                                                                          1
#define mmUVD_CXW_WR_INT_ID                                                                            0x00ca
#define mmUVD_CXW_WR_INT_ID_BASE_IDX                                                                   1
#define mmUVD_CXW_WR_INT_CTX_ID                                                                        0x00cb
#define mmUVD_CXW_WR_INT_CTX_ID_BASE_IDX                                                               1
#define mmUVD_CXW_INT_ID                                                                               0x00cc
#define mmUVD_CXW_INT_ID_BASE_IDX                                                                      1
#define mmUVD_TOP_CTRL                                                                                 0x00cf
#define mmUVD_TOP_CTRL_BASE_IDX                                                                        1
#define mmUVD_YBASE                                                                                    0x00d0
#define mmUVD_YBASE_BASE_IDX                                                                           1
#define mmUVD_UVBASE                                                                                   0x00d1
#define mmUVD_UVBASE_BASE_IDX                                                                          1
#define mmUVD_PITCH                                                                                    0x00d2
#define mmUVD_PITCH_BASE_IDX                                                                           1
#define mmUVD_WIDTH                                                                                    0x00d3
#define mmUVD_WIDTH_BASE_IDX                                                                           1
#define mmUVD_HEIGHT                                                                                   0x00d4
#define mmUVD_HEIGHT_BASE_IDX                                                                          1
#define mmUVD_PICCOUNT                                                                                 0x00d5
#define mmUVD_PICCOUNT_BASE_IDX                                                                        1
#define mmUVD_SCRATCH_NP                                                                               0x00db
#define mmUVD_SCRATCH_NP_BASE_IDX                                                                      1
#define mmUVD_VERSION                                                                                  0x00dd
#define mmUVD_VERSION_BASE_IDX                                                                         1
#define mmUVD_GP_SCRATCH0                                                                              0x00de
#define mmUVD_GP_SCRATCH0_BASE_IDX                                                                     1
#define mmUVD_GP_SCRATCH1                                                                              0x00df
#define mmUVD_GP_SCRATCH1_BASE_IDX                                                                     1
#define mmUVD_GP_SCRATCH2                                                                              0x00e0
#define mmUVD_GP_SCRATCH2_BASE_IDX                                                                     1
#define mmUVD_GP_SCRATCH3                                                                              0x00e1
#define mmUVD_GP_SCRATCH3_BASE_IDX                                                                     1
#define mmUVD_GP_SCRATCH4                                                                              0x00e2
#define mmUVD_GP_SCRATCH4_BASE_IDX                                                                     1
#define mmUVD_GP_SCRATCH5                                                                              0x00e3
#define mmUVD_GP_SCRATCH5_BASE_IDX                                                                     1
#define mmUVD_GP_SCRATCH6                                                                              0x00e4
#define mmUVD_GP_SCRATCH6_BASE_IDX                                                                     1
#define mmUVD_GP_SCRATCH7                                                                              0x00e5
#define mmUVD_GP_SCRATCH7_BASE_IDX                                                                     1
#define mmUVD_GP_SCRATCH8                                                                              0x00e6
#define mmUVD_GP_SCRATCH8_BASE_IDX                                                                     1
#define mmUVD_GP_SCRATCH9                                                                              0x00e7
#define mmUVD_GP_SCRATCH9_BASE_IDX                                                                     1
#define mmUVD_GP_SCRATCH10                                                                             0x00e8
#define mmUVD_GP_SCRATCH10_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH11                                                                             0x00e9
#define mmUVD_GP_SCRATCH11_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH12                                                                             0x00ea
#define mmUVD_GP_SCRATCH12_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH13                                                                             0x00eb
#define mmUVD_GP_SCRATCH13_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH14                                                                             0x00ec
#define mmUVD_GP_SCRATCH14_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH15                                                                             0x00ed
#define mmUVD_GP_SCRATCH15_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH16                                                                             0x00ee
#define mmUVD_GP_SCRATCH16_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH17                                                                             0x00ef
#define mmUVD_GP_SCRATCH17_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH18                                                                             0x00f0
#define mmUVD_GP_SCRATCH18_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH19                                                                             0x00f1
#define mmUVD_GP_SCRATCH19_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH20                                                                             0x00f2
#define mmUVD_GP_SCRATCH20_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH21                                                                             0x00f3
#define mmUVD_GP_SCRATCH21_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH22                                                                             0x00f4
#define mmUVD_GP_SCRATCH22_BASE_IDX                                                                    1
#define mmUVD_GP_SCRATCH23                                                                             0x00f5
#define mmUVD_GP_SCRATCH23_BASE_IDX                                                                    1


// addressBlock: uvd0_ecpudec
// base address: 0x1fd00
#define mmUVD_VCPU_CACHE_OFFSET0                                                                       0x0140
#define mmUVD_VCPU_CACHE_OFFSET0_BASE_IDX                                                              1
#define mmUVD_VCPU_CACHE_SIZE0                                                                         0x0141
#define mmUVD_VCPU_CACHE_SIZE0_BASE_IDX                                                                1
#define mmUVD_VCPU_CACHE_OFFSET1                                                                       0x0142
#define mmUVD_VCPU_CACHE_OFFSET1_BASE_IDX                                                              1
#define mmUVD_VCPU_CACHE_SIZE1                                                                         0x0143
#define mmUVD_VCPU_CACHE_SIZE1_BASE_IDX                                                                1
#define mmUVD_VCPU_CACHE_OFFSET2                                                                       0x0144
#define mmUVD_VCPU_CACHE_OFFSET2_BASE_IDX                                                              1
#define mmUVD_VCPU_CACHE_SIZE2                                                                         0x0145
#define mmUVD_VCPU_CACHE_SIZE2_BASE_IDX                                                                1
#define mmUVD_VCPU_CACHE_OFFSET3                                                                       0x0146
#define mmUVD_VCPU_CACHE_OFFSET3_BASE_IDX                                                              1
#define mmUVD_VCPU_CACHE_SIZE3                                                                         0x0147
#define mmUVD_VCPU_CACHE_SIZE3_BASE_IDX                                                                1
#define mmUVD_VCPU_CACHE_OFFSET4                                                                       0x0148
#define mmUVD_VCPU_CACHE_OFFSET4_BASE_IDX                                                              1
#define mmUVD_VCPU_CACHE_SIZE4                                                                         0x0149
#define mmUVD_VCPU_CACHE_SIZE4_BASE_IDX                                                                1
#define mmUVD_VCPU_CACHE_OFFSET5                                                                       0x014a
#define mmUVD_VCPU_CACHE_OFFSET5_BASE_IDX                                                              1
#define mmUVD_VCPU_CACHE_SIZE5                                                                         0x014b
#define mmUVD_VCPU_CACHE_SIZE5_BASE_IDX                                                                1
#define mmUVD_VCPU_CACHE_OFFSET6                                                                       0x014c
#define mmUVD_VCPU_CACHE_OFFSET6_BASE_IDX                                                              1
#define mmUVD_VCPU_CACHE_SIZE6                                                                         0x014d
#define mmUVD_VCPU_CACHE_SIZE6_BASE_IDX                                                                1
#define mmUVD_VCPU_CACHE_OFFSET7                                                                       0x014e
#define mmUVD_VCPU_CACHE_OFFSET7_BASE_IDX                                                              1
#define mmUVD_VCPU_CACHE_SIZE7                                                                         0x014f
#define mmUVD_VCPU_CACHE_SIZE7_BASE_IDX                                                                1
#define mmUVD_VCPU_CACHE_OFFSET8                                                                       0x0150
#define mmUVD_VCPU_CACHE_OFFSET8_BASE_IDX                                                              1
#define mmUVD_VCPU_CACHE_SIZE8                                                                         0x0151
#define mmUVD_VCPU_CACHE_SIZE8_BASE_IDX                                                                1
#define mmUVD_VCPU_NONCACHE_OFFSET0                                                                    0x0152
#define mmUVD_VCPU_NONCACHE_OFFSET0_BASE_IDX                                                           1
#define mmUVD_VCPU_NONCACHE_SIZE0                                                                      0x0153
#define mmUVD_VCPU_NONCACHE_SIZE0_BASE_IDX                                                             1
#define mmUVD_VCPU_NONCACHE_OFFSET1                                                                    0x0154
#define mmUVD_VCPU_NONCACHE_OFFSET1_BASE_IDX                                                           1
#define mmUVD_VCPU_NONCACHE_SIZE1                                                                      0x0155
#define mmUVD_VCPU_NONCACHE_SIZE1_BASE_IDX                                                             1
#define mmUVD_VCPU_CNTL                                                                                0x0156
#define mmUVD_VCPU_CNTL_BASE_IDX                                                                       1
#define mmUVD_VCPU_PRID                                                                                0x0157
#define mmUVD_VCPU_PRID_BASE_IDX                                                                       1
#define mmUVD_VCPU_TRCE                                                                                0x0158
#define mmUVD_VCPU_TRCE_BASE_IDX                                                                       1
#define mmUVD_VCPU_TRCE_RD                                                                             0x0159
#define mmUVD_VCPU_TRCE_RD_BASE_IDX                                                                    1


// addressBlock: uvd0_uvd_mpcdec
// base address: 0x20310
#define mmUVD_MP_SWAP_CNTL                                                                             0x02c4
#define mmUVD_MP_SWAP_CNTL_BASE_IDX                                                                    1
#define mmUVD_MP_SWAP_CNTL2                                                                            0x02c5
#define mmUVD_MP_SWAP_CNTL2_BASE_IDX                                                                   1
#define mmUVD_MPC_LUMA_SRCH                                                                            0x02c6
#define mmUVD_MPC_LUMA_SRCH_BASE_IDX                                                                   1
#define mmUVD_MPC_LUMA_HIT                                                                             0x02c7
#define mmUVD_MPC_LUMA_HIT_BASE_IDX                                                                    1
#define mmUVD_MPC_LUMA_HITPEND                                                                         0x02c8
#define mmUVD_MPC_LUMA_HITPEND_BASE_IDX                                                                1
#define mmUVD_MPC_CHROMA_SRCH                                                                          0x02c9
#define mmUVD_MPC_CHROMA_SRCH_BASE_IDX                                                                 1
#define mmUVD_MPC_CHROMA_HIT                                                                           0x02ca
#define mmUVD_MPC_CHROMA_HIT_BASE_IDX                                                                  1
#define mmUVD_MPC_CHROMA_HITPEND                                                                       0x02cb
#define mmUVD_MPC_CHROMA_HITPEND_BASE_IDX                                                              1
#define mmUVD_MPC_CNTL                                                                                 0x02cc
#define mmUVD_MPC_CNTL_BASE_IDX                                                                        1
#define mmUVD_MPC_PITCH                                                                                0x02cd
#define mmUVD_MPC_PITCH_BASE_IDX                                                                       1
#define mmUVD_MPC_SET_MUXA0                                                                            0x02ce
#define mmUVD_MPC_SET_MUXA0_BASE_IDX                                                                   1
#define mmUVD_MPC_SET_MUXA1                                                                            0x02cf
#define mmUVD_MPC_SET_MUXA1_BASE_IDX                                                                   1
#define mmUVD_MPC_SET_MUXB0                                                                            0x02d0
#define mmUVD_MPC_SET_MUXB0_BASE_IDX                                                                   1
#define mmUVD_MPC_SET_MUXB1                                                                            0x02d1
#define mmUVD_MPC_SET_MUXB1_BASE_IDX                                                                   1
#define mmUVD_MPC_SET_MUX                                                                              0x02d2
#define mmUVD_MPC_SET_MUX_BASE_IDX                                                                     1
#define mmUVD_MPC_SET_ALU                                                                              0x02d3
#define mmUVD_MPC_SET_ALU_BASE_IDX                                                                     1
#define mmUVD_MPC_PERF0                                                                                0x02d4
#define mmUVD_MPC_PERF0_BASE_IDX                                                                       1
#define mmUVD_MPC_PERF1                                                                                0x02d5
#define mmUVD_MPC_PERF1_BASE_IDX                                                                       1


// addressBlock: uvd0_uvd_rbcdec
// base address: 0x20370
#define mmUVD_RBC_IB_SIZE                                                                              0x02dc
#define mmUVD_RBC_IB_SIZE_BASE_IDX                                                                     1
#define mmUVD_RBC_IB_SIZE_UPDATE                                                                       0x02dd
#define mmUVD_RBC_IB_SIZE_UPDATE_BASE_IDX                                                              1
#define mmUVD_RBC_RB_CNTL                                                                              0x02de
#define mmUVD_RBC_RB_CNTL_BASE_IDX                                                                     1
#define mmUVD_RBC_RB_RPTR_ADDR                                                                         0x02df
#define mmUVD_RBC_RB_RPTR_ADDR_BASE_IDX                                                                1
#define mmUVD_RBC_RB_RPTR                                                                              0x02e0
#define mmUVD_RBC_RB_RPTR_BASE_IDX                                                                     1
#define mmUVD_RBC_RB_WPTR                                                                              0x02e1
#define mmUVD_RBC_RB_WPTR_BASE_IDX                                                                     1
#define mmUVD_RBC_VCPU_ACCESS                                                                          0x02e2
#define mmUVD_RBC_VCPU_ACCESS_BASE_IDX                                                                 1
#define mmUVD_RBC_READ_REQ_URGENT_CNTL                                                                 0x02e5
#define mmUVD_RBC_READ_REQ_URGENT_CNTL_BASE_IDX                                                        1
#define mmUVD_RBC_RB_WPTR_CNTL                                                                         0x02e6
#define mmUVD_RBC_RB_WPTR_CNTL_BASE_IDX                                                                1
#define mmUVD_RBC_WPTR_STATUS                                                                          0x02e7
#define mmUVD_RBC_WPTR_STATUS_BASE_IDX                                                                 1
#define mmUVD_RBC_WPTR_POLL_CNTL                                                                       0x02e8
#define mmUVD_RBC_WPTR_POLL_CNTL_BASE_IDX                                                              1
#define mmUVD_RBC_WPTR_POLL_ADDR                                                                       0x02e9
#define mmUVD_RBC_WPTR_POLL_ADDR_BASE_IDX                                                              1
#define mmUVD_SEMA_CMD                                                                                 0x02ea
#define mmUVD_SEMA_CMD_BASE_IDX                                                                        1
#define mmUVD_SEMA_ADDR_LOW                                                                            0x02eb
#define mmUVD_SEMA_ADDR_LOW_BASE_IDX                                                                   1
#define mmUVD_SEMA_ADDR_HIGH                                                                           0x02ec
#define mmUVD_SEMA_ADDR_HIGH_BASE_IDX                                                                  1
#define mmUVD_ENGINE_CNTL                                                                              0x02ed
#define mmUVD_ENGINE_CNTL_BASE_IDX                                                                     1
#define mmUVD_SEMA_TIMEOUT_STATUS                                                                      0x02ee
#define mmUVD_SEMA_TIMEOUT_STATUS_BASE_IDX                                                             1
#define mmUVD_SEMA_CNTL                                                                                0x02ef
#define mmUVD_SEMA_CNTL_BASE_IDX                                                                       1
#define mmUVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL                                                      0x02f0
#define mmUVD_SEMA_SIGNAL_INCOMPLETE_TIMEOUT_CNTL_BASE_IDX                                             1
#define mmUVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL                                                             0x02f1
#define mmUVD_SEMA_WAIT_FAULT_TIMEOUT_CNTL_BASE_IDX                                                    1
#define mmUVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL                                                        0x02f2
#define mmUVD_SEMA_WAIT_INCOMPLETE_TIMEOUT_CNTL_BASE_IDX                                               1
#define mmUVD_JOB_START                                                                                0x02f3
#define mmUVD_JOB_START_BASE_IDX                                                                       1
#define mmUVD_RBC_BUF_STATUS                                                                           0x02f4
#define mmUVD_RBC_BUF_STATUS_BASE_IDX                                                                  1


// addressBlock: uvd0_uvdgendec
// base address: 0x20470
#define mmUVD_LCM_CGC_CNTRL                                                                            0x033f
#define mmUVD_LCM_CGC_CNTRL_BASE_IDX                                                                   1
#define mmUVD_MIF_CURR_UV_ADDR_CONFIG                                                                  0x03a0
#define mmUVD_MIF_CURR_UV_ADDR_CONFIG_BASE_IDX                                                         1
#define mmUVD_MIF_REF_UV_ADDR_CONFIG                                                                   0x03a1
#define mmUVD_MIF_REF_UV_ADDR_CONFIG_BASE_IDX                                                          1
#define mmUVD_MIF_RECON1_UV_ADDR_CONFIG                                                                0x03a2
#define mmUVD_MIF_RECON1_UV_ADDR_CONFIG_BASE_IDX                                                       1
#define mmUVD_MIF_CURR_ADDR_CONFIG                                                                     0x03ae
#define mmUVD_MIF_CURR_ADDR_CONFIG_BASE_IDX                                                            1
#define mmUVD_MIF_REF_ADDR_CONFIG                                                                      0x03af
#define mmUVD_MIF_REF_ADDR_CONFIG_BASE_IDX                                                             1
#define mmUVD_MIF_RECON1_ADDR_CONFIG                                                                   0x03e1
#define mmUVD_MIF_RECON1_ADDR_CONFIG_BASE_IDX                                                          1


// addressBlock: uvd0_lmi_adpdec
// base address: 0x20870
#define mmUVD_LMI_RBC_RB_64BIT_BAR_LOW                                                                 0x0432
#define mmUVD_LMI_RBC_RB_64BIT_BAR_LOW_BASE_IDX                                                        1
#define mmUVD_LMI_RBC_RB_64BIT_BAR_HIGH                                                                0x0433
#define mmUVD_LMI_RBC_RB_64BIT_BAR_HIGH_BASE_IDX                                                       1
#define mmUVD_LMI_RBC_IB_64BIT_BAR_LOW                                                                 0x0434
#define mmUVD_LMI_RBC_IB_64BIT_BAR_LOW_BASE_IDX                                                        1
#define mmUVD_LMI_RBC_IB_64BIT_BAR_HIGH                                                                0x0435
#define mmUVD_LMI_RBC_IB_64BIT_BAR_HIGH_BASE_IDX                                                       1
#define mmUVD_LMI_VCPU_NC0_64BIT_BAR_LOW                                                               0x0438
#define mmUVD_LMI_VCPU_NC0_64BIT_BAR_LOW_BASE_IDX                                                      1
#define mmUVD_LMI_VCPU_NC0_64BIT_BAR_HIGH                                                              0x0439
#define mmUVD_LMI_VCPU_NC0_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define mmUVD_LMI_VCPU_NC1_64BIT_BAR_LOW                                                               0x043a
#define mmUVD_LMI_VCPU_NC1_64BIT_BAR_LOW_BASE_IDX                                                      1
#define mmUVD_LMI_VCPU_NC1_64BIT_BAR_HIGH                                                              0x043b
#define mmUVD_LMI_VCPU_NC1_64BIT_BAR_HIGH_BASE_IDX                                                     1
#define mmUVD_LMI_VCPU_CACHE_64BIT_BAR_LOW                                                             0x043c
#define mmUVD_LMI_VCPU_CACHE_64BIT_BAR_LOW_BASE_IDX                                                    1
#define mmUVD_LMI_VCPU_CACHE_64BIT_BAR_HIGH                                                            0x043d
#define mmUVD_LMI_VCPU_CACHE_64BIT_BAR_HIGH_BASE_IDX                                                   1
#define mmUVD_LMI_VCPU_CACHE1_64BIT_BAR_LOW                                                            0x0468
#define mmUVD_LMI_VCPU_CACHE1_64BIT_BAR_LOW_BASE_IDX                                                   1
#define mmUVD_LMI_VCPU_CACHE1_64BIT_BAR_HIGH                                                           0x0469
#define mmUVD_LMI_VCPU_CACHE1_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define mmUVD_LMI_VCPU_CACHE8_64BIT_BAR_LOW                                                            0x046a
#define mmUVD_LMI_VCPU_CACHE8_64BIT_BAR_LOW_BASE_IDX                                                   1
#define mmUVD_LMI_VCPU_CACHE8_64BIT_BAR_HIGH                                                           0x046b
#define mmUVD_LMI_VCPU_CACHE8_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define mmUVD_LMI_VCPU_CACHE2_64BIT_BAR_LOW                                                            0x046c
#define mmUVD_LMI_VCPU_CACHE2_64BIT_BAR_LOW_BASE_IDX                                                   1
#define mmUVD_LMI_VCPU_CACHE2_64BIT_BAR_HIGH                                                           0x046d
#define mmUVD_LMI_VCPU_CACHE2_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define mmUVD_LMI_VCPU_CACHE3_64BIT_BAR_LOW                                                            0x046e
#define mmUVD_LMI_VCPU_CACHE3_64BIT_BAR_LOW_BASE_IDX                                                   1
#define mmUVD_LMI_VCPU_CACHE3_64BIT_BAR_HIGH                                                           0x046f
#define mmUVD_LMI_VCPU_CACHE3_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define mmUVD_LMI_VCPU_CACHE4_64BIT_BAR_LOW                                                            0x0470
#define mmUVD_LMI_VCPU_CACHE4_64BIT_BAR_LOW_BASE_IDX                                                   1
#define mmUVD_LMI_VCPU_CACHE4_64BIT_BAR_HIGH                                                           0x0471
#define mmUVD_LMI_VCPU_CACHE4_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define mmUVD_LMI_VCPU_CACHE5_64BIT_BAR_LOW                                                            0x0472
#define mmUVD_LMI_VCPU_CACHE5_64BIT_BAR_LOW_BASE_IDX                                                   1
#define mmUVD_LMI_VCPU_CACHE5_64BIT_BAR_HIGH                                                           0x0473
#define mmUVD_LMI_VCPU_CACHE5_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define mmUVD_LMI_VCPU_CACHE6_64BIT_BAR_LOW                                                            0x0474
#define mmUVD_LMI_VCPU_CACHE6_64BIT_BAR_LOW_BASE_IDX                                                   1
#define mmUVD_LMI_VCPU_CACHE6_64BIT_BAR_HIGH                                                           0x0475
#define mmUVD_LMI_VCPU_CACHE6_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define mmUVD_LMI_VCPU_CACHE7_64BIT_BAR_LOW                                                            0x0476
#define mmUVD_LMI_VCPU_CACHE7_64BIT_BAR_LOW_BASE_IDX                                                   1
#define mmUVD_LMI_VCPU_CACHE7_64BIT_BAR_HIGH                                                           0x0477
#define mmUVD_LMI_VCPU_CACHE7_64BIT_BAR_HIGH_BASE_IDX                                                  1
#define mmUVD_LMI_SPH_64BIT_BAR_HIGH                                                                   0x047c
#define mmUVD_LMI_SPH_64BIT_BAR_HIGH_BASE_IDX                                                          1
#define mmUVD_LMI_MMSCH_NC0_64BIT_BAR_LOW                                                              0x047d
#define mmUVD_LMI_MMSCH_NC0_64BIT_BAR_LOW_BASE_IDX                                                     1
#define mmUVD_LMI_MMSCH_NC0_64BIT_BAR_HIGH                                                             0x047e
#define mmUVD_LMI_MMSCH_NC0_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define mmUVD_LMI_MMSCH_NC1_64BIT_BAR_LOW                                                              0x047f
#define mmUVD_LMI_MMSCH_NC1_64BIT_BAR_LOW_BASE_IDX                                                     1
#define mmUVD_LMI_MMSCH_NC1_64BIT_BAR_HIGH                                                             0x0480
#define mmUVD_LMI_MMSCH_NC1_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define mmUVD_LMI_MMSCH_NC2_64BIT_BAR_LOW                                                              0x0481
#define mmUVD_LMI_MMSCH_NC2_64BIT_BAR_LOW_BASE_IDX                                                     1
#define mmUVD_LMI_MMSCH_NC2_64BIT_BAR_HIGH                                                             0x0482
#define mmUVD_LMI_MMSCH_NC2_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define mmUVD_LMI_MMSCH_NC3_64BIT_BAR_LOW                                                              0x0483
#define mmUVD_LMI_MMSCH_NC3_64BIT_BAR_LOW_BASE_IDX                                                     1
#define mmUVD_LMI_MMSCH_NC3_64BIT_BAR_HIGH                                                             0x0484
#define mmUVD_LMI_MMSCH_NC3_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define mmUVD_LMI_MMSCH_NC4_64BIT_BAR_LOW                                                              0x0485
#define mmUVD_LMI_MMSCH_NC4_64BIT_BAR_LOW_BASE_IDX                                                     1
#define mmUVD_LMI_MMSCH_NC4_64BIT_BAR_HIGH                                                             0x0486
#define mmUVD_LMI_MMSCH_NC4_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define mmUVD_LMI_MMSCH_NC5_64BIT_BAR_LOW                                                              0x0487
#define mmUVD_LMI_MMSCH_NC5_64BIT_BAR_LOW_BASE_IDX                                                     1
#define mmUVD_LMI_MMSCH_NC5_64BIT_BAR_HIGH                                                             0x0488
#define mmUVD_LMI_MMSCH_NC5_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define mmUVD_LMI_MMSCH_NC6_64BIT_BAR_LOW                                                              0x0489
#define mmUVD_LMI_MMSCH_NC6_64BIT_BAR_LOW_BASE_IDX                                                     1
#define mmUVD_LMI_MMSCH_NC6_64BIT_BAR_HIGH                                                             0x048a
#define mmUVD_LMI_MMSCH_NC6_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define mmUVD_LMI_MMSCH_NC7_64BIT_BAR_LOW                                                              0x048b
#define mmUVD_LMI_MMSCH_NC7_64BIT_BAR_LOW_BASE_IDX                                                     1
#define mmUVD_LMI_MMSCH_NC7_64BIT_BAR_HIGH                                                             0x048c
#define mmUVD_LMI_MMSCH_NC7_64BIT_BAR_HIGH_BASE_IDX                                                    1
#define mmUVD_LMI_MMSCH_NC_VMID                                                                        0x048d
#define mmUVD_LMI_MMSCH_NC_VMID_BASE_IDX                                                               1
#define mmUVD_LMI_MMSCH_CTRL                                                                           0x048e
#define mmUVD_LMI_MMSCH_CTRL_BASE_IDX                                                                  1
#define mmUVD_LMI_ARB_CTRL2                                                                            0x049a
#define mmUVD_LMI_ARB_CTRL2_BASE_IDX                                                                   1
#define mmUVD_LMI_VCPU_CACHE_VMIDS_MULTI                                                               0x049f
#define mmUVD_LMI_VCPU_CACHE_VMIDS_MULTI_BASE_IDX                                                      1
#define mmUVD_LMI_VCPU_NC_VMIDS_MULTI                                                                  0x04a0
#define mmUVD_LMI_VCPU_NC_VMIDS_MULTI_BASE_IDX                                                         1
#define mmUVD_LMI_LAT_CTRL                                                                             0x04a1
#define mmUVD_LMI_LAT_CTRL_BASE_IDX                                                                    1
#define mmUVD_LMI_LAT_CNTR                                                                             0x04a2
#define mmUVD_LMI_LAT_CNTR_BASE_IDX                                                                    1
#define mmUVD_LMI_AVG_LAT_CNTR                                                                         0x04a3
#define mmUVD_LMI_AVG_LAT_CNTR_BASE_IDX                                                                1
#define mmUVD_LMI_SPH                                                                                  0x04a4
#define mmUVD_LMI_SPH_BASE_IDX                                                                         1
#define mmUVD_LMI_VCPU_CACHE_VMID                                                                      0x04a5
#define mmUVD_LMI_VCPU_CACHE_VMID_BASE_IDX                                                             1
#define mmUVD_LMI_CTRL2                                                                                0x04a6
#define mmUVD_LMI_CTRL2_BASE_IDX                                                                       1
#define mmUVD_LMI_URGENT_CTRL                                                                          0x04a7
#define mmUVD_LMI_URGENT_CTRL_BASE_IDX                                                                 1
#define mmUVD_LMI_CTRL                                                                                 0x04a8
#define mmUVD_LMI_CTRL_BASE_IDX                                                                        1
#define mmUVD_LMI_STATUS                                                                               0x04a9
#define mmUVD_LMI_STATUS_BASE_IDX                                                                      1
#define mmUVD_LMI_PERFMON_CTRL                                                                         0x04ac
#define mmUVD_LMI_PERFMON_CTRL_BASE_IDX                                                                1
#define mmUVD_LMI_PERFMON_COUNT_LO                                                                     0x04ad
#define mmUVD_LMI_PERFMON_COUNT_LO_BASE_IDX                                                            1
#define mmUVD_LMI_PERFMON_COUNT_HI                                                                     0x04ae
#define mmUVD_LMI_PERFMON_COUNT_HI_BASE_IDX                                                            1
#define mmUVD_LMI_RBC_RB_VMID                                                                          0x04b0
#define mmUVD_LMI_RBC_RB_VMID_BASE_IDX                                                                 1
#define mmUVD_LMI_RBC_IB_VMID                                                                          0x04b1
#define mmUVD_LMI_RBC_IB_VMID_BASE_IDX                                                                 1
#define mmUVD_LMI_MC_CREDITS                                                                           0x04b2
#define mmUVD_LMI_MC_CREDITS_BASE_IDX                                                                  1


// addressBlock: uvd0_uvdnpdec
// base address: 0x20bd0
#define mmMDM_DMA_CMD                                                                                  0x06f4
#define mmMDM_DMA_CMD_BASE_IDX                                                                         1
#define mmMDM_DMA_STATUS                                                                               0x06f5
#define mmMDM_DMA_STATUS_BASE_IDX                                                                      1
#define mmMDM_DMA_CTL                                                                                  0x06f6
#define mmMDM_DMA_CTL_BASE_IDX                                                                         1
#define mmMDM_ENC_PIPE_BUSY                                                                            0x06f7
#define mmMDM_ENC_PIPE_BUSY_BASE_IDX                                                                   1
#define mmMDM_WIG_PIPE_BUSY                                                                            0x06f9
#define mmMDM_WIG_PIPE_BUSY_BASE_IDX                                                                   1


/* VCN 2_6_0 regs */
#define mmUVD_RAS_VCPU_VCODEC_STATUS                           0x0057
#define mmUVD_RAS_VCPU_VCODEC_STATUS_BASE_IDX                  1
#define mmUVD_RAS_MMSCH_FATAL_ERROR                            0x0058
#define mmUVD_RAS_MMSCH_FATAL_ERROR_BASE_IDX                   1


/* JPEG 2_6_0 regs */
#define mmUVD_RAS_JPEG0_STATUS                                 0x0059
#define mmUVD_RAS_JPEG0_STATUS_BASE_IDX                        1
#define mmUVD_RAS_JPEG1_STATUS                                 0x005a
#define mmUVD_RAS_JPEG1_STATUS_BASE_IDX                        1

#endif
