/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.sort.CustomMapEntryChain;
import net.sf.saxon.expr.sort.EqualityMatcher;
import net.sf.saxon.z.IntHashMap;

public class CustomMap<K, V> {
    private final IntHashMap<CustomMapEntryChain<K, V>> buckets = new IntHashMap();
    private final EqualityMatcher<K> equalityMatcher;

    public CustomMap(EqualityMatcher<K> matcher) {
        this.equalityMatcher = matcher;
    }

    public V put(K key, V value) {
        int h2 = this.equalityMatcher.hash(key);
        CustomMapEntryChain<K, V> bucket = this.buckets.get(h2);
        if (bucket == null) {
            CustomMapEntryChain<K, V> entry = new CustomMapEntryChain<K, V>(key, value);
            this.buckets.put(h2, entry);
            return null;
        }
        while (true) {
            if (this.equalityMatcher.equal(bucket.key, key)) {
                Object existing = bucket.value;
                bucket.value = value;
                return existing;
            }
            if (bucket.next == null) {
                CustomMapEntryChain<K, V> entry = new CustomMapEntryChain<K, V>(key, value);
                bucket.next = entry;
                return null;
            }
            bucket = bucket.next;
        }
    }

    public V get(K key) {
        int h2 = this.equalityMatcher.hash(key);
        CustomMapEntryChain<K, V> bucket = this.buckets.get(h2);
        if (bucket == null) {
            return null;
        }
        while (!this.equalityMatcher.equal(bucket.key, key)) {
            if (bucket.next == null) {
                return null;
            }
            bucket = bucket.next;
        }
        return bucket.value;
    }

    public boolean containsKey(K key) {
        int h2 = this.equalityMatcher.hash(key);
        CustomMapEntryChain<K, V> bucket = this.buckets.get(h2);
        if (bucket == null) {
            return false;
        }
        while (!this.equalityMatcher.equal(bucket.key, key)) {
            if (bucket.next == null) {
                return false;
            }
            bucket = bucket.next;
        }
        return true;
    }

    public List<K> keys() {
        ArrayList result = new ArrayList();
        Iterator<CustomMapEntryChain<K, V>> iterator = this.buckets.valueSet().iterator();
        while (iterator.hasNext()) {
            CustomMapEntryChain<K, V> entry;
            CustomMapEntryChain<K, V> e = entry = iterator.next();
            do {
                result.add(e.key);
            } while ((e = e.next) != null);
        }
        return result;
    }

    public List<V> values() {
        ArrayList result = new ArrayList();
        Iterator<CustomMapEntryChain<K, V>> iterator = this.buckets.valueSet().iterator();
        while (iterator.hasNext()) {
            CustomMapEntryChain<K, V> entry;
            CustomMapEntryChain<K, V> e = entry = iterator.next();
            do {
                result.add(e.value);
            } while ((e = e.next) != null);
        }
        return result;
    }
}

