/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

@StatelessCheck
public class ArrayTypeStyleCheck
extends AbstractCheck {
    public static final String MSG_KEY = "array.type.style";
    private boolean javaStyle = true;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{17};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST typeAST = ast.getParent();
        DetailAST identAst = typeAST.getNextSibling();
        if (identAst != null) {
            boolean isVariableViolation;
            boolean isMethod = typeAST.getParent().getType() == 9;
            boolean isJavaStyle = identAst.getLineNo() > ast.getLineNo() || identAst.getColumnNo() - ast.getColumnNo() > -1;
            boolean isMethodViolation = isMethod && !isJavaStyle;
            boolean bl = isVariableViolation = !isMethod && isJavaStyle != this.javaStyle;
            if (isMethodViolation || isVariableViolation) {
                this.log(ast, MSG_KEY, new Object[0]);
            }
        }
    }

    public void setJavaStyle(boolean javaStyle) {
        this.javaStyle = javaStyle;
    }
}

