/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import java.util.Arrays;
import net.sf.saxon.z.IntComplementSet;
import net.sf.saxon.z.IntEmptySet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntUniversalSet;

public class IntHashSet
extends IntSet {
    private static final int NBIT = 30;
    private static final int MAX_SIZE = 0x40000000;
    private final int ndv;
    private int _nmax;
    private int _size;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    private int[] _values;

    public IntHashSet() {
        this(8, Integer.MIN_VALUE);
    }

    public IntHashSet(int capacity) {
        this(capacity, Integer.MIN_VALUE);
    }

    public IntHashSet(int capacity, int noDataValue) {
        this.ndv = noDataValue;
        this.setCapacity(capacity);
    }

    @Override
    public IntSet copy() {
        if (this._size == 0) {
            return IntEmptySet.getInstance();
        }
        IntHashSet s2 = new IntHashSet(this._size, this.ndv);
        s2._nmax = this._nmax;
        s2._size = this._size;
        s2._nlo = this._nlo;
        s2._nhi = this._nhi;
        s2._shift = this._shift;
        s2._mask = this._mask;
        s2._values = new int[this._values.length];
        System.arraycopy(this._values, 0, s2._values, 0, this._values.length);
        return s2;
    }

    @Override
    public IntSet mutableCopy() {
        return this.copy();
    }

    @Override
    public void clear() {
        this._size = 0;
        for (int i = 0; i < this._nmax; ++i) {
            this._values[i] = this.ndv;
        }
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    public int[] getValues() {
        int index = 0;
        int[] values = new int[this._size];
        for (int _value : this._values) {
            if (_value == this.ndv) continue;
            values[index++] = _value;
        }
        return values;
    }

    @Override
    public boolean contains(int value) {
        return this._values[this.indexOf(value)] != this.ndv;
    }

    @Override
    public boolean remove(int value) {
        int i = this.indexOf(value);
        if (this._values[i] == this.ndv) {
            return false;
        }
        --this._size;
        while (true) {
            int r;
            this._values[i] = this.ndv;
            int j = i;
            do {
                if (this._values[i = i - 1 & this._mask] != this.ndv) continue;
                return true;
            } while (i <= (r = this.hash(this._values[i])) && r < j || r < j && j < i || j < i && i <= r);
            this._values[j] = this._values[i];
        }
    }

    @Override
    public boolean add(int value) {
        if (value == this.ndv) {
            throw new IllegalArgumentException("Can't add the 'no data' value");
        }
        int i = this.indexOf(value);
        if (this._values[i] == this.ndv) {
            ++this._size;
            this._values[i] = value;
            if (this._size > 0x40000000) {
                throw new RuntimeException("Too many elements (> 1073741824)");
            }
            if (this._nlo < this._size && this._size <= this._nhi) {
                this.setCapacity(this._size);
            }
            return true;
        }
        return false;
    }

    private int hash(int key) {
        return 1327217885 * key >> this._shift & this._mask;
    }

    private int indexOf(int value) {
        int i = this.hash(value);
        while (this._values[i] != this.ndv) {
            if (this._values[i] == value) {
                return i;
            }
            i = i - 1 & this._mask;
        }
        return i;
    }

    private void setCapacity(int capacity) {
        int nmax;
        if (capacity < this._size) {
            capacity = this._size;
        }
        int nbit = 1;
        for (nmax = 2; nmax < capacity * 4 && nmax < 0x40000000; nmax *= 2) {
            ++nbit;
        }
        int nold = this._nmax;
        if (nmax == nold) {
            return;
        }
        this._nmax = nmax;
        this._nlo = nmax / 4;
        this._nhi = 0x10000000;
        this._shift = 31 - nbit;
        this._mask = nmax - 1;
        this._size = 0;
        int[] values = this._values;
        this._values = new int[nmax];
        Arrays.fill(this._values, this.ndv);
        if (values != null) {
            for (int i = 0; i < nold; ++i) {
                int value = values[i];
                if (value == this.ndv) continue;
                ++this._size;
                this._values[this.indexOf((int)value)] = value;
            }
        }
    }

    @Override
    public IntIterator iterator() {
        return new IntHashSetIterator(this);
    }

    public static boolean containsSome(IntSet one, IntSet two) {
        if (two instanceof IntEmptySet) {
            return false;
        }
        if (two instanceof IntUniversalSet) {
            return !one.isEmpty();
        }
        if (two instanceof IntComplementSet) {
            return !((IntComplementSet)two).getExclusions().containsAll(one);
        }
        IntIterator it = two.iterator();
        while (it.hasNext()) {
            if (!one.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof IntSet) {
            IntHashSet s2 = (IntHashSet)other;
            return this.size() == s2.size() && this.containsAll(s2);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 936247625;
        IntIterator it = this.iterator();
        while (it.hasNext()) {
            h2 += it.next();
        }
        return h2;
    }

    public String toString() {
        return IntHashSet.stringify(this.iterator());
    }

    public static String stringify(IntIterator it) {
        StringBuilder sb = new StringBuilder(100);
        while (it.hasNext()) {
            if (sb.length() == 0) {
                sb.append(it.next());
                continue;
            }
            sb.append(' ').append(it.next());
        }
        return sb.toString();
    }

    public static IntHashSet of(int ... members) {
        IntHashSet is = new IntHashSet(members.length);
        for (int i : members) {
            is.add(i);
        }
        return is;
    }

    private static class IntHashSetIterator
    implements IntIterator {
        private final IntHashSet container;
        private int i;

        IntHashSetIterator(IntHashSet container) {
            this.container = container;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            while (this.i < this.container._values.length) {
                if (this.container._values[this.i] != this.container.ndv) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        @Override
        public int next() {
            return this.container._values[this.i++];
        }
    }
}

